/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseStartupActivity;
import com.intellij.database.editor.DatabaseTableFileEditorProvider;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.IntIntFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableFileEditor
extends TableEditorBase
implements NavigatableFileEditor,
DataProvider,
DocumentReferenceProvider {
    public static final int UNKNOWN_COLUMN_POSITION = 0;
    public static final int DEFAULT_OR_HIDDEN_COLUMN_POSITION = -1;
    private final VirtualFile myFile;
    private final EditorTableResultPanel myResultPanel;
    private final JPanel myRootPanel;
    private final LoadingManager myLoadingManager;
    private boolean stateWasSet;

    public DatabaseTableFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseTableFileEditorProvider provider) {
        if (project == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myRootPanel = new JPanel(new BorderLayout());
        this.stateWasSet = false;
        this.myFile = file;
        State state2 = (State)ObjectUtils.tryCast((Object)EditorHistoryManager.getInstance((Project)project).getState(file, (FileEditorProvider)provider), State.class);
        String sessionName = state2 == null ? null : state2.sessionName;
        DataGridSessionClient hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this, sessionName);
        this.myResultPanel = new EditorTableResultPanel(project, hookUp){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = "editor:" + DatabaseTableFileEditor.this.getFile().getPresentableName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor$1", "getDisplayName"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myResultPanel);
        DataGridUtil.setupProgressIndicatingAuditor(this.myResultPanel);
        this.myLoadingManager = DatabaseStartupActivity.DataEditorConfigurator.isSafeToLoadData(project) ? new MyInstantLoadingManager() : new MyDelayedLoadingManager();
        this.myLoadingManager.onInit();
        DataManager.registerDataProvider((JComponent)this.myRootPanel, (DataProvider)this);
        DataGridUtil.addGridHeaderComponent(this.myResultPanel, this.myFile);
        this.myRootPanel.add((Component)this.myResultPanel.getComponent(), "Center");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor");
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        EditorTableResultPanel editorTableResultPanel = this.myResultPanel;
        if (editorTableResultPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(4);
        }
        return editorTableResultPanel;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(6);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.table.editor";
        }
        return null;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(7);
        }
        return navigatable instanceof OpenDataFileDescriptor;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(8);
        }
        if (!(navigatable instanceof OpenDataFileDescriptor)) {
            return;
        }
        OpenDataFileDescriptor descriptor = (OpenDataFileDescriptor)navigatable;
        descriptor.setFilterAndLoadData(this.myLoadingManager, this.myResultPanel);
        DeferredLoader.doWhenLoaded(this.myResultPanel, () -> descriptor.navigateTo(this.myResultPanel));
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(9);
        }
        if (level == FileEditorStateLevel.FULL) {
            State state2 = new State();
            this.updateColumnAttributes(state2.columnAttributes);
            this.updateFilterState(state2.filter);
            this.updateIsTransposed(state2);
            state2.projectRestartId = DatabaseStartupActivity.DataEditorConfigurator.getLaunchId(this.getProject());
            state2.pageSize = this.myResultPanel.getDataHookup().getPageModel().getPageSize();
            DataGridSessionClient client = DataGridUtil.getDataGridClient(this.myResultPanel);
            state2.sessionName = client != null && SessionsUtil.needToSaveSessionName(client.getSession(), client) ? client.getSession().getTitle() : null;
            State state3 = state2;
            if (state3 == null) {
                DatabaseTableFileEditor.$$$reportNull$$$0(10);
            }
            return state3;
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(11);
        }
        return fileEditorState;
    }

    private void updateIsTransposed(State state2) {
        state2.isTransposed = this.myResultPanel.isTransposed();
    }

    private void updateFilterState(@NotNull State.Filter filterState) {
        if (filterState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(12);
        }
        filterState.enabled = this.myResultPanel.isFilteringEnabled();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        filterState.text = model == null ? "" : model.getFilterText();
        filterState.history.clear();
        filterState.history.addAll(this.myResultPanel.getFiltersHistory());
    }

    private void updateColumnAttributes(@NotNull List<State.Column> columnAttributes) {
        if (columnAttributes == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(13);
        }
        columnAttributes.clear();
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA);
        IntIntFunction column2View = this.myResultPanel.getRawIndexConverter().column2View();
        for (ModelIndex columnIdx : model.getColumnIndices().asIterable()) {
            DataConsumer.Column column2 = model.getColumn(columnIdx);
            String columnName = column2 != null ? column2.name : null;
            boolean enabled = this.myResultPanel.isColumnEnabled(columnIdx);
            Language contentLanguage = this.myResultPanel.getContentLanguage(columnIdx);
            int position = column2View.fun(columnIdx.value);
            if (columnName == null || enabled && contentLanguage == Language.ANY && position == columnIdx.value) continue;
            State.Column attributes2 = new State.Column();
            attributes2.name = columnName;
            attributes2.enabled = enabled;
            attributes2.languageId = contentLanguage.getID();
            attributes2.position = DatabaseTableFileEditor.toSerializedPosition(position);
            columnAttributes.add(attributes2);
        }
    }

    private static int toSerializedPosition(int position) {
        if (position == -1) {
            return position;
        }
        return position + 1;
    }

    public static int fromSerializedPosition(int position) {
        if (position == -1) {
            return position;
        }
        return position - 1;
    }

    @Override
    public void setState(@NotNull FileEditorState state2) {
        State s;
        if (state2 == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(14);
        }
        if ((s = (State)ObjectUtils.tryCast((Object)state2, State.class)) != null) {
            this.myResultPanel.getDataHookup().getPageModel().setPageSize(s.pageSize);
            this.applyColumnAttributes(s.columnAttributes);
            this.applyFilterState(s);
            this.applyIsTransposed(s.isTransposed);
        }
        if (!this.stateWasSet && !OpenDataFileDescriptor.isDataLoadedByDescriptor(this.myFile)) {
            this.myLoadingManager.onEditorStateApplied();
        }
        this.stateWasSet = true;
    }

    private void applyIsTransposed(boolean isTransposed) {
        if (isTransposed) {
            this.myResultPanel.transpose();
        }
    }

    private void applyColumnAttributes(@Nullable List<State.Column> columnAttributes) {
        if (ContainerUtil.isEmpty(columnAttributes)) {
            return;
        }
        HashMap<String, EditorTableResultPanel.InitialColumnProperties> props = new HashMap<String, EditorTableResultPanel.InitialColumnProperties>(columnAttributes.size());
        for (State.Column attributes2 : columnAttributes) {
            Language contentLanguage = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)attributes2.languageId), (Object)Language.ANY);
            props.put(attributes2.name, new EditorTableResultPanel.InitialColumnProperties(attributes2.enabled, contentLanguage, attributes2.position));
        }
        if (!props.isEmpty()) {
            this.myResultPanel.setInitialColumnProperties(props);
        }
    }

    private boolean isDragging() {
        return Boolean.TRUE.equals(FileEditorManagerImpl.CLOSING_TO_REOPEN.get((UserDataHolder)this.myFile));
    }

    private boolean shouldRestoreFilter(@NotNull State state2) {
        boolean wasNotRestarted;
        if (state2 == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(15);
        }
        return (wasNotRestarted = StringUtil.equals((CharSequence)state2.projectRestartId, (CharSequence)DatabaseStartupActivity.DataEditorConfigurator.getLaunchId(this.getProject()))) && (UISettings.getInstance().getEditorTabPlacement() == 0 || this.isDragging());
    }

    private void applyFilterState(@Nullable State state2) {
        if (state2 == null) {
            return;
        }
        State.Filter filterState = state2.filter;
        if (filterState == null) {
            return;
        }
        ArrayList<String> filterHistory = filterState.history != null ? filterState.history : new ArrayList<String>();
        this.myResultPanel.setFiltersHistory(filterHistory);
        if (!this.shouldRestoreFilter(state2)) {
            return;
        }
        if (this.myResultPanel.isFilteringEnabled() != filterState.enabled) {
            this.myResultPanel.toggleFiltering();
        }
        this.myResultPanel.setFilterText(filterState.text, -1);
        if (StringUtil.isNotEmpty((String)filterState.text)) {
            this.myResultPanel.setIgnoreCurrentFilterText(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateFilterState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateColumnAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDelayedLoadingManager
    implements LoadingManager {
        private MyDelayedLoadingManager() {
        }

        @Override
        public void onInit() {
            DatabaseStartupActivity.DataEditorConfigurator.delayLoading(DatabaseTableFileEditor.this.myResultPanel);
        }

        @Override
        public void onEditorStateApplied() {
        }

        @Override
        public void reload() {
            DatabaseStartupActivity.DataEditorConfigurator.disableLoadingDelay(DatabaseTableFileEditor.this.myResultPanel);
            DeferredLoader.installOn(DatabaseTableFileEditor.this.myResultPanel);
        }
    }

    private class MyInstantLoadingManager
    implements LoadingManager {
        private MyInstantLoadingManager() {
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onEditorStateApplied() {
            DeferredLoader.installOn(DatabaseTableFileEditor.this.myResultPanel);
        }

        @Override
        public void reload() {
            DeferredLoader.installOn(DatabaseTableFileEditor.this.myResultPanel);
        }
    }

    static interface LoadingManager {
        public void onInit();

        public void onEditorStateApplied();

        public void reload();
    }

    private static class DeferredLoader
    extends Activatable.Adapter
    implements ModificationTrackerListener<DbPsiFacade>,
    Disposable {
        private static final Map<DatabaseTableGridDataHookUp, DeferredLoader> LOADERS = ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
        private final DataGridSessionClient mySession;
        private final Collection<DataGrid> myGrids;
        private final ActionCallback myInitialLoadCallback;
        private LoadingState myState;

        private DeferredLoader(@NotNull DataGridSessionClient session2) {
            if (session2 == null) {
                DeferredLoader.$$$reportNull$$$0(0);
            }
            this.myGrids = new WeakList();
            this.myInitialLoadCallback = new ActionCallback();
            this.myState = LoadingState.NONE;
            this.mySession = session2;
            Disposer.register((Disposable)this.mySession, (Disposable)this);
        }

        public static void installOn(@NotNull DataGrid grid) {
            DataGridSessionClient client;
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(1);
            }
            if ((loader = LOADERS.get(client = DeferredLoader.getTableHookUp(grid))) == null) {
                loader = new DeferredLoader(client);
                LOADERS.put(client, loader);
            }
            loader.addGrid(grid);
        }

        public static void doWhenLoaded(@NotNull DataGrid grid, @NotNull Runnable action2) {
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(2);
            }
            if (action2 == null) {
                DeferredLoader.$$$reportNull$$$0(3);
            }
            ActionCallback callback = (loader = LOADERS.get(DeferredLoader.getTableHookUp(grid))) == null ? ActionCallback.DONE : loader.myInitialLoadCallback;
            callback.doWhenDone((Runnable)new DoWhenLoadedActionWrapper(grid, action2));
        }

        @NotNull
        private static DataGridSessionClient getTableHookUp(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(4);
            }
            DataGridSessionClient dataGridSessionClient = (DataGridSessionClient)grid.getDataHookup();
            if (dataGridSessionClient == null) {
                DeferredLoader.$$$reportNull$$$0(5);
            }
            return dataGridSessionClient;
        }

        private void addGrid(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(6);
            }
            this.myGrids.add(grid);
            if (this.myState == LoadingState.NONE) {
                Disposer.register((Disposable)grid, (Disposable)new UiNotifyConnector.Once((Component)grid.getComponent(), (Activatable)this));
            }
        }

        public void showNotify() {
            if (this.myState != LoadingState.NONE) {
                return;
            }
            this.myState = LoadingState.INITIATED;
            for (DataGrid grid : this.myGrids) {
                DataGridUtil.setProgressMessage(grid, "Connecting...");
            }
            DbPsiFacade psiFacade = DbPsiFacade.getInstance((Project)this.mySession.getProject());
            psiFacade.addModificationTrackerListener((ModificationTrackerListener)this, (Disposable)this);
            this.modificationCountChanged(psiFacade);
        }

        public void modificationCountChanged(@NotNull DbPsiFacade source) {
            VirtualFile file;
            DbElement element2;
            if (source == null) {
                DeferredLoader.$$$reportNull$$$0(7);
            }
            DbElement dbElement = element2 = (file = this.mySession.getVirtualFile()).isValid() ? DbImplUtil.findElement(this.mySession.getProject(), file) : null;
            if (element2 == null) {
                return;
            }
            if (this.myState != LoadingState.COMPLETED && DatabaseEditorHelper.isTableDataAvailable(element2)) {
                this.myState = LoadingState.COMPLETED;
                this.loadTable();
            }
        }

        private void loadTable() {
            final GridRequestSource<DataConsumer.Row, DataConsumer.Column> initialLoadSource = GridRequestSource.create((Grid)JBIterable.from(this.myGrids).first(), null);
            Disposable initialLoadDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)initialLoadDisposable);
            this.mySession.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){
                private String myErrorMessage;

                @Override
                public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message2, @Nullable Throwable th) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (initialLoadSource == source) {
                        this.myErrorMessage = message2;
                    }
                }

                @Override
                public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount2) {
                    if (source == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                @Override
                public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                    if (source == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (initialLoadSource == source) {
                        if (!success) {
                            myInitialLoadCallback.reject(this.myErrorMessage);
                        } else {
                            myInitialLoadCallback.setDone();
                        }
                        Disposer.dispose((Disposable)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "source";
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "error";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateCountReceived";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "requestFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, initialLoadDisposable);
            this.mySession.getLoader().loadFirstPage(initialLoadSource);
        }

        public void dispose() {
            LOADERS.remove(this.mySession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "installOn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doWhenLoaded";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableHookUp";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addGrid";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "modificationCountChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DoWhenLoadedActionWrapper
        implements Runnable,
        Disposable {
            private Runnable myAction;

            DoWhenLoadedActionWrapper(@NotNull DataGrid grid, @NotNull Runnable action2) {
                if (grid == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(0);
                }
                if (action2 == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(1);
                }
                this.myAction = action2;
                Disposer.register((Disposable)grid, (Disposable)this);
            }

            public void dispose() {
                this.myAction = null;
            }

            @Override
            public void run() {
                try {
                    if (this.myAction != null) {
                        this.myAction.run();
                    }
                }
                finally {
                    this.myAction = null;
                    Disposer.dispose((Disposable)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$DoWhenLoadedActionWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static enum LoadingState {
            NONE,
            INITIATED,
            COMPLETED;

        }
    }

    static class State
    implements FileEditorState,
    Serializable {
        @Attribute(value="isTransposed")
        public boolean isTransposed = false;
        @Attribute(value="sessionName")
        public String sessionName = null;
        @Property(surroundWithTag=false)
        public Filter filter = new Filter();
        @XCollection(propertyElementName="column-attributes", elementTypes={Column.class})
        public List<Column> columnAttributes = new ArrayList<Column>();
        @Attribute(value="projectRestartId")
        public String projectRestartId = null;
        @Attribute(value="pageSize")
        public int pageSize = -2;

        State() {
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        @Tag(value="column")
        static class Column
        implements Serializable {
            @Attribute(value="name")
            public String name = "";
            @Attribute(value="enabled")
            public boolean enabled = true;
            @Attribute(value="languageId")
            public String languageId = Language.ANY.getID();
            @Attribute(value="position")
            public int position;

            Column() {
            }
        }

        @Tag(value="filtering")
        static class Filter
        implements Serializable {
            @Attribute(value="enabled")
            public boolean enabled = true;
            @Transient
            public String text = "";
            @Property(surroundWithTag=false)
            @XCollection(elementName="filter", valueAttributeName="text")
            public List<String> history = new ArrayList<String>();

            Filter() {
            }
        }
    }
}

