/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ParameterizedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.RunnableWhereClause;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenDataFileDescriptor
extends OpenFileDescriptor {
    private static final Key<Boolean> DATA_WILL_BE_LOADED_BY_DESCRIPTOR = Key.create((String)"DATA_GRID_LOADING_ORDER_KEY");
    private final String[] myColumnNames;
    private final String myDescription;
    private final Object[] myValues;
    private final DbImplUtil.TriConsumer<DdlBuilder, List<DasColumn>, Dbms> myWhereCondition;

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, @Nullable String[] columnNames, @Nullable String description, @Nullable Object[] values2, @Nullable DbImplUtil.TriConsumer<DdlBuilder, List<DasColumn>, Dbms> whereCondition) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(1);
        }
        super(project, file);
        DATA_WILL_BE_LOADED_BY_DESCRIPTOR.set((UserDataHolder)file, (Object)true);
        this.myColumnNames = columnNames;
        this.myDescription = description;
        this.myValues = values2;
        this.myWhereCondition = whereCondition;
    }

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(3);
        }
        this(project, file, null, null, null, null);
    }

    public OpenDataFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, @Nullable String[] columnNames, @Nullable String description) {
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(5);
        }
        this(project, file, columnNames, description, null, null);
    }

    public void setFilterAndLoadData(DatabaseTableFileEditor.LoadingManager manager, EditorTableResultPanel resultPanel) {
        DATA_WILL_BE_LOADED_BY_DESCRIPTOR.set((UserDataHolder)this.getFile(), (Object)false);
        if (this.myWhereCondition != null) {
            this.setFilterText(resultPanel);
        }
        manager.reload();
    }

    public static boolean isDataLoadedByDescriptor(@NotNull VirtualFile file) {
        if (file == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(6);
        }
        return Boolean.TRUE.equals(DATA_WILL_BE_LOADED_BY_DESCRIPTOR.get((UserDataHolder)file));
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        List editors;
        FileEditor editor;
        JComponent component;
        if (project == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(7);
        }
        JComponent jComponent = component = (editor = (FileEditor)ContainerUtil.getFirstItem((List)(editors = FileEditorManager.getInstance((Project)project).openEditor((OpenFileDescriptor)this, requestFocus)))) != null ? editor.getPreferredFocusedComponent() : null;
        if (component != null) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)component, true);
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void navigateTo(@NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(8);
        }
        if (this.myColumnNames != null && this.myColumnNames.length != 0) {
            if (this.myWhereCondition == null && this.myValues == null) {
                DasTable table = DataGridUtil.getDatabaseTable(resultPanel);
                int[] indices = new int[this.myColumnNames.length];
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    indices[i2] = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class).indexOf(DasUtil.byName((String)this.myColumnNames[i2]));
                }
                resultPanel.getSelectionModel().setColumnSelection(ModelIndexSet.forColumns(resultPanel, indices));
            } else if (this.myValues != null) {
                this.navigateToFirstMatched(resultPanel);
            }
        }
    }

    private void setFilterText(@NotNull EditorTableResultPanel resultPanel) {
        List<DasColumn> columns;
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(9);
        }
        if ((columns = OpenDataFileDescriptor.getDasColumns(resultPanel)) == null) {
            return;
        }
        Dbms dbms = DataGridUtil.getDbms(resultPanel);
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbms);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)DataGridUtil.getDatabaseTable(resultPanel));
        this.myWhereCondition.accept(builder, columns, dbms);
        String whereCondition = builder.getStatement();
        resultPanel.setFilterText(whereCondition, -1);
        resultPanel.setIgnoreCurrentFilterText(false);
    }

    private void navigateToFirstMatched(final @NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(10);
        }
        final QueryWithParameters existsQuery = this.buildSelectQuery(resultPanel);
        final QueryWithParameters countQuery = this.buildCountQuery(resultPanel);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
        if (existsQuery == null || countQuery == null || hookup == null) {
            return;
        }
        DasTable table = DataGridUtil.getDatabaseTable(resultPanel);
        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)table);
        LinkedHashSet orderBy = new LinkedHashSet();
        Collections.addAll(orderBy, this.myColumnNames);
        if (primaryKey != null) {
            Iterables.addAll(orderBy, (Iterable)primaryKey.getColumnsRef().names());
        }
        ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering = new ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>>(orderBy.size());
        for (String columnName : orderBy) {
            ModelIndex<DataConsumer.Column> column2 = DataGridUtil.findColumn(resultPanel, columnName);
            if (!column2.isValid(resultPanel)) {
                return;
            }
            ordering.add(RowSortOrder.asc(column2));
        }
        resultPanel.setOrdering(ordering);
        resultPanel.setFilterText("", -1);
        resultPanel.setSortViaOrderBy(true);
        resultPanel.applyFilter();
        hookup.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(hookup){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) {
                int position = -1;
                SmartStatements statements2 = SmartStatements.poweredBy(connection2);
                ParameterizedSmartStatement statement = statements2.parameterized();
                String sql = existsQuery.sql;
                boolean exists = statement.execute(new StatementParameters().placeholdersOffsets(existsQuery.offsets).parameters((List<ColumnQueryData>)existsQuery.data).asData(sql), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(rs -> rs.next(), false)).rightOr(false);
                if (exists) {
                    position = 0;
                    ParameterizedStatementData data = new StatementParameters().parameters((List<ColumnQueryData>)countQuery.data).placeholdersOffsets(countQuery.offsets).asData(countQuery.sql);
                    Either<ClosableResultsProducer> producerEither = statement.execute(data, StandardExecutionMode.QUERY);
                    if (producerEither.isRight()) {
                        try (ClosableResultsProducer producer = (ClosableResultsProducer)ObjectUtils.notNull((Object)producerEither.getRight());){
                            while (producer.advanceSafe()) {
                                position += producer.processCurrent(StandardResultsProcessors.SUM).intValue();
                            }
                        }
                    }
                }
                resultPanel.showCell(resultPanel.uiRow(position + 1), resultPanel.uiColumn(0));
            }
        });
    }

    private QueryWithParameters buildSelectQuery(@NotNull DataGrid grid) {
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(11);
        }
        DasTable dasTable = DataGridUtil.getDatabaseTable(grid);
        List<DataConsumer.Column> columns = this.getColumns(grid);
        if (dasTable == null || columns == null) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        JdbcEngine.OffsetSavingBuilder builder = new JdbcEngine.OffsetSavingBuilder(DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(dbms), (DasObject)dasTable));
        List<ColumnQueryData> data = IntStream.range(0, Math.min(this.myValues.length, columns.size())).mapToObj(idx -> new ColumnQueryData((DataConsumer.Column)columns.get(idx), this.myValues[idx])).collect(Collectors.toList());
        DbDataSource system = DataGridUtil.getDatabaseSystem(grid);
        List<ColumnQueryData> parameters = OpenDataFileDescriptor.createSelectAllQueryWithParameters(builder, dasTable, dbms, (DasDataSource)system, data, 1);
        return new QueryWithParameters(builder.getStatement(), (List)ContainerUtil.immutableList(parameters), builder.getOffsets());
    }

    @NotNull
    private static List<ColumnQueryData> createSelectAllQueryWithParameters(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull Dbms dbms, @Nullable DasDataSource system, @NotNull List<ColumnQueryData> datas, int limit) {
        if (builder == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(12);
        }
        if (table == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(14);
        }
        if (datas == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(15);
        }
        ArrayList<ColumnQueryData> newData = new ArrayList<ColumnQueryData>();
        SelectTask task = DmlTaskKt.allColumns(table).system(system).limit(limit).whereClause(new RunnableWhereClause((Function2<? super DdlBuilder, ? super String, Unit>)((Function2)(b2, tableNameAlias) -> {
            b2.keyword("WHERE").space();
            newData.addAll(DbImplUtil.composeWhereConditionWithParameters(builder, datas, tableNameAlias, dbms));
            return Unit.INSTANCE;
        }))).build();
        DmlUtilKt.dmlGenerator(dbms).generate(builder, task);
        ArrayList<ColumnQueryData> arrayList = newData;
        if (arrayList == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private QueryWithParameters buildCountQuery(@NotNull DataGrid grid) {
        DasTable dasTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(17);
        }
        if ((dasTable = DataGridUtil.getDatabaseTable(grid)) == null) {
            return null;
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        SelectTask task = DmlTaskKt.allColumns(dasTable).system((DasDataSource)DataGridUtil.getDatabaseSystem(grid)).build();
        JdbcEngine.OffsetSavingBuilder builder = new JdbcEngine.OffsetSavingBuilder(DmlUtilKt.dmlGenerator(dbms).generate(DbImplUtil.createBuilderForUIExec(dbms, (DasObject)dasTable), task));
        builder.space().keyword("WHERE").space();
        ArrayList<Pair> parameters = new ArrayList<Pair>();
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        for (int i3 = 0; i3 < this.myColumnNames.length; ++i3) {
            String columnName = this.myColumnNames[i3];
            Object parameterValue = this.myValues[i3];
            DataConsumer.Column column2 = model.getColumn(DataGridUtil.findColumn(grid, columnName));
            if (column2 == null) {
                return null;
            }
            if (i3 > 0) {
                builder.space().keyword("OR").space();
            }
            Pair columnValuePair = Pair.create((Object)column2, (Object)parameterValue);
            builder.columnRef(columnName).space().symbol("<").space().placeholder();
            parameters.add(columnValuePair);
            DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
            if (dasColumn != null && !dasColumn.isNotNull()) {
                builder.space().keyword("OR").space().columnRef(columnName).space().keywords("IS", "NULL");
            }
            for (int j = 0; j < i3; ++j) {
                builder.space().keyword("AND").space();
                int placeholdersCount = DbImplUtil.composeWhereItemWithParameters(builder, column2, parameterValue == null ? ThreeState.YES : ThreeState.NO, null, dbms, false);
                for (int k = 0; k < placeholdersCount; ++k) {
                    parameters.add(columnValuePair);
                }
            }
        }
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(grid);
        int[] offsets = builder.getOffsets();
        task = DmlTaskKt.countAll().system((DasDataSource)dataSource).build();
        DmlGenerator.Companion.Result result2 = DmlUtilKt.dmlGenerator(dbms).wrap(DbImplUtil.createBuilderForUIExec(DbImplUtil.getDatabaseDialect(dbms), (DasObject)dataSource), builder.getStatement(), this.getProject(), task);
        return result2 instanceof DmlGenerator.Companion.WrapQueryResult ? new QueryWithParameters(result2.getStatement(), ContainerUtil.immutableList(parameters), IntStream.of(offsets).map(i2 -> i2 + ((DmlGenerator.Companion.WrapQueryResult)result2).getOffset()).toArray()) : null;
    }

    @Nullable
    private static List<DasColumn> getDasColumns(@NotNull DataGrid grid) {
        DbTableImpl dbTable;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(18);
        }
        if ((dbTable = (DbTableImpl)((Object)ObjectUtils.tryCast((Object)DataGridUtil.getDatabaseTable(grid), DbTableImpl.class))) == null) {
            return null;
        }
        BasicTableOrView table = (BasicTableOrView)ObjectUtils.tryCast((Object)DbImplUtil.getMaybeBasicElement((DasObject)dbTable), BasicTableOrView.class);
        if (table == null) {
            return null;
        }
        return JBIterable.from(table.getColumns()).filter(DasColumn.class).toList();
    }

    @Nullable
    private List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        GridModel model;
        List columns;
        if (grid == null) {
            OpenDataFileDescriptor.$$$reportNull$$$0(19);
        }
        return (columns = ContainerUtil.mapNotNull((Object[])this.myColumnNames, arg_0 -> OpenDataFileDescriptor.lambda$getColumns$3(model = grid.getDataModel(DataAccessType.DATABASE_DATA), grid, arg_0))).size() == this.myColumnNames.length ? columns : null;
    }

    private static /* synthetic */ DataConsumer.Column lambda$getColumns$3(GridModel model, DataGrid grid, String columnName) {
        return model.getColumn(DataGridUtil.findColumn(grid, columnName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 11: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datas";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSelectAllQueryWithParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDataLoadedByDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "navigateInEditor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "navigateToFirstMatched";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildSelectQuery";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSelectAllQueryWithParameters";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildCountQuery";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDasColumns";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class QueryWithParameters {
        public final String sql;
        public final ImmutableList<ColumnQueryData> data;
        public final int[] offsets;

        private QueryWithParameters(@NotNull String sql, @NotNull ImmutableList<Pair<DataConsumer.Column, Object>> pairs2, int[] offsets) {
            if (sql == null) {
                QueryWithParameters.$$$reportNull$$$0(0);
            }
            if (pairs2 == null) {
                QueryWithParameters.$$$reportNull$$$0(1);
            }
            this(sql, (List<ColumnQueryData>)QueryWithParameters.convert(pairs2), offsets);
        }

        private QueryWithParameters(@NotNull String sql, @NotNull List<ColumnQueryData> data, int[] offsets) {
            if (sql == null) {
                QueryWithParameters.$$$reportNull$$$0(2);
            }
            if (data == null) {
                QueryWithParameters.$$$reportNull$$$0(3);
            }
            this.sql = sql;
            this.data = ContainerUtil.immutableList(data);
            this.offsets = offsets;
        }

        @NotNull
        private static ImmutableList<ColumnQueryData> convert(@NotNull List<Pair<DataConsumer.Column, Object>> pairs2) {
            if (pairs2 == null) {
                QueryWithParameters.$$$reportNull$$$0(4);
            }
            List data = ContainerUtil.map(pairs2, pair -> {
                DataConsumer.Column first2 = (DataConsumer.Column)pair.getFirst();
                Object second = pair.getSecond();
                return new ColumnQueryData(first2, second);
            });
            ImmutableList immutableList = ContainerUtil.immutableList((List)data);
            if (immutableList == null) {
                QueryWithParameters.$$$reportNull$$$0(5);
            }
            return immutableList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/OpenDataFileDescriptor$QueryWithParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

