/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranspositionAwareDefaultExtractor<T extends DatabaseSettings.StdState>
extends DefaultValuesExtractor<T> {
    protected static final DataConsumer.Column ROW_NAMES_COLUMN = new DataConsumer.Column(0, "Column", 12, "", "");
    private boolean myTransposedMode;

    protected TranspositionAwareDefaultExtractor(@NotNull T state2, @NotNull ObjectFormatter converter) {
        if (state2 == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(1);
        }
        super(state2, converter);
    }

    public void setTransposedMode(boolean enabled) {
        this.myTransposedMode = enabled;
    }

    public boolean isTransposedMode() {
        return this.myTransposedMode;
    }

    @Override
    public String getValueLiteral(@NotNull Dbms dbms, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(2);
        }
        if (value == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(3);
        }
        return super.getValueLiteral(dbms, value, TranspositionAwareDefaultExtractor.getOriginalRow(row, column2), TranspositionAwareDefaultExtractor.getOriginalColumn(row, column2));
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, boolean forDisplay) {
        if (row == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            TranspositionAwareDefaultExtractor.$$$reportNull$$$0(6);
        }
        return super.getValueAsString(TranspositionAwareDefaultExtractor.getOriginalRow(row, column2), TranspositionAwareDefaultExtractor.getOriginalColumn(row, column2), dbms, forDisplay);
    }

    @Override
    public final DataExtractor.Extraction startExtraction(CharOut out, Dbms dbms, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return this.startExtraction(out, dbms, forceSkipHeader, this.isTransposedMode(), allColumns, selectedColumns);
    }

    protected TranspositionAwareExtractionBase startExtraction(CharOut out, Dbms dbms, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new TranspositionAwareExtractionBase(out, dbms, forceSkipHeader, transposedMode, allColumns, selectedColumns);
    }

    @Nullable
    protected static DataConsumer.Column getOriginalColumn(@Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        return row instanceof TransposedRow ? ((TransposedRow)row).originalColumn : column2;
    }

    @Nullable
    protected static DataConsumer.Row getOriginalRow(@Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        return column2 instanceof TransposedColumn ? ((TransposedColumn)column2).originalRow : row;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/TranspositionAwareDefaultExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueLiteral";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class TransposedColumn
    extends DataConsumer.Column {
        public final DataConsumer.Row originalRow;

        public TransposedColumn(int columnNum, DataConsumer.Row originalRow) {
            super(columnNum, "Value (" + originalRow.rowNum + ")", 12, "", "");
            this.originalRow = originalRow;
        }
    }

    protected static class TransposedRow
    extends DataConsumer.Row {
        public final DataConsumer.Column originalColumn;

        public TransposedRow(int rowNum, Object[] values2, DataConsumer.Column originalColumn) {
            super(rowNum, values2);
            this.originalColumn = originalColumn;
        }
    }

    protected class TranspositionAwareExtractionBase
    extends DefaultValuesExtractor.DefaultExtraction {
        protected boolean myTranspose;

        public TranspositionAwareExtractionBase(CharOut output, Dbms dbms, boolean forceSkipHeader, boolean transpose, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(output, dbms, forceSkipHeader, allColumns, selectedColumnIndices);
            this.myTranspose = transpose;
        }

        @Override
        protected final void appendHeader(boolean appendNewLine) {
            if (!this.myTranspose) {
                this.doAppendHeader(appendNewLine);
            }
        }

        @Override
        protected final void appendData(List<DataConsumer.Row> rows) {
            if (!this.myTranspose) {
                this.doAppendData(rows);
            } else {
                this.doTransposedExtraction(rows);
            }
        }

        @Override
        protected final void appendFooter() {
            if (!this.myTranspose) {
                this.doAppendFooter();
            }
        }

        @Override
        @NotNull
        protected String getRowNumber(DataConsumer.Row row) {
            if (!this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0)) {
                Object rowNumber = ROW_NAMES_COLUMN.getValue(row);
                String string = rowNumber instanceof String ? (String)rowNumber : "";
                if (string == null) {
                    TranspositionAwareExtractionBase.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = super.getRowNumber(row);
            if (string == null) {
                TranspositionAwareExtractionBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        protected DataConsumer.Column getRowNumbersColumn() {
            DataConsumer.Column column2 = !this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0) ? ROW_NAMES_COLUMN : super.getRowNumbersColumn();
            if (column2 == null) {
                TranspositionAwareExtractionBase.$$$reportNull$$$0(2);
            }
            return column2;
        }

        protected void doTransposedExtraction(List<DataConsumer.Row> rows) {
            List<DataConsumer.Column> transposedColumns = this.getTransposedColumns(rows);
            int[] selectedColumns = new int[Math.max(0, transposedColumns.size() - 1)];
            for (int i2 = 0; i2 < selectedColumns.length; ++i2) {
                selectedColumns[i2] = i2 + 1;
            }
            TranspositionAwareExtractionBase e = TranspositionAwareDefaultExtractor.this.startExtraction(this.myOutput, this.myDbms, this.myForceSkipHeader, false, transposedColumns, selectedColumns);
            e.addData(this.getTransposedRows(rows));
            e.complete();
        }

        protected void doAppendHeader(boolean appendNewLine) {
            super.appendHeader(appendNewLine);
        }

        protected void doAppendData(List<DataConsumer.Row> rows) {
            super.appendData(rows);
        }

        protected void doAppendFooter() {
            super.appendFooter();
        }

        protected List<DataConsumer.Row> getTransposedRows(List<DataConsumer.Row> rows) {
            int[] originalSelection = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            ArrayList<DataConsumer.Row> transposedRows = new ArrayList<DataConsumer.Row>(originalSelection.length);
            for (int i2 : originalSelection) {
                DataConsumer.Column column2 = (DataConsumer.Column)this.myAllColumns.get(i2);
                Object[] transposedRow = new Object[rows.size() + 1];
                transposedRow[0] = column2.name;
                for (int j = 0; j < rows.size(); ++j) {
                    transposedRow[j + 1] = column2.getValue(rows.get(j));
                }
                transposedRows.add(new TransposedRow(i2, transposedRow, column2));
            }
            return transposedRows;
        }

        protected List<DataConsumer.Column> getTransposedColumns(List<DataConsumer.Row> rows) {
            ArrayList<DataConsumer.Column> transposedColumns = new ArrayList<DataConsumer.Column>(rows.size() + 1);
            transposedColumns.add(ROW_NAMES_COLUMN);
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                transposedColumns.add(new TransposedColumn(i2 + 1, rows.get(i2)));
            }
            return transposedColumns;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/extractors/TranspositionAwareDefaultExtractor$TranspositionAwareExtractionBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumber";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumbersColumn";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

