/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicColumniation
extends BasicMinorObject,
DasTableChild {
    @Nullable
    default public BasicLikeTable getLikeTable() {
        return (BasicLikeTable)this.getParent();
    }

    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            BasicColumniation.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends BasicLikeColumn> getCols() {
        List<String> names = this.getColNames();
        if (names.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicColumniation.$$$reportNull$$$0(1);
            }
            return list;
        }
        BasicLikeTable table = this.getLikeTable();
        if (table == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicColumniation.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = table.getColumns().get(names);
        if (list == null) {
            BasicColumniation.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static boolean areColNames(@NotNull BasicColumniation columniation, @NotNull List<String> names) {
        if (columniation == null) {
            BasicColumniation.$$$reportNull$$$0(4);
        }
        if (names == null) {
            BasicColumniation.$$$reportNull$$$0(5);
        }
        List<String> myNames = columniation.getColNames();
        int n = myNames.size();
        if (names.size() != n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            if (StringUtil.equals((CharSequence)myNames.get(i2), (CharSequence)names.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean dependsOnColumn(@NotNull BasicColumniation columniation, @NotNull String columnName) {
        if (columniation == null) {
            BasicColumniation.$$$reportNull$$$0(6);
        }
        if (columnName == null) {
            BasicColumniation.$$$reportNull$$$0(7);
        }
        return columniation.getColNames().contains(columnName);
    }

    @NotNull
    public static String calculateDisplayOrderByColumns(@NotNull BasicColumniation element2) {
        String d2;
        if (element2 == null) {
            BasicColumniation.$$$reportNull$$$0(8);
        }
        List<? extends BasicLikeColumn> cols2 = element2.getCols();
        int n = cols2.size();
        switch (n) {
            case 0: {
                String d22 = "\uffff";
                break;
            }
            case 1: {
                BasicElement c1 = cols2.get(0);
                String o = c1 != null ? c1.getDisplayOrder() : "";
                d2 = o + '!' + element2.getName();
                break;
            }
            default: {
                String name2 = element2.getName();
                StringBuilder b2 = new StringBuilder(n * 8 + name2.length());
                for (BasicLikeColumn basicLikeColumn : cols2) {
                    String o2 = basicLikeColumn != null ? basicLikeColumn.getDisplayOrder() : "";
                    b2.append(o2).append('!');
                }
                b2.append(name2);
                d2 = b2.toString();
            }
        }
        void v0 = d2;
        if (v0 == null) {
            BasicColumniation.$$$reportNull$$$0(9);
        }
        return v0;
    }

    @Deprecated
    default public DasTable getTable() {
        return (DasTable)ObjectUtils.tryCast((Object)this.getLikeTable(), DasTable.class);
    }

    @Deprecated
    default public String getTableName() {
        BasicLikeTable table = this.getLikeTable();
        return table != null ? table.getName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/BasicColumniation";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columniation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getColNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCols";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/BasicColumniation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisplayOrderByColumns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areColNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnColumn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateDisplayOrderByColumns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

