/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementUsageBase<T extends DbElement>
implements PsiElementUsage,
UsagePresentation,
DataProvider {
    protected final TextChunk[] myChunks;
    protected final String myText;
    protected final T myElement;

    public DbElementUsageBase(@NotNull String text2, @NotNull T element2) {
        if (text2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(1);
        }
        this(text2, element2, new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), text2)});
    }

    protected DbElementUsageBase(@NotNull String text2, @NotNull T element2, @NotNull TextChunk[] chunks) {
        if (text2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            DbElementUsageBase.$$$reportNull$$$0(3);
        }
        if (chunks == null) {
            DbElementUsageBase.$$$reportNull$$$0(4);
        }
        this.myText = text2;
        this.myElement = element2;
        this.myChunks = chunks;
    }

    @NotNull
    public UsagePresentation getPresentation() {
        DbElementUsageBase dbElementUsageBase = this;
        if (dbElementUsageBase == null) {
            DbElementUsageBase.$$$reportNull$$$0(5);
        }
        return dbElementUsageBase;
    }

    public boolean isValid() {
        return this.myElement.isValid();
    }

    public boolean isReadOnly() {
        return true;
    }

    public FileEditorLocation getLocation() {
        FileEditor editor;
        DbElement target2 = DatabaseTargetElementEvaluator.adjustForNavigation(this.myElement);
        VirtualFile file = DbImplUtil.findSourceVirtualFile(target2, true);
        FileEditor fileEditor = editor = file == null ? null : FileEditorManager.getInstance((Project)this.myElement.getProject()).getSelectedEditor(file);
        if (!(editor instanceof TextEditor)) {
            return null;
        }
        return new TextEditorLocation(0, (TextEditor)editor);
    }

    public void selectInEditor() {
    }

    public void highlightInEditor() {
    }

    protected T getNavigateElement() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        DatabaseView databaseView = DatabaseView.getDatabaseView(this.getNavigateElement().getProject());
        DatabaseViewOptions viewOptions = databaseView.getViewOptions();
        if (this.myElement instanceof DbDataSource) {
            DatabaseView.select(this.myElement, requestFocus);
        } else if (!viewOptions.HIDDEN_KINDS.contains(this.myElement.getKind().code())) {
            this.doNavigate(requestFocus);
        } else {
            this.getNavigateElement().navigate(requestFocus);
        }
    }

    protected void doNavigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public boolean isNonCodeUsage() {
        return true;
    }

    @NotNull
    public TextChunk[] getText() {
        if (this.myChunks == null) {
            DbElementUsageBase.$$$reportNull$$$0(6);
        }
        return this.myChunks;
    }

    @NotNull
    public String getPlainText() {
        String string = this.myText;
        if (string == null) {
            DbElementUsageBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    public Icon getIcon() {
        return this.myElement.getIcon();
    }

    public String getTooltipText() {
        return this.myText;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            DbElementUsageBase.$$$reportNull$$$0(8);
        }
        if (UsageView.USAGE_INFO_LIST_KEY.is(dataId)) {
            SqlDefinition definition;
            DbElement target2 = DatabaseTargetElementEvaluator.adjustForNavigation(this.myElement);
            VirtualFile file = DbImplUtil.findSourceVirtualFile(target2, true);
            if (file == null) {
                return null;
            }
            if (file instanceof DatabaseElementVirtualFileImpl) {
                DatabaseEditorHelper.reloadIfNeeded(this.myElement.getProject(), (DatabaseElementVirtualFileImpl)file);
            }
            if ((definition = DatabaseTargetElementEvaluator.calcTarget(this.myElement.getProject(), file, this.myElement)) != null) {
                return Collections.singletonList(new UsageInfo((PsiElement)definition));
            }
            PsiFile psiFile = this.myElement.getManager().findFile(file);
            return psiFile == null ? null : Collections.singletonList(new UsageInfo(psiFile));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbElementUsageBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbElementUsageBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

