/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.ChangePageSizeActionGroup;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CountRowsAction
extends IconWithTextAction
implements CustomComponentAction,
GridAction {
    static final String DESCRIPTION = "Click to update (runs SELECT COUNT(*) FROM ...)";

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CountRowsAction.$$$reportNull$$$0(0);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            CountRowsAction.countRows(grid);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CountRowsAction.$$$reportNull$$$0(1);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MyActionState state2 = CountRowsAction.getActionState(grid);
        CountRowsAction.updatePresentation(state2, e.getPresentation());
        super.update(e);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            CountRowsAction.$$$reportNull$$$0(2);
        }
        if (place == null) {
            CountRowsAction.$$$reportNull$$$0(3);
        }
        ActionButtonWithText c2 = new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public Color getInactiveTextColor() {
                return this.getForeground();
            }

            public Insets getInsets() {
                return new JBInsets(0, 0, 0, 0);
            }
        };
        JComponent jComponent = AlignedIconWithTextAction.align((JComponent)c2);
        if (jComponent == null) {
            CountRowsAction.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    public static AsyncFutureResult<Long> countRows(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            CountRowsAction.$$$reportNull$$$0(5);
        }
        return CountRowsAction.countRows(hookUp, null);
    }

    public static AsyncFutureResult<Long> countRows(@NotNull DataGrid grid) {
        if (grid == null) {
            CountRowsAction.$$$reportNull$$$0(6);
        }
        return CountRowsAction.countRows(grid.getDataHookup(), grid);
    }

    private static AsyncFutureResult<Long> countRows(final @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp, @Nullable DataGrid grid) {
        if (hookUp == null) {
            CountRowsAction.$$$reportNull$$$0(7);
        }
        final AsyncFutureResult result2 = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        final GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource = new GridRequestSource<DataConsumer.Row, DataConsumer.Column>(grid, CountRowsAction.class.getName());
        final Disposable disposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)grid, (Object)hookUp.getProject())), (Disposable)disposable);
        hookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message2, @Nullable Throwable th) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount2) {
                if (source == null) {
                    2.$$$reportNull$$$0(1);
                }
                throw new AssertionError((Object)"Row count query should not modify data");
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (source != requestSource) {
                    return;
                }
                if (success) {
                    long rowCount = hookUp.getPageModel().getTotalRowCount();
                    result2.set((Object)rowCount);
                } else {
                    result2.setException((Throwable)new Exception("Row count update failed"));
                }
                Disposer.dispose((Disposable)disposable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "source";
                objectArray2[1] = "com/intellij/database/run/actions/CountRowsAction$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, disposable);
        hookUp.getLoader().updateTotalRowCount(requestSource);
        return result2;
    }

    private static void updatePresentation(MyActionState state2, Presentation presentation) {
        MyActionState oldState = CountRowsAction.getActionState(presentation);
        if (oldState.equals(state2)) {
            return;
        }
        presentation.setText(state2.text);
        presentation.setDescription(state2.description);
        presentation.setEnabled(state2.enabled);
        presentation.setVisible(state2.visible);
        JComponent component = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(state2.tooltip);
            component.repaint();
        }
    }

    @NotNull
    private static MyActionState getActionState(@NotNull Presentation presentation) {
        if (presentation == null) {
            CountRowsAction.$$$reportNull$$$0(8);
        }
        JComponent component = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        String text2 = presentation.getText();
        String description = presentation.getDescription();
        String tooltip = component != null ? component.getToolTipText() : null;
        boolean loading = presentation.isEnabled();
        boolean visible = presentation.isVisible();
        MyActionState myActionState = new MyActionState(text2, description, tooltip, loading, visible);
        if (myActionState == null) {
            CountRowsAction.$$$reportNull$$$0(9);
        }
        return myActionState;
    }

    @NotNull
    private static MyActionState getActionState(@NotNull DataGrid grid) {
        if (grid == null) {
            CountRowsAction.$$$reportNull$$$0(10);
        }
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        int pageEndIdx = pageModel.getPageEnd();
        long totalRowCount = pageModel.getTotalRowCount();
        boolean totalRowCountIsPrecise = pageModel.isTotalRowCountPrecise();
        boolean canUpdateTotalRowCount = pageModel.isTotalRowCountUpdateable();
        boolean rowsWereDeleted = totalRowCount < (long)pageEndIdx;
        String text2 = "of " + ChangePageSizeActionGroup.format(totalRowCount) + (totalRowCountIsPrecise ? "" : "+");
        boolean querying = grid.getDataHookup().getBusyCount() > 0;
        boolean isSinglePage = pageModel.isFirstPage() && pageModel.isLastPage() && !rowsWereDeleted;
        boolean visible = !isSinglePage;
        boolean enabled = canUpdateTotalRowCount && !querying && grid.isReady();
        String description = DESCRIPTION;
        String tooltip = "Click to count(*)";
        if (!enabled) {
            String unavailableText;
            description = unavailableText = canUpdateTotalRowCount && querying ? "Querying..." : "";
            tooltip = unavailableText;
        }
        MyActionState myActionState = new MyActionState(text2, description, tooltip, enabled, visible);
        if (myActionState == null) {
            CountRowsAction.$$$reportNull$$$0(11);
        }
        return myActionState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CountRowsAction";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CountRowsAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countRows";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActionState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyActionState {
        final String text;
        final String description;
        final String tooltip;
        final boolean enabled;
        final boolean visible;

        private MyActionState(String text2, String description, String tooltip, boolean enabled, boolean visible) {
            this.text = text2;
            this.description = description;
            this.tooltip = tooltip;
            this.enabled = enabled;
            this.visible = visible;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyActionState state2 = (MyActionState)o;
            return this.enabled == state2.enabled && this.visible == state2.visible && Objects.equals(this.text, state2.text) && Objects.equals(this.description, state2.description) && Objects.equals(this.tooltip, state2.tooltip);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.description, this.tooltip, this.enabled, this.visible);
        }
    }
}

