/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaEditor {
    private final SchemaExporters mySchemaExporters;
    private final DatabaseEditorCapabilities.DbEditorCaps myDbEditorCaps;
    private static final SchemaExporters ourExporters = DasSchemaExporters.createDefaultExporters();
    private static final Map<Dbms, SchemaEditor> ourFactory = ConcurrentFactoryMap.create(dbms -> new SchemaEditor(ourExporters, DatabaseEditorCapabilities.createFor(dbms)), ContainerUtil::createConcurrentSoftValueMap);

    @NotNull
    public DeModel createModel(@NotNull DatabaseEditorContext context, @Nullable DasModel model) {
        if (context == null) {
            SchemaEditor.$$$reportNull$$$0(0);
        }
        DeModel deModel = new DeModel(this.mySchemaExporters, context, model);
        if (deModel == null) {
            SchemaEditor.$$$reportNull$$$0(1);
        }
        return deModel;
    }

    public boolean canExport(@NotNull BasicElement object) {
        if (object == null) {
            SchemaEditor.$$$reportNull$$$0(2);
        }
        return this.mySchemaExporters.get(object) != null;
    }

    public SchemaEditor(@NotNull SchemaExporters exporters, @NotNull DatabaseEditorCapabilities.DbEditorCaps caps) {
        if (exporters == null) {
            SchemaEditor.$$$reportNull$$$0(3);
        }
        if (caps == null) {
            SchemaEditor.$$$reportNull$$$0(4);
        }
        this.mySchemaExporters = exporters;
        this.myDbEditorCaps = caps;
    }

    @NotNull
    public DatabaseEditorCapabilities.DbEditorCaps getDbEditorCaps() {
        DatabaseEditorCapabilities.DbEditorCaps dbEditorCaps = this.myDbEditorCaps;
        if (dbEditorCaps == null) {
            SchemaEditor.$$$reportNull$$$0(5);
        }
        return dbEditorCaps;
    }

    public static SchemaEditor forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            SchemaEditor.$$$reportNull$$$0(6);
        }
        return ourFactory.get(dbms);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbEditorCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canExport";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

