/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentationProvider
extends DocumentationProviderEx {
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof SqlDefinition) {
            SqlDefinition definition = (SqlDefinition)element2;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " " + QNameUtil.getQualifiedName((DasObject)definition);
        }
        if (SqlImplUtil.getPomTarget(element2) instanceof BuiltinFunction) {
            return ((BuiltinFunction)ObjectUtils.notNull((Object)SqlImplUtil.getPomTarget(element2))).getName();
        }
        return null;
    }

    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof SqlDefinition) {
            PsiElement textElement = element2.getParent() instanceof SqlAlterInstruction ? element2.getParent() : element2;
            SqlDefinition definition = (SqlDefinition)element2;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " <b>" + QNameUtil.getQualifiedName((DasObject)definition) + "</b><br><pre><code>" + DbSqlUtil.sql2Html(element2.getProject(), (Language)SqlImplUtil.getSqlDialectSafe(element2), (CharSequence)ObjectUtils.notNull((Object)textElement.getText(), (Object)"")) + "</code></pre>";
        }
        if (SqlImplUtil.getPomTarget(element2) instanceof SqlFunctionDefinition && originalElement != null) {
            Class<?> dialectClass = originalElement.getContainingFile().getLanguage().getClass();
            SqlFunctionCallExpression call2 = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalElement, SqlFunctionCallExpression.class);
            SqlFunctionDefinition.Prototype prototype = call2 == null ? null : SqlFunctionsUtil.chooseTheBestPrototype(call2, false);
            return SqlDocumentationProvider.getDocumentation((SqlFunctionDefinition)((Object)ObjectUtils.notNull((Object)SqlImplUtil.getPomTarget(element2))), prototype, dialectClass);
        }
        return null;
    }

    @Nullable
    public static String getDocumentation(@NotNull SqlFunctionDefinition definition, @Nullable SqlFunctionDefinition.Prototype prototype, @NotNull Class<? extends Language> dialectClass) {
        if (definition == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (dialectClass == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(1);
        }
        int prototypeId = prototype == null ? 0 : prototype.getPrototypeId();
        String name2 = definition.getAliasedFunction();
        String basePath = "functions/" + name2.replace('@', '_');
        if (prototypeId > 0) {
            try {
                return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + "-" + prototypeId + ".html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + ".html");
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        if (object instanceof SqlFunctionDefinition.Prototype) {
            return PomService.convertToPsi((Project)psiManager.getProject(), (PomTarget)((SqlFunctionDefinition.Prototype)object).getFunction());
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(3);
        }
        PsiReference ref = contextElement == null ? TargetElementUtil.findReference((Editor)editor) : TargetElementUtil.findReference((Editor)editor, (int)contextElement.getTextOffset());
        DbElement element2 = (DbElement)SqlDocumentationProvider.findRelatedDbElements(ref, null).filter(DbImplUtil.CAN_CONNECT_TO).first();
        return element2 == null ? super.getCustomDocumentationElement(editor, file, contextElement) : element2;
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiElement o, boolean strict) {
        if (o == null || !o.isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        if (o instanceof DbElement) {
            JBIterable jBIterable = JBIterable.of((Object)((DbElement)o));
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable parents2 = strict ? JBIterable.of((Object)o) : SyntaxTraverser.psiApi().parents((Object)o);
        SqlReferenceExpression ref = (SqlReferenceExpression)parents2.filter(SqlReferenceExpression.class).first();
        DbDataSource dataSource = null;
        DbElement element2 = null;
        if (!strict) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)o);
            dataSource = DbImplUtil.findDataSource(o.getProject(), file);
            element2 = DbImplUtil.findElement(o.getProject(), file);
        }
        JBIterable<DbElement> result1 = ref != null ? SqlDocumentationProvider.findRelatedDbElements((PsiReference)ref.getReference(), null) : JBIterable.empty();
        JBIterable result2 = parents2.filter(SqlDefinition.class).filter(SqlDefinition.class).flatMap(parentDef -> SqlDocumentationProvider.findRelatedDbElements(null, parentDef));
        JBIterable jBIterable = result1.append((Iterable)result2).append((Object)element2).append((Object)dataSource);
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiReference refAt, @Nullable SqlDefinition definition) {
        if (!(refAt instanceof PsiPolyVariantReference) && definition == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable result2 = (JBIterable)RecursionManager.doPreventingRecursion((Object)ObjectUtils.coalesce((Object)refAt, (Object)definition), (boolean)false, () -> {
            if (refAt instanceof PsiPolyVariantReference) {
                return SqlDocumentationProvider.findRelatedDbElementsImpl((PsiPolyVariantReference)refAt);
            }
            return SqlDocumentationProvider.findRelatedDbElementsImpl(definition);
        });
        JBIterable jBIterable = result2 != null ? result2 : JBIterable.empty();
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull PsiPolyVariantReference refAt) {
        if (refAt == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(9);
        }
        JBIterable jBIterable = JBIterable.of((Object[])refAt.multiResolve(false)).flatMap(rr -> {
            PsiElement element2 = rr.getElement();
            if (element2 instanceof DbElement) {
                return JBIterable.of((Object)element2);
            }
            if (!(element2 instanceof SqlDefinition)) {
                return JBIterable.empty();
            }
            return SqlDocumentationProvider.findRelatedDbElementsImpl((SqlDefinition)element2);
        }).filter(DbElement.class);
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(11);
        }
        ObjectKind kind = definition.getKind();
        SqlNameElement element2 = definition.getNameElement();
        if (element2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        SqlReferenceElementType refType = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getReferenceElementType() : (kind == ObjectKind.COLUMN ? SqlCompositeElementTypes.SQL_COLUMN_REFERENCE : SqlCompositeElementTypes.SQL_REFERENCE);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
        String refText = InjectedLanguageManager.getInstance((Project)definition.getProject()).getUnescapedText((PsiElement)element2);
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)element2);
        if (newRef == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        JBIterable result2 = JBIterable.of((Object[])newRef.multiResolve(false)).transform(rr -> rr.getElement()).filter(DbElement.class);
        if (result2.isNotEmpty()) {
            JBIterable jBIterable = result2;
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        DasObject parent2 = definition.getDasParent();
        if (parent2 instanceof SqlDefinition && !(parent2 instanceof FakePsiElement)) {
            JBIterable jBIterable = SqlDocumentationProvider.findRelatedDbElementsImpl((SqlDefinition)parent2).flatMap(db -> {
                SqlReferenceExpression ref = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)db);
                return SqlDocumentationProvider.findRelatedDbElementsImpl((PsiPolyVariantReference)((SqlReferenceExpression)ObjectUtils.notNull((Object)ref)).getReference());
            });
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlDocumentationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlDocumentationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElements";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElementsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedDbElementsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

