/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DdlBuilder;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.FileStructureFilter;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeStructureUtil;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.PropertyOwner;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectIntoClauseImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableElementListImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStructureViewBuilderProvider
implements PsiStructureViewFactory {
    private static final Condition<PsiElement> DDL_FILTER = Conditions.instanceOf((Class[])new Class[]{SqlDdlStatement.class, SqlDefinition.class});
    private static final Condition<PsiElement> DML_FILTER = Conditions.instanceOf(SqlDmlStatement.class);
    private static final Condition<PsiElement> SELECT_FILTER = Conditions.instanceOf(SqlSelectStatement.class);
    private static final Condition<PsiElement> OTHER_FILTER = Conditions.and((Condition)Conditions.instanceOf(SqlStatement.class), (Condition)Conditions.not((Condition)Conditions.or(DDL_FILTER, (Condition)Conditions.or(DML_FILTER, SELECT_FILTER))));
    private static final int ITEM_TEXT_LENGTH = 50;
    private static final ClassFilter[] FILTERS = new ClassFilter[]{new ClassFilter(DDL_FILTER, "D", new ActionPresentationData("DDL statements", "", DatabaseIcons.Table)), new ClassFilter(DML_FILTER, "M", new ActionPresentationData("DML statements", "", DatabaseIcons.SqlDmlStatement)), new ClassFilter(SELECT_FILTER, "S", new ActionPresentationData("Select statements", "", DatabaseIcons.SqlSelectStatement)), new ClassFilter(OTHER_FILTER, "O", new ActionPresentationData("Other", "", DatabaseIcons.SqlOtherStatement))};
    private static final Sorter SQL_ALPHA_SORTER = new Sorter(){

        @NotNull
        public Comparator getComparator() {
            Comparator comparator = Sorter.ALPHA_SORTER.getComparator();
            if (comparator == null) {
                1.$$$reportNull$$$0(0);
            }
            return comparator;
        }

        public boolean isVisible() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentation actionPresentation = Sorter.ALPHA_SORTER.getPresentation();
            if (actionPresentation == null) {
                1.$$$reportNull$$$0(1);
            }
            return actionPresentation;
        }

        @NotNull
        public String getName() {
            if ("SQL_ALPHA_COMPARATOR" == null) {
                1.$$$reportNull$$$0(2);
            }
            return "SQL_ALPHA_COMPARATOR";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComparator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final Pattern SPACES = Pattern.compile("\\s+");

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(final @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            SqlStructureViewBuilderProvider.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof SqlFile)) {
            return null;
        }
        if (SqlStructureViewBuilderProvider.noFiltersByDefault()) {
            PropertiesComponent properties2 = PropertiesComponent.getInstance();
            boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
            for (ClassFilter filter2 : JBIterable.of((Object[])FILTERS).take(testMode ? FILTERS.length : 1)) {
                String propertyName = TreeStructureUtil.getPropertyName((String)filter2.getPropertyName());
                if (properties2.isValueSet(propertyName)) continue;
                properties2.setValue(propertyName, "true");
            }
        }
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                MyModel myModel = new MyModel((SqlFile)psiFile, editor);
                if (myModel == null) {
                    2.$$$reportNull$$$0(0);
                }
                return myModel;
            }

            public boolean isRootNodeShown() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlStructureViewBuilderProvider$2", "createStructureViewModel"));
            }
        };
    }

    public static boolean noFiltersByDefault() {
        PropertiesComponent properties2 = PropertiesComponent.getInstance();
        for (ClassFilter f : FILTERS) {
            String propertyName = TreeStructureUtil.getPropertyName((String)f.getPropertyName());
            if (!properties2.isValueSet(propertyName)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null,null->null")
    public static String getPresentableName(@Nullable PsiElement element2, @Nullable String emptyName) {
        String name2 = SqlStructureViewBuilderProvider.getPresentableName(element2);
        return StringUtil.isEmpty((String)name2) ? emptyName : name2;
    }

    @Nullable
    private static String getPresentableName(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof SqlSelectStatement) {
            SqlTableExpression fromClause;
            SqlQueryExpression qe = ((SqlSelectStatement)element2).getQueryExpression();
            SqlSelectClause selectClause = qe != null ? qe.getSelectClause() : null;
            SqlTableExpression sqlTableExpression = fromClause = qe != null ? qe.getTableExpression() : null;
            if (selectClause != null && fromClause != null) {
                return SqlStructureViewBuilderProvider.trimLong(selectClause.getText(), 25) + " " + SqlStructureViewBuilderProvider.trimLong(fromClause.getText(), 25);
            }
            return SqlStructureViewBuilderProvider.fromText(element2);
        }
        if (element2 instanceof SqlWithClause) {
            return PsiTreeUtil.firstChild((PsiElement)element2).getText();
        }
        if (element2 instanceof DasRoutine) {
            DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2).getDatabaseDialect();
            SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe(element2);
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(element2.getProject(), sqlDialect).withDialect(dialect);
            if (element2 instanceof PsiNamedElement) {
                builder.plain(StringUtil.notNullize((String)((PsiNamedElement)element2).getName()));
            }
            return dialect.sqlDefinePrototype(builder, (DasRoutine)element2, false, true).getStatement();
        }
        if (element2 instanceof SqlDefinition) {
            String name2;
            SqlDefinition definition = (SqlDefinition)element2;
            SqlNameElement namedElement = definition.getNameElement();
            if (namedElement == null) {
                if (element2 instanceof DasConstraint) {
                    String info = DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)((DasConstraint)element2).getColumnsRef());
                    if (info.isEmpty()) {
                        SqlDefinition type = (SqlDefinition)PsiTreeUtil.findChildOfType((PsiElement)element2, SqlDefinition.class);
                        return SqlStructureViewBuilderProvider.getPresentableName((PsiElement)type);
                    }
                    if (element2 instanceof DasForeignKey) {
                        DasForeignKey key2 = (DasForeignKey)element2;
                        info = info + DbPresentation.arrowToColumns(null, key2.getRefTableName(), (MultiRef<? extends DasTypedObject>)key2.getRefColumns());
                    }
                    return info;
                }
                if (element2 instanceof DasIndex) {
                    return DbPresentation.multiRef((MultiRef<? extends DasTypedObject>)((DasIndex)element2).getColumnsRef());
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(name2 = SqlStructureViewBuilderProvider.getPresentableName((PsiElement)namedElement)))) {
                return SqlStructureViewBuilderProvider.fromText(element2);
            }
            return name2;
        }
        if (element2 instanceof SqlNameElement) {
            String s = ((SqlNameElement)element2).getName();
            return StringUtil.isEmptyOrSpaces((String)s) ? SqlStructureViewBuilderProvider.fromText(element2) : s;
        }
        if (element2 instanceof DasObject) {
            return ((DasObject)element2).getName();
        }
        if (element2 instanceof SqlBlockStatementImpl) {
            return "begin ... end";
        }
        return SqlStructureViewBuilderProvider.fromText(element2);
    }

    @NotNull
    private static String fromText(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlStructureViewBuilderProvider.$$$reportNull$$$0(1);
        }
        String string = SqlStructureViewBuilderProvider.trimLong(element2.getText(), 50);
        if (string == null) {
            SqlStructureViewBuilderProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String trimLong(String text2, int limit) {
        if (limit == 0) {
            if ("" == null) {
                SqlStructureViewBuilderProvider.$$$reportNull$$$0(3);
            }
            return "";
        }
        String trim = SqlStructureViewBuilderProvider.removeDuplicateSpaces(text2).trim();
        String string = trim.length() > limit ? trim.subSequence(0, (int)((double)limit * 0.9)) + "..." + trim.subSequence((int)((double)trim.length() - (double)limit * 0.1), trim.length()) : trim;
        if (string == null) {
            SqlStructureViewBuilderProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String removeDuplicateSpaces(@Nullable String text2) {
        if (StringUtil.isEmptyOrSpaces((String)text2)) {
            if ("" == null) {
                SqlStructureViewBuilderProvider.$$$reportNull$$$0(5);
            }
            return "";
        }
        String string = SPACES.matcher(text2).replaceAll(" ");
        if (string == null) {
            SqlStructureViewBuilderProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlStructureViewBuilderProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlStructureViewBuilderProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLong";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicateSpaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStructureViewBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeGrouper
    implements Grouper {
        private final ActionPresentationData myPresentation;

        TypeGrouper(ActionPresentationData presentation) {
            this.myPresentation = presentation;
        }

        @NotNull
        public Collection<Group> group(@NotNull AbstractTreeNode parent2, @NotNull Collection<TreeElement> children2) {
            Object value;
            if (parent2 == null) {
                TypeGrouper.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                TypeGrouper.$$$reportNull$$$0(1);
            }
            if (!((value = parent2.getValue()) instanceof MyElement) || !(((MyElement)((Object)value)).getElement() instanceof PsiFile)) {
                List<Group> list = Collections.emptyList();
                if (list == null) {
                    TypeGrouper.$$$reportNull$$$0(2);
                }
                return list;
            }
            MultiMap map2 = new MultiMap();
            for (TreeElement child : children2) {
                map2.putValue((Object)((MyElement)child).myFilter, (Object)child);
            }
            ArrayList<Group> result2 = new ArrayList<Group>(map2.keySet().size());
            for (final ClassFilter filter2 : FILTERS) {
                final Collection elements = map2.get((Object)filter2);
                if (elements.isEmpty()) continue;
                result2.add(new Group(){

                    @NotNull
                    public ItemPresentation getPresentation() {
                        PresentationData presentationData = new PresentationData(filter2.getName(), "", filter2.getPresentation().getIcon(), null);
                        if (presentationData == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return presentationData;
                    }

                    @NotNull
                    public Collection<TreeElement> getChildren() {
                        Collection collection = elements;
                        if (collection == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return collection;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getPresentation";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getChildren";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                });
            }
            ArrayList<Group> arrayList = result2;
            if (arrayList == null) {
                TypeGrouper.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentation;
            if (actionPresentationData == null) {
                TypeGrouper.$$$reportNull$$$0(4);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation.getText();
            if (string == null) {
                TypeGrouper.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/SqlStructureViewBuilderProvider$TypeGrouper";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "group";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "group";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClassFilter
    implements FileStructureFilter,
    PropertyOwner {
        private final Condition<PsiElement> myFilter;
        private final Shortcut myShortCut;
        private final String myLetter;
        private final ActionPresentationData myPresentation;

        @NotNull
        public String getPropertyName() {
            String string = "SqlStructureView.filter" + this.myLetter;
            if (string == null) {
                ClassFilter.$$$reportNull$$$0(0);
            }
            return string;
        }

        ClassFilter(Condition<PsiElement> filter2, String shortCutLetter, ActionPresentationData presentation) {
            this.myFilter = filter2;
            this.myPresentation = presentation;
            this.myLetter = shortCutLetter;
            this.myShortCut = KeyboardShortcut.fromString((String)((SystemInfo.isMac ? "meta " : "control ") + shortCutLetter));
        }

        public boolean isVisible(TreeElement treeNode) {
            return !(treeNode instanceof MyElement) || !this.acceptsElement(((MyElement)treeNode).getElement());
        }

        protected boolean acceptsElement(PsiElement element2) {
            return this.myFilter.value((Object)element2);
        }

        public boolean isReverted() {
            return true;
        }

        @NotNull
        public ActionPresentation getPresentation() {
            ActionPresentationData actionPresentationData = this.myPresentation;
            if (actionPresentationData == null) {
                ClassFilter.$$$reportNull$$$0(1);
            }
            return actionPresentationData;
        }

        @NotNull
        public String getName() {
            String string = this.myPresentation.getText();
            if (string == null) {
                ClassFilter.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getCheckBoxText() {
            String string = this.myPresentation.getText();
            if (string == null) {
                ClassFilter.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Shortcut[] getShortcut() {
            Shortcut[] shortcutArray = new Shortcut[]{this.myShortCut};
            if (shortcutArray == null) {
                ClassFilter.$$$reportNull$$$0(4);
            }
            return shortcutArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$ClassFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCheckBoxText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortcut";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyElement
    extends PsiTreeElementBase<PsiElement>
    implements SortableTreeElement,
    LocationPresentation {
        private final ClassFilter myFilter;
        static final Function<PsiElement, StructureViewTreeElement> TO_ME = element2 -> new MyElement((PsiElement)element2);

        MyElement(PsiElement element2) {
            super(element2);
            ClassFilter filter2 = FILTERS[FILTERS.length - 1];
            for (ClassFilter f : FILTERS) {
                if (!f.acceptsElement(element2)) continue;
                filter2 = f;
                break;
            }
            this.myFilter = filter2;
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            SqlQueryExpression qe;
            PsiElement element2 = this.getElement();
            if (element2 == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(0);
                }
                return list;
            }
            if (element2 instanceof SqlColumnDefinition || element2 instanceof SqlTableKeyDefinition) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(1);
                }
                return list;
            }
            if (element2 instanceof SqlSelectIntoNewTableClauseImpl) {
                List list = JBIterable.from(((SqlSelectIntoNewTableClauseImpl)element2).getColumns()).transform(TO_ME).toList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (element2 instanceof SqlSelectStatement && (qe = ((SqlSelectStatement)element2).getQueryExpression()) instanceof SqlWithQueryExpression) {
                List list = JBIterable.of((Object[])new SqlElement[]{((SqlWithQueryExpression)qe).getWithClause(), ((SqlWithQueryExpression)qe).getExpression()}).transform(TO_ME).toList();
                if (list == null) {
                    MyElement.$$$reportNull$$$0(3);
                }
                return list;
            }
            List defs = MyElement.subDefinitions(element2).transform(TO_ME).toList();
            if (!defs.isEmpty() || element2.getNode() == null) {
                List list = defs;
                if (list == null) {
                    MyElement.$$$reportNull$$$0(4);
                }
                return list;
            }
            List list = this.subElements(element2).flatten(element1 -> {
                if (element1 instanceof SqlBlockStatementImpl && element1.getParent() instanceof SqlDefinition) {
                    return MyElement.subDefinitions((PsiElement)element1).append(this.subElements((PsiElement)element1));
                }
                return JBIterable.of((Object)element1).append(MyElement.subDefinitions((PsiElement)element1));
            }).transform(TO_ME).toList();
            if (list == null) {
                MyElement.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        protected JBIterable<SqlElement> subElements(PsiElement element2) {
            JBIterable jBIterable = SqlImplUtil.sqlElements(element2).filter(Conditions.notEqualTo((Object)element2)).filter(Conditions.instanceOf((Class[])new Class[]{SqlStatement.class, SqlDefinition.class, SqlTableElementListImpl.class})).flatten(o -> o instanceof SqlTableElementListImpl ? SqlImplUtil.sqlElements((PsiElement)o).filter(SqlDefinition.class) : JBIterable.of((Object)o));
            if (jBIterable == null) {
                MyElement.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        private static JBIterable<SqlElement> subDefinitions(@Nullable PsiElement element2) {
            if (!(element2 instanceof SqlElement)) {
                return JBIterable.empty();
            }
            return SqlImplUtil.getSqlDialectSafe(element2).extractDefinitions((SqlElement)element2).filter(SqlElement.class);
        }

        @NotNull
        public String getAlphaSortKey() {
            String string = this.getPresentableText();
            if (string == null) {
                MyElement.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public String getPresentableText() {
            PsiElement element2 = this.getElement();
            String string = SqlStructureViewBuilderProvider.getPresentableName(element2, "");
            if (string == null) {
                MyElement.$$$reportNull$$$0(8);
            }
            return string;
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationString() {
            PsiElement element2 = this.getElement();
            if (element2 == null) {
                return null;
            }
            return element2 instanceof DasTypedObject ? ((DasTypedObject)element2).getDataType().getSpecification() : null;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            PsiElement element2 = this.getElement();
            return element2 == null ? null : (element2 instanceof DasObject ? element2.getIcon(0) : this.myFilter.getPresentation().getIcon());
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$MyElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subElements";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlphaSortKey";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyModel
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        protected MyModel(@NotNull SqlFile psiFile, @Nullable Editor editor) {
            if (psiFile == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super((PsiFile)psiFile, editor, (StructureViewTreeElement)new MyElement((PsiElement)psiFile));
            this.withSuitableClasses(new Class[]{SqlFile.class, SqlDefinition.class, SqlStatement.class, SqlSelectIntoClauseImpl.class});
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element2) {
            return false;
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element2) {
            Object e = element2.getValue();
            return e instanceof SqlTypedDefinition || e instanceof SqlTableKeyDefinition;
        }

        @NotNull
        public ClassFilter[] getFilters() {
            ClassFilter[] classFilterArray = FILTERS;
            if (classFilterArray == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return classFilterArray;
        }

        @NotNull
        public Grouper[] getGroupers() {
            Grouper[] grouperArray = new Grouper[]{new TypeGrouper(new ActionPresentationData("Group by type", "", DatabaseIcons.SqlGroupByType))};
            if (grouperArray == null) {
                MyModel.$$$reportNull$$$0(2);
            }
            return grouperArray;
        }

        public Object getCurrentEditorElement() {
            Object element2 = super.getCurrentEditorElement();
            if (element2 != null) {
                return element2;
            }
            Editor editor = this.getEditor();
            if (editor == null) {
                return null;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiFile file = this.getPsiFile();
            PsiElement at = file.getViewProvider().findElementAt(offset, file.getLanguage());
            if (at == null && offset > 0) {
                at = file.getViewProvider().findElementAt(offset - 1, file.getLanguage());
            }
            if (at == null) {
                return null;
            }
            Object prev = this.findAcceptableElement(PsiTreeUtil.getPrevSiblingOfType((PsiElement)PsiTreeUtil.prevVisibleLeaf((PsiElement)at), SqlStatement.class));
            if (prev != null) {
                return prev;
            }
            return this.findAcceptableElement(PsiTreeUtil.nextVisibleLeaf((PsiElement)at));
        }

        @NotNull
        public Sorter[] getSorters() {
            Sorter[] sorterArray = new Sorter[]{SQL_ALPHA_SORTER};
            if (sorterArray == null) {
                MyModel.$$$reportNull$$$0(3);
            }
            return sorterArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/SqlStructureViewBuilderProvider$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupers";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSorters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

