/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base.psi;

import com.intellij.database.util.Case;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlFunctionBodyInjector
implements MultiHostInjector {
    private static Map<String, Language> ourTestInterceptor;

    public static void setTestInterceptor(@Nullable Map<String, Language> testInterceptor) {
        ourTestInterceptor = testInterceptor;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            SqlFunctionBodyInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlFunctionBodyInjector.$$$reportNull$$$0(1);
        }
        if (!(context instanceof PsiLanguageInjectionHost)) {
            return;
        }
        if (!this.canApply(context)) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        Pair<Language, String> pair = this.calcBodyLanguage(context);
        if (pair == null) {
            return;
        }
        Language language = (Language)pair.first;
        String extension = (String)pair.second;
        if (language == null) {
            return;
        }
        if (extension == null) {
            registrar.startInjecting(language);
        } else {
            registrar.startInjecting(language, extension);
        }
        Pair<String, String> prefixSuffix = this.getPrefixSuffix(language);
        String prefix = null;
        String suffix = null;
        if (prefixSuffix != null) {
            prefix = (String)prefixSuffix.first;
            suffix = (String)prefixSuffix.second;
        }
        registrar.addPlace(prefix, suffix, host, ElementManipulators.getValueTextRange((PsiElement)host));
        registrar.doneInjecting();
    }

    protected abstract boolean canApply(PsiElement var1);

    @Nullable
    protected abstract Pair<Language, String> calcBodyLanguage(@NotNull PsiElement var1);

    @Nullable
    protected abstract Pair<String, String> getPrefixSuffix(Language var1);

    @Nullable
    protected Pair<Language, String> getLangBySpec(@Nullable String text2, @NotNull PsiElement host) {
        if (host == null) {
            SqlFunctionBodyInjector.$$$reportNull$$$0(2);
        }
        return SqlFunctionBodyInjector.getLangBySpecInner(text2);
    }

    @Nullable
    @Contract(value="null,_,_->!null")
    public static Pair<Language, String> getBlockByLangSpec(@Nullable String text2, @Nullable PsiElement host, @NotNull Language language) {
        if (language == null) {
            SqlFunctionBodyInjector.$$$reportNull$$$0(3);
        }
        String string = text2 = text2 == null ? null : Case.LOWER.apply(text2);
        if (text2 == null) {
            SqlFileElementType.setPlSubDialect(host, true);
            return Pair.create((Object)language, null);
        }
        boolean isPl = text2.startsWith("pl");
        if ((text2 = text2.substring(text2.startsWith("plpg") ? 4 : (text2.startsWith("pl") ? 2 : 0), text2.endsWith("u") ? text2.length() - 1 : text2.length())).contains("sql")) {
            SqlFileElementType.setPlSubDialect(host, isPl);
            return new Pair((Object)language, (Object)text2);
        }
        SqlFileElementType.setPlSubDialect(host, false);
        return SqlFunctionBodyInjector.getLangBySpecInner(text2);
    }

    @Nullable
    protected static Pair<Language, String> getLangBySpecInner(@Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        text2 = Case.LOWER.apply(text2);
        String languageId = null;
        String extension = text2;
        if (text2.contains("python")) {
            languageId = "Python";
            extension = "py";
        } else {
            switch (text2) {
                case "v8": {
                    languageId = "JS";
                    extension = "js";
                    break;
                }
                case "java": {
                    languageId = "JAVA";
                    extension = "java";
                    break;
                }
                case "r": {
                    languageId = "R";
                    extension = "r";
                    break;
                }
                case "lua": {
                    languageId = "Lua";
                    extension = "lua";
                    break;
                }
                case "ruby": {
                    languageId = "ruby";
                    extension = "rb";
                    break;
                }
                case "javascript": {
                    languageId = "JavaScript";
                    extension = "js";
                }
            }
        }
        Language language = ourTestInterceptor != null ? ourTestInterceptor.get(languageId) : Language.findLanguageByID((String)languageId);
        return languageId == null ? SqlFunctionBodyInjector.findLanguage(text2, extension) : Pair.create((Object)language, (Object)extension);
    }

    @Nullable
    static Pair<Language, String> findLanguage(String name2, String extension) {
        FileTypeManager typeManager = FileTypeManager.getInstance();
        FileType fileType = typeManager.getFileTypeByExtension(name2);
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = typeManager.getFileTypeByExtension(extension);
        }
        if (fileType instanceof LanguageFileType) {
            return Pair.create((Object)((LanguageFileType)fileType).getLanguage(), (Object)extension);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/base/psi/SqlFunctionBodyInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLangBySpec";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockByLangSpec";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

