/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.oracle.OraElementFactory;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraOptionalKeywords;
import com.intellij.sql.dialects.oracle.OraPlReservedKeywords;
import com.intellij.sql.dialects.oracle.OraReservedKeywords;
import com.intellij.sql.dialects.oracle.OraTokens;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.com.intellij.sql.dialects.oracle.dataFlow.OraErrorSpecHelper;
import com.intellij.sql.dialects.oracle.dataFlow.OraDFABuildingVisitor;
import com.intellij.sql.dialects.oracle.psi.OraModelClauseImpl;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractFunctionHelper;
import com.intellij.sql.dialects.oracle.refactoring.OraExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraDialect
extends SqlLanguageDialectEx {
    public static final OraDialect INSTANCE = new OraDialect();

    public OraDialect() {
        super("Oracle");
    }

    protected OraDialect(@NonNls @NotNull String id) {
        if (id == null) {
            OraDialect.$$$reportNull$$$0(0);
        }
        super(id);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.ORACLE;
        if (dbms == null) {
            OraDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    public boolean isReservedKeywordPL(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokensPL.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            OraDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean processConnectByPseudoColumns(@NotNull PsiElement element2, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            OraDialect.$$$reportNull$$$0(4);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.CONNECT_BY_PSEUDO_COLUMNS.values()) {
                if (processor.executeTarget(entity, element2, this.integerType(), null, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        ObjectKind kind;
        if (element2 == null) {
            OraDialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            OraDialect.$$$reportNull$$$0(6);
        }
        if (!OraDialect.processReservedEntitiesWithTypeDual(name2, element2, resolve, processor)) {
            return false;
        }
        if (!super.processReservedEntitiesWithType(name2, element2, resolve, processor)) {
            return false;
        }
        if (processor.isExpected(ObjectKind.COLUMN) && DbImplUtil.isDataTable(kind = SqlImplUtil.getQualifierKind(element2))) {
            for (DasObject entity : LazyData.PSEUDO_COLUMNS.values()) {
                if (OraDialect.processReservedEntitiesWithTypeSimple(entity, this.integerType(), name2, element2, resolve, processor, true, null)) continue;
                return false;
            }
        }
        if ((processor.isExpected(ObjectKind.COLUMN) || processor.isExpected(ObjectKind.ROUTINE)) && (SqlType.Category.COLLECTION.is(SqlImplUtil.getQualifierType(element2)) || OraDialect.isBulkUpdateAttribute(element2))) {
            for (DasObject entity : LazyData.PL_TABLE_ATTRIBUTES.values()) {
                if (OraDialect.processReservedEntitiesWithTypeSimple(entity, entity.getKind() == ObjectKind.COLUMN ? this.integerType() : null, name2, element2, resolve, processor, true, null)) continue;
                return false;
            }
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(LazyData.RE_EXTEND.name, name2, resolve) && SqlType.Category.COLLECTION.is(SqlImplUtil.getQualifierType(element2)) && !processor.executeTarget(LazyData.RE_EXTEND, element2, SqlTypeFactory.REFERENCE, false, ResolveState.initial())) {
            return false;
        }
        if (!OraDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_PROFILE_DEFAULT, SqlTypeFactory.REFERENCE, name2, element2, resolve, processor, true, null)) {
            return false;
        }
        if (element2 instanceof SqlReferenceExpression && resolve && ((SqlReferenceExpression)element2).getQualifierExpression() == null) {
            for (ReservedEntity object : LazyData.ourObjects) {
                if (processor.executeTarget(object, element2, null, false, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            OraDialect.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            OraDialect.$$$reportNull$$$0(11);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(ObjectName.quoted((String)"PUBLIC")), false, SqlImportUtil.DATA_SOURCE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            OraDialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target2) {
        if (target2 == null) {
            OraDialect.$$$reportNull$$$0(13);
        }
        Set<ObjectKind> set = target2 == ObjectKind.ROUTINE && SqlPsiMiscUtil.isDropTarget(context) ? LazyData.IGNORED_ROUTINE_DROP_TARGETS : super.getIgnoredParentKinds(context, target2);
        if (set == null) {
            OraDialect.$$$reportNull$$$0(14);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable PsiElement element2, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            OraDialect.$$$reportNull$$$0(15);
        }
        if (strict) {
            return false;
        }
        if (SqlDialectImplUtil.isLabelOrRoutineQualification(element2, type, place, isCompletion)) {
            return true;
        }
        if (type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type == ObjectKind.ROUTINE && expectedTypes.contains(ObjectKind.COLUMN)) {
            if (element2 == null) {
                return true;
            }
            DasRoutine routine = (DasRoutine)ObjectUtils.tryCast((Object)element2, DasRoutine.class);
            if (routine == null) {
                return false;
            }
            DasArgument arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments((DasObject)routine).find(a -> !a.getName().equalsIgnoreCase("self") && a.getDefault() == null);
            return arg == null;
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            return element2 == null || element2.getParent() instanceof OraModelClauseImpl;
        }
        if (type == ObjectKind.VARIABLE && expectedTypes.contains(OraElementTypes.Extra.COLLECTION)) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element2, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        ProblemDescriptor result2 = this.checkIdentifierStartsWithLetter(o, manager, onTheFly);
        if (result2 != null) {
            return result2;
        }
        SqlDefinition def = (SqlDefinition)ObjectUtils.tryCast((Object)PsiTreeUtil.getTopmostParentOfType((PsiElement)o, SqlStatement.class), SqlDefinition.class);
        boolean isPl = false;
        if (def != null && !PsiTreeUtil.isContextAncestor((PsiElement)def.getNameElement(), (PsiElement)o, (boolean)false)) {
            ObjectKind kind = def.getKind();
            isPl = kind == ObjectKind.ROUTINE || kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
        }
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, isPl);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.PACKAGE);
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OPERATOR) {
            result2.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.BODY);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        if (type == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new OraExtractVariableHelper();
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return OraExtractFunctionHelper.INSTANCE;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            OraDialect.$$$reportNull$$$0(16);
        }
        return kind == ObjectKind.CLUSTER || super.shouldSkipFromQualification(kind);
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            OraDialect.$$$reportNull$$$0(17);
        }
        switch (cat) {
            case INTEGER: {
                return "number";
            }
            case REAL: {
                return "float";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "timestamp";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "varray";
            }
            case COLLECTION: {
                return "varray";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            OraDialect.$$$reportNull$$$0(18);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("LONG VARCHAR")) {
            if ("LONG" == null) {
                OraDialect.$$$reportNull$$$0(19);
            }
            return "LONG";
        }
        if (name2.equals("NUMERIC")) {
            if ("NUMBER" == null) {
                OraDialect.$$$reportNull$$$0(20);
            }
            return "NUMBER";
        }
        if (name2.equals("DECIMAL")) {
            if ("NUMBER" == null) {
                OraDialect.$$$reportNull$$$0(21);
            }
            return "NUMBER";
        }
        if (name2.equals("DEC")) {
            if ("NUMBER" == null) {
                OraDialect.$$$reportNull$$$0(22);
            }
            return "NUMBER";
        }
        if (name2.equals("INTEGER")) {
            if ("NUMBER" == null) {
                OraDialect.$$$reportNull$$$0(23);
            }
            return "NUMBER";
        }
        if (name2.equals("INT")) {
            if ("NUMBER" == null) {
                OraDialect.$$$reportNull$$$0(24);
            }
            return "NUMBER";
        }
        if (name2.equals("SMALLINT")) {
            if ("NUMBER" == null) {
                OraDialect.$$$reportNull$$$0(25);
            }
            return "NUMBER";
        }
        if (name2.equals("DOUBLE PRECISION")) {
            if ("FLOAT" == null) {
                OraDialect.$$$reportNull$$$0(26);
            }
            return "FLOAT";
        }
        if (name2.equals("REAL")) {
            if ("FLOAT" == null) {
                OraDialect.$$$reportNull$$$0(27);
            }
            return "FLOAT";
        }
        String string = name2;
        if (string == null) {
            OraDialect.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            OraDialect.$$$reportNull$$$0(29);
        }
        if ("BINARY_FLOAT".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(30);
            }
            return category;
        }
        if ("BINARY_DOUBLE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(31);
            }
            return category;
        }
        if ("LONG".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(32);
            }
            return category;
        }
        if ("LONG RAW".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(33);
            }
            return category;
        }
        if ("BFILE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(34);
            }
            return category;
        }
        if ("ROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(35);
            }
            return category;
        }
        if ("UROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OraDialect.$$$reportNull$$$0(36);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            OraDialect.$$$reportNull$$$0(37);
        }
        return category;
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != OraElementTypes.Extra.CONDITIONAL_FLAG && (type != ObjectKind.EXCEPTION || o != null && !this.getExceptionNames().contains(o.getName())) && super.shallResolve(o, type);
    }

    @Override
    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        if (name2 == null) {
            OraDialect.$$$reportNull$$$0(38);
        }
        if (name2.equals("JSON_PASSING_CLAUSE")) {
            return OraElementTypes.Misc.ORA_JSON_PASSING_CLAUSE;
        }
        if (name2.equals("JSON_EXISTS_ON_ERROR_CLAUSE")) {
            return OraElementTypes.Misc.ORA_JSON_EXISTS_ON_ERROR_CLAUSE;
        }
        IElementType res2 = OraElementFactory.findComposite(name2);
        return res2 == null ? super.getFunctionParserExtension(name2) : res2;
    }

    @Override
    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        OraErrorSpecHelper oraErrorSpecHelper = OraErrorSpecHelper.INSTANCE;
        if (oraErrorSpecHelper == null) {
            OraDialect.$$$reportNull$$$0(39);
        }
        return oraErrorSpecHelper;
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        OraDFABuildingVisitor oraDFABuildingVisitor = new OraDFABuildingVisitor(this);
        if (oraDFABuildingVisitor == null) {
            OraDialect.$$$reportNull$$$0(40);
        }
        return oraDFABuildingVisitor;
    }

    private static boolean isBulkUpdateAttribute(PsiElement element2) {
        PsiElement parent2 = element2.getParent();
        if (!(parent2 instanceof SqlBinaryExpression)) {
            return false;
        }
        SqlUnaryExpression prev = (SqlUnaryExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element2, SqlUnaryExpression.class);
        ASTNode node = prev == null ? null : prev.getNode();
        ASTNode bulkException = node == null ? null : node.findChildByType(OraTypes.ORA_BULK_EXCEPTIONS);
        return bulkException != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraDialect";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 18: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraDialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createDFAVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processConnectByPseudoColumns";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final Set<ObjectKind> IGNORED_ROUTINE_DROP_TARGETS = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.PACKAGE, ObjectKind.OBJECT_TYPE});
        static final TokenClasses ourClasses = new TokenClasses(OraTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = new SqlLanguageDialectEx.BuiltinFunctionsMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars;
        static final Set<String> ourExceptionNames;
        static final List<ReservedEntity> ourObjects;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static final NullableFunction<String, IElementType> ourReservedTokensPL;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final TokenSet ourClosingTokens;
        static final Set<IElementType> ourSupportedOperators;
        static final Map<String, DasObject> PSEUDO_COLUMNS;
        static final Map<String, DasObject> CONNECT_BY_PSEUDO_COLUMNS;
        static final Map<String, DasObject> PL_TABLE_ATTRIBUTES;
        static final ReservedEntity RE_EXTEND;
        static final ReservedEntity RE_PROFILE_DEFAULT;
        private static final EnterHandlerDelegate ENTER_HANDLER;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            SqlTokenRegistry.initTypeMap(OraPlReservedKeywords.class, null);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
            ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
            ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourReservedTokensPL = SqlTokenRegistry.getTokenProvider(OraPlReservedKeywords.class);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV, SqlTokens.ORAP_SLASH_DELIMITER_TOKEN, SqlTokens.ORAP_DELIMITER_TOKEN})});
            ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.ORA_POWER, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.ORA_OP_JOIN, OraReservedKeywords.ORA_PRIOR, OraOptionalKeywords.ORA_LIKEC, OraOptionalKeywords.ORA_LIKE2, OraOptionalKeywords.ORA_LIKE4, OraTypes.ORA_AT, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_NEQ_WS, SqlTokens.SQL_OP_NEQ2_WS, SqlTokens.SQL_OP_NEQ3_WS, SqlTokens.SQL_YEAR, SqlTokens.SQL_DAY, SqlTokens.SQL_OP_ASSIGN, OraTypes.ORA_MEMBER, OraTypes.ORA_SUBMULTISET, OraTypes.ORA_CURSOR, OraOptionalKeywords.ORA_MULTISET});
            PSEUDO_COLUMNS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "BINARY_DOUBLE_INFINITY", "BINARY_DOUBLE_NAN", "BINARY_FLOAT_INFINITY", "BINARY_FLOAT_NAN", "COLUMN_VALUE", "OBJECT_ID", "OBJECT_VALUE", "ORA_ROWSCN", "VERSIONS_STARTTIME", "VERSIONS_STARTSCN", "VERSIONS_ENDTIME", "VERSIONS_ENDSCN", "VERSIONS_XID", "VERSIONS_OPERATION", "XMLDATA", "ROWID", "ROWNUM");
            CONNECT_BY_PSEUDO_COLUMNS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "CONNECT_BY_ISCYCLE", "CONNECT_BY_ISLEAF", "LEVEL");
            PL_TABLE_ATTRIBUTES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "COUNT", "FIRST", "LAST");
            RE_EXTEND = new ReservedEntity("extend", ObjectKind.OBJECT_TYPE);
            RE_PROFILE_DEFAULT = new ReservedEntity("DEFAULT", SqlDbElementType.PROFILE);
            ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_WHILE_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false))));
            PL_TABLE_ATTRIBUTES.putAll(SqlDialectImplUtil.buildEntities(ObjectKind.ROUTINE, "EXISTS", "PRIOR", "NEXT", "DELETE"));
        }
    }
}

