/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.postgres.PgParser;
import com.intellij.sql.dialects.postgres.PgParserBase;
import com.intellij.sql.dialects.redshift.RsDdlParsing;
import com.intellij.sql.dialects.redshift.RsDialect;
import com.intellij.sql.dialects.redshift.RsDmlParsing;
import com.intellij.sql.dialects.redshift.RsExpressionParsing;
import com.intellij.sql.dialects.redshift.RsGeneratedParser;
import com.intellij.sql.dialects.redshift.RsGeneratedParserUtil;
import com.intellij.sql.dialects.redshift.RsPlParsing;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class RsParser
extends PgParserBase {
    public static final SqlSuggestedInjection REDSHIFT_INJECTION = new SqlSuggestedInjection("Redshift");

    public RsParser() {
        super(RsDialect.INSTANCE);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (RsGeneratedParserUtil.isJoinOperator(builder)) {
            return false;
        }
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (RsGeneratedParser.within_group_clause(builder, level) | RsGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref = SqlGeneratedParserUtil.getExposedFunctionRef(builder);
            IElementType iElementType = type = ref == null ? null : ref.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return REDSHIFT_INJECTION;
    }

    @Override
    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        PsiBuilder.Marker mark2 = builder.mark();
        if (!allowCharSetSpec && this.getLanguage().supportsSql92CharSetSpecFor((IElementType)SQL_IDENTIFIER)) {
            this.consumeUnderscoreAndCharSpec(builder);
        }
        if (this.consumeIdentifier(builder, allowKeywords, this.allowStringsAsIdentifiers(refType), refType != null)) {
            mark2.done((IElementType)SQL_IDENTIFIER);
            return true;
        }
        if (!optional) {
            mark2.error(SqlMessages.message("identifier.expected", new Object[0]));
        } else {
            mark2.drop();
        }
        return false;
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return RsGeneratedParser.parse_extra_roots_(root2, builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = RsExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, RsExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (super.parseSqlStatement(builder, level)) {
            return true;
        }
        return RsGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return RsGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return RsDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? RsPlParsing.type_element_ext(builder, level) : RsDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, RsExpressionParsing::parenthesized_values_expr, RsDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, RsExpressionParsing::row_element_list, (b2, l) -> RsExpressionParsing.root_expr_0(b2, l, -1) && RsExpressionParsing.row_element_list_separator(b2, l) && RsExpressionParsing.row_element_list(b2, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, RsDmlParsing::parenthesized_aliased_join_expression, RsDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, (b2, l) -> RsDmlParsing.join_expression(b2, l, -1), (b2, l) -> RsDmlParsing.join_expression_0(b2, l, -1));
    }

    @Override
    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        RsDmlParsing.order_by_clause(builder, level);
        return true;
    }

    @Override
    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result2 = super.parseTypedReference(builder, refType);
        if (!result2 && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark2 = builder.mark();
            builder.advanceLexer();
            mark2.done((IElementType)SQL_STRING_LITERAL);
            result2 = true;
        }
        if (result2 && SqlParserUtil.consumeOptionalToken(builder, (IElementType)PG_OP_TYPE_CAST)) {
            PsiBuilder.Marker marker = (PsiBuilder.Marker)ObjectUtils.assertNotNull((Object)((PsiBuilder.Marker)builder.getLatestDoneMarker()));
            RsPlParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result2;
    }

    @Override
    @Nullable
    public IElementType getLazyCodeBlockType() {
        return null;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        RsDmlParsing.query_expression_0(builder, level, -1);
        return RsDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

