/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/SqlIndentOptionProvider;", "Lcom/intellij/psi/codeStyle/FileIndentOptionsProvider;", "()V", "getIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.database.sql.impl"})
public final class SqlIndentOptionProvider
extends FileIndentOptionsProvider {
    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        CommonCodeStyleSettings.IndentOptions indentOptions;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Language language = file.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"file.language");
        Language dialect = language;
        if (dialect instanceof SqlLanguageDialect) {
            SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((CodeStyleSettings)settings, (Language)dialect);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlCodeStyleSettings, (String)"SqlCodeStyles.getSqlSettings(settings, dialect)");
            indentOptions = sqlCodeStyleSettings.getCorrespondedIndentOptions();
        } else {
            indentOptions = dialect instanceof SqlLanguage ? settings.getLanguageIndentOptions((Language)SqlLanguage.INSTANCE) : null;
        }
        return indentOptions;
    }
}

