/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.psi.SqlCommonTokens;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/formatter/model/UntilPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "untilMatcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "acceptEOF", "", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "(Ljava/lang/Byte;Ljava/lang/Byte;Lcom/intellij/sql/formatter/model/NodeMatcher;ZLcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.impl"})
public final class UntilPattern
extends FlowPattern {
    private final NodeMatcher untilMatcher;
    private final boolean acceptEOF;
    @NotNull
    private final BlockRole role;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IntRange process(@NotNull List<? extends ASTNode> nodes2, int since) {
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int n = nodes2.size();
        if (since >= n) {
            return null;
        }
        if (NodeMatcherKt.matches(nodes2.get(since), this.untilMatcher)) {
            return null;
        }
        int par = 0;
        int n2 = since;
        int n3 = n;
        while (n2 < n3) {
            void k;
            ASTNode theNode = nodes2.get((int)k);
            if (par <= 0 && NodeMatcherKt.matches(theNode, this.untilMatcher)) {
                return RangesKt.until((int)since, (int)k);
            }
            IElementType iElementType = theNode.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_LEFT_PAREN)) {
                ++par;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_RIGHT_PAREN)) {
                --par;
            }
            ++k;
        }
        return this.acceptEOF ? RangesKt.until((int)since, (int)n) : null;
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    public UntilPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull NodeMatcher untilMatcher, boolean acceptEOF, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkParameterIsNotNull((Object)untilMatcher, (String)"untilMatcher");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.untilMatcher = untilMatcher;
        this.acceptEOF = acceptEOF;
        this.role = role;
    }

    public /* synthetic */ UntilPattern(Byte by, Byte by2, NodeMatcher nodeMatcher, boolean bl, BlockRole blockRole, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            blockRole = BlockRole.NOTHING;
        }
        this(by, by2, nodeMatcher, bl, blockRole, (Function0<? extends SqlBlock>)function0);
    }
}

