/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.util.io.ZipUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkSessionUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.remote.PyHelpersDownload;
import com.jetbrains.python.remote.PyHelpersUpload;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PyRemoteSkeletonGeneratorWithRemoteSources;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyRemoteSkeletonGenerator
extends PyRemoteSkeletonGeneratorWithRemoteSources {
    @Nullable
    private final Component myOwnerComponent;
    private final PyRemoteSdkCredentials myRemoteSdkData;

    PyRemoteSkeletonGenerator(@Nullable Project project, @Nullable Component ownerComponent, String skeletonsPath, Sdk sdk) throws ExecutionException {
        super(skeletonsPath, sdk, null, project);
        this.myOwnerComponent = ownerComponent;
        try {
            this.myRemoteSdkData = this.getRemoteSdkAdditionalData().getRemoteSdkCredentials(false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Couldn't get remote credentials", e);
        }
    }

    public void prepare() {
        ListenableFuture<?> future = PyHelpersUpload.uploadAllHelpers(this.myProject, null, (RemoteSdkCredentials)this.myRemoteSdkData, false);
        try {
            future.get();
        }
        catch (Exception e) {
            LOG.error("Helpers upload failed", (Throwable)e);
        }
    }

    protected ProcessOutput getProcessOutput(String homePath, @NotNull String[] commandLine, Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        if (commandLine == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(0);
        }
        commandLine = PyRemoteSkeletonGenerator.addUnbuffered(homePath, commandLine);
        PyRemoteSdkCredentials data = this.myRemoteSdkData;
        try {
            PyRemotePathMapper pathMapper = this.createPathMappings(this.myProject, (PyRemoteSdkAdditionalDataBase)this.getRemoteSdkAdditionalData());
            ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)data, (Project)this.myProject);
            RemoteSdkSessionUtil.checkConnection((ConnectionBuilder)connectionBuilder, (Project)this.myProject);
            return PyRemoteProcessUtil.getProcessOutput(connectionBuilder, (RemoteSdkCredentials)data, pathMapper, commandLine);
        }
        catch (RemoteSdkException e) {
            throw new InvalidSdkException(e.getMessage(), (Throwable)e);
        }
    }

    public void finishSkeletonsGeneration() {
    }

    private ProcessHandler getProcessHandler(Project project, GeneralCommandLine commandLine) throws InvalidSdkException {
        PyRemoteSdkCredentials remoteSdkData = this.myRemoteSdkData;
        PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
        if (manager != null) {
            try {
                assert (this.mySdk.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase);
                return manager.startRemoteProcess(project, remoteSdkData, commandLine, this.createPathMappings(project, (PyRemoteSdkAdditionalDataBase)this.mySdk.getSdkAdditionalData()));
            }
            catch (RemoteSdkException e) {
                throw new InvalidSdkException("Error running SDK");
            }
        }
        throw new InvalidSdkException("Remote interpreter can't be executed. Please enable the Remote Hosts Access plugin.");
    }

    private GeneralCommandLine createZipSourcesCommandLine() {
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{this.mySdk.getHomePath()});
        cmd.getParametersList().addParamsGroup("Exe Options");
        ParamsGroup group = cmd.getParametersList().addParamsGroup("Script");
        group.addParameters(new String[]{PythonHelpersLocator.getHelperPath((String)"generator3.py"), "-z", this.getSkeletonsPath()});
        return cmd;
    }

    private static void extractSources(File arc, String localPath) throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setText("Extracting contents of " + arc.getPath());
        CountingFilenameFilter countingFilenameFilter = new CountingFilenameFilter();
        ZipUtil.extract((File)arc, (File)new File(localPath), (FilenameFilter)countingFilenameFilter);
        LOG.info("Extracted " + countingFilenameFilter.myCount + " files from skeletons zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendSourcesToCompressList(@NotNull Collection<PyRemoteSourceItem> list, @NotNull ProcessHandler process) {
        if (list == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(1);
        }
        if (process == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(2);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try (PrintWriter w = new PrintWriter(process.getProcessInput());){
            for (PyRemoteSourceItem sourceItem : list) {
                indicator.setText("Compressing " + sourceItem.getModule());
                String arcPath = sourceItem.getArcPath();
                arcPath = StringUtil.trimStart((String)arcPath, (String)"/");
                w.println(sourceItem.getPath() + " " + arcPath);
            }
            w.println("-");
            w.flush();
        }
    }

    @Override
    protected String getRemoteSkeletonsPath() {
        String sdkHomePath = this.mySdk.getHomePath();
        assert (sdkHomePath != null);
        return RemoteFile.detectSystemByPath((String)sdkHomePath).createRemoteFile(PythonSdkType.getSkeletonsPath((String)this.myRemoteSdkData.getHelpersPath(), (String)sdkHomePath)).getPath();
    }

    @Override
    protected void downloadSourcesToLocalFolder(@NotNull String localPath, @NotNull Collection<PyRemoteSourceItem> sourcesToDownload) throws InvalidSdkException {
        if (localPath == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(3);
        }
        if (sourcesToDownload == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(4);
        }
        final Ref zipTransfer = Ref.create((Object)false);
        final Ref zipSourceItem = Ref.create(null);
        GeneralCommandLine cmd = this.createZipSourcesCommandLine();
        long compressingStartedInNanos = System.nanoTime();
        ProcessHandler process = this.getProcessHandler(this.myProject, cmd);
        final Semaphore semaphore = new Semaphore(0);
        final StringBuilder output = new StringBuilder();
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                String text = event.getText();
                output.append(text);
                if (text.startsWith("OK: ")) {
                    text = text.substring(4).trim();
                    zipSourceItem.set((Object)new PyRemoteSourceItem(text, new File(text).getParent(), 0));
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                LOG.info("Remote zip process terminated with exit code " + event.getExitCode());
                if (event.getExitCode() != 0) {
                    zipTransfer.set((Object)false);
                } else {
                    zipTransfer.set((Object)true);
                }
                semaphore.release(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSkeletonGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        process.startNotify();
        LOG.info("Compressing " + sourcesToDownload.size() + " source files");
        PyRemoteSkeletonGenerator.sendSourcesToCompressList(sourcesToDownload, process);
        process.waitFor(2000L);
        try {
            while (!process.isProcessTerminated() && !semaphore.tryAcquire(120L, TimeUnit.SECONDS)) {
                long durationInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - compressingStartedInNanos);
                LOG.info("Still compressing source files during " + StringUtil.formatDuration((long)durationInMillis) + "...");
            }
        }
        catch (InterruptedException e) {
            zipTransfer.set((Object)false);
        }
        if (((Boolean)zipTransfer.get()).booleanValue()) {
            try {
                PyRemoteSourceItem remoteZip = (PyRemoteSourceItem)zipSourceItem.get();
                String name = new File(remoteZip.getPath()).getName();
                File zipFile = new File(localPath, name);
                FileUtil.delete((File)zipFile);
                LOG.info("Downloading zipped sources and localSourcesFile: " + remoteZip.getPath());
                this.transferSources(Lists.newArrayList((Object[])new PyRemoteSourceItem[]{remoteZip}), localPath);
                LOG.info("Extracting downloaded zipped sources and localSourcesFile: " + zipFile.getPath());
                PyRemoteSkeletonGenerator.extractSources(zipFile, localPath);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                zipTransfer.set((Object)false);
            }
        }
        if (!((Boolean)zipTransfer.get()).booleanValue()) {
            LOG.warn("Problems with compressing sources:\n" + output.toString());
            try {
                this.transferSources(sourcesToDownload, localPath);
            }
            catch (Exception e) {
                LOG.error("Can't copy sources ", (Throwable)e);
            }
        }
    }

    private void transferSources(@NotNull Collection<PyRemoteSourceItem> sources, @NotNull String localFolder) throws FileSystemException {
        if (sources == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(5);
        }
        if (localFolder == null) {
            PyRemoteSkeletonGenerator.$$$reportNull$$$0(6);
        }
        PyHelpersDownload.transferSources(this.mySdk, this.myProject, this.myOwnerComponent, this.myRemoteSdkData, sources, localFolder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcesToDownload";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSkeletonGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProcessOutput";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendSourcesToCompressList";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadSourcesToLocalFolder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "transferSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CountingFilenameFilter
    implements FilenameFilter {
        private int myCount = 0;

        private CountingFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            ++this.myCount;
            return true;
        }
    }
}

