/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PySyncDirection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyServerBasedRemoteProjectSynchronizer
implements PyProjectSynchronizer {
    @NotNull
    protected final Sdk mySdk;
    @NotNull
    protected final PyRemoteSdkAdditionalData myAdditionalData;

    protected PyServerBasedRemoteProjectSynchronizer(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(0);
        }
        this.mySdk = sdk;
        this.myAdditionalData = PyServerBasedRemoteProjectSynchronizer.getAdditionalData(this.mySdk);
    }

    @NotNull
    static PyRemoteSdkAdditionalData getAdditionalData(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(1);
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        assert (data instanceof PyRemoteSdkAdditionalData) : String.format("sdk is not remote: %s", sdk);
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = (PyRemoteSdkAdditionalData)data;
        if (pyRemoteSdkAdditionalData == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(2);
        }
        return pyRemoteSdkAdditionalData;
    }

    @Nullable
    public final String mapFilePath(@NotNull Project project, @NotNull PySyncDirection direction, @NotNull String filePath) {
        List<PathMappingSettings.PathMapping> mappings;
        if (project == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(3);
        }
        if (direction == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(4);
        }
        if (filePath == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(5);
        }
        if ((mappings = this.getPathMappingsIgnoreError(project)) == null) {
            return null;
        }
        for (PathMappingSettings.PathMapping mapping : mappings) {
            if (direction == PySyncDirection.REMOTE_TO_LOCAL && mapping.canReplaceRemote(filePath)) {
                return mapping.mapToLocal(filePath);
            }
            if (direction != PySyncDirection.LOCAL_TO_REMOTE || !mapping.canReplaceLocal(filePath)) continue;
            return mapping.mapToRemote(filePath);
        }
        return null;
    }

    @Nullable
    protected abstract Result<List<PathMappingSettings.PathMapping>, String> getPathMappings(@NotNull Project var1);

    @Nullable
    protected final List<PathMappingSettings.PathMapping> getPathMappingsIgnoreError(@NotNull Project project) {
        Result<List<PathMappingSettings.PathMapping>, String> result;
        if (project == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(6);
        }
        if ((result = this.getPathMappings(project)) == null) {
            return null;
        }
        return (List)result.getSuccessOrNull();
    }

    @Nullable
    public String getDefaultRemotePath() {
        return null;
    }

    @NotNull
    protected final PyRemoteSdkCredentials getCredentials() throws ExecutionException, InterruptedException {
        PyRemoteSdkCredentials pyRemoteSdkCredentials = this.myAdditionalData.getRemoteSdkCredentials(null, false);
        if (pyRemoteSdkCredentials == null) {
            PyServerBasedRemoteProjectSynchronizer.$$$reportNull$$$0(7);
        }
        return pyRemoteSdkCredentials;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyServerBasedRemoteProjectSynchronizer";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyServerBasedRemoteProjectSynchronizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalData";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingsIgnoreError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

