/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectLoaded
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"PerformancePlugin");
    private static final int TIMEOUT = 10000;
    private static final String fileNameProperty = System.getProperty("testscript.filename");
    private static final String INDEXING_PROFILER_PREFIX = "%%profileIndexing";
    private final Project myProject;

    private static Pair<String, List<String>> initializeProfilerSettingsForIndexing() {
        try {
            List lines = FileUtil.loadLines((File)ProjectLoaded.getTestFile());
            for (String line : lines) {
                if (!line.startsWith(INDEXING_PROFILER_PREFIX)) continue;
                String[] command = line.substring(INDEXING_PROFILER_PREFIX.length()).trim().split("\\s+", 2);
                String indexingActivity = command[0];
                ArrayList profilingParameters = command.length > 1 ? Arrays.asList(command[1].trim().split(",")) : new ArrayList();
                return new Pair((Object)indexingActivity, profilingParameters);
            }
        }
        catch (IOException ignored) {
            System.err.println(MessagesBundle.message("startup.script.read.error", new Object[0]));
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        return null;
    }

    public ProjectLoaded(@NotNull Project project) {
        if (project == null) {
            ProjectLoaded.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    private static File getTestFile() {
        File file = new File(fileNameProperty);
        if (!file.isFile()) {
            System.err.println(MessagesBundle.message("startup.noscript", file.getAbsolutePath()));
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        return file;
    }

    public void projectOpened() {
        if (fileNameProperty != null) {
            LOG.info("Start Execution");
            ProjectLoaded.subscribeToErrors();
            Pair<String, List<String>> profilerSettings = ProjectLoaded.initializeProfilerSettingsForIndexing();
            if (profilerSettings != null) {
                try {
                    ProfilersController.getInstance().getCurrentProfilerHandler().startProfiling((String)profilerSettings.first, (List)profilerSettings.second);
                }
                catch (Exception e) {
                    System.err.println("Start profile failed: " + e.getMessage());
                    ApplicationManagerEx.getApplicationEx().exit(true, true);
                }
            }
            this.runAfterDumb();
        } else {
            if (YourKitProfilerHandler.isStartupProfilingInVMEnabled()) {
                YourKitProfilerHandler.disableProfiler();
                ProjectLoaded.showStartupProfilingNotification();
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info(MessagesBundle.message("startup.silent", new Object[0]));
            }
        }
    }

    private static void showStartupProfilingNotification() {
        final File snapshotDir = new File(SystemProperties.getUserHome(), "snapshots");
        final Notification completeNotification = new Notification("PerformancePlugin", "Startup Profiling in Progress", "CPU snapshot file will be saved automatically into " + snapshotDir.getAbsolutePath() + " after you close the IDE.", NotificationType.INFORMATION);
        completeNotification.addAction(new AnAction("Show Profile Location"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileUtil.createDirectory((File)snapshotDir);
                ShowFilePathAction.openDirectory((File)snapshotDir);
                completeNotification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/ProjectLoaded$1", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)completeNotification);
    }

    private static void subscribeToErrors() {
        final MessagePool messagePool = MessagePool.getInstance();
        messagePool.addListener(new MessagePoolListener(){

            public void newEntryAdded() {
                List errors = messagePool.getFatalErrors(true, true);
                if (!errors.isEmpty()) {
                    String throwableText = ((AbstractMessage)errors.get(0)).getThrowableText();
                    System.out.printf("##teamcity[testFailed name='%s' message='%s' details='%s']\n", FileUtilRt.getNameWithoutExtension((String)ProjectLoaded.getTestFile().getName()), "Exception occured during the run", ProjectLoaded.processStringForTC(throwableText));
                    ApplicationManagerEx.getApplicationEx().exit(true, true);
                }
            }

            public void poolCleared() {
            }

            public void entryWasRead() {
            }
        });
    }

    private static String processStringForTC(String line) {
        int MAX_DESCRIPTION_LENGTH = 10000;
        return line.substring(0, Math.min(10000, line.length() - 1)).replaceAll("\\|", "||").replaceAll("\\[", "|[").replaceAll("]", "|]").replaceAll("\n", "|n").replaceAll("'", "|'").replaceAll("\r", "|r");
    }

    private void runAfterDumb() {
        IdeEventQueue.getInstance().addIdleListener(new Runnable(){

            @Override
            public void run() {
                DumbService.getInstance((Project)ProjectLoaded.this.myProject).smartInvokeLater(() -> {
                    PlaybackRunnerExtended playback = ProjectLoaded.this.createRunner("%include " + ProjectLoaded.getTestFile(), new CommandLogger(), ProjectLoaded.this.myProject);
                    playback.setScriptDir(ProjectLoaded.getTestFile().getParentFile());
                    playback.run();
                });
                IdeEventQueue.getInstance().removeIdleListener((Runnable)this);
            }
        }, 10000);
    }

    @NotNull
    protected PlaybackRunnerExtended createRunner(String script, CommandLogger commandLogger, Project project) {
        PlaybackRunnerExtended playbackRunnerExtended = new PlaybackRunnerExtended(script, commandLogger, project);
        if (playbackRunnerExtended == null) {
            ProjectLoaded.$$$reportNull$$$0(1);
        }
        return playbackRunnerExtended;
    }

    public void projectClosed() {
        if (fileNameProperty != null) {
            LOG.info(MessagesBundle.message("startup.finish", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/ProjectLoaded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/ProjectLoaded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

