/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.CachingDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.PureDockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.parse.ToolBasedDockerComposeConfigurationParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeConfigurationParserUtil {
    public static final String VERSION_3 = "3";
    static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)(\\.\\d+)?");
    private static DockerComposeConfigurationParser ourInstance;
    private static final Object ourInstanceCreationMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DockerComposeConfigurationParser defaultParserForUi() {
        Object object = ourInstanceCreationMonitor;
        synchronized (object) {
            if (ourInstance == null) {
                ourInstance = new CachingDockerComposeConfigurationParser(new ToolBasedDockerComposeConfigurationParser(PureDockerComposeConfigurationParser.getInstance()));
            }
            return ourInstance;
        }
    }

    @Nullable
    public static String getMajorVersion(@NotNull String version) {
        Matcher matcher;
        if (version == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(0);
        }
        return (matcher = VERSION_PATTERN.matcher(version)).matches() ? matcher.group("major") : null;
    }

    public static void saveDockerComposeFiles(@NotNull List<String> dockerComposeFilePaths) {
        if (dockerComposeFilePaths == null) {
            DockerComposeConfigurationParserUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            List documents = (List)ReadAction.compute(() -> {
                ArrayList<Document> list = new ArrayList<Document>();
                LocalFileSystem fs = LocalFileSystem.getInstance();
                for (String path : dockerComposeFilePaths) {
                    VirtualFile file2 = fs.findFileByPath(path);
                    if (file2 == null) continue;
                    list.add(documentManager.getDocument(file2));
                }
                return list;
            });
            if (!documents.isEmpty()) {
                WriteAction.runAndWait(() -> {
                    for (Document document : documents) {
                        if (!documentManager.isDocumentUnsaved(document)) continue;
                        documentManager.saveDocument(document);
                    }
                });
            }
        });
    }

    static {
        ourInstanceCreationMonitor = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeFilePaths";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationParserUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMajorVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "saveDockerComposeFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

