/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryUtil;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(0);
        }
        SyntheticLibrary library = NodeCoreSyntheticLibraryProvider.getSyntheticLibrary(project);
        List list2 = ContainerUtil.createMaybeSingletonList((Object)library);
        if (list2 == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public static SyntheticLibrary getSyntheticLibrary(@NotNull Project project) {
        if (project == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(2);
        }
        NodeCoreLibraryConfigurator configurator = NodeCoreLibraryConfigurator.getInstance(project);
        NodeCoreLibraryManager coreLibraryManager = configurator.getCoreLibraryManager();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<VirtualFile> coreModuleFiles = configurator.myTestCoreModuleFiles;
            if (coreModuleFiles == null) {
                coreLibraryManager.setSnapshot(null);
                return null;
            }
            if (coreModuleFiles.isEmpty()) {
                coreLibraryManager.setSnapshot(null);
            } else {
                VirtualFile parentDir = ((VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(coreModuleFiles))).getParent();
                coreLibraryManager.setSnapshot(new NodeCoreSourcesSnapshot(parentDir));
            }
            return SyntheticLibrary.newImmutableLibrary((Collection)ContainerUtil.union(coreModuleFiles, NodeCoreLibraryUtil.getNodeGlobalStubFiles()));
        }
        String version = configurator.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isEmptyOrSpaces((String)version)) {
            coreLibraryManager.setSnapshot(null);
            return null;
        }
        File coreModulesSrcDir = NodeCoreLibraryConfigurator.getCoreModulesSrcDir(version);
        VirtualFile coreModulesSrcVirtualDir = LocalFileSystem.getInstance().findFileByIoFile(coreModulesSrcDir);
        if (coreModulesSrcVirtualDir == null) {
            coreLibraryManager.setSnapshot(null);
            return null;
        }
        NodeCoreSourcesSnapshot snapshot = new NodeCoreSourcesSnapshot(coreModulesSrcVirtualDir);
        coreLibraryManager.setSnapshot(snapshot);
        if (!coreLibraryManager.hasAssociatedRoots()) {
            return null;
        }
        SyntheticLibrary library = NodeCoreSyntheticLibraryProvider.createLibrary(version, snapshot);
        return new NodeCoreSyntheticLibrary(project, version, library);
    }

    @NotNull
    private static SyntheticLibrary createLibrary(@NotNull String version, @NotNull NodeCoreSourcesSnapshot snapshot) {
        if (version == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(3);
        }
        if (snapshot == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(4);
        }
        if (NodeCoreLibraryManager.shouldUseNodeTypings()) {
            VirtualFile nodeTypingsDir;
            File typingsDir = NodeCoreLibraryConfigurator.getTypingsDir(version);
            VirtualFile typingsVirtualDir = LocalFileSystem.getInstance().findFileByIoFile(typingsDir);
            if (typingsVirtualDir != null && (nodeTypingsDir = typingsVirtualDir.findFileByRelativePath("node_modules/@types/node")) != null && nodeTypingsDir.isDirectory()) {
                SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary((Collection)ContainerUtil.newArrayList((Object[])new VirtualFile[]{nodeTypingsDir.getParent(), snapshot.getCoreModulesSrcDir()}), Collections.emptyList(), NodeCoreSyntheticLibraryProvider.getExcludedSources(snapshot), null);
                if (syntheticLibrary == null) {
                    NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(5);
                }
                return syntheticLibrary;
            }
        }
        ArrayList<VirtualFile> sourceRoots = new ArrayList<VirtualFile>(NodeCoreLibraryUtil.getNodeGlobalStubFiles());
        ContainerUtil.addAllNotNull(sourceRoots, (Object[])new VirtualFile[]{snapshot.getCoreModulesSrcDir()});
        Set<VirtualFile> excluded = NodeCoreSyntheticLibraryProvider.getExcludedSources(snapshot);
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(sourceRoots, excluded, null);
        if (syntheticLibrary == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(6);
        }
        return syntheticLibrary;
    }

    @NotNull
    private static Set<VirtualFile> getExcludedSources(@NotNull NodeCoreSourcesSnapshot snapshot) {
        if (snapshot == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(7);
        }
        HashSet excluded = ContainerUtil.newHashSet((Object[])VfsUtil.getChildren((VirtualFile)snapshot.getCoreModulesSrcDir()));
        Set<VirtualFile> filesToIndex = snapshot.getFilesToIndex();
        excluded.removeAll(filesToIndex);
        HashSet hashSet = excluded;
        if (hashSet == null) {
            NodeCoreSyntheticLibraryProvider.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSyntheticLibrary";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExcludedSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeCoreSyntheticLibrary
    extends SyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        private final Project myProject;
        private final String myVersion;
        private final SyntheticLibrary myDelegate;

        NodeCoreSyntheticLibrary(@NotNull Project project, @NotNull String version, @NotNull SyntheticLibrary delegate) {
            if (project == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(0);
            }
            if (version == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(1);
            }
            if (delegate == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myVersion = version;
            this.myDelegate = delegate;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection collection = this.myDelegate.getSourceRoots();
            if (collection == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @NotNull
        public Collection<VirtualFile> getBinaryRoots() {
            Collection collection = this.myDelegate.getBinaryRoots();
            if (collection == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getExcludedRoots() {
            Set set = this.myDelegate.getExcludedRoots();
            if (set == null) {
                NodeCoreSyntheticLibrary.$$$reportNull$$$0(5);
            }
            return set;
        }

        @Nullable
        public Condition<VirtualFile> getExcludeFileCondition() {
            return this.myDelegate.getExcludeFileCondition();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            return this.myDelegate.equals((Object)((NodeCoreSyntheticLibrary)((Object)o)).myDelegate);
        }

        public int hashCode() {
            return this.myDelegate.hashCode();
        }

        @Nullable
        public String getPresentableText() {
            return "Node.js Core";
        }

        @Nullable
        public String getLocationString() {
            return this.myVersion;
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return JavaScriptLanguageIcons.Nodejs.Nodejs;
        }

        public void navigate(boolean requestFocus) {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, NodeSettingsConfigurable.class);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return "Configure Node.js and NPM...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider$NodeCoreSyntheticLibrary";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreSyntheticLibraryProvider$NodeCoreSyntheticLibrary";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceRoots";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryRoots";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExcludedRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

