/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.editor;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.editing.JSStringLiteralCopyPasteProcessor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CopyPasteProcessor
extends CopyPastePostProcessor<ES6ImportsTransferableData> {
    private static final DataFlavor ES6_IMPORTS_FLAVOR = new DataFlavor(ES6ImportsTransferableData.class, "es6 imports");
    public static final Logger LOGGER = Logger.getInstance(ES6CopyPasteProcessor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<ES6ImportsTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor, int[] startOffsets, int[] endOffsets) {
        if (file2 == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(1);
        }
        if (!this.checkFile(file2)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ES6CopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return list2;
        }
        try {
            ArrayList<ES6ReferenceExpressionsInfo> referenceExpressions = new ArrayList<ES6ReferenceExpressionsInfo>();
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            int j = 0;
            while (true) {
                block16: {
                    PsiElement parent;
                    TextRange textRange;
                    block17: {
                        int n;
                        PsiElement[] psiElementArray;
                        block18: {
                            block15: {
                                if (j >= startOffsets.length) break block15;
                                textRange = new TextRange(startOffsets[j], endOffsets[j]);
                                ranges.add(textRange);
                                parent = CollectHighlightsUtil.findCommonParent((PsiElement)file2, (int)startOffsets[j], (int)endOffsets[j]);
                                if (parent == null) break block16;
                                if (!(parent instanceof JSFile) && !(parent instanceof JSEmbeddedContent)) break block17;
                                psiElementArray = parent.getChildren();
                                n = psiElementArray.length;
                                break block18;
                            }
                            if (referenceExpressions.isEmpty()) {
                                List list3 = ContainerUtil.emptyList();
                                if (list3 == null) {
                                    ES6CopyPasteProcessor.$$$reportNull$$$0(4);
                                }
                                return list3;
                            }
                            Collection<ImportedElement> importedElementList = ES6CopyPasteProcessor.toImportedElements(referenceExpressions, ranges);
                            List<ES6ImportsTransferableData> list4 = importedElementList.isEmpty() ? ContainerUtil.emptyList() : Collections.singletonList(new ES6ImportsTransferableData(new ArrayList<ImportedElement>(importedElementList)));
                            if (list4 == null) {
                                ES6CopyPasteProcessor.$$$reportNull$$$0(5);
                            }
                            return list4;
                        }
                        for (int i = 0; i < n; ++i) {
                            PsiElement child = psiElementArray[i];
                            if (!child.getTextRange().intersects(textRange) || !(child instanceof ES6ImportDeclaration) && !(child instanceof ES6ImportExportDeclarationPart)) continue;
                            List list5 = ContainerUtil.emptyList();
                            if (list5 == null) {
                                ES6CopyPasteProcessor.$$$reportNull$$$0(3);
                            }
                            return list5;
                        }
                    }
                    referenceExpressions.add(ES6ReferenceExpressionsInfo.getInfo(parent, textRange));
                }
                ++j;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            List list6 = ContainerUtil.emptyList();
            if (list6 == null) {
                ES6CopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return list6;
        }
    }

    @Contract(value="null -> false")
    public boolean checkFile(@Nullable PsiFile file2) {
        if (!(file2 instanceof JSFile)) {
            return false;
        }
        if (DumbService.isDumb((Project)file2.getProject())) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file2);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return false;
        }
        if (holder.isECMA6) {
            return JSApplicationSettings.getInstance().isUseJavaScriptAutoImport();
        }
        if (holder.isTypeScript) {
            return JSApplicationSettings.getInstance().isUseTypeScriptAutoImport();
        }
        return false;
    }

    @NotNull
    private static Collection<ImportedElement> toImportedElements(@NotNull List<ES6ReferenceExpressionsInfo> expressions, @NotNull Collection<TextRange> ranges) {
        if (expressions == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(7);
        }
        if (ranges == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(8);
        }
        LinkedHashSet<ImportedElement> imports = new LinkedHashSet<ImportedElement>();
        for (ES6ReferenceExpressionsInfo expressionsInfo : expressions) {
            for (Map.Entry<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> importEntry : expressionsInfo.getReferencedImports().entrySet()) {
                PsiElement value = importEntry.getValue();
                PsiElement fileOrModule = (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule(value, false), (Object)value.getContainingFile());
                String path = ES6CopyPasteProcessor.getModuleNameOrPath(fileOrModule);
                if (path == null) continue;
                imports.add(new ImportedElement(path, importEntry.getKey(), fileOrModule instanceof TypeScriptModule));
            }
            for (PsiElement localElement : expressionsInfo.getExportedLocalReferencedElements()) {
                String name;
                if (ContainerUtil.or(ranges, range -> range.intersects(localElement.getTextRange()))) continue;
                PsiElement refModule = ES6PsiUtil.findExternalModule(localElement);
                if (!(localElement instanceof JSNamedElement) || refModule == null || StringUtil.isEmpty((String)(name = ((JSNamedElement)localElement).getName()))) continue;
                imports.add(ES6CopyPasteProcessor.createImportedElement(localElement, name, refModule));
            }
        }
        LinkedHashSet<ImportedElement> linkedHashSet = imports;
        if (linkedHashSet == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Nullable
    private static ImportedElement createImportedElement(@NotNull PsiElement currentElement, @NotNull String name, @NotNull PsiElement currentModule) {
        String path;
        if (currentElement == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(11);
        }
        if (currentModule == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(12);
        }
        if ((path = ES6CopyPasteProcessor.getModuleNameOrPath(currentModule)) != null && !TypeScriptPsiUtil.isAugmentationModule(currentElement)) {
            ES6ImportPsiUtil.ImportExportType type = ES6ImportHandler.isExportedWithDefault(currentElement) ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER;
            ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(name, type);
            return new ImportedElement(path, info, currentModule instanceof TypeScriptModule);
        }
        return null;
    }

    @Nullable
    private static String getModuleNameOrPath(@Nullable PsiElement fileOrModule) {
        if (fileOrModule instanceof PsiFile) {
            return ((PsiFile)fileOrModule).getVirtualFile().getPath();
        }
        if (fileOrModule instanceof TypeScriptModule) {
            return ((TypeScriptModule)fileOrModule).getExternalModuleText();
        }
        return null;
    }

    @NotNull
    public List<ES6ImportsTransferableData> extractTransferableData(Transferable content) {
        block9: {
            List list2;
            Object data;
            block8: {
                if (!content.isDataFlavorSupported(ES6_IMPORTS_FLAVOR)) {
                    List list3 = ContainerUtil.emptyList();
                    if (list3 == null) {
                        ES6CopyPasteProcessor.$$$reportNull$$$0(13);
                    }
                    return list3;
                }
                data = content.getTransferData(ES6_IMPORTS_FLAVOR);
                if (!(data instanceof ES6ImportsTransferableData)) break block8;
                List<ES6ImportsTransferableData> list4 = Collections.singletonList((ES6ImportsTransferableData)data);
                if (list4 == null) {
                    ES6CopyPasteProcessor.$$$reportNull$$$0(14);
                }
                return list4;
            }
            try {
                if (!(data instanceof List)) break block9;
                list2 = (List)data;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list2 == null) {
                ES6CopyPasteProcessor.$$$reportNull$$$0(15);
            }
            return list2;
        }
        List list5 = super.extractTransferableData(content);
        if (list5 == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(16);
        }
        return list5;
    }

    public void processTransferableData(Project project, Editor editor, RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<ES6ImportsTransferableData> values) {
        if (DumbService.getInstance((Project)project).isDumb()) {
            return;
        }
        Document document2 = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
        if (!this.checkFile(file2) || ES6CopyPasteProcessor.isStringLiteralOrCommentContext(file2, caretOffset)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file2);
        List elements = values.stream().flatMap(v -> v.getImportedElements().stream()).map(importedElement -> {
            String exportedName = ((ImportedElement)importedElement).myInfo.getExportedName();
            String importedName = ((ImportedElement)importedElement).myInfo.getImportedName();
            String actualExportedName = (String)ObjectUtils.coalesce((Object)exportedName, (Object)importedName);
            String actualImportedName = (String)ObjectUtils.coalesce((Object)importedName, (Object)exportedName);
            if (actualImportedName != null && !JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(actualImportedName, (PsiElement)file2).isEmpty()) {
                return null;
            }
            PsiElement module = ES6CopyPasteProcessor.findFileOrModule(importedElement, file2, scope);
            JSNamedElement element = null;
            if (module instanceof JSElement && actualExportedName != null) {
                element = JSResolveResult.resolveAny(ES6PsiUtil.resolveSymbolInModule(actualExportedName, (PsiElement)file2, (JSElement)module));
            }
            if (element instanceof TypeScriptImplicitOverloadedAliasElement) {
                element = ((TypeScriptImplicitOverloadedAliasElement)element).getAliasElement();
            }
            if (element == null) {
                element = module;
            }
            return element != null ? Pair.create((Object)((ImportedElement)importedElement).myInfo, (Object)element) : null;
        }).filter(pair -> pair != null).collect(Collectors.toList());
        WriteAction.run(() -> ES6CreateImportUtil.addRequiredImports((PsiElement)file2, elements));
    }

    @Nullable
    private static PsiElement findFileOrModule(@NotNull ImportedElement importedElement, @NotNull PsiFile file2, @NotNull GlobalSearchScope scope) {
        if (importedElement == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(19);
        }
        if (importedElement.myExternalModule) {
            return JSFileReferencesUtil.resolveModuleReference((PsiElement)file2, importedElement.myPath).stream().filter(t -> t instanceof TypeScriptModule).findFirst().orElse(null);
        }
        VirtualFile candidateFile = file2.getVirtualFile().getFileSystem().findFileByPath(importedElement.myPath);
        if (candidateFile == null || !scope.accept(candidateFile)) {
            return null;
        }
        PsiFile targetFile = file2.getManager().findFile(candidateFile);
        if (targetFile == null || targetFile.equals(file2)) {
            return null;
        }
        return targetFile;
    }

    public static boolean isStringLiteralOrCommentContext(@NotNull PsiFile file2, int offset) {
        PsiElement candidate;
        if (file2 == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(20);
        }
        if ((candidate = ES6CopyPasteProcessor.getContextElementOrFile(file2, offset)) instanceof PsiFile) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)candidate, (Class[])new Class[]{JSLiteralExpressionImpl.class, JSStringTemplateExpression.class, PsiComment.class});
        if (parent instanceof JSStringTemplateExpression) {
            return JSStringLiteralCopyPasteProcessor.isInStringRange((JSStringTemplateExpression)parent, offset);
        }
        return parent != null;
    }

    @NotNull
    public static PsiElement getContextElementOrFile(@NotNull PsiFile file2, int offset) {
        PsiElement candidate;
        if (file2 == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(21);
        }
        Object object = (candidate = file2.findElementAt(offset)) == null ? file2 : candidate;
        if (object == null) {
            ES6CopyPasteProcessor.$$$reportNull$$$0(22);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentModule";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toImportedElements";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextElementOrFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toImportedElements";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createImportedElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFileOrModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralOrCommentContext";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContextElementOrFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ES6ImportsTransferableData
    implements TextBlockTransferableData {
        @NotNull
        private final ArrayList<ImportedElement> myList;

        public ES6ImportsTransferableData(@NotNull ArrayList<ImportedElement> list2) {
            if (list2 == null) {
                ES6ImportsTransferableData.$$$reportNull$$$0(0);
            }
            this.myList = list2;
        }

        @NotNull
        public List<ImportedElement> getImportedElements() {
            ArrayList<ImportedElement> arrayList = this.myList;
            if (arrayList == null) {
                ES6ImportsTransferableData.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public DataFlavor getFlavor() {
            return ES6_IMPORTS_FLAVOR;
        }

        public int getOffsetCount() {
            return 0;
        }

        public int getOffsets(int[] offsets, int index) {
            return index;
        }

        public int setOffsets(int[] offsets, int index) {
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor$ES6ImportsTransferableData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor$ES6ImportsTransferableData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ImportedElement
    implements Serializable {
        @NotNull
        private final String myPath;
        @NotNull
        private final ES6ImportPsiUtil.CreateImportExportInfo myInfo;
        private final boolean myExternalModule;

        public ImportedElement(@NotNull String filePath, @NotNull ES6ImportPsiUtil.CreateImportExportInfo info, boolean isExternalModule) {
            if (filePath == null) {
                ImportedElement.$$$reportNull$$$0(0);
            }
            if (info == null) {
                ImportedElement.$$$reportNull$$$0(1);
            }
            this.myPath = filePath;
            this.myInfo = info;
            this.myExternalModule = isExternalModule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImportedElement element = (ImportedElement)o;
            return this.myExternalModule == element.myExternalModule && Objects.equals(this.myPath, element.myPath) && Objects.equals(this.myInfo, element.myInfo);
        }

        public int hashCode() {
            return Objects.hash(this.myPath, this.myInfo, this.myExternalModule);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/ecmascript6/editor/ES6CopyPasteProcessor$ImportedElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

