/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.PlatformUtils;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class WebStormDiagramsConfigurator
implements ApplicationInitializedListener {
    @NonNls
    private static final String[] REMOVE_ACTIONS = new String[]{"Uml.ShowDiff", "UML.ShowChanges"};

    public void componentsInitialized() {
        if (PlatformUtils.isWebStorm()) {
            WebStormDiagramsConfigurator.removeDiagramActions(ActionManager.getInstance());
        }
    }

    private static void removeDiagramActions(ActionManager actionManager) {
        AbbreviationManager abbreviationManager = AbbreviationManager.getInstance();
        for (String actionId : REMOVE_ACTIONS) {
            Set abbreviations = abbreviationManager.getAbbreviations(actionId);
            for (String abbreviation : abbreviations) {
                abbreviationManager.remove(abbreviation, actionId);
            }
        }
        for (String actionId : REMOVE_ACTIONS) {
            ActionGroup group;
            AnAction action = actionManager.getAction(actionId);
            if (action == null) continue;
            if (actionManager.isGroup(actionId) && (group = (ActionGroup)action) instanceof DefaultActionGroup) {
                ((DefaultActionGroup)group).removeAll();
            }
            actionManager.unregisterAction(actionId);
        }
    }
}

