/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.base.PaddedIconBuilder;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRunTaskAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtAddBuildfileAction
extends AnAction
implements DumbAware {
    private final JsbtService myService;

    public JsbtAddBuildfileAction(@NotNull JsbtService service, boolean popupPlace) {
        if (service == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(0);
        }
        super("Add " + service.getBuildfileCommonName());
        this.myService = service;
        LayeredIcon icon = (LayeredIcon)JBUI.scale((JBUI.JBIcon)new LayeredIcon(2));
        icon.setIcon(AllIcons.General.Add, 0);
        icon.setIcon(AllIcons.General.Dropdown, 1);
        this.getTemplatePresentation().setIcon(JsbtAddBuildfileAction.createIcon((Icon)icon, popupPlace));
        this.setShortcutSet(CommonShortcuts.getNewForDialogs());
    }

    @NotNull
    private static Icon createIcon(@NotNull Icon icon, boolean popupPlace) {
        if (icon == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(1);
        }
        if (!popupPlace) {
            Icon icon2 = icon;
            if (icon2 == null) {
                JsbtAddBuildfileAction.$$$reportNull$$$0(2);
            }
            return icon2;
        }
        int verticalPadding = 6;
        Icon icon3 = new PaddedIconBuilder(icon).setTopBottomPaddings(verticalPadding / 2, verticalPadding / 2).setLeftRightPaddings(5, 4).build();
        if (icon3 == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(3);
        }
        return icon3;
    }

    @Nullable
    public static Shortcut getKeyboardShortcut() {
        Object[] shortcuts = CommonShortcuts.getNewForDialogs().getShortcuts();
        return (Shortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(4);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(5);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<VirtualFile> all = this.myService.detectAllBuildfiles(project);
            List filtered = ContainerUtil.filter(all, file2 -> {
                JsbtFileManager fileManager = this.myService.getFileManager(project);
                return !fileManager.containsBuildfile((VirtualFile)file2);
            });
            UIUtil.invokeLaterIfNeeded(() -> {
                InputEvent inputEvent = e.getInputEvent();
                Component component = inputEvent.getComponent();
                if (component == null) {
                    return;
                }
                ListPopup popup = JsbtAddBuildfileAction.createPopup(project, this.myService, filtered);
                if (inputEvent instanceof MouseEvent) {
                    popup.show(new RelativePoint(component, ((MouseEvent)inputEvent).getPoint()));
                } else {
                    popup.showInCenterOf(component);
                }
            });
        });
    }

    @NotNull
    private static ListPopup createPopup(final @NotNull Project project, final @NotNull JsbtService service, @NotNull List<VirtualFile> files) {
        if (project == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(6);
        }
        if (service == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(7);
        }
        if (files == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(8);
        }
        ArrayList<VirtualFile> values = new ArrayList<VirtualFile>(files);
        values.add(null);
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(null, values){

            @NotNull
            public String getTextFor(VirtualFile value) {
                if (value != null) {
                    String string = JsbtUtil.getRelativePath(project, value);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = "Choose " + service.getBuildfileCommonName() + "...";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIconFor(VirtualFile file2) {
                if (file2 != null) {
                    return file2.getFileType().getIcon();
                }
                return null;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                JsbtFileManager fileManager = service.getFileManager(project);
                if (selectedValue != null) {
                    fileManager.addBuildfile(selectedValue);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                        fileChooserDescriptor.setTitle("Choose " + service.getBuildfileCommonName());
                        boolean popupShown = JsbtRunTaskAction.hidePopup(project);
                        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null, files1 -> {
                            VirtualFile file2 = (VirtualFile)ContainerUtil.getFirstItem((List)files1);
                            if (file2 != null) {
                                fileManager.addBuildfile(file2);
                            }
                        });
                        if (popupShown) {
                            new Alarm(Alarm.ThreadToUse.SWING_THREAD).addRequest(() -> JsbtRunTaskAction.showPopup(project), 50);
                        }
                    });
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "getTextFor"));
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (listPopup == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(9);
        }
        return listPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

