/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpUtil;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpFilter;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpWatchTaskListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final ExecutionEnvironment myEnvironment;
    private final GulpRunSettings myRunSettings;
    private final NodePackage myGulpPackage;

    public GulpRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull GulpRunSettings runSettings, @NotNull NodePackage gulpPackage) {
        if (environment == null) {
            GulpRunProfileState.$$$reportNull$$$0(0);
        }
        if (runSettings == null) {
            GulpRunProfileState.$$$reportNull$$$0(1);
        }
        if (gulpPackage == null) {
            GulpRunProfileState.$$$reportNull$$$0(2);
        }
        this.myEnvironment = environment;
        this.myRunSettings = runSettings;
        this.myGulpPackage = gulpPackage;
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myEnvironment.getProject());
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
        GulpRunProfileState.installWatchFsSynchronizer((ProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ConsoleView console = this.createConsole((ProcessHandler)processHandler, commandLine.getWorkDirectory());
        console.attachToProcess((ProcessHandler)processHandler);
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        if (defaultExecutionResult == null) {
            GulpRunProfileState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    private static void installWatchFsSynchronizer(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            GulpRunProfileState.$$$reportNull$$$0(4);
        }
        processHandler.addProcessListener((ProcessListener)new GulpWatchTaskListener());
    }

    @NotNull
    private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable File cwd) {
        if (processHandler == null) {
            GulpRunProfileState.$$$reportNull$$$0(5);
        }
        Project project = this.myEnvironment.getProject();
        ConsoleView consoleView = NodeCommandLineUtil.createConsole(processHandler, project, false);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(project, cwd));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(project, cwd));
        consoleView.addMessageFilter((Filter)new GulpFilter(project));
        consoleView.addMessageFilter((Filter)new TypeScriptErrorConsoleFilter(project, cwd));
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            GulpRunProfileState.$$$reportNull$$$0(6);
        }
        return consoleView2;
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            GulpRunProfileState.$$$reportNull$$$0(7);
        }
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)new File(this.myRunSettings.getGulpfilePath()).getParentFile(), (boolean)false);
        List nodeOptionList = ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim());
        try {
            NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptionList, debugPort, true, interpreter, true);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        commandLine.addParameter(GulpUtil.getGulpBinFile(this.myGulpPackage).getAbsolutePath());
        commandLine.addParameter("--color");
        commandLine.addParameter("--gulpfile");
        commandLine.addParameter(this.myRunSettings.getGulpfilePath());
        commandLine.addParameters(this.myRunSettings.getTasks());
        String arguments = this.myRunSettings.getArguments().trim();
        if (StringUtil.isNotEmpty((String)arguments)) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            GulpRunProfileState.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        BaseOSProcessHandler osProcessHandler;
        if (consoleView == null) {
            GulpRunProfileState.$$$reportNull$$$0(9);
        }
        if (processHandler == null) {
            GulpRunProfileState.$$$reportNull$$$0(10);
        }
        if ((osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class)) != null) {
            ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"gulp"});
            args.addAll(this.myRunSettings.getTasks());
            String arguments = this.myRunSettings.getArguments().trim();
            if (StringUtil.isNotEmpty((String)arguments)) {
                args.addAll(ParametersListUtil.parse((String)arguments));
            }
            GulpRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)args));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        String commandLine;
        if (consoleView == null) {
            GulpRunProfileState.$$$reportNull$$$0(11);
        }
        if (processHandler == null) {
            GulpRunProfileState.$$$reportNull$$$0(12);
        }
        if (foldedCommandLineText == null) {
            GulpRunProfileState.$$$reportNull$$$0(13);
        }
        if ((commandLine = processHandler.getCommandLine()) != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState$1", "startNotified"));
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpPackage";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldedCommandLineText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installWatchFsSynchronizer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doFoldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

