/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletion;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.FlexPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSCompletionContributor
extends CompletionContributor {
    private boolean myDoingSmartCodeCompleteAction;
    private Set<String> myAlreadyUsedClassesSet;

    public boolean isDoingSmartCodeCompleteAction() {
        return this.myDoingSmartCodeCompleteAction;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        String text;
        PsiReference[] references;
        int i;
        boolean insideJs;
        if (parameters == null) {
            JSCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!(insideJs = JSCompletionContributor.getElementLanguage(parameters).isKindOf((Language)JavascriptLanguage.INSTANCE))) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PsiReference ref = position.getContainingFile().findReferenceAt(parameters.getOffset());
        if (ref instanceof FlexPropertyReference || ref instanceof FileReference) {
            return;
        }
        this.myDoingSmartCodeCompleteAction = parameters.getCompletionType() == CompletionType.SMART;
        this.myAlreadyUsedClassesSet = null;
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher();
        String prefix = prefixMatcher.getPrefix();
        if (ref == null || !(ref.getElement() instanceof JSLiteralExpression)) {
            for (i = prefix.length() - 1; i >= 0 && Character.isJavaIdentifierPart(prefix.charAt(i)); --i) {
            }
            if (i != -1) {
                prefixMatcher = prefixMatcher.cloneWithPrefix(prefix.substring(i + 1));
            }
        }
        CompletionSorterImpl sorter = JSCompletionContributor.createOwnSorter(parameters);
        CompletionResultSet completionResultSet = result2.withRelevanceSorter((CompletionSorter)sorter);
        completionResultSet.runRemainingContributors(parameters, completionResult -> {
            LookupElement item = completionResult.getLookupElement();
            completionResultSet.withPrefixMatcher(completionResult.getPrefixMatcher()).addElement(item);
        });
        if (position.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA && !(ref instanceof JSDocReference) && !(ref instanceof JSDocParamReference) && (references = new JSDocReferenceSet(position, (text = position.getText()).substring(0, i + 2), 0, true).getReferences()).length > 0) {
            JSTextReferenceCompletion.addVariants((JSTextReference)references[references.length - 1], parameters, completionResultSet.withPrefixMatcher(prefixMatcher));
        }
        this.myAlreadyUsedClassesSet = null;
        this.myDoingSmartCodeCompleteAction = false;
        result2.stopHere();
    }

    public static CompletionSorterImpl createOwnSorter(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            JSCompletionContributor.$$$reportNull$$$0(2);
        }
        final CompletionLocation location = new CompletionLocation(parameters);
        return ((CompletionSorterImpl)CompletionService.getCompletionService().emptySorter()).weigh((LookupElementWeigher)new LiveTemplateWeigher()).weigh((LookupElementWeigher)new PreferStartMatching()).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                Double d = -JSCompletionUtil.getLookupElementPriority(element);
                if (d == null) {
                    3.$$$reportNull$$$0(1);
                }
                return d;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).withClassifier((ClassifierFactory)new ClassifierFactory<LookupElement>("stat"){

            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        }).weigh(new LookupElementWeigher("minor_priority"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PrioritizedLookupElement) {
                    Integer n = -((PrioritizedLookupElement)element).getExplicitProximity();
                    if (n == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return n;
                }
                Integer proximity = (Integer)element.getUserData(JSLookupPriority.EXPLICIT_PROXIMITY_KEY);
                Integer n = proximity != null ? -proximity.intValue() : 0;
                if (n == null) {
                    1.$$$reportNull$$$0(2);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "weigh";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "weigh";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public void setAlreadyUsedClassesSet(Set<String> alreadyUsedClassesSet) {
        this.myAlreadyUsedClassesSet = alreadyUsedClassesSet;
    }

    public Set<String> getAlreadyUsedClassesSet() {
        return this.myAlreadyUsedClassesSet;
    }

    private static Language getElementLanguage(CompletionParameters parameters) {
        return (Language)ReadAction.compute(() -> PsiUtilCore.getLanguageAtOffset((PsiFile)parameters.getPosition().getContainingFile(), (int)parameters.getOffset()));
    }

    public static JSCompletionContributor getInstance() {
        return JSCompletionContributorHolder.ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createOwnSorter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSCompletionContributorHolder {
        private static final JSCompletionContributor ourInstance;

        private JSCompletionContributorHolder() {
        }

        static {
            JSCompletionContributor instance = null;
            for (CompletionContributor c : CompletionContributor.forLanguage((Language)JavascriptLanguage.INSTANCE)) {
                if (!(c instanceof JSCompletionContributor)) continue;
                instance = (JSCompletionContributor)c;
                break;
            }
            assert (instance != null);
            ourInstance = instance;
        }
    }
}

