/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.ES6CompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSImportCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSSmartCompletionVariantsHandler;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSReferenceCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        if (JSReferenceCompletionProvider.skipReferenceCompletionByContext(parent)) {
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        PsiFile containingFile = referenceExpression.getContainingFile();
        boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        List<LookupElement> smartVariants = JSSmartCompletionVariantsHandler.getSmartVariants(referenceExpression);
        THashSet populatedSmartVariants = new THashSet();
        if (smartVariants != null) {
            for (LookupElement element : smartVariants) {
                populatedSmartVariants.add(element.getLookupString());
                JSReferenceCompletionProvider.addVariant(element, result2);
            }
            if (parameters.getCompletionType() == CompletionType.SMART) {
                return;
            }
        }
        Collection<LookupElement> variants = JSReferenceCompletionUtil.calcDefaultVariants((JSExpression)referenceExpression, containingFile, ecma, (Set<String>)populatedSmartVariants, parameters, result2);
        JSReferenceCompletionProvider.addVariantsToImport(referenceExpression, variants, result2);
    }

    private static boolean skipReferenceCompletionByContext(@NotNull PsiElement parent) {
        if (parent == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(3);
        }
        if (DialectDetector.isActionScript(parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addFromOrAsKeyword(null, parent)) {
            return true;
        }
        if (ES6CompletionKeywordsContributor.addExtendsImplements(null, parent)) {
            return true;
        }
        if (ES6CompletionKeywordsContributor.isAfterExport(parent)) {
            return true;
        }
        return JSKeywordsCompletionProvider.isExactContextForOperation(parent);
    }

    private static void addVariantsToImport(@NotNull JSReferenceExpression referenceExpression, @NotNull Collection<LookupElement> variants, @NotNull CompletionResultSet resultSet) {
        DialectOptionHolder holder;
        if (referenceExpression == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(4);
        }
        if (variants == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(5);
        }
        if (resultSet == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(6);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)referenceExpression)) != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            PsiElement parent;
            JSExpression qualifier;
            JSExpression jSExpression = qualifier = referenceExpression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)referenceExpression).getResolveQualifier() : referenceExpression.getQualifier();
            if (qualifier == null && !JSResolveUtil.isSelfReference(parent = referenceExpression.getParent(), (PsiElement)referenceExpression)) {
                JSImportCompletionUtil.addExportedVariants(referenceExpression, variants, resultSet);
            }
        }
    }

    public static void addVariant(@NotNull LookupElement element, @NotNull CompletionResultSet result2) {
        LookupElementBuilder lookupItem;
        if (element == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            JSReferenceCompletionProvider.$$$reportNull$$$0(8);
        }
        if (element instanceof LookupElementBuilder && (lookupItem = (LookupElementBuilder)element).getInsertHandler() == null) {
            element = lookupItem.withInsertHandler(JSInsertHandler.DEFAULT);
        }
        result2.addElement(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "skipReferenceCompletionByContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariantsToImport";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

