/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageLevel
extends Enum<JSLanguageLevel> {
    public static final /* enum */ JSLanguageLevel JS_1_5 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_5, "js.language.version.combo.es3");
    public static final /* enum */ JSLanguageLevel ES5 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_5, "js.language.version.combo.es5");
    public static final /* enum */ JSLanguageLevel JS_1_6 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_6, "js.language.version.combo.js16");
    public static final /* enum */ JSLanguageLevel JS_1_7 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_7, "js.language.version.combo.js17");
    public static final /* enum */ JSLanguageLevel JS_1_8 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_8, "js.language.version.combo.js18");
    public static final /* enum */ JSLanguageLevel JS_1_8_5 = new JSLanguageLevel(JavaScriptSupportLoader.JAVASCRIPT_1_8, "js.language.version.combo.js185");
    public static final /* enum */ JSLanguageLevel ES6 = new JSLanguageLevel(JavaScriptSupportLoader.ECMA_SCRIPT_6, "js.language.version.combo.es6");
    public static final /* enum */ JSLanguageLevel JSX = new JSLanguageLevel(JavaScriptSupportLoader.JSX_HARMONY, "js.language.version.combo.jsx");
    public static final /* enum */ JSLanguageLevel NASHORN = new JSLanguageLevel(JavaScriptSupportLoader.NASHORN_JS, "js.language.version.combo.nashorn");
    public static final /* enum */ JSLanguageLevel FLOW = new JSLanguageLevel(JavaScriptSupportLoader.FLOW_JS, "js.language.version.combo.flow");
    private static final Set<JSLanguageLevel> OBSOLETE_LEVELS;
    public static final JSLanguageLevel DEFAULT;
    private final String myLabel;
    private final String myDescription;
    private final JSLanguageDialect myDialect;
    private static final /* synthetic */ JSLanguageLevel[] $VALUES;

    public static JSLanguageLevel[] values() {
        return (JSLanguageLevel[])$VALUES.clone();
    }

    public static JSLanguageLevel valueOf(String name) {
        return Enum.valueOf(JSLanguageLevel.class, name);
    }

    private JSLanguageLevel(JSLanguageDialect dialect, String resourceId) {
        if (dialect == null) {
            JSLanguageLevel.$$$reportNull$$$0(0);
        }
        this.myLabel = JSBundle.message((String)resourceId, (Object[])new Object[0]);
        this.myDescription = JSBundle.message((String)(resourceId + ".description"), (Object[])new Object[0]);
        this.myDialect = dialect;
    }

    public String toString() {
        return this.myLabel;
    }

    public String getId() {
        return super.toString();
    }

    @NotNull
    public JSLanguageDialect getDialect() {
        JSLanguageDialect jSLanguageDialect = this.myDialect;
        if (jSLanguageDialect == null) {
            JSLanguageLevel.$$$reportNull$$$0(1);
        }
        return jSLanguageDialect;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public static JSLanguageLevel ofElement(@NotNull PsiElement element) {
        JSLanguageDialect dialect;
        if (element == null) {
            JSLanguageLevel.$$$reportNull$$$0(2);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(element)) != null && dialect.getOptionHolder().isJavaScript()) {
            JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(element.getContainingFile(), element.getProject());
            if (level.getDialect().isAtLeast(dialect)) {
                return level;
            }
            for (JSLanguageLevel value : JSLanguageLevel.values()) {
                if (value.getDialect() != dialect) continue;
                return value;
            }
        }
        return null;
    }

    public boolean isAtLeast(@NotNull JSLanguageLevel level) {
        if (level == null) {
            JSLanguageLevel.$$$reportNull$$$0(3);
        }
        if (level == this) {
            return true;
        }
        switch (this) {
            case JS_1_5: {
                return false;
            }
            case ES5: {
                return JS_1_5.isAtLeast(level);
            }
            case JS_1_6: {
                return JS_1_5.isAtLeast(level);
            }
            case JS_1_7: {
                return JS_1_6.isAtLeast(level);
            }
            case JS_1_8: {
                return JS_1_7.isAtLeast(level);
            }
            case JS_1_8_5: {
                return JS_1_8.isAtLeast(level) || ES5.isAtLeast(level);
            }
            case ES6: {
                return ES5.isAtLeast(level);
            }
            case JSX: {
                return ES6.isAtLeast(level);
            }
            case NASHORN: {
                return ES6.isAtLeast(level);
            }
            case FLOW: {
                return ES6.isAtLeast(level) || JSX.isAtLeast(level);
            }
        }
        assert (false) : (Object)((Object)this) + " JSLanguageLevel case is missed";
        return false;
    }

    public boolean isES5Compatible() {
        return this.isAtLeast(ES5);
    }

    public boolean isES6Compatible() {
        return this.isAtLeast(ES6);
    }

    public boolean isXmlEnabled() {
        return this.getDialect().getOptionHolder().hasFeature(JSLanguageFeature.E4X);
    }

    @NotNull
    public static JSLanguageLevel ofId(@Nullable String id) {
        for (JSLanguageLevel level : JSLanguageLevel.values()) {
            if (!level.getId().equals(id)) continue;
            JSLanguageLevel jSLanguageLevel = level;
            if (jSLanguageLevel == null) {
                JSLanguageLevel.$$$reportNull$$$0(4);
            }
            return jSLanguageLevel;
        }
        JSLanguageLevel jSLanguageLevel = DEFAULT;
        if (jSLanguageLevel == null) {
            JSLanguageLevel.$$$reportNull$$$0(5);
        }
        return jSLanguageLevel;
    }

    @NotNull
    public static List<JSLanguageLevel> getVisibleLevels() {
        ArrayList<JSLanguageLevel> result2 = new ArrayList<JSLanguageLevel>(JSLanguageLevel.values().length);
        for (JSLanguageLevel value : JSLanguageLevel.values()) {
            if (OBSOLETE_LEVELS.contains((Object)value) || !PlatformUtils.isIntelliJ() && value == NASHORN) continue;
            result2.add(value);
        }
        ArrayList<JSLanguageLevel> arrayList = result2;
        if (arrayList == null) {
            JSLanguageLevel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    static {
        $VALUES = new JSLanguageLevel[]{JS_1_5, ES5, JS_1_6, JS_1_7, JS_1_8, JS_1_8_5, ES6, JSX, NASHORN, FLOW};
        OBSOLETE_LEVELS = ContainerUtil.set((Object[])new JSLanguageLevel[]{JS_1_6, JS_1_7, JS_1_8});
        DEFAULT = ApplicationManager.getApplication().isUnitTestMode() ? ES6 : ES5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSLanguageLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSLanguageLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "ofId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleLevels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ofElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

