/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Color;
import java.awt.Font;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSQuickNavigateBuilder {
    private static final int INITIALIZER_MAX_LENGTH = 50;

    @Nullable
    protected String getQuickNavigateInfoForNavigationElement(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(0);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(1);
        }
        originalElement = JSQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement);
        if (element instanceof JSFunction) {
            return this.createQuickNavigateForFunction((JSFunction)element, originalElement);
        }
        if (element instanceof JSClass) {
            return this.createQuickNavigateForJSClass((JSClass)element, originalElement);
        }
        if (element instanceof JSFieldVariable) {
            return this.createQuickNavigateForVariableOrField((JSFieldVariable)element, originalElement);
        }
        if (element instanceof JSProperty) {
            return this.createQuickNavigateForProperty((JSProperty)element, originalElement);
        }
        if (element instanceof XmlToken) {
            String xmlAttributeDoc = JSQuickNavigateBuilder.checkAndGetXmlAttributeQuickNavigate(element);
            if (xmlAttributeDoc != null) {
                return xmlAttributeDoc;
            }
            JSTagContextBuilder builder = new JSTagContextBuilder(element, "XmlTag");
            return StringUtil.unquoteString((String)element.getText()) + ":" + builder.typeName;
        }
        return null;
    }

    @Nullable
    public final String getQuickNavigateInfo(@Nullable PsiElement element, @Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return null;
        }
        if (element instanceof JSOffsetBasedImplicitElement) {
            element = ((JSOffsetBasedImplicitElement)element).getElementAtOffset();
        }
        return element == null || DumbService.isDumb((Project)element.getProject()) ? null : this.getQuickNavigateInfoForNavigationElement(element.getNavigationElement(), originalElement);
    }

    @Nullable
    protected final String createQuickNavigateForProperty(@NotNull JSProperty element, @NotNull PsiElement originalElement) {
        String name;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(2);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(3);
        }
        if ((name = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)element, true)) == null) {
            return null;
        }
        JSQualifiedNamedElement parent = element == JSQuickNavigateBuilder.getOriginalElementOrParentIfLeaf(originalElement) ? null : JSQuickNavigateBuilder.getPropertyParent(element);
        String qName = parent != null ? parent.getQualifiedName() + "." + name : name;
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)element, originalElement);
        String typeText = this.getTypeTextForQuickNavigate(this.getPropertyTypeText(element), substitutor);
        StringBuilder typePart = new StringBuilder();
        this.appendType((PsiElement)element, typeText, typePart);
        JSExpression value = element.getValue();
        ObjectKind kind = value instanceof JSFunctionExpression ? ObjectKind.FUNCTION : ObjectKind.PROPERTY;
        String result2 = JSQuickNavigateBuilder.buildHtmlForProperty(element, qName, typePart);
        return JSQuickNavigateBuilder.buildResult(kind, result2, (PsiElement)element, originalElement);
    }

    private static String buildHtmlForProperty(@NotNull JSProperty element, String qName, CharSequence typePart) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(4);
        }
        return JSQuickNavigateBuilder.buildHtmlForVariableOrField((PsiElement)element, "", qName, false, typePart);
    }

    @Nullable
    protected JSType getPropertyTypeText(@NotNull JSProperty element) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(5);
        }
        return JSTypeUtils.widenLiteralTypes(element.getJSType());
    }

    @Nullable
    private static JSQualifiedNamedElement getPropertyParent(@NotNull JSProperty property) {
        PsiElement literalContainer;
        PsiElement parent;
        if (property == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(6);
        }
        if ((parent = property.getParent()) instanceof JSObjectLiteralExpression && (literalContainer = parent.getParent()) instanceof JSVariable) {
            return (JSVariable)literalContainer;
        }
        return null;
    }

    protected static boolean isFileNameRequired(@NotNull PsiElement element, @NotNull PsiElement originalElement) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(7);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(8);
        }
        VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)originalElement);
        return elementFile == null || !elementFile.equals(originalFile);
    }

    @Nullable
    protected String createQuickNavigateForFunction(@NotNull JSFunction function, @NotNull PsiElement originalElement) {
        boolean isGetterOrSetter;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(9);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(10);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        StringBuilder attributes = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)function, originalElement);
        boolean shouldAppendFunctionKeyword = this.shouldAppendFunctionKeyword(function, parent);
        this.appendFunctionAttributes(function, attributes, shouldAppendFunctionKeyword);
        String parentInfo = this.getParentInfo(parent, (PsiNamedElement)function, substitutor);
        String simpleName = StringUtil.notNullize((String)function.getName(), (String)"[unknown]");
        String qName = !StringUtil.isEmpty((String)parentInfo) ? parentInfo + "." + simpleName : simpleName;
        StringBuilder parametersWithReturnType = new StringBuilder();
        boolean get = function.isGetProperty();
        boolean set = function.isSetProperty();
        boolean bl = isGetterOrSetter = get || set;
        if (!isGetterOrSetter) {
            this.appendParameterList(function, parametersWithReturnType, substitutor);
        }
        String varType = this.getNarrowedTypeText(originalElement, substitutor);
        varType = get && varType != null ? varType : this.getReturnTypeTextForQuickNavigate(function, get, set, substitutor);
        this.appendType((PsiElement)function, varType, parametersWithReturnType);
        ObjectKind kind = this.getFunctionKind(function, isGetterOrSetter, shouldAppendFunctionKeyword);
        String result2 = JSQuickNavigateBuilder.buildHtmlForFunction((PsiElement)function, attributes, qName, shouldAppendFunctionKeyword, parametersWithReturnType);
        return JSQuickNavigateBuilder.buildResult(kind, result2, (PsiElement)function, originalElement);
    }

    @Nullable
    protected String getNarrowedTypeText(@NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(11);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @NotNull
    protected static String buildHtmlForFunction(@NotNull PsiElement context, @NotNull CharSequence modifiers, @NotNull CharSequence qName, boolean hasFunctionKeyword, @NotNull CharSequence parametersWithReturnType) {
        if (context == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(13);
        }
        if (modifiers == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(14);
        }
        if (qName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(15);
        }
        if (parametersWithReturnType == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(16);
        }
        String prefix = hasFunctionKeyword ? "" : "class Foo { ";
        String finalText = prefix + modifiers + "$$Name$$" + parametersWithReturnType;
        int beforeNameLength = prefix.length() + modifiers.length();
        TextRange toHighlight = new TextRange(beforeNameLength, beforeNameLength + "$$Name$$".length());
        String string = JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(context, qName, prefix, finalText, toHighlight);
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    protected ObjectKind getFunctionKind(@NotNull JSFunction function, boolean isGetterOrSetter, boolean shouldAppendKeyword) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(18);
        }
        if (isGetterOrSetter) {
            ObjectKind objectKind = ObjectKind.PROPERTY;
            if (objectKind == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(19);
            }
            return objectKind;
        }
        if (function.isConstructor()) {
            ObjectKind objectKind = ObjectKind.SIMPLE_DECLARATION;
            if (objectKind == null) {
                JSQuickNavigateBuilder.$$$reportNull$$$0(20);
            }
            return objectKind;
        }
        ObjectKind objectKind = shouldAppendKeyword ? ObjectKind.SIMPLE_DECLARATION : ObjectKind.FUNCTION;
        if (objectKind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(21);
        }
        return objectKind;
    }

    protected void appendParameterList(@NotNull JSFunction function, @NotNull StringBuilder result2, @NotNull JSTypeSubstitutor substitutor) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(22);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(23);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(24);
        }
        result2.append('(');
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null) {
            JSParameterListElement[] parameters = jsParameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                JSParameterListElement p = parameters[i];
                if (i != 0) {
                    result2.append(", ");
                }
                result2.append(JSParameterInfoHandler.getSignatureForParameter((JSParameterItem)p, substitutor, t -> this.getTypeTextForQuickNavigate((JSType)t, substitutor)));
            }
        }
        result2.append(')');
    }

    protected static String buildResult(@NotNull ObjectKind kind, @NotNull String objectText, @NotNull PsiElement element, @NotNull PsiElement originalElement) {
        boolean needFileName;
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(25);
        }
        if (objectText == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(26);
        }
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(27);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(28);
        }
        if (!(needFileName = JSQuickNavigateBuilder.isFileNameRequired(element, originalElement))) {
            return kind.toPrefix() + objectText;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        assert (file2 != null);
        String fileNameText = "(" + file2.getName() + ")";
        String kindText = kind.toPrefix();
        return kindText + objectText + JSQuickNavigateBuilder.buildAdditionalInformationText(fileNameText);
    }

    protected final String createQuickNavigateForVariableOrField(@NotNull JSFieldVariable variableOrField, PsiElement originalElement) {
        String prefix;
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(29);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variableOrField);
        StringBuilder modifiers = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)variableOrField, originalElement);
        this.appendAttrList((JSAttributeListOwner)variableOrField, modifiers);
        boolean hasVarPrefix = false;
        if (variableOrField instanceof JSVariable && !(prefix = this.getVarPrefix((JSVariable)variableOrField)).isEmpty()) {
            hasVarPrefix = true;
            modifiers.append(prefix);
        }
        String parentInfo = this.getParentInfo(parent, (PsiNamedElement)variableOrField, substitutor);
        String name = JSDocumentationBuilder.getNameForDocumentation((JSPsiElementBase)variableOrField);
        String qName = "";
        if (!StringUtil.isEmpty((String)parentInfo)) {
            qName = parentInfo;
            if (!StringUtil.startsWithChar((CharSequence)name, (char)'[')) {
                qName = qName + ".";
            }
        }
        qName = qName + name;
        StringBuilder typeAndInitializer = new StringBuilder();
        String variableOrFieldTypeText = this.getVariableOrFieldTypeText(variableOrField, substitutor);
        String inferredType = this.getVariableOrFieldInferredTypeText(variableOrField, originalElement, substitutor);
        if (variableOrFieldTypeText != null) {
            this.appendType((PsiElement)variableOrField, inferredType != null ? inferredType : variableOrFieldTypeText, typeAndInitializer);
        }
        if (variableOrField instanceof JSVariable && variableOrField.hasInitializer()) {
            this.appendVariableInitializer((JSVariable)variableOrField, typeAndInitializer);
        }
        ObjectKind kind = this.getFieldOrVariableKind(variableOrField);
        String textWithHighlighting = JSQuickNavigateBuilder.buildHtmlForVariableOrField((PsiElement)variableOrField, modifiers.toString(), qName, hasVarPrefix, typeAndInitializer);
        return JSQuickNavigateBuilder.buildResult(kind, textWithHighlighting, (PsiElement)variableOrField, originalElement);
    }

    @NotNull
    protected static String buildHtmlForVariableOrField(@NotNull PsiElement owner, @NotNull CharSequence modifiers, @NotNull CharSequence qName, boolean hasVarPrefix, @NotNull CharSequence typeAndInitializer) {
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(30);
        }
        if (modifiers == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(31);
        }
        if (qName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(32);
        }
        if (typeAndInitializer == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(33);
        }
        String prefix = hasVarPrefix ? "" : (owner instanceof JSParameter ? "function f( " : "class { ");
        String finalText = prefix + modifiers + "$$Name$$" + typeAndInitializer;
        int modifiersWithPrefixLength = modifiers.length() + prefix.length();
        TextRange toHighlight = new TextRange(modifiersWithPrefixLength, modifiersWithPrefixLength + "$$Name$$".length());
        String string = JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(owner, qName, prefix, finalText, toHighlight);
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    protected static String getQuickNavigateHtmlHighlighting(@NotNull PsiElement owner, @NotNull CharSequence qName, @NotNull String prefixToExclude, @NotNull String finalText, @Nullable TextRange toHighlight) {
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(35);
        }
        if (qName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(36);
        }
        if (prefixToExclude == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(37);
        }
        if (finalText == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(38);
        }
        CharSequence result2 = ApplicationManager.getApplication().isUnitTestMode() ? null : JSHtmlHighlightingUtil.tryGetHtmlHighlighting(owner, finalText, toHighlight, prefixToExclude.length(), finalText.length());
        result2 = result2 == null ? XmlTagUtilBase.escapeString((String)finalText.substring(prefixToExclude.length()), (boolean)false) : result2.toString().replace("font-style:italic;", "");
        String string = result2.toString().replace("$$Name$$", qName);
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    protected String getVariableOrFieldTypeText(@NotNull JSFieldVariable variableOrField, @NotNull JSTypeSubstitutor substitutor) {
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(40);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(41);
        }
        return this.getTypeTextForQuickNavigate(this.getVariableOrFieldType((JSTypeDeclarationOwner)variableOrField), substitutor);
    }

    @NotNull
    protected ObjectKind getFieldOrVariableKind(@NotNull JSFieldVariable variableOrField) {
        if (variableOrField == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(42);
        }
        ObjectKind objectKind = variableOrField instanceof JSParameter ? ObjectKind.PARAMETER : ObjectKind.SIMPLE_DECLARATION;
        if (objectKind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(43);
        }
        return objectKind;
    }

    private static String buildAdditionalInformationText(@NotNull String text) {
        if (text == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(44);
        }
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        Color color = CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getDefaultAttributes().getForegroundColor();
        StringBuilder result2 = new StringBuilder();
        result2.append(" <span");
        result2.append(" style=\"");
        Font font = StartupUiUtil.getLabelFont();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (font != null) {
                result2.append("font-size:").append(font.getSize()).append("pt").append(";");
            }
            if (color != null) {
                result2.append("color:").append(ColorUtil.toHex((Color)color)).append(";");
            }
        }
        result2.append("\">");
        result2.append(text);
        result2.append("</span>");
        return result2.toString();
    }

    @Nullable
    protected String createQuickNavigateForJSClass(@NotNull JSClass jsClass, PsiElement originalElement) {
        String qName;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(45);
        }
        if ((qName = jsClass.getQualifiedName()) == null) {
            return null;
        }
        StringBuilder attributesAndKeyword = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        this.appendClassAttributes(jsClass, originalElement, packageName, attributesAndKeyword);
        qName = this.getClassQualifiedName(jsClass, packageName);
        StringBuilder extendsImplements = new StringBuilder();
        this.appendClassExtendsAndImplements(jsClass, originalElement, packageName, extendsImplements);
        String htmlForClass = JSQuickNavigateBuilder.buildHtmlForClass(jsClass, attributesAndKeyword, qName, extendsImplements);
        return JSQuickNavigateBuilder.buildResult(ObjectKind.SIMPLE_DECLARATION, htmlForClass, (PsiElement)jsClass, originalElement);
    }

    private static String buildHtmlForClass(@NotNull JSClass jsClass, CharSequence attributesAndKeyword, String qName, CharSequence extendsImplements) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(46);
        }
        String finalText = attributesAndKeyword + "$$Name$$" + extendsImplements;
        TextRange range = new TextRange(attributesAndKeyword.length(), attributesAndKeyword.length() + "$$Name$$".length());
        return JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting((PsiElement)jsClass, qName, "", finalText, range);
    }

    @Nullable
    protected String getParentInfo(@Nullable PsiElement parent, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(47);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(48);
        }
        if (parent instanceof JSClass) {
            return StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)"default");
        }
        return "";
    }

    @Nullable
    private static String checkAndGetXmlAttributeQuickNavigate(@NotNull PsiElement element) {
        PsiElement xmlAttribute;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(49);
        }
        String xmlAttributeDoc = null;
        Object object = element.getParent() instanceof XmlAttribute ? element.getParent() : (xmlAttribute = element.getParent() instanceof XmlAttributeValue && element.getParent().getParent() instanceof XmlAttribute ? element.getParent().getParent() : null);
        if (xmlAttribute != null) {
            String value = StringUtil.unquoteString((String)StringUtil.notNullize((String)((XmlAttribute)xmlAttribute).getValue()));
            xmlAttributeDoc = ((XmlAttribute)xmlAttribute).getName() + " " + value;
        }
        return xmlAttributeDoc;
    }

    @Nullable
    protected String getReturnTypeTextForQuickNavigate(@NotNull JSFunction function, boolean get, boolean set, @NotNull JSTypeSubstitutor substitutor) {
        JSParameterListElement[] jsParameters;
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(50);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(51);
        }
        if (get || !set) {
            JSType type = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function, null);
            if (type instanceof JSFunctionReturnWrapperType) {
                type = type.substitute();
            }
            if (!JSFormatUtil.isPossiblyPresentableType(type, (PsiElement)function, true)) {
                return null;
            }
            return this.getTypeTextForQuickNavigate(type, substitutor);
        }
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null && (jsParameters = jsParameterList.getParameters()).length > 0) {
            return this.getTypeTextForQuickNavigate(jsParameters[0].getJSType(), substitutor);
        }
        return null;
    }

    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        JSType type;
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(52);
        }
        return (type = JSTypeUtils.applyGenericArguments(rawType, substitutor)) != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
    }

    protected void appendFunctionAttributes(@NotNull JSFunction function, @NotNull StringBuilder result2, boolean shouldAppendKeyword) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(53);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(54);
        }
        this.appendAttrList((JSAttributeListOwner)function, result2);
        if (shouldAppendKeyword) {
            result2.append(function.getKind() == JSFunction.FunctionKind.DECORATOR ? "decorator @" : "function ");
        }
    }

    protected boolean shouldAppendFunctionKeyword(@NotNull JSFunction function, @Nullable PsiElement parent) {
        if (function == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(55);
        }
        if (JSPsiImplUtils.isGetterOrSetter(function)) {
            return false;
        }
        if (function instanceof JSFunctionProperty || function instanceof TypeScriptFunctionSignature || function instanceof TypeScriptFunctionType) {
            return false;
        }
        return !(parent instanceof JSClass);
    }

    protected void appendAttrList(@NotNull JSAttributeListOwner owner, @NotNull StringBuilder result2) {
        JSElement exportScope;
        JSAttributeList attributeList;
        if (owner == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(56);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(57);
        }
        if ((attributeList = owner.getAttributeList()) == null) {
            return;
        }
        JSAttributeList.AccessType type = attributeList.getAccessType();
        String visibilityOrExportPart = null;
        JSClass jsClass = JSUtils.getMemberContainingClass((PsiElement)owner);
        if (jsClass != null) {
            visibilityOrExportPart = JSFormatUtil.formatVisibility(type, (PsiElement)owner);
        } else if (owner instanceof JSQualifiedNamedElement && ((exportScope = ES6PsiUtil.getExportScope((PsiElement)owner)) instanceof TypeScriptModule || ES6PsiUtil.isExternalModule((PsiElement)exportScope))) {
            if (((JSQualifiedNamedElement)owner).isExported()) {
                visibilityOrExportPart = "export";
            } else if (ES6ImportHandler.isExportedWithDefault((PsiElement)owner)) {
                visibilityOrExportPart = "export default";
            }
        }
        if (visibilityOrExportPart != null) {
            result2.append(visibilityOrExportPart);
            result2.append(" ");
        }
        this.appendPlainModifierList(attributeList, result2);
    }

    protected void appendPlainModifierList(@NotNull JSAttributeList attributeList, @NotNull StringBuilder result2) {
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(58);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(59);
        }
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.ASYNC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.STATIC);
        JSQuickNavigateBuilder.appendModifierWithSpace(result2, attributeList, JSAttributeList.ModifierType.GENERATOR);
    }

    @Nullable
    protected String getVariableOrFieldInferredTypeText(@NotNull JSFieldVariable resolved, @NotNull PsiElement originalElement, @NotNull JSTypeSubstitutor substitutor) {
        if (resolved == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(60);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(61);
        }
        if (substitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(62);
        }
        return null;
    }

    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(63);
        }
        return variable.getJSType();
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement el, @NotNull PsiElement originalElement) {
        if (el == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(64);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(65);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(66);
        }
        return jSTypeSubstitutor;
    }

    protected void appendType(@NotNull PsiElement context, @Nullable String varType, @NotNull StringBuilder builder) {
        if (context == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(67);
        }
        if (builder == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(68);
        }
        if (!StringUtil.isEmpty((String)varType)) {
            builder.append(JSSymbolPresentationProvider.getDefaultTypeSeparator(context)).append(varType);
        }
    }

    protected void appendClassAttributes(@NotNull JSClass jsClass, @NotNull PsiElement originalElement, @Nullable String packageOrModule, @NotNull StringBuilder result2) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(69);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(70);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(71);
        }
        this.appendAttrList((JSAttributeListOwner)jsClass, result2);
        result2.append(jsClass.isInterface() ? "interface " : "class ");
    }

    protected String getClassQualifiedName(@NotNull JSClass jsClass, @Nullable String packageOrModule) {
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(72);
        }
        return !StringUtil.isEmpty((String)packageOrModule) ? packageOrModule + "." + jsClass.getName() : jsClass.getName();
    }

    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, PsiElement originalElement, @NotNull String packageNameOrEmptyString, @NotNull StringBuilder result2) {
        String implementsList;
        String extendsList;
        if (jsClass == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(73);
        }
        if (packageNameOrEmptyString == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(74);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(75);
        }
        if ((extendsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getExtendsList(), packageNameOrEmptyString)) == null && this.isIncludeObjectInExtendsList() && !"Object".equals(jsClass.getName())) {
            extendsList = "Object";
        }
        if (extendsList != null) {
            result2.append(" extends ").append(extendsList);
        }
        if ((implementsList = JSQuickNavigateBuilder.generateReferenceTargetList(jsClass.getImplementsList(), packageNameOrEmptyString)) != null) {
            result2.append("\nimplements ").append(implementsList);
        }
    }

    protected boolean isIncludeObjectInExtendsList() {
        return false;
    }

    @Nullable
    private static String generateReferenceTargetList(@Nullable JSReferenceList implementsList, @NotNull String packageName) {
        String[] referenceExpressionTexts;
        if (packageName == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(76);
        }
        if (implementsList == null) {
            return null;
        }
        StringBuilder result2 = null;
        for (String refExprText : referenceExpressionTexts = implementsList.getReferenceTexts()) {
            refExprText = JSImportHandlingUtil.resolveTypeName(refExprText, (PsiElement)implementsList);
            if (result2 == null) {
                result2 = new StringBuilder();
            } else {
                result2.append(",");
            }
            refExprText = StringUtil.notNullize((String)refExprText);
            String referencedPackageName = StringUtil.getPackageName((String)refExprText);
            result2.append(referencedPackageName.equals(packageName) ? refExprText.substring(refExprText.lastIndexOf(46) + 1) : refExprText);
        }
        return result2 == null ? null : result2.toString();
    }

    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        JSVarStatement statement;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(77);
        }
        JSVarStatement.VarKeyword keyword = (statement = variable.getStatement()) != null ? statement.getVarKeyword() : null;
        String string = keyword != null ? keyword.getText() + " " : "";
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(78);
        }
        return string;
    }

    protected void appendVariableInitializer(@NotNull JSVariable variable, @NotNull StringBuilder result2) {
        JSExpression initializer;
        String initializerText;
        if (variable == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(79);
        }
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(80);
        }
        if ((initializerText = variable.getLiteralOrReferenceInitializerText()) == null && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            if (initializerText.length() > 50) {
                initializerText = initializerText.substring(0, 50) + " ...";
            }
            result2.append(" = ").append(initializerText);
        }
    }

    protected static void appendModifierWithSpace(@NotNull StringBuilder result2, @NotNull JSAttributeList attributeList, @NotNull JSAttributeList.ModifierType modifier) {
        if (result2 == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(81);
        }
        if (attributeList == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(82);
        }
        if (modifier == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(83);
        }
        if (attributeList.hasModifier(modifier)) {
            result2.append(modifier.keyword).append(" ");
        }
    }

    @Nullable
    protected String createQuickNavigateForJSElement(@NotNull JSElement element, @NotNull PsiElement originalElement, @NotNull String declaration, @NotNull ObjectKind kind) {
        String qName;
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(84);
        }
        if (originalElement == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(85);
        }
        if (declaration == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(86);
        }
        if (kind == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(87);
        }
        String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : element.getName();
        if (StringUtil.isEmpty((String)qName)) {
            return null;
        }
        StringBuilder attributesAndDeclaration = new StringBuilder();
        if (element instanceof JSAttributeListOwner) {
            this.appendAttrList((JSAttributeListOwner)element, attributesAndDeclaration);
        }
        attributesAndDeclaration.append(declaration);
        String result2 = JSQuickNavigateBuilder.buildHtmlForJSElement(element, attributesAndDeclaration, qName, !declaration.isEmpty());
        return JSQuickNavigateBuilder.buildResult(kind, result2, (PsiElement)element, originalElement);
    }

    private static String buildHtmlForJSElement(@NotNull JSElement element, CharSequence prefix, String qName, boolean hasDeclaration) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(88);
        }
        if (hasDeclaration) {
            String finalText = prefix + "$$Name$$";
            TextRange range = new TextRange(prefix.length(), prefix.length() + "$$Name$$".length());
            return JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting((PsiElement)element, qName, "", finalText, range);
        }
        return prefix + JSQuickNavigateBuilder.buildHtmlForName(element, qName);
    }

    @NotNull
    private static String buildHtmlForName(@NotNull JSElement element, @NotNull String name) {
        if (element == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(89);
        }
        if (name == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(90);
        }
        String result2 = ApplicationManager.getApplication().isUnitTestMode() ? null : JSHtmlHighlightingUtil.tryGetHtmlHighlightingForName((PsiElement)element, name);
        String string = result2 == null ? XmlTagUtilBase.escapeString((String)name, (boolean)false) : result2;
        if (string == null) {
            JSQuickNavigateBuilder.$$$reportNull$$$0(91);
        }
        return string;
    }

    @Contract(value="!null->!null")
    protected static PsiElement getOriginalElementOrParentIfLeaf(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement && JSKeywordSets.IDENTIFIER_NAMES.contains(originalElement.getNode().getElementType())) {
            originalElement = originalElement.getParent();
        }
        return originalElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 34: 
            case 39: 
            case 43: 
            case 66: 
            case 78: 
            case 91: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 34: 
            case 39: 
            case 43: 
            case 66: 
            case 78: 
            case 91: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 28: 
            case 61: 
            case 65: 
            case 70: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 18: 
            case 22: 
            case 50: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 12: 
            case 24: 
            case 41: 
            case 48: 
            case 51: 
            case 52: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 13: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 15: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersWithReturnType";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 34: 
            case 39: 
            case 43: 
            case 66: 
            case 78: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 23: 
            case 54: 
            case 57: 
            case 59: 
            case 71: 
            case 75: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectText";
                break;
            }
            case 29: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 30: 
            case 35: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAndInitializer";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixToExclude";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalText";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 45: 
            case 46: 
            case 69: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 58: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 63: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNameOrEmptyString";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlForFunction";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionKind";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlForVariableOrField";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickNavigateHtmlHighlighting";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldOrVariableKind";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlForName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateInfoForNavigationElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyTypeText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyParent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameRequired";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForFunction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedTypeText";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForFunction";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 34: 
            case 39: 
            case 43: 
            case 66: 
            case 78: 
            case 91: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionKind";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterList";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildResult";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForVariableOrField";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForVariableOrField";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateHtmlHighlighting";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldTypeText";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFieldOrVariableKind";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildAdditionalInformationText";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSClass";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForClass";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getParentInfo";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetXmlAttributeQuickNavigate";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeTextForQuickNavigate";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForQuickNavigate";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributes";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "shouldAppendFunctionKeyword";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "appendAttrList";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "appendPlainModifierList";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldInferredTypeText";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "appendType";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributes";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getClassQualifiedName";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "generateReferenceTargetList";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "appendModifierWithSpace";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSElement";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForJSElement";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "buildHtmlForName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 34: 
            case 39: 
            case 43: 
            case 66: 
            case 78: 
            case 91: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum ObjectKind {
        SIMPLE_DECLARATION{

            @Override
            @NotNull
            public String toPrefix() {
                if ("" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$1", "toPrefix"));
            }
        }
        ,
        PROPERTY{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(property) " == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "(property) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$2", "toPrefix"));
            }
        }
        ,
        PARAMETER{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(parameter) " == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "(parameter) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$3", "toPrefix"));
            }
        }
        ,
        FUNCTION{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(function) " == null) {
                    4.$$$reportNull$$$0(0);
                }
                return "(function) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$4", "toPrefix"));
            }
        }
        ,
        METHOD{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(method) " == null) {
                    5.$$$reportNull$$$0(0);
                }
                return "(method) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$5", "toPrefix"));
            }
        }
        ,
        IMPORT_SPECIFIER{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(named import) " == null) {
                    6.$$$reportNull$$$0(0);
                }
                return "(named import) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$6", "toPrefix"));
            }
        }
        ,
        IMPORT_DEFAULT{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(default import) " == null) {
                    7.$$$reportNull$$$0(0);
                }
                return "(default import) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$7", "toPrefix"));
            }
        }
        ,
        IMPORT_ALL{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(namespace import) " == null) {
                    8.$$$reportNull$$$0(0);
                }
                return "(namespace import) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$8", "toPrefix"));
            }
        }
        ,
        EXPORT{

            @Override
            @NotNull
            public String toPrefix() {
                if ("(export element) " == null) {
                    9.$$$reportNull$$$0(0);
                }
                return "(export element) ";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSQuickNavigateBuilder$ObjectKind$9", "toPrefix"));
            }
        };


        @NotNull
        public abstract String toPrefix();
    }
}

