/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigUtil;
import com.intellij.lang.javascript.flow.flowconfig.FlowModuleMapping;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSConfigImpl
extends UserDataHolderBase
implements FlowJSConfig {
    @NotNull
    private static final Set<String> TAGS = ContainerUtil.newHashSet((Object[])new String[]{"ignore", "include", "version", "options", "libs"});
    private final boolean myIsProjectConfig;
    @NotNull
    private final VirtualFile myConfigDir;
    @NotNull
    private final VirtualFile myConfigFile;
    @NotNull
    private final Collection<String> myIncludedPatterns;
    @NotNull
    private final Collection<String> myIgnoredPatterns;
    @Nullable
    private final FlowModuleMapping myModuleMapping;
    private final NullableLazyValue<Pattern> myIncludedRegPattern;
    private final NullableLazyValue<Pattern> myIgnoredRegPattern;

    @Nullable
    public static FlowJSConfig getConfig(@NotNull PsiFile psiFile, boolean isProject) {
        if (psiFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile configFile = psiFile.getVirtualFile();
        if (configFile == null) {
            return null;
        }
        VirtualFile configDir = configFile.getParent();
        if (configDir == null) {
            return null;
        }
        return new FlowJSConfigImpl(configFile, configDir, isProject);
    }

    @NotNull
    private Collection<String> getIgnoredPatterns() {
        Collection<String> collection = this.getTagOptions("ignore");
        if (collection == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    private Collection<String> getIncludedPatterns() {
        Collection<String> collection = this.getTagOptions("include");
        if (collection == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static boolean isCommentLine(@NotNull String line) {
        if (line == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(3);
        }
        boolean isComment = false;
        String lineWithoutWhiteSpaces = line.trim();
        if (lineWithoutWhiteSpaces.charAt(0) == '#') {
            isComment = true;
        }
        return isComment;
    }

    @NotNull
    private static ArrayList<String> removeEmptyLines(@NotNull String[] stringArray) {
        if (stringArray == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(4);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String line : stringArray) {
            String newLine = line.trim();
            if (newLine.isEmpty()) continue;
            result2.add(newLine);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private Collection<String> getTagOptions(@NotNull String requiredTag) {
        if (requiredTag == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(6);
        }
        Document configDocument = FileDocumentManager.getInstance().getDocument(this.myConfigFile);
        HashSet<String> stopTags = new HashSet<String>();
        stopTags.addAll(TAGS);
        stopTags.remove(requiredTag);
        ArrayList<String> collection = new ArrayList<String>();
        if (configDocument == null) {
            ArrayList<String> arrayList = collection;
            if (arrayList == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (configDocument.getLineCount() <= 0) {
            ArrayList<String> arrayList = collection;
            if (arrayList == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        String text = configDocument.getText();
        boolean isStart = false;
        String[] textLines = text.split("\n");
        ArrayList<String> textWithoutEmptyLines = FlowJSConfigImpl.removeEmptyLines(textLines);
        String tagLine = "[" + requiredTag + "]";
        for (String line : textWithoutEmptyLines) {
            if (!isStart) {
                if (!line.contains(tagLine)) continue;
                isStart = true;
                continue;
            }
            boolean isAnotherTag = false;
            for (String tag : stopTags) {
                if (!line.contains("[" + tag + "]")) continue;
                isAnotherTag = true;
                break;
            }
            if (isAnotherTag) break;
            if (FlowJSConfigImpl.isCommentLine(line)) continue;
            collection.add(line);
        }
        ArrayList<String> arrayList = collection;
        if (arrayList == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public static Pattern createPattern(@Nullable String pattern) {
        if (pattern == null) {
            return null;
        }
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            Logger.getInstance(FlowJSConfigImpl.class).warn("Bad pattern in .flowconfig: " + pattern);
            return null;
        }
    }

    private FlowJSConfigImpl(@NotNull VirtualFile configFile, @NotNull VirtualFile configDir, boolean isProjectConfig) {
        if (configFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(10);
        }
        if (configDir == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(11);
        }
        this.myIncludedRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (FlowJSConfigImpl.this.myIncludedPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpressionForGlobPattern(FlowJSConfigImpl.this.myIncludedPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.createPattern(pattern);
            }
        };
        this.myIgnoredRegPattern = new NullableLazyValue<Pattern>(){

            @Nullable
            protected Pattern compute() {
                if (FlowJSConfigImpl.this.myIgnoredPatterns.isEmpty()) {
                    return null;
                }
                String pattern = FlowJSConfigUtil.getRegularExpression(FlowJSConfigImpl.this.myIgnoredPatterns, FlowJSConfigImpl.this.myConfigDir);
                return FlowJSConfigImpl.createPattern(pattern);
            }
        };
        this.myConfigDir = configDir;
        this.myConfigFile = configFile;
        this.myIncludedPatterns = this.getIncludedPatterns();
        this.myIgnoredPatterns = this.getIgnoredPatterns();
        this.myIsProjectConfig = isProjectConfig;
        this.myModuleMapping = FlowModuleMapping.parse(configDir, this.getTagOptions("options"));
    }

    @Override
    public boolean isFileIncluded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(12);
        }
        String path = file2.getCanonicalPath();
        Pattern pattern = (Pattern)this.myIncludedRegPattern.getValue();
        return VfsUtilCore.isAncestor((VirtualFile)this.getConfigDirectory(), (VirtualFile)file2, (boolean)false) || pattern != null && FlowJSConfigImpl.checkPattern(path, pattern);
    }

    @Override
    public boolean isFileIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(13);
        }
        String path = file2.getCanonicalPath();
        if (this.myIgnoredPatterns.isEmpty()) {
            return false;
        }
        Pattern pattern = (Pattern)this.myIgnoredRegPattern.getValue();
        if (pattern == null) {
            return false;
        }
        return FlowJSConfigImpl.checkPattern(path, pattern);
    }

    @NotNull
    private MultiMap<String, VirtualFile> getModuleCache(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(14);
        }
        MultiMap multiMap = (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)this, () -> CachedValueProvider.Result.create(this.buildModuleCache(project), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS}));
        if (multiMap == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    @NotNull
    private MultiMap<String, VirtualFile> buildModuleCache(@NotNull Project project) {
        Condition<VirtualFile> acceptor;
        if (project == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(16);
        }
        Condition<VirtualFile> condition = acceptor = this.myModuleMapping == null ? null : this.myModuleMapping.getFileAcceptor();
        if (acceptor == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(17);
            }
            return multiMap;
        }
        GlobalSearchScope scope = this.isProjectConfig() ? GlobalSearchScope.projectScope((Project)project) : ProjectScope.getLibrariesScope((Project)project);
        DelegatingGlobalSearchScope resultScope = new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && acceptor.value((Object)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl$3", "contains"));
            }
        };
        ArrayList files = new ArrayList(FileTypeIndex.getFiles((FileType)FlowJSFileType.INSTANCE, (GlobalSearchScope)resultScope));
        files.addAll(FileTypeIndex.getFiles((FileType)JavaScriptFileType.INSTANCE, (GlobalSearchScope)resultScope));
        if (files.isEmpty()) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                FlowJSConfigImpl.$$$reportNull$$$0(18);
            }
            return multiMap;
        }
        MultiMap map = MultiMap.create();
        for (VirtualFile file2 : files) {
            map.putValue((Object)this.myModuleMapping.reduceName(file2.getName()), (Object)file2);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(19);
        }
        return multiMap;
    }

    public static boolean checkPattern(@NotNull String path, @NotNull Pattern pattern) {
        if (path == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(20);
        }
        if (pattern == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(21);
        }
        Matcher m = pattern.matcher(path);
        return m.find();
    }

    @Override
    public boolean isProjectConfig() {
        return this.myIsProjectConfig;
    }

    @Override
    @Nullable
    public FlowModuleMapping getMapping() {
        return this.myModuleMapping;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> resolveModule(@NotNull Project project, @NotNull String unquotedName) {
        if (project == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(22);
        }
        if (unquotedName == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(23);
        }
        Collection collection = this.getModuleCache(project).get((Object)unquotedName);
        if (collection == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(24);
        }
        return collection;
    }

    @Override
    @NotNull
    public VirtualFile getConfigDirectory() {
        VirtualFile virtualFile = this.myConfigDir;
        if (virtualFile == null) {
            FlowJSConfigImpl.$$$reportNull$$$0(25);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringArray";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredTag";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/flowconfig/FlowJSConfigImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredPatterns";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEmptyLines";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleCache";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModuleCache";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModule";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfig";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCommentLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyLines";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTagOptions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isFileIncluded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getModuleCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildModuleCache";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkPattern";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

