/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ReactImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final String COMPONENT_NAME = "Component";
    private static final String LIFECYCLE_INTERFACE_WITH_MARK = "^ComponentLifecycle";
    private static final String CHILD_CONTEXT_INTERFACE_WITH_MARK = "^ChildContextProvider";
    private static final String COMPONENT_STATIC_NAME = "^ComponentClass";
    public static final String REACT = "React";

    public boolean isImplicitUsage(PsiElement element) {
        if (!DialectDetector.isJSX(element)) {
            return false;
        }
        if (element instanceof JSVariable && REACT.equals(((JSVariable)element).getName())) {
            return true;
        }
        if (element instanceof JSField) {
            String name = ((JSField)element).getName();
            return "defaultProps".equals(name) || "propTypes".equals(name) || "contextTypes".equals(name) || "childContextTypes".equals(name) || "displayName".equals(name);
        }
        if (!(element instanceof JSFunction) && !(element instanceof JSProperty)) {
            return false;
        }
        JSNamedElement namedElement = (JSNamedElement)element;
        String name = namedElement.getName();
        if (name == null) {
            return false;
        }
        if (this.checkForClass(namedElement, name, CHILD_CONTEXT_INTERFACE_WITH_MARK)) {
            return true;
        }
        if (this.checkForClass(namedElement, name, LIFECYCLE_INTERFACE_WITH_MARK)) {
            return true;
        }
        if (this.checkForClass(namedElement, name, COMPONENT_NAME)) {
            return true;
        }
        return this.checkForClass(namedElement, name, COMPONENT_STATIC_NAME);
    }

    public boolean checkForClass(@NotNull JSNamedElement namedElement, @NotNull String name, @NotNull String className2) {
        if (namedElement == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        if (className2 == null) {
            ReactImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        Collection elements = StubIndex.getElements(JSClassIndex.KEY, (Object)className2, (Project)namedElement.getProject(), (GlobalSearchScope)TypeScriptReactTagUtil.getReactLibraryScope(namedElement.getProject()), JSElement.class);
        THashSet jsClasses = new THashSet();
        for (JSElement element : elements) {
            if (!(element instanceof JSClass)) continue;
            jsClasses.add((JSClass)element);
            ContainerUtil.addAll((Collection)jsClasses, (Object[])((JSClass)element).getSupers());
        }
        for (JSClass jsClass : jsClasses) {
            if ("Object".equals(jsClass.getName()) || jsClass.findFunctionByName(name) == null && jsClass.findFieldByName(name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "namedElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "className";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/frameworks/react/ReactImplicitUsageProvider";
        objectArray[2] = "checkForClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

