/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentsMover {
    private final List<PsiElement> myBeforeComments;
    private final List<PsiElement> myAfterComments;
    private final boolean myAllowNonStatements;

    public CommentsMover(@NotNull JSSourceElement statement) {
        if (statement == null) {
            CommentsMover.$$$reportNull$$$0(0);
        }
        this(statement, false);
    }

    public CommentsMover(@NotNull JSSourceElement statement, boolean allowNonStatements) {
        if (statement == null) {
            CommentsMover.$$$reportNull$$$0(1);
        }
        this.myBeforeComments = CommentsMover.collectBeforeComments(statement);
        this.myAfterComments = CommentsMover.collectAfterComments(statement);
        this.myAllowNonStatements = allowNonStatements;
    }

    @Nullable
    private static PsiElement fixMinToStatement(PsiElement min) {
        return !(min instanceof JSSourceElement) ? PsiTreeUtil.getParentOfType((PsiElement)min, JSSourceElement.class) : min;
    }

    public void move(@NotNull Set<PsiElement> created, @NotNull Collection<PsiElement> touched) {
        if (created == null) {
            CommentsMover.$$$reportNull$$$0(2);
        }
        if (touched == null) {
            CommentsMover.$$$reportNull$$$0(3);
        }
        if (this.myBeforeComments.isEmpty() && this.myAfterComments.isEmpty()) {
            return;
        }
        PsiElement min = Collections.min(created, Comparator.comparingInt(o -> o.getTextRange().getStartOffset()));
        if (min == null) {
            return;
        }
        if (!this.myAllowNonStatements && (min = CommentsMover.fixMinToStatement(min)) == null) {
            return;
        }
        if (!this.myBeforeComments.isEmpty() && this.myBeforeComments.get(0) instanceof JSDocComment) {
            JSDocumentationUtils.moveJSDoc((PsiComment)this.myBeforeComments.get(0), min);
        } else {
            if (this.myAllowNonStatements && (min = CommentsMover.fixMinToStatement(min)) == null) {
                return;
            }
            Collections.reverse(this.myBeforeComments);
            CommentsMover.moveCommentsList(min, this.myBeforeComments, touched);
        }
        if (!this.myAfterComments.isEmpty()) {
            if (this.myAllowNonStatements && (min = CommentsMover.fixMinToStatement(min)) == null) {
                return;
            }
            CommentsMover.moveCommentsList(min.getNextSibling(), this.myAfterComments, touched);
        }
    }

    public boolean hasAfterComments() {
        return !this.myAfterComments.isEmpty();
    }

    @NotNull
    private static List<PsiElement> collectBeforeComments(JSSourceElement statement) {
        SmartList comments = new SmartList();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (!(comment instanceof JSDocComment)) {
            PsiElement current = statement.getPrevSibling();
            boolean commentsFound = false;
            while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
                comments.add(current);
                if (commentsFound && current instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)current.getText()) > 1) break;
                commentsFound |= current instanceof PsiComment;
                current = current.getPrevSibling();
            }
            if (!commentsFound) {
                List<PsiElement> list2 = Collections.emptyList();
                if (list2 == null) {
                    CommentsMover.$$$reportNull$$$0(4);
                }
                return list2;
            }
        } else {
            comments.add(comment);
        }
        SmartList smartList = comments;
        if (smartList == null) {
            CommentsMover.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    public static PsiElement createNewLine(@NotNull PsiElement context) {
        if (context == null) {
            CommentsMover.$$$reportNull$$$0(6);
        }
        return CommentsMover.createWhiteSpace(context, "\n");
    }

    public static PsiElement createWhiteSpace(@NotNull PsiElement context, @NotNull String text) {
        if (context == null) {
            CommentsMover.$$$reportNull$$$0(7);
        }
        if (text == null) {
            CommentsMover.$$$reportNull$$$0(8);
        }
        return JSChangeUtil.createJSFileFromText(context.getProject(), text, DialectDetector.languageDialectOfElement(context)).getFirstChild();
    }

    @NotNull
    private static List<PsiElement> collectAfterComments(JSSourceElement statement) {
        SmartList comments = new SmartList();
        boolean commentsFound = false;
        PsiElement current = statement.getNextSibling();
        while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
            comments.add(current);
            if (commentsFound && current instanceof PsiWhiteSpace) break;
            commentsFound |= current instanceof PsiComment;
            if (current.getText().contains("\n")) break;
            current = current.getNextSibling();
        }
        if (!commentsFound) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                CommentsMover.$$$reportNull$$$0(9);
            }
            return list2;
        }
        SmartList smartList = comments;
        if (smartList == null) {
            CommentsMover.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static void moveCommentsList(@NotNull PsiElement target, @NotNull List<PsiElement> comments, @NotNull Collection<PsiElement> touched) {
        int numNewlinesAfterMove;
        if (target == null) {
            CommentsMover.$$$reportNull$$$0(11);
        }
        if (comments == null) {
            CommentsMover.$$$reportNull$$$0(12);
        }
        if (touched == null) {
            CommentsMover.$$$reportNull$$$0(13);
        }
        if (comments.isEmpty()) {
            return;
        }
        for (PsiElement element : comments) {
            if (!element.isValid()) {
                return;
            }
            if (!(element instanceof PsiComment) || !touched.contains(CommentsMover.findAssociatedElementForComment((PsiComment)element))) continue;
            return;
        }
        JSChangeUtil.addComments(comments, target);
        PsiElement before = comments.get(0).getPrevSibling();
        PsiElement lastComment = comments.get(comments.size() - 1);
        PsiElement after = lastComment.getNextSibling();
        for (PsiElement element : comments) {
            element.getParent().getNode().removeChild(element.getNode());
        }
        int lastSpaceNewLines = Math.max(1, CommentsMover.countNewLinesIfSpace(lastComment));
        if (before != null && after != null && (numNewlinesAfterMove = CommentsMover.countNewLinesIfSpace(before) + CommentsMover.countNewLinesIfSpace(after)) < lastSpaceNewLines) {
            String str = StringUtil.repeat((String)"\n", (int)(lastSpaceNewLines - numNewlinesAfterMove));
            JSChangeUtil.addWs(after.getParent().getNode(), after.getNode(), str);
        }
    }

    private static int countNewLinesIfSpace(@NotNull PsiElement element) {
        if (element == null) {
            CommentsMover.$$$reportNull$$$0(14);
        }
        return element instanceof PsiWhiteSpace ? StringUtil.countNewLines((CharSequence)element.getText()) : 0;
    }

    static PsiElement findAssociatedSameLineElementForComment(PsiComment current) {
        Document document2 = PsiDocumentManager.getInstance((Project)current.getProject()).getDocument(current.getContainingFile());
        if (document2 == null) {
            return null;
        }
        int startLine = document2.getLineNumber(current.getTextRange().getStartOffset());
        for (PsiElement currentOnLine = current.getPrevSibling(); currentOnLine != null && startLine == document2.getLineNumber(currentOnLine.getTextRange().getStartOffset()); currentOnLine = currentOnLine.getPrevSibling()) {
            if (!(currentOnLine instanceof JSElement) || currentOnLine instanceof PsiComment) continue;
            return currentOnLine;
        }
        return null;
    }

    static PsiElement findAssociatedElementForComment(PsiComment current) {
        PsiElement sameLineElementForComment = CommentsMover.findAssociatedSameLineElementForComment(current);
        if (sameLineElementForComment != null) {
            return sameLineElementForComment;
        }
        return JSDocumentationUtils.findAttachedElementFromComment(current);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "created";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touched";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/CommentsMover";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/CommentsMover";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBeforeComments";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAfterComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createWhiteSpace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveCommentsList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "countNewLinesIfSpace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

