/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertParametersToObjectIntention
extends JavaScriptIntention {
    private static final String PARAMETERS_VARIABLE = "parameters";

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.parameters.to.object.intention.name", (Object[])new Object[0]);
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element) || DialectDetector.isActionScript(element)) {
            return false;
        }
        JSParameterList parameterList = JSConvertParametersToObjectIntention.getFunctionParameterList(element);
        Object[] parameters = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        return function != null && (StringUtil.isNotEmpty((String)function.getName()) || JSConvertParametersToObjectIntention.getParentCall(function) != null) && !ArrayUtil.isEmpty((Object[])parameters) && ContainerUtil.and((Object[])parameters, this::isSimpleParameter);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(5);
        }
        JSParameterList parameterList = JSConvertParametersToObjectIntention.getFunctionParameterList(element);
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        if (parameterList == null || function == null) {
            return;
        }
        JSParameter[] parameters = parameterList.getParameterVariables();
        if (parameters.length == 0) {
            return;
        }
        ArrayList<JSCallExpression> callExpressions = new ArrayList<JSCallExpression>();
        MultiMap conflicts = new MultiMap();
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{function})) {
            return;
        }
        if (!JSConvertParametersToObjectIntention.fillFunctionUsagesWithProgress(element, function, callExpressions, (MultiMap<PsiElement, String>)conflicts)) {
            return;
        }
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)parameterList, JSLanguageFeature.TYPES);
        boolean hasDestructuring = DialectDetector.hasFeature((PsiElement)function, JSLanguageFeature.DESTRUCTURING_PARAMETERS);
        StringBuilder parameterTypeBuilder = hasTypes ? new StringBuilder() : null;
        StringBuilder destructuringObjectBuilder = hasDestructuring ? new StringBuilder() : null;
        JSConvertParametersToObjectIntention.buildTypeAndDestructuringTexts(parameters, parameterTypeBuilder, destructuringObjectBuilder);
        String destructuringObjectText = hasDestructuring ? destructuringObjectBuilder.toString() : null;
        String newParameterType = hasTypes ? parameterTypeBuilder.toString() : "";
        WriteAction.run(() -> {
            if (destructuringObjectText != null) {
                JSConvertParametersToObjectIntention.replaceParametersInFunctionSignature(parameterList, parameters, destructuringObjectText + newParameterType);
            } else {
                JSConvertParametersToObjectIntention.replaceParametersInFunctionSignature(parameterList, parameters, PARAMETERS_VARIABLE + newParameterType);
                JSConvertParametersToObjectIntention.addVariablesInitializationToFunctionBody(parameters, function);
            }
            JSConvertParametersToObjectIntention.replaceArgumentsInCalls(parameters, callExpressions);
        });
    }

    @Nullable
    private static JSParameterList getFunctionParameterList(@NotNull PsiElement element) {
        if (element == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(6);
        }
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class);
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        while (TypeScriptPsiUtil.isTypeSignature(function)) {
            parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)function, JSParameterList.class);
            function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parameterList, JSFunction.class);
        }
        return parameterList;
    }

    private static void replaceArgumentsInCalls(@NotNull JSParameter[] parameters, @NotNull List<JSCallExpression> callExpressions) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(7);
        }
        if (callExpressions == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(8);
        }
        boolean hasRest = parameters.length > 0 && parameters[parameters.length - 1].isRest();
        for (JSCallExpression call : callExpressions) {
            JSArgumentList argumentList = call.getArgumentList();
            if (argumentList == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{argumentList})) continue;
            JSExpression[] arguments = argumentList.getArguments();
            int argToReplaceCount = Math.min(arguments.length, parameters.length);
            String newArgument = JSConvertParametersToObjectIntention.wrapArgumentsWithObjectLiteral(parameters, arguments, argToReplaceCount, hasRest);
            JSExpression newArgumentPsi = JSPsiElementFactory.createJSExpression(newArgument, (PsiElement)call);
            if (argToReplaceCount > 0) {
                if (argToReplaceCount > 1) {
                    argumentList.getNode().removeRange(arguments[0].getNode(), arguments[argToReplaceCount - 1].getNode());
                }
                arguments[argToReplaceCount - 1].replace((PsiElement)newArgumentPsi);
            } else {
                ASTNode leftPar = argumentList.getNode().findChildByType(JSTokenTypes.LPAR);
                if (leftPar != null) {
                    argumentList.addAfter((PsiElement)newArgumentPsi, leftPar.getPsi());
                }
            }
            if (!hasRest || arguments.length <= argToReplaceCount) continue;
            for (int i = argToReplaceCount; i < arguments.length; ++i) {
                JSExpression argument = arguments[i];
                JSChangeUtil.removeRangeWithRemovalOfCommas((PsiElement)argument, (PsiElement[])arguments);
            }
        }
    }

    private static void replaceParametersInFunctionSignature(@NotNull JSParameterList parameterList, @NotNull JSParameter[] parameters, @NotNull String replacement) {
        if (parameterList == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(10);
        }
        if (replacement == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(11);
        }
        JSParameter firstParam = parameters[0];
        JSParameter lastParam = parameters[parameters.length - 1];
        if (parameters.length > 1) {
            parameterList.getNode().removeRange(firstParam.getNode(), lastParam.getNode());
        }
        JSParameterList list2 = (JSParameterList)JSChangeUtil.createParameter(replacement, (PsiElement)parameterList).getParent();
        lastParam.replace((PsiElement)list2.getParameters()[0]);
    }

    private static void buildTypeAndDestructuringTexts(@NotNull JSParameter[] parameters, @Nullable StringBuilder parameterTypeBuilder, @Nullable StringBuilder destructuringObjectBuilder) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(12);
        }
        if (parameterTypeBuilder == null && destructuringObjectBuilder == null) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            JSParameter parameter = parameters[i];
            if (parameterTypeBuilder != null) {
                if (i != 0) {
                    parameterTypeBuilder.append(", ");
                }
                JSConvertParametersToObjectIntention.appendParameterType(parameterTypeBuilder, parameter);
            }
            if (destructuringObjectBuilder == null) continue;
            if (i != 0) {
                destructuringObjectBuilder.append(", ");
            }
            JSConvertParametersToObjectIntention.appendParameterNameWithInitializer(destructuringObjectBuilder, parameter);
        }
        if (parameterTypeBuilder != null && parameterTypeBuilder.length() != 0) {
            parameterTypeBuilder.insert(0, ": { ").append(" }");
        }
        if (destructuringObjectBuilder != null) {
            destructuringObjectBuilder.insert(0, "{").append("}");
        }
    }

    private static void appendParameterType(@NotNull StringBuilder parameterTypeBuilder, @NotNull JSParameter parameter) {
        boolean isRest;
        if (parameterTypeBuilder == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(13);
        }
        if (parameter == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(14);
        }
        JSType type = (isRest = parameter.isRest()) ? TypeScriptPsiUtil.getTypeFromDeclaration((StubBasedPsiElementBase)parameter) : parameter.getJSType();
        String name = parameter.getName();
        if (isRest && type == null) {
            type = new JSArrayTypeImpl(JSAnyType.get((PsiElement)parameter, true), JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true));
        }
        parameterTypeBuilder.append(name).append(parameter.isOptional() || parameter.isRest() && !(type instanceof JSTupleType) ? "?" : "").append(": ").append(type != null ? type.getTypeText(JSType.TypeTextFormat.CODE) : JSClassUtils.getAnyTypeString((PsiElement)parameter, true));
    }

    private static void appendParameterNameWithInitializer(@NotNull StringBuilder destructuringObjectBuilder, @NotNull JSParameter parameter) {
        if (destructuringObjectBuilder == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(16);
        }
        destructuringObjectBuilder.append(parameter.getName());
        JSExpression initializer = parameter.getInitializer();
        if (initializer != null) {
            destructuringObjectBuilder.append("=").append(initializer.getText());
        }
    }

    @Nullable
    private static JSCallExpression getParentCall(@NotNull JSFunction function) {
        PsiElement parent;
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(17);
        }
        if (function instanceof JSFunctionExpression && (parent = JSUtils.getParentSkipParentheses((PsiElement)function)) instanceof JSCallExpression) {
            return (JSCallExpression)parent;
        }
        return null;
    }

    private static boolean fillFunctionUsagesWithProgress(@NotNull PsiElement invocationElement, @NotNull JSFunction function, @NotNull List<JSCallExpression> callExpressions, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (invocationElement == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(18);
        }
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(19);
        }
        if (callExpressions == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(20);
        }
        if (conflicts == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(21);
        }
        JSQualifiedNamedElement funcRef = function instanceof JSFunctionExpression ? ((JSFunctionExpression)function).getElementAssignedTo() : null;
        JSParameterListElement[] parameters = function.getParameters();
        boolean hasRestParam = parameters.length > 0 && parameters[parameters.length - 1].isRest();
        JSCallExpression parentCall = JSConvertParametersToObjectIntention.getParentCall(function);
        if (parentCall != null) {
            callExpressions.add(parentCall);
        }
        Processor referenceProcessor = reference -> {
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = JSUtils.getParentSkipParentheses(referenceElement);
            if (parent instanceof JSCallExpression) {
                JSExpression[] arguments = ((JSCallExpression)parent).getArguments();
                boolean hasNonTerminalSpread = false;
                for (int i = 0; i < arguments.length; ++i) {
                    JSExpression argument = arguments[i];
                    if (!(argument instanceof JSSpreadExpression) || i == arguments.length - 1 && hasRestParam) continue;
                    conflicts.putValue((Object)argument, (Object)JSBundle.message((String)"js.convert.parameters.to.object.usage.will.not.be.updated.for.spread", (Object[])new Object[0]));
                    hasNonTerminalSpread = true;
                    break;
                }
                if (!hasNonTerminalSpread) {
                    callExpressions.add((JSCallExpression)parent);
                }
            } else if (parent == function.getParent()) {
                conflicts.putValue((Object)referenceElement, (Object)JSBundle.message((String)"js.convert.parameters.to.object.usage.will.not.be.updated.for.contextual.type", (Object[])new Object[0]));
            } else if (referenceElement instanceof JSReferenceExpression) {
                conflicts.putValue((Object)referenceElement, (Object)JSBundle.message((String)"js.convert.parameters.to.object.non.call.usage.will.not.be.updated", (Object[])new Object[0]));
            }
            return true;
        };
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> JSConvertParametersToObjectIntention.lambda$fillFunctionUsagesWithProgress$3(function, referenceProcessor, (JSNamedElement)funcRef), JSBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, invocationElement.getProject());
    }

    protected boolean isSimpleParameter(JSParameterListElement p) {
        if (!this.isValidSimpleParameter(p)) {
            return false;
        }
        PsiElement typeElement = p.getTypeElement();
        return typeElement == null || ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)typeElement).filter(Conditions.instanceOf((Class[])new Class[]{TypeScriptThisType.class, TypeScriptInferType.class}))).traverse().isEmpty();
    }

    protected boolean isValidSimpleParameter(JSParameterListElement p) {
        JSParameter simpleParameter = (JSParameter)ObjectUtils.tryCast((Object)p, JSParameter.class);
        return simpleParameter != null && !TypeScriptPsiUtil.isFieldParameter(simpleParameter);
    }

    @NotNull
    private static String wrapArgumentsWithObjectLiteral(@NotNull JSParameter[] parameters, @NotNull JSExpression[] arguments, int argToReplaceCount, boolean hasRest) {
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(22);
        }
        if (arguments == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(23);
        }
        StringBuilder builder = new StringBuilder(argToReplaceCount * 4);
        builder.append("{");
        int maxIndex = hasRest ? arguments.length : argToReplaceCount;
        boolean closeBracket = false;
        for (int i = 0; i < maxIndex; ++i) {
            JSExpression argument = arguments[i];
            boolean spread = false;
            if (argument instanceof JSSpreadExpression && ((JSSpreadExpression)argument).getExpression() instanceof JSArrayLiteralExpression) {
                spread = true;
                argument = ((JSSpreadExpression)argument).getExpression();
            }
            if (!hasRest || i < argToReplaceCount) {
                builder.append(parameters[i].getName());
                builder.append(" : ");
                if (hasRest && i == argToReplaceCount - 1 && !spread) {
                    builder.append("[");
                    closeBracket = true;
                }
            }
            builder.append(argument == null ? "" : argument.getText());
            if (i < maxIndex - 1) {
                builder.append(", ");
                continue;
            }
            if (!hasRest || !closeBracket) continue;
            builder.append("]");
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static void addVariablesInitializationToFunctionBody(@NotNull JSParameter[] parameters, @NotNull JSFunction function) {
        JSBlockStatement body;
        if (parameters == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(25);
        }
        if (function == null) {
            JSConvertParametersToObjectIntention.$$$reportNull$$$0(26);
        }
        if ((body = function.getBlock()) == null) {
            return;
        }
        PsiElement anchor = body.getFirstChild();
        String variablePrefix = JSChangeUtil.getVariablePrefix((PsiElement)function);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        for (JSParameter parameter : parameters) {
            String parameterName = parameter.getName();
            String variableText = variablePrefix + " " + parameterName + " = " + PARAMETERS_VARIABLE + "." + parameterName + semicolon;
            anchor = body.addAfter((PsiElement)JSPsiElementFactory.createJSStatement(variableText, (PsiElement)function), anchor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$fillFunctionUsagesWithProgress$3(JSFunction function, Processor referenceProcessor, JSNamedElement funcRef) {
        ApplicationManager.getApplication().runReadAction(() -> {
            ReferencesSearch.search((PsiElement)function, (SearchScope)function.getUseScope()).forEach(referenceProcessor);
            if (funcRef != null) {
                ReferencesSearch.search((PsiElement)funcRef, (SearchScope)funcRef.getUseScope()).forEach(referenceProcessor);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = PARAMETERS_VARIABLE;
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeBuilder";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringObjectBuilder";
                break;
            }
            case 17: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertParametersToObjectIntention";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapArgumentsWithObjectLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParameterList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceArgumentsInCalls";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceParametersInFunctionSignature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeAndDestructuringTexts";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterNameWithInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParentCall";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fillFunctionUsagesWithProgress";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapArgumentsWithObjectLiteral";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addVariablesInitializationToFunctionBody";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

