/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSwitchBranchesProcessor {
    @Nullable
    public static JSType findTypeForCases(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            return null;
        }
        JSExpression expression = statement.getSwitchExpression();
        if (expression == null) {
            return null;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(expression);
        return JSSwitchBranchesProcessor.expandTypeForSwitch(jsType);
    }

    @Nullable
    public static JSType expandTypeForSwitch(@Nullable JSType jsType) {
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(jsType);
        if (type instanceof JSTypeWithIncompleteSubstitution) {
            type = ((JSTypeWithIncompleteSubstitution)type).substituteCompletely();
        }
        return JSTypeUtils.getValuableType(type);
    }

    public static List<Pair<Integer, String>> getAllCaseVariants(JSSwitchStatement statement) {
        return JSSwitchBranchesProcessor.getAllCaseVariants(JSSwitchBranchesProcessor.findTypeForCases(statement), JSSwitchBranchesProcessor.getExistingVariants(statement), JSCodeStyleSettings.getQuote((PsiElement)statement));
    }

    @NotNull
    public static List<Pair<Integer, String>> getAllCaseVariants(@Nullable JSType cases, @NotNull List<Pair<Integer, JSType>> existingVariants, @Nullable String quote) {
        if (existingVariants == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(0);
        }
        List<Pair<Integer, String>> list2 = JSSwitchBranchesProcessor.getAllCaseVariants(cases, existingVariants, quote, false);
        if (list2 == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static List<Pair<Integer, String>> getAllCaseVariants(@Nullable JSType cases, @NotNull List<Pair<Integer, JSType>> existingVariants, @Nullable String quote, boolean strict) {
        if (existingVariants == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<Integer, String>> result2 = new ArrayList<Pair<Integer, String>>();
        if (cases instanceof JSStringLiteralTypeImpl) {
            if (strict && ((JSStringLiteralTypeImpl)cases).allowWidening()) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    JSSwitchBranchesProcessor.$$$reportNull$$$0(3);
                }
                return list2;
            }
            String literal = ((JSStringLiteralTypeImpl)cases).getLiteral();
            Pair<Integer, JSType> firstMatch = JSSwitchBranchesProcessor.getFirstMatchingLiteral(existingVariants, literal);
            if (quote == null) {
                quote = "\"";
            }
            StringBuilder buffer = new StringBuilder();
            JSStringUtil.escapeSimpleStringChars(literal, quote.charAt(0), true, false, false, buffer);
            String variant = quote + buffer + quote;
            result2.add((Pair<Integer, String>)Pair.create((Object)(firstMatch != null ? (Integer)firstMatch.first : -1), (Object)variant));
        } else if (cases instanceof JSResolvableType) {
            TypeScriptEnum enumeration;
            JSResolvedTypeInfo info = ((JSResolvableType)cases).resolveType();
            if (info.isEnumLiteral()) {
                result2.add(JSSwitchBranchesProcessor.getWithOffset(existingVariants, cases));
            } else if (info.isEnum() && (enumeration = info.getDeclarationOfType(TypeScriptEnum.class)) != null) {
                for (JSField field : enumeration.getFields()) {
                    String name = field.getName();
                    if (name == null) continue;
                    result2.add(JSSwitchBranchesProcessor.getWithOffset(existingVariants, JSNamedTypeFactory.createEnumLiteralType((JSResolvableType)cases, (JSFieldVariable)field)));
                }
            }
        } else if (cases instanceof JSUnionType) {
            for (JSType type : ((JSUnionType)cases).getTypes()) {
                result2.addAll(JSSwitchBranchesProcessor.getAllCaseVariants(type, existingVariants, quote));
            }
        }
        ArrayList<Pair<Integer, String>> arrayList = result2;
        if (arrayList == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static Pair<Integer, String> getWithOffset(@NotNull List<Pair<Integer, JSType>> existingVariants, @NotNull JSType type) {
        Pair firstMatch;
        if (existingVariants == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(6);
        }
        Pair pair = Pair.create((Object)((firstMatch = (Pair)existingVariants.stream().filter(v -> ((JSType)v.second).isEquivalentTo(type, null)).findFirst().orElse(null)) != null ? (Integer)firstMatch.first : -1), (Object)type.getTypeText(JSType.TypeTextFormat.CODE));
        if (pair == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(7);
        }
        return pair;
    }

    @Nullable
    private static Pair<Integer, JSType> getFirstMatchingLiteral(@NotNull List<Pair<Integer, JSType>> existingVariants, @Nullable String literal) {
        if (existingVariants == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(8);
        }
        for (Pair<Integer, JSType> v : existingVariants) {
            if (!(v.second instanceof JSStringLiteralTypeImpl) || !Objects.equals(((JSStringLiteralTypeImpl)v.second).getLiteral(), literal)) continue;
            return v;
        }
        return null;
    }

    @NotNull
    public static List<Pair<Integer, JSType>> getExistingVariants(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSSwitchBranchesProcessor.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList<Pair<Integer, JSType>> existingTypes = new ArrayList<Pair<Integer, JSType>>();
        JSType typeForCases = JSSwitchBranchesProcessor.findTypeForCases(statement);
        for (JSCaseClause clause : statement.getCaseClauses()) {
            JSExpression expression = clause.getCaseExpression();
            JSType type = JSSwitchBranchesProcessor.replaceByEnumConstantOrLiteralIfNeeded(JSResolveUtil.getExpressionJSType(expression), expression, typeForCases);
            if (type == null) continue;
            existingTypes.add((Pair<Integer, JSType>)Pair.create((Object)clause.getTextOffset(), (Object)type));
        }
        ArrayList<Pair<Integer, JSType>> arrayList = existingTypes;
        if (arrayList == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    private static JSType replaceByEnumConstantOrLiteralIfNeeded(@Nullable JSType type, @Nullable JSExpression context, @Nullable JSType typeForCases) {
        JSType match;
        JSResolvedTypeInfo resolvedInfo;
        if (context == null) {
            return type;
        }
        if (type instanceof JSLiteralType) {
            JSType match2 = JSSwitchBranchesProcessor.findMatch(type, typeForCases, JSSwitchBranchesProcessor::findMatchForLiteral);
            if (match2 != null) {
                return match2;
            }
        } else if (type instanceof JSTypeImpl && (resolvedInfo = ((JSTypeImpl)type).resolveType()).isEnumLiteral() && (match = JSSwitchBranchesProcessor.findMatch(type, typeForCases, JSSwitchBranchesProcessor::findMatchForEnum)) != null) {
            return match;
        }
        return type;
    }

    @Nullable
    private static JSType findMatch(@NotNull JSType type, @Nullable JSType typeForCases, BiFunction<JSType, JSType, JSType> matchFinder) {
        JSType singleMatch;
        if (type == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(11);
        }
        if ((singleMatch = matchFinder.apply(type, typeForCases)) != null) {
            return singleMatch;
        }
        if (typeForCases instanceof JSUnionType) {
            for (JSType jsType : ((JSUnionType)typeForCases).getTypes()) {
                JSType matchingEnum = matchFinder.apply(type, jsType);
                if (matchingEnum == null) continue;
                return matchingEnum;
            }
        }
        return null;
    }

    @Nullable
    private static JSType findMatchForLiteral(JSType type, JSType jsType) {
        JSType matchingEnum;
        if (jsType instanceof JSTypeImpl && type instanceof JSLiteralType && (matchingEnum = JSSwitchBranchesProcessor.findMatchingEnumType((JSLiteralType)type, (JSTypeImpl)jsType)) != null) {
            return matchingEnum;
        }
        return null;
    }

    @Nullable
    private static JSType findMatchForEnum(JSType type, JSType jsType) {
        JSType matchingEnum;
        if (type instanceof JSTypeImpl && jsType instanceof JSLiteralType && (matchingEnum = JSSwitchBranchesProcessor.findMatchingEnumType((JSLiteralType)jsType, (JSTypeImpl)type)) != null) {
            return jsType;
        }
        return null;
    }

    @Nullable
    private static JSType findMatchingEnumType(@NotNull JSLiteralType type, @NotNull JSTypeImpl enumOrEnumLiteral) {
        JSResolvedTypeInfo info;
        EnumConstantValue value;
        if (type == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(12);
        }
        if (enumOrEnumLiteral == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(13);
        }
        if (JSSwitchBranchesProcessor.matchesConstantValue(type, value = (info = enumOrEnumLiteral.resolveType()).getEnumConstValue())) {
            return enumOrEnumLiteral;
        }
        if (info.isEnumWithLiteralValues()) {
            Collection<TypeScriptEnum> enums = info.getDeclarationsOfType(TypeScriptEnum.class);
            if (enums.size() != 1) {
                return null;
            }
            TypeScriptEnum decl = enums.iterator().next();
            for (JSField field : decl.getFields()) {
                EnumConstantValue constValue;
                if (!(field instanceof TypeScriptEnumField) || !JSSwitchBranchesProcessor.matchesConstantValue(type, constValue = ((TypeScriptEnumField)field).getConstantValue())) continue;
                return JSNamedTypeFactory.createEnumLiteralType(enumOrEnumLiteral, (JSFieldVariable)field);
            }
        }
        return null;
    }

    private static boolean matchesConstantValue(@NotNull JSLiteralType type, @NotNull EnumConstantValue value) {
        if (type == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(14);
        }
        if (value == null) {
            JSSwitchBranchesProcessor.$$$reportNull$$$0(15);
        }
        return type instanceof JSStringLiteralTypeImpl && ((JSStringLiteralTypeImpl)type).getLiteral().equals(value.getStringValue()) || type instanceof JSNumberLiteralTypeImpl && ((JSNumberLiteralTypeImpl)type).getLiteral().equals(value.getNumericValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingVariants";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumOrEnumLiteral";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSwitchBranchesProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCaseVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithOffset";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllCaseVariants";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWithOffset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMatchingLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMatch";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingEnumType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matchesConstantValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

