/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.JSTypedEntity;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConditionalType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterProvider;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptSingleTypeStub;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSingleTypeImpl
extends JSStubElementImpl<TypeScriptSingleTypeStub>
implements TypeScriptSingleType {
    public static final String IMPORT_PREFIX = "import(";
    public static final String TYPEOF_IMPORT = "typeof import(";
    private static final Function<JSTypeDeclaration, JSType> MAP_DECLARATION_TO_TYPE = JSTypedEntity::getJSType;

    public TypeScriptSingleTypeImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptSingleTypeImpl(TypeScriptSingleTypeStub stub, IStubElementType signature) {
        super(stub, signature);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptSingleType((TypeScriptSingleType)this);
        } else {
            super.accept(visitor);
        }
    }

    public String getQualifiedTypeName() {
        TypeScriptSingleTypeStub stub = (TypeScriptSingleTypeStub)this.getGreenStub();
        if (stub != null) {
            return stub.getQualifiedTypeName();
        }
        ASTNode ownNode = this.getNode();
        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)"unique symbol", (CharSequence)ownNode.getText())) {
            return "unique symbol";
        }
        ASTNode primitive = ownNode.findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter);
        if (primitive != null) {
            return primitive.getText();
        }
        String prefix = ownNode.findChildByType(JSTokenTypes.TYPEOF_KEYWORD) != null ? "typeof " : "";
        ASTNode node = ownNode.findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
        if (node == null) {
            node = ownNode.findChildByType(ES6ElementTypes.IMPORT_CALL);
        }
        if (node == null) {
            return null;
        }
        PsiElement psi = node.getPsi();
        if (psi == null) {
            return null;
        }
        JSQualifiedNameImpl name = this.getAccurateName(psi);
        return name == null ? null : prefix + name.getQualifiedName();
    }

    @Nullable
    private JSQualifiedNameImpl getAccurateName(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(1);
        }
        if (element instanceof JSReferenceExpression) {
            JSReferenceExpression reference = (JSReferenceExpression)element;
            String referenceName = reference.getReferenceName();
            if (referenceName == null) {
                return null;
            }
            JSExpression qualifier = reference.getQualifier();
            if (qualifier == null) {
                return JSQualifiedNameImpl.create(referenceName, null);
            }
            JSQualifiedNameImpl qualifierName = this.getAccurateName((PsiElement)qualifier);
            return qualifierName != null ? JSQualifiedNameImpl.create(referenceName, qualifierName) : null;
        }
        if (element instanceof ES6ImportCall) {
            JSLiteralExpression argument = ((ES6ImportCall)element).getStringArgument();
            if (argument == null) {
                return null;
            }
            return JSQualifiedNameImpl.create(IMPORT_PREFIX + argument.getText() + ")", null);
        }
        Logger.getInstance(TypeScriptSingleTypeImpl.class).error("Unexpected element: " + element.getText() + " in " + this.getText());
        return null;
    }

    @Nullable
    public TypeScriptTypeArgumentList getTypeArgumentList() {
        return (TypeScriptTypeArgumentList)this.getStubOrPsiChild((IStubElementType)TypeScriptElementTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public JSTypeDeclaration[] getTypeArguments() {
        TypeScriptTypeArgumentList arguments = this.getTypeArgumentList();
        JSTypeDeclaration[] jSTypeDeclarationArray = arguments == null ? JSTypeDeclaration.EMPTY_ARRAY : arguments.getTypeArguments();
        if (jSTypeDeclarationArray == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(2);
        }
        return jSTypeDeclarationArray;
    }

    @Nullable
    public JSReferenceExpression getReferenceExpression() {
        ASTNode node = this.getNode().findChildByType(JSElementTypes.REFERENCE_EXPRESSION);
        return node != null ? (JSReferenceExpression)node.getPsi() : null;
    }

    @NotNull
    public JSType getJSType() {
        String typeName = this.getQualifiedTypeName();
        if (typeName == null) {
            JSAnyType jSAnyType = JSAnyType.get((PsiElement)this, true);
            if (jSAnyType == null) {
                TypeScriptSingleTypeImpl.$$$reportNull$$$0(3);
            }
            return jSAnyType;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)this, true);
        if (!typeName.contains(".")) {
            TypeScriptTypeParameterProvider ownerCandidate = (TypeScriptTypeParameterProvider)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{TypeScriptTypeParameterProvider.class});
            while (ownerCandidate != null) {
                JSType genericParameter = TypeScriptSingleTypeImpl.getAsGenericParameterIfOwner(this, source, typeName, ownerCandidate);
                if (genericParameter != null) {
                    JSType jSType = genericParameter;
                    if (jSType == null) {
                        TypeScriptSingleTypeImpl.$$$reportNull$$$0(4);
                    }
                    return jSType;
                }
                ownerCandidate = (TypeScriptTypeParameterProvider)PsiTreeUtil.getContextOfType((PsiElement)ownerCandidate, (Class[])new Class[]{TypeScriptTypeParameterProvider.class});
            }
        }
        JSType jSType = TypeScriptSingleTypeImpl.getSingleOrGenericType(this, TypeScriptSingleTypeImpl.getSimpleType(source, typeName), source);
        if (jSType == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    @Nullable
    private static JSType getAsGenericParameterIfOwner(@NotNull TypeScriptSingleType type, @NotNull JSTypeSource source, @NotNull String typeName, @NotNull TypeScriptTypeParameterProvider ownerCandidate) {
        TypeScriptGenericOrMappedTypeParameter typeParameter;
        if (type == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(6);
        }
        if (source == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(7);
        }
        if (typeName == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(8);
        }
        if (ownerCandidate == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(9);
        }
        if ((typeParameter = ownerCandidate.getTypeParameter(typeName)) == null) {
            return null;
        }
        if (ownerCandidate instanceof TypeScriptMappedType) {
            return new TypeScriptMappedTypeGenericParameterImpl(typeParameter.getGenericId(), source);
        }
        if (ownerCandidate instanceof TypeScriptConditionalType) {
            return new TypeScriptConditionalTypeGenericParameterImpl(typeParameter.getGenericId(), source);
        }
        if (ownerCandidate instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)ownerCandidate).getTypeParameterList();
            boolean fromDeclaration = PsiTreeUtil.isContextAncestor((PsiElement)typeParameterList, (PsiElement)type, (boolean)true);
            TypeScriptType constraint = ((TypeScriptTypeParameter)typeParameter).getTypeConstraint();
            JSType jsConstraint = fromDeclaration || constraint == null ? null : constraint.getJSType();
            TypeScriptGenericParameterImpl genericParameter = new TypeScriptGenericParameterImpl(typeParameter.getGenericId(), source, jsConstraint);
            return TypeScriptSingleTypeImpl.getSingleOrGenericType(type, genericParameter, source);
        }
        return null;
    }

    @NotNull
    private static JSType getSingleOrGenericType(@NotNull TypeScriptSingleType type, @NotNull JSType baseType, @NotNull JSTypeSource source) {
        Object[] declarations;
        if (type == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(10);
        }
        if (baseType == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(11);
        }
        if (source == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(12);
        }
        if ((declarations = type.getTypeArguments()).length > 0) {
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, baseType, ContainerUtil.map((Object[])declarations, MAP_DECLARATION_TO_TYPE));
            if (jSGenericTypeImpl == null) {
                TypeScriptSingleTypeImpl.$$$reportNull$$$0(13);
            }
            return jSGenericTypeImpl;
        }
        JSType jSType = baseType;
        if (jSType == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    @NotNull
    private static JSType getSimpleType(@NotNull JSTypeSource source, @NotNull String typeName) {
        if (source == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(15);
        }
        if (typeName == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(16);
        }
        JSType jSType = JSNamedTypeFactory.createType(typeName, source, JSTypeContext.INSTANCE, false, false);
        if (jSType == null) {
            TypeScriptSingleTypeImpl.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptSingleTypeImpl";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerCandidate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptSingleTypeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleOrGenericType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAccurateName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAsGenericParameterIfOwner";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSingleOrGenericType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

