/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceSetElement
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    @NotNull
    protected final String myCanonicalText;
    @NotNull
    protected final TextRange myRangeInElement;
    protected final JSReferenceSet mySet;

    protected JSReferenceSetElement(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSReferenceSetElement.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSReferenceSetElement.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(2);
        }
        this.mySet = set;
        this.myCanonicalText = s;
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.mySet.element;
        if (psiElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            JSReferenceSetElement.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Nullable
    public final PsiElement resolve() {
        Object[] resolveResults = this.multiResolve(false);
        if (resolveResults.length == 1) {
            return resolveResults[0].getElement();
        }
        if (resolveResults.length == 0) {
            return null;
        }
        int validElements = 0;
        PsiElement lastValid = null;
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) continue;
            ++validElements;
            lastValid = resolveResult.getElement();
        }
        if (validElements > 1) {
            return null;
        }
        if (validElements == 1) {
            return lastValid;
        }
        ResolveResult element = (ResolveResult)ArrayUtil.getLastElement((Object[])resolveResults);
        return element != null ? element.getElement() : null;
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.mySet.element.getContainingFile();
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file2, this, (reference, __) -> reference.doResolve(), incompleteCode);
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @NotNull
    protected ResolveResult[] doResolve() {
        ResolveResult[] keyResults = JSReferenceSetElement.getLiteralKeyResults(this.mySet.element);
        if (keyResults != null) {
            if (keyResults == null) {
                JSReferenceSetElement.$$$reportNull$$$0(6);
            }
            return keyResults;
        }
        ResolveResult[] resolveResultArray = this.doResolveQualifiedName(this.getQualifiedName());
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @NotNull
    public ResolveResult[] doResolveQualifiedName(@NotNull JSQualifiedName qualifiedName) {
        ResolveResult[] localResults;
        if (qualifiedName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(8);
        }
        PsiElement referenceElement = this.mySet.element;
        PsiFile psiFile = this.getElement().getContainingFile();
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(qualifiedName.getName(), psiFile, referenceElement);
        JSQualifiedName qualifier = qualifiedName.getParent();
        if (qualifier != null) {
            processor.addTypeHierarchy(JSNamedTypeFactory.createNamespace(qualifier, JSContext.UNKNOWN, this.getElement(), true));
        }
        processor.allowPartialResults();
        String str = qualifiedName.getQualifiedName();
        if (qualifier == null) {
            SinkResolveProcessor<ResolveResultSink> localProcessor = new SinkResolveProcessor<ResolveResultSink>(str, new ResolveResultSink(referenceElement, str));
            this.processLocalVariants(localProcessor);
            processor.addLocalResults(localProcessor);
        }
        if ((localResults = processor.getResults()).length > 0) {
            if (localResults == null) {
                JSReferenceSetElement.$$$reportNull$$$0(9);
            }
            return localResults;
        }
        JSIndexBasedResolveUtil.processAllSymbols(processor);
        ResolveResult[] results = processor.getResults();
        if (results.length == 0 && "undefined".equals(str)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(referenceElement)};
            if (resolveResultArray == null) {
                JSReferenceSetElement.$$$reportNull$$$0(10);
            }
            return resolveResultArray;
        }
        if (results == null) {
            JSReferenceSetElement.$$$reportNull$$$0(11);
        }
        return results;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            JSReferenceSetElement.$$$reportNull$$$0(12);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSReferenceSetElement.$$$reportNull$$$0(13);
        }
        return JSReferenceSetElement.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String qName;
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(14);
        }
        if ((qName = JSPsiImplUtils.getQNameForMove(this.getElement(), element)) != null) {
            JSReferenceSetElement.handleContentChange(this.getElement(), new TextRange(this.mySet.myReferences[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset()), qName);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(15);
        }
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.myCanonicalText, element);
        }
        return false;
    }

    public boolean isPrimary() {
        return this.mySet.getReferences()[0] == this;
    }

    @Nullable
    public PsiReference getQualifier() {
        if (this.isPrimary()) {
            return null;
        }
        PsiReference qualifier = null;
        for (PsiReference reference : this.mySet.getReferences()) {
            if (reference == this) {
                return qualifier;
            }
            qualifier = reference;
        }
        return qualifier;
    }

    public boolean isSoft() {
        return this.mySet.isSoft();
    }

    public LocalQuickFix[] getQuickFixes() {
        return this.mySet.myLocalQuickFixProvider == null ? LocalQuickFix.EMPTY_ARRAY : this.mySet.myLocalQuickFixProvider.getQuickFixes();
    }

    @NotNull
    public JSQualifiedName getQualifiedName() {
        JSQualifiedNameImpl qName = null;
        for (PsiReference ref : this.mySet.myReferences) {
            qName = JSQualifiedNameImpl.create(ref.getCanonicalText(), qName);
            if (ref == this) break;
        }
        assert (qName != null) : this;
        JSQualifiedNameImpl jSQualifiedNameImpl = qName;
        if (jSQualifiedNameImpl == null) {
            JSReferenceSetElement.$$$reportNull$$$0(16);
        }
        return jSQualifiedNameImpl;
    }

    public void processLocalVariants(SinkResolveProcessor<?> processor) {
    }

    protected static PsiElement handleContentChange(PsiElement elt, TextRange range, String newElementName) {
        return ElementManipulators.getManipulator((PsiElement)elt).handleContentChange(elt, range, newElementName);
    }

    @NotNull
    public JSReferenceSet getSet() {
        JSReferenceSet jSReferenceSet = this.mySet;
        if (jSReferenceSet == null) {
            JSReferenceSetElement.$$$reportNull$$$0(17);
        }
        return jSReferenceSet;
    }

    @Nullable
    protected static ResolveResult[] getLiteralKeyResults(@NotNull PsiElement referenceElement) {
        ResolveResult[] keyRefType;
        if (referenceElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(18);
        }
        if ((keyRefType = JSReferenceSetElement.getResolveResultsFromTypeScriptKeyTypes(referenceElement)) != null) {
            return keyRefType;
        }
        return JSReferenceSetElement.getResolveResultsFromIndexerProperty(referenceElement);
    }

    @Nullable
    private static ResolveResult[] getResolveResultsFromTypeScriptKeyTypes(PsiElement referenceElement) {
        JSType key;
        if (!(referenceElement instanceof JSLiteralExpression) || !DialectDetector.isTypeScript(referenceElement)) {
            return null;
        }
        JSType expressionType = JSResolveUtil.getExpressionJSType((JSExpression)referenceElement);
        if (expressionType instanceof JSStringLiteralTypeImpl && (key = JSReferenceSetElement.getLiteralKeyType((JSLiteralExpression)referenceElement, expressionType)) instanceof JSLiteralKeyType) {
            return ((JSLiteralKeyType)key).resolveKey();
        }
        return null;
    }

    @Nullable
    private static JSType getLiteralKeyType(@NotNull JSLiteralExpression rawqualifier, @Nullable JSType type) {
        if (rawqualifier == null) {
            JSReferenceSetElement.$$$reportNull$$$0(19);
        }
        if (!(type instanceof JSStringLiteralTypeImpl)) {
            return null;
        }
        PsiElement parent = rawqualifier.getParent();
        JSType keyType = TypeScriptLiteralKeyUtil.modifyStringLiteralTypeForTaggedLiteralType((JSExpression)rawqualifier, (JSStringLiteralTypeImpl)type, parent);
        if (keyType != null) {
            return keyType;
        }
        return TypeScriptLiteralKeyUtil.modifyStringLiteralTypeByContextualType((JSExpression)rawqualifier, (JSStringLiteralTypeImpl)type);
    }

    @Nullable
    private static ResolveResult[] getResolveResultsFromIndexerProperty(PsiElement referenceElement) {
        if (!(referenceElement instanceof JSLiteralExpression)) {
            return null;
        }
        String propertyName = ((JSLiteralExpression)referenceElement).getValueAsPropertyName();
        if (propertyName == null) {
            return null;
        }
        JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)PsiTreeUtil.getContextOfType((PsiElement)referenceElement, (Class[])new Class[]{JSIndexedPropertyAccessExpression.class});
        if (indexer == null) {
            return null;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)indexer, propertyName);
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)indexer).createQualifiedItemProcessor(sink, (PsiElement)indexer);
        processor.setTypeContext(true);
        JSExpression qualifier = indexer.getQualifier();
        if (qualifier == null) {
            return null;
        }
        JSTypeEvaluator.evaluateTypes(qualifier, indexer.getContainingFile(), processor);
        ResolveResultSink resultSink = (ResolveResultSink)processor.getResultSink();
        if (processor.resolved.isSuitableForReferenceResolve() || resultSink.getCompleteResult() != null) {
            ResolveResult[] results = processor.getResultsAsResolveResults();
            JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results.length);
            return results;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveQualifiedName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doResolveQualifiedName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralKeyResults";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralKeyType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

