/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSGenericTypesEvaluatorBase
implements JSGenericTypesEvaluator {
    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExplicitThisParameterType(@NotNull Getter<? extends JSType> qualifierType, @Nullable PsiElement resolvedFunction) {
        if (qualifierType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(0);
        }
        if (!(resolvedFunction instanceof TypeScriptFunction)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(1);
            }
            return jSTypeSubstitutor;
        }
        JSType definedType = ((TypeScriptFunction)resolvedFunction).getExplicitThisType();
        if (JSTypeUtils.hasForeignGenericParameter(definedType)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues((JSType)qualifierType.get(), definedType, resolvedFunction);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(2);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(3);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected Function.Mono<JSType> getJSQualifierGenericsRemapper(@Nullable JSExpression methodExpression) {
        JSExpression qualifier;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            Function.Mono mono = type -> JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type, qualifier);
            if (mono == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(4);
            }
            return mono;
        }
        Function.Mono mono = Functions.id();
        if (mono == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(5);
        }
        return mono;
    }

    @NotNull
    protected static JSTypeSubstitutor getDefaultTypeSubstitutor(@NotNull PsiElement typeParametersOwner, @NotNull JSCallItem callItem) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(6);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(7);
        }
        if (JSTypeUtils.hasTypeArguments(callItem)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(8);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(typeParametersOwner);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(9);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForDefaultParameters(@NotNull PsiElement typeParametersOwner) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(10);
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(11);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSClass jsClass;
            if (typeParametersOwner instanceof JSFunction && ((JSFunction)typeParametersOwner).isConstructor() && (jsClass = JSUtils.getMemberContainingClass(typeParametersOwner)) != null && !jsClass.isInterface()) {
                JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters((PsiElement)jsClass);
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(12);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(13);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            JSTypeSubstitutor.JSTypeGenericId id = parameter.getGenericId();
            JSType type = JSGenericTypesEvaluatorBase.getTypeParameterDefaultType(parameter);
            substitutor.put(id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(14);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected static Set<JSTypeSubstitutor.JSTypeGenericId> getGenericNames(@Nullable PsiElement resolvedFunction) {
        if (resolvedFunction instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(resolvedFunction);
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Arrays.stream(parameters).map(p -> p.getGenericId()).collect(Collectors.toSet());
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(15);
            }
            return set;
        }
        Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
        if (set == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(16);
        }
        return set;
    }

    protected static void addGenericDependencyFromType(final @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> generics, final @NotNull MultiMap<Integer, JSTypeSubstitutor.JSTypeGenericId> results, final int ownName, @Nullable JSType type) {
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(17);
        }
        if (results == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(18);
        }
        if (type == null) {
            return;
        }
        type.accept(new JSRecursiveTypeVisitor(){

            public void visitJSType(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type instanceof JSGenericParameterImpl && generics.contains(((JSGenericParameterImpl)type).getGenericId())) {
                    results.putValue((Object)ownName, (Object)((JSGenericParameterImpl)type).getGenericId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase$1", "visitJSType"));
            }
        });
    }

    @NotNull
    protected static Integer[] reorderByDependencies(int argumentsLength, @NotNull List<? extends JSType> parameterTypes, @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> generics) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(19);
        }
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(20);
        }
        Integer[] result2 = new Integer[argumentsLength];
        MultiMap results = new MultiMap();
        for (int i = 0; i < argumentsLength; ++i) {
            result2[i] = i;
            if (i >= parameterTypes.size()) continue;
            JSGenericTypesEvaluatorBase.addGenericDependencyFromType(generics, (MultiMap<Integer, JSTypeSubstitutor.JSTypeGenericId>)results, i, parameterTypes.get(i));
        }
        Arrays.sort(result2, (r1, r2) -> {
            Collection all2;
            Collection all1 = results.get(r1);
            if (all1 == (all2 = results.get(r2))) {
                return 0;
            }
            return all1.stream().anyMatch(i -> all2.contains(i)) ? -1 : 1;
        });
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(21);
        }
        return result2;
    }

    @NotNull
    protected static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(22);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSUnknownType jSUnknownType = defaultType == null ? JSUnknownType.TS_INSTANCE : defaultType.getJSType();
        if (jSUnknownType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(23);
        }
        return jSUnknownType;
    }

    @Contract(value="null->false")
    protected static boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSUtilType) {
            return type instanceof JSArrayType || type instanceof JSFunctionType;
        }
        return true;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallItem callItem, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments, int paramToSkip) {
        JSType type;
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(24);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(25);
        }
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(26);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        if (paramToSkip == -1) {
            result2.putAll(JSGenericTypesEvaluatorBase.getDefaultTypeSubstitutor(resolvedFunction, callItem));
        }
        if (resolvedFunction instanceof JSFunctionItem) {
            boolean isContextualWithOverloads = paramToSkip != -1;
            List argumentTypes = callItem.getArgumentTypes(isContextualWithOverloads);
            int length = argumentTypes.size();
            List<JSType> parameterTypes = JSGenericTypesEvaluatorBase.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), length);
            Condition<JSType> condition = JSGenericTypesEvaluatorBase.getExcludeExplicitArgumentsCondition(explicitArguments);
            this.doInferParameters(resolvedFunction, callItem, reporter, paramToSkip, result2, isContextualWithOverloads, argumentTypes, parameterTypes, condition);
        } else if (resolvedFunction instanceof JSTypeInfoOwner && (type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(((JSTypeInfoOwner)resolvedFunction).getJSType())) instanceof JSFunctionType) {
            List argumentTypes = callItem.getArgumentTypes(paramToSkip != -1);
            List parameterTypes = ContainerUtil.map((Collection)((JSFunctionType)type).getParameters(), p -> p.getInferredType());
            Condition<JSType> condition = JSGenericTypesEvaluatorBase.getExcludeExplicitArgumentsCondition(explicitArguments);
            this.doInferParameters(resolvedFunction, callItem, reporter, paramToSkip, result2, paramToSkip != -1, argumentTypes, parameterTypes, condition);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(27);
        }
        return jSTypeSubstitutor;
    }

    private void doInferParameters(@NotNull PsiElement resolvedFunction, @NotNull JSCallItem callItem, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, int paramToSkip, @NotNull JSTypeSubstitutor result2, boolean isContextualWithOverloads, @NotNull List<JSType> argumentTypes, @NotNull List<JSType> parameterTypes, @NotNull Condition<JSType> condition) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(28);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(29);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(30);
        }
        if (argumentTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(31);
        }
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(32);
        }
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(33);
        }
        JSGenericMappings genericArguments = this.inferGenericArgumentsFromCall(argumentTypes, parameterTypes, paramToSkip, resolvedFunction, condition, isContextualWithOverloads, callItem);
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
        result2.putAll(this.getTypeSubstitutorForReturnType(resolvedFunction, callItem, (Condition<? super JSType>)Conditions.and(condition, type -> {
            if (type instanceof JSGenericParameterImpl) {
                return !mapping.containsKey((Object)((JSGenericParameterImpl)type).getGenericId());
            }
            return true;
        })));
        result2.putAll(JSGenericTypesEvaluatorBase.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
    }

    @NotNull
    public static Condition<JSType> getExcludeExplicitArgumentsCondition(@NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments) {
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(34);
        }
        Condition condition = type -> type instanceof JSGenericParameterImpl && !explicitArguments.contains(((JSGenericParameterImpl)type).getGenericId());
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(35);
        }
        return condition;
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorForReturnType(@NotNull PsiElement resolvedFunction, @NotNull JSCallItem callItem, @NotNull Condition<? super JSType> condition) {
        JSType returnType;
        JSFunction function;
        PsiElement typeElement;
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(36);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(37);
        }
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(38);
        }
        if (resolvedFunction instanceof JSFunction && callItem instanceof JSExpression && (typeElement = (function = (JSFunction)resolvedFunction).getReturnTypeElement()) != null && JSTypeUtils.hasTypes(returnType = function.getReturnType(), false, condition)) {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)callItem, JSExpectedTypeKind.CONTEXTUAL_FOR_INFERENCE);
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(expectedType, returnType, resolvedFunction);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(39);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(40);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getParameterTypesForInference(@NotNull JSParameterItem[] parameters, int argumentsLength) {
        if (parameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(41);
        }
        List parameterTypes = ContainerUtil.newSmartList();
        JSType restParameterType = null;
        for (JSParameterItem parameter : parameters) {
            JSType parameterType = parameter.getSimpleType();
            parameterTypes.add(parameterType);
            if (!parameter.isRest()) continue;
            restParameterType = parameterType;
        }
        if (restParameterType != null && argumentsLength > parameterTypes.size()) {
            for (int i = parameterTypes.size(); i < argumentsLength; ++i) {
                parameterTypes.add(restParameterType);
            }
        }
        List list2 = parameterTypes;
        if (list2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(42);
        }
        return list2;
    }

    private static JSTypeSubstitutor intersectGenericsForCall(@NotNull JSGenericMappings applyingContext, @NotNull PsiElement context, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(43);
        }
        if (context == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(44);
        }
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = applyingContext.getMapping();
        JSTypeSubstitutor result2 = JSGenericTypesEvaluatorBase.intersectGenerics(mapping, context, reporter);
        for (Map.Entry entry : mapping.entrySet()) {
            Collection types2;
            JSTypeSubstitutor.JSTypeGenericId key = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            if (!result2.containsId(key) || (types2 = (Collection)entry.getValue()) == null || !types2.stream().allMatch(t -> t instanceof JSLiteralType)) continue;
            result2.put(key, (JSType)(types2.size() == 1 ? (JSType)types2.iterator().next() : new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(context, true), new ArrayList(types2))));
        }
        JSTypeSubstitutor deepSubstitutor = JSGenericTypesEvaluatorBase.intersectGenerics(applyingContext.getDeepMapping(), context, null);
        for (JSTypeSubstitutor.JSTypeGenericId key : result2.keys()) {
            result2.put(key, JSTypeUtils.applyGenericArguments(result2.get(key), deepSubstitutor));
        }
        return result2;
    }

    @NotNull
    protected static JSTypeSubstitutor intersectGenerics(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> map, @Nullable PsiElement context, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (map == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(45);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        ProcessingContext processingContext = context == null ? null : JSTypeComparingContextService.getProcessingContextWithCache(context);
        for (Map.Entry entry : map.entrySet()) {
            Collection rawTypes = (Collection)entry.getValue();
            assert (rawTypes.size() > 0);
            JSTypeSubstitutor.JSTypeGenericId parameterName = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            JSGenericTypesEvaluatorBase.addTypesForParameter(rawTypes, parameterName, result2, processingContext, reporter);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(46);
        }
        return jSTypeSubstitutor;
    }

    private static void addTypesForParameter(@NotNull Collection<JSType> rawTypes, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSTypeSubstitutor result2, @Nullable ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (rawTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(47);
        }
        if (parameterId == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(48);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(49);
        }
        if (rawTypes.size() == 0) {
            return;
        }
        if (rawTypes.size() == 1) {
            result2.put(parameterId, (JSType)ContainerUtil.getFirstItem(rawTypes));
            return;
        }
        boolean hasImplicitly = JSGenericTypesEvaluatorBase.checkImplicitFlags(rawTypes);
        List typesWithoutGenerics = ContainerUtil.filter(rawTypes, el -> !(el instanceof JSGenericParameterImpl) && el != null && !JSCompositeTypeBaseImpl.isNullOrUndefinedType(el));
        List typesToIntersect = typesWithoutGenerics.isEmpty() ? rawTypes : typesWithoutGenerics;
        JSType type = JSGenericTypesEvaluatorBase.intersectTypes(typesToIntersect, processingContext);
        if (type != null) {
            result2.put(parameterId, type);
            return;
        }
        if (hasImplicitly) {
            return;
        }
        if (typesWithoutGenerics.size() > 0) {
            result2.put(parameterId, (JSType)typesWithoutGenerics.get(0));
            if (reporter != null && typesWithoutGenerics.size() > 1) {
                reporter.error("typescript.validation.cannot.find.best.common.type");
            }
        }
    }

    private static boolean checkImplicitFlags(@NotNull Collection<? extends JSType> types2) {
        if (types2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(50);
        }
        boolean hasImplicitly = false;
        for (JSType jSType : types2) {
            JSType valuableType = JSTypeUtils.getValuableType(jSType);
            if (valuableType != null && valuableType.isSourceStrict()) continue;
            hasImplicitly = true;
            break;
        }
        return hasImplicitly;
    }

    @Nullable
    private static JSType intersectTypes(@NotNull Collection<? extends JSType> types2, @Nullable ProcessingContext context) {
        if (types2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(51);
        }
        ArrayList<? extends JSType> sortedTypes = new ArrayList<JSType>(types2);
        ContainerUtil.sort(sortedTypes, Comparator.comparing(el -> el instanceof JSLiteralType && ((JSLiteralType)el).allowWidening() ? 1 : 0));
        JSType firstNamed = null;
        for (JSType jSType : sortedTypes) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && jSType instanceof JSNamedType) {
                firstNamed = jSType;
            }
            if (jSType == null || (source = jSType.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(jSType)).getSource().isStrict()) continue;
            boolean result2 = true;
            for (JSType jSType2 : types2) {
                if (jSType2 == jSType || jSType.isDirectlyAssignableType(jSType2, context)) continue;
                result2 = false;
                break;
            }
            if (!result2) continue;
            return jSType;
        }
        return null;
    }

    @NotNull
    protected final JSGenericMappings inferGenericArgumentsFromCall(@NotNull List<? extends JSType> argumentTypes, @NotNull List<? extends JSType> parameterTypes, int callArgumentToSkip, @NotNull PsiElement resolvedFunction, @NotNull Condition<? super JSType> acceptableGenericArguments, boolean isContextualWithOverloads, @Nullable JSCallItem callItem) {
        if (argumentTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(52);
        }
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(53);
        }
        if (resolvedFunction == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(54);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(55);
        }
        List argumentProviders = ContainerUtil.map(argumentTypes, type -> () -> {
            JSType result2 = isContextualWithOverloads ? TypeScriptSignatureChooser.mapContextualTypeForOverload(type, resolvedFunction, callItem) : type;
            return result2 instanceof JSPsiBasedTypeOfType ? JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)result2) : result2;
        });
        JSGenericMappings inferred = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, callArgumentToSkip, resolvedFunction, acceptableGenericArguments);
        JSGenericMappings jSGenericMappings = isContextualWithOverloads ? inferred : inferred.copyWithMapping(JSGenericTypesEvaluatorBase.widenInferredTypes(inferred.getMapping(), parameterTypes.subList(0, Math.min(parameterTypes.size(), argumentTypes.size())), resolvedFunction, callItem));
        if (jSGenericMappings == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(56);
        }
        return jSGenericMappings;
    }

    @NotNull
    public static MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> widenInferredTypes(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> inferred, @NotNull List<? extends JSType> actualParameters, @Nullable PsiElement resolvedFunction, @Nullable JSCallItem callItem) {
        if (inferred == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(57);
        }
        if (actualParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(58);
        }
        JSType returnType = resolvedFunction instanceof JSFunctionItem ? ((JSFunctionItem)resolvedFunction).getReturnType() : null;
        Set returnIds = ContainerUtil.map2Set(JSGenericTypesEvaluatorBase.getTopLevelGenerics(returnType), JSGenericParameterImpl::getGenericId);
        Set toWiden = StreamEx.of(actualParameters).map(JSGenericTypesEvaluatorBase::getTopLevelGenerics).flatMap(Collection::stream).map(generic -> {
            JSType constraintType;
            JSTypeSubstitutor.JSTypeGenericId id = generic.getGenericId();
            if (!returnIds.contains(id) && inferred.containsKey((Object)id) && !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType = generic.getConstraintType())) {
                return id;
            }
            return null;
        }).nonNull().toSet();
        if (toWiden.isEmpty()) {
            MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> multiMap = inferred;
            if (multiMap == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(59);
            }
            return multiMap;
        }
        Set<JSTypeSubstitutor.JSTypeGenericId> excludedFromWideningByContextType = null;
        for (JSTypeSubstitutor.JSTypeGenericId id : toWiden) {
            Collection types2 = inferred.get((Object)id);
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types2.size());
            boolean hasWiden = false;
            for (JSType type : types2) {
                JSType widen;
                if (type != (widen = JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(type)))) {
                    if (excludedFromWideningByContextType == null) {
                        excludedFromWideningByContextType = JSGenericTypesEvaluatorBase.calcExcludedFromWideningByContextType(callItem, returnType);
                    }
                    if (!excludedFromWideningByContextType.contains(id)) {
                        hasWiden = true;
                        type = widen;
                    }
                }
                newTypes.add(type);
            }
            if (!hasWiden) continue;
            inferred.put((Object)id, newTypes);
        }
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> multiMap = inferred;
        if (multiMap == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(60);
        }
        return multiMap;
    }

    @NotNull
    private static Set<JSTypeSubstitutor.JSTypeGenericId> calcExcludedFromWideningByContextType(@Nullable JSCallItem callItem, @Nullable JSType returnType) {
        if (returnType == null) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(61);
            }
            return set;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)callItem, JSCallExpression.class);
        if (callExpression == null) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(62);
            }
            return set;
        }
        JSType jSType = returnType = returnType instanceof JSArrayType ? ((JSArrayType)returnType).asGenericType() : returnType;
        if (!(returnType instanceof JSGenericTypeImpl)) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(63);
            }
            return set;
        }
        JSGenericTypeImpl genericReturnType = (JSGenericTypeImpl)returnType;
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)callExpression, JSExpectedTypeKind.WIDENING);
        if (expectedType instanceof JSArrayType) {
            expectedType = ((JSArrayType)expectedType).asGenericType();
        }
        if (!(expectedType instanceof JSGenericTypeImpl)) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(64);
            }
            return set;
        }
        if (!((JSGenericTypeImpl)expectedType).getType().isEquivalentTo(genericReturnType.getType(), null)) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(65);
            }
            return set;
        }
        List<JSType> arguments = genericReturnType.getArguments();
        List<JSType> arguments1 = ((JSGenericTypeImpl)expectedType).getArguments();
        HashSet<JSTypeSubstitutor.JSTypeGenericId> result2 = new HashSet<JSTypeSubstitutor.JSTypeGenericId>();
        for (int i = 0; i < Math.min(arguments.size(), arguments1.size()); ++i) {
            JSType argument = arguments.get(i);
            JSType argument1 = arguments1.get(i);
            if (!(argument instanceof JSGenericParameterImpl) || !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(argument1)) continue;
            result2.add(((JSGenericParameterImpl)argument).getGenericId());
        }
        HashSet<JSTypeSubstitutor.JSTypeGenericId> hashSet = result2;
        if (hashSet == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(66);
        }
        return hashSet;
    }

    @NotNull
    public final JSGenericMappings inferGenericArgumentsFromCall(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends Supplier<JSType>> arguments, int callArgumentToSkip, @Nullable PsiElement resolvedFunction, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(67);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(68);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(69);
        }
        Set<JSTypeSubstitutor.JSTypeGenericId> generics = JSGenericTypesEvaluatorBase.getGenericNames(resolvedFunction);
        Integer[] newIndices = JSGenericTypesEvaluatorBase.reorderByDependencies(arguments.size(), parameterTypes, generics);
        JSGenericMappings applyingContext = new JSGenericMappings();
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(resolvedFunction);
        for (int i = 0; i < arguments.size(); ++i) {
            int j = newIndices[i];
            if (j == callArgumentToSkip) continue;
            if (j >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(j);
            if (paramType instanceof JSCodeBasedType) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasTypes(paramType, false, acceptableGenericArguments)) continue;
            JSType exprType = JSGenericTypesEvaluatorBase.getArgType(arguments, j);
            boolean matchedTuples = false;
            if (paramType instanceof JSRestTypeImpl) {
                JSType tempType = ((JSRestTypeImpl)paramType).getIterableType();
                if (tempType instanceof JSGenericParameterImpl) {
                    JSType constraintType = ((JSGenericParameterImpl)tempType).getConstraintType();
                    if (constraintType != null && JSTypeUtils.isIterableCollectionType(constraintType)) {
                        List<JSType> types2 = JSGenericTypesEvaluatorBase.getArgTypesForRestTuple(arguments, newIndices, i);
                        JSType tupleType = JSTupleTypeImpl.createTupleType(paramType.getSource(), types2, true, -1, false);
                        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, tupleType, tempType, acceptableGenericArguments);
                        matchedTuples = true;
                    }
                } else if (tempType instanceof JSTupleTypeImpl) {
                    List<JSType> types3 = JSGenericTypesEvaluatorBase.getArgTypesForRestTuple(arguments, newIndices, i);
                    for (int k = 0; k < types3.size(); ++k) {
                        JSType type = ((JSTupleTypeImpl)tempType).getTypeByIndex(k);
                        if (type == null) continue;
                        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, types3.get(k), type, acceptableGenericArguments);
                    }
                    matchedTuples = true;
                }
            }
            if (!matchedTuples) {
                JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, exprType, paramType, acceptableGenericArguments);
            }
            if (matchedTuples) break;
        }
        JSGenericMappings jSGenericMappings = applyingContext;
        if (jSGenericMappings == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(70);
        }
        return jSGenericMappings;
    }

    @NotNull
    private static List<JSType> getArgTypesForRestTuple(@NotNull List<? extends Supplier<JSType>> arguments, @NotNull Integer[] newIndices, int i) {
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(71);
        }
        if (newIndices == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(72);
        }
        ArrayList<JSType> types2 = new ArrayList<JSType>();
        for (int k = i; k < arguments.size(); ++k) {
            types2.add(JSTypeUtils.widenLiteralTypes(JSGenericTypesEvaluatorBase.getArgType(arguments, newIndices[k])));
        }
        ArrayList<JSType> arrayList = types2;
        if (arrayList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    @Nullable
    private static JSType getArgType(@NotNull List<? extends Supplier<JSType>> arguments, int index) {
        PsiElement sourceElement;
        JSType exprType;
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(74);
        }
        if ((exprType = arguments.get(index).get()) != null && exprType.isTypeScript() && (sourceElement = exprType.getSource().getSourceElement()) != null) {
            return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(sourceElement, exprType);
        }
        return exprType;
    }

    @NotNull
    public static JSTypeSubstitutor findAndIntersectGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> generics = JSGenericTypesEvaluatorBase.findGenericsTypeValues(exprType, paramType, context);
        if (!generics.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.intersectGenerics(generics, context, null);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(75);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(76);
        }
        return jSTypeSubstitutor;
    }

    protected static MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        if (exprType == null || paramType == null) {
            return MultiMap.empty();
        }
        JSGenericMappings applyingContext = new JSGenericMappings();
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, JSTypeComparingContextService.getProcessingContextWithCache(context), exprType, paramType);
        return applyingContext.getMapping();
    }

    @Deprecated
    public static void matchGenericTypes(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (mapping == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(77);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(78);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(79);
        }
        JSGenericTypesEvaluatorBase.matchGenericTypes(new JSGenericMappings(mapping), processingContext, exprType, paramType, (Condition<? super JSType>)Conditions.alwaysTrue());
        JSGenericTypesEvaluatorBase.widenInferredTypes(mapping, Collections.singletonList(paramType), null, null);
    }

    public static void matchGenericTypes(@NotNull JSGenericMappings applyingContext, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(80);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(81);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(82);
        }
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, exprType, paramType, (Condition<? super JSType>)Conditions.alwaysTrue());
    }

    public static void matchGenericTypes(@NotNull JSGenericMappings applyingContext, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        JSType toCheck;
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(83);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(84);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(85);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(86);
        }
        if (paramType == (toCheck = paramType.transformTypeHierarchy(type -> {
            if (!(type instanceof JSGenericParameterImpl)) {
                return type;
            }
            JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)type;
            if (!acceptableGenericArguments.value((Object)genericParameter)) {
                return genericParameter;
            }
            return genericParameter.copyWithSourceAndApplying(genericParameter.getSource(), true);
        }))) {
            return;
        }
        processingContext.put(ourGenericArgumentsMapKey, (Object)applyingContext);
        toCheck.isDirectlyAssignableType(exprType instanceof JSSpreadType ? ((JSSpreadType)exprType).getComponentType() : exprType, processingContext);
        processingContext.put(ourGenericArgumentsMapKey, null);
    }

    @NotNull
    private static List<JSGenericParameterImpl> getTopLevelGenerics(@Nullable JSType paramType) {
        ArrayList<JSGenericParameterImpl> topLevelGenerics = new ArrayList<JSGenericParameterImpl>();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)t);
            }
            return true;
        }), paramType);
        ArrayList<JSGenericParameterImpl> arrayList = topLevelGenerics;
        if (arrayList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    @NotNull
    private static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(88);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(89);
        }
        JSType jSType = JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type, () -> JSResolveUtil.getElementJSType((PsiElement)qualifier));
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(90);
        }
        return jSType;
    }

    @NotNull
    protected static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type, @NotNull Supplier<JSType> qualifierTypeSupplier) {
        JSType qualifierType;
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(91);
        }
        if (qualifierTypeSupplier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(92);
        }
        if (type.getSource().isTypeScript()) {
            JSType jSType = type;
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(93);
            }
            return jSType;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSDocComment) {
            namespaceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)namespaceElement);
        }
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file2 = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file2)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                type = JSGenericTypesEvaluatorBase.convertNamedTypesToGenericParameters(type, javaScriptGenericParameters);
            }
        }
        if (JSTypeUtils.hasForeignGenericParameter(type) && javaScriptGenericParameters != null && (qualifierType = qualifierTypeSupplier.get()) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            JSType jSType = JSTypeUtils.applyGenericArguments(type, typeArguments);
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(94);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(95);
        }
        return jSType;
    }

    @NotNull
    private static JSType convertNamedTypesToGenericParameters(@NotNull JSType type, @NotNull List<String> javaScriptGenericParameters) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(96);
        }
        if (javaScriptGenericParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(97);
        }
        List<String> genericParameters = javaScriptGenericParameters;
        JSType jSType = type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
            String text;
            if (type1 instanceof JSTypeImpl && genericParameters.contains(text = type1.getTypeText())) {
                return new JSGenericParameterImpl(text, type1.getSource());
            }
            return type1;
        }));
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(98);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(99);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(100);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(101);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(102);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(103);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(104);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(105);
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluatorBase.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(106);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(107);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(108);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(109);
        }
        if (typeArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(110);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(111);
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, typeArguments);
            typeArguments = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(112);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeArgumentsMap(@NotNull JSType genericType, @NotNull GlobalSearchScope scope) {
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(113);
        }
        if (scope == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(114);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(115);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(116);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 115: 
            case 116: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 115: 
            case 116: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 7: 
            case 25: 
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 19: 
            case 32: 
            case 53: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: 
            case 28: 
            case 36: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitArguments";
                break;
            }
            case 30: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 43: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyingContext";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypes";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 55: 
            case 69: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableGenericArguments";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferred";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 68: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIndices";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 78: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 79: 
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 88: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierTypeSupplier";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaScriptGenericParameters";
                break;
            }
            case 99: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 101: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSQualifierGenericsRemapper";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "reorderByDependencies";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesForInference";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 56: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "widenInferredTypes";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "calcExcludedFromWideningByContextType";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgTypesForRestTuple";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndIntersectGenericsTypeValues";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelGenerics";
                break;
            }
            case 90: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 115: 
            case 116: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDependencyFromType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "reorderByDependencies";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doInferParameters";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesForInference";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenericsForCall";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenerics";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForParameter";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitFlags";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericArgumentsFromCall";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "widenInferredTypes";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getArgTypesForRestTuple";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getArgType";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 27: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 56: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 111: 
            case 112: 
            case 115: 
            case 116: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

