/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordMemberSourceFactory {
    @NotNull
    public static JSRecordType.MemberSource createEmptySource() {
        EmptyMemberSource emptyMemberSource = EmptyMemberSource.INSTANCE;
        if (emptyMemberSource == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(0);
        }
        return emptyMemberSource;
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@Nullable PsiElement element) {
        MemberSourceBase memberSourceBase = element == null ? EmptyMemberSource.INSTANCE : new SingleMemberSource(element);
        if (memberSourceBase == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(1);
        }
        return memberSourceBase;
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@Nullable PsiElement element, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
        if (memberSourceKind == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(2);
        }
        MemberSourceBase memberSourceBase = element == null ? EmptyMemberSource.INSTANCE : new SingleMemberSource(element, memberSourceKind);
        if (memberSourceBase == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(3);
        }
        return memberSourceBase;
    }

    @NotNull
    public static JSRecordType.MemberSource createSource(@NotNull List<PsiElement> elements, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
        int size;
        if (elements == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(4);
        }
        if (memberSourceKind == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(5);
        }
        if ((size = (elements = elements.stream().distinct().filter(e -> e != null).collect(Collectors.toList())).size()) == 0) {
            EmptyMemberSource emptyMemberSource = EmptyMemberSource.INSTANCE;
            if (emptyMemberSource == null) {
                JSRecordMemberSourceFactory.$$$reportNull$$$0(6);
            }
            return emptyMemberSource;
        }
        if (size == 1) {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource((PsiElement)elements.get(0), memberSourceKind);
            if (memberSource == null) {
                JSRecordMemberSourceFactory.$$$reportNull$$$0(7);
            }
            return memberSource;
        }
        MultipleMemberSource multipleMemberSource = new MultipleMemberSource(elements, memberSourceKind);
        if (multipleMemberSource == null) {
            JSRecordMemberSourceFactory.$$$reportNull$$$0(8);
        }
        return multipleMemberSource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberSourceKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptySource";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSource";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EmptyMemberSource
    extends MemberSourceBase {
        public static final EmptyMemberSource INSTANCE = new EmptyMemberSource();

        public EmptyMemberSource() {
            super(JSRecordType.MemberSourceKind.Empty);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isUnion() {
            return false;
        }

        @Override
        public boolean isMerged() {
            return false;
        }

        @Override
        public boolean isReadonly() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        public boolean hasSingleDocumentation() {
            return true;
        }

        @Nullable
        public PsiElement getSingleElement() {
            return null;
        }

        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                EmptyMemberSource.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public JSRecordType.MemberSource copyWithKind(JSRecordType.MemberSourceKind kind) {
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$EmptyMemberSource", "getAllSourceElements"));
        }
    }

    private static abstract class MemberSourceBase
    implements JSRecordType.MemberSource {
        private final JSRecordType.MemberSourceKind myMemberSourceKind;

        MemberSourceBase(JSRecordType.MemberSourceKind memberSourceKind) {
            this.myMemberSourceKind = memberSourceKind;
        }

        public JSRecordType.MemberSourceKind getSourceKind() {
            return this.myMemberSourceKind;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isUnion() {
            return this.myMemberSourceKind.isUnion();
        }

        public boolean isMerged() {
            return this.myMemberSourceKind.isTypeScriptMergedTypeKind();
        }

        public boolean isReadonly() {
            JSRecordType.MemberSourceKind kind = this.myMemberSourceKind;
            if (kind.isForceReadonly()) {
                return true;
            }
            if (kind.isForceNonReadonly()) {
                return false;
            }
            return kind == JSRecordType.MemberSourceKind.Union || kind == JSRecordType.MemberSourceKind.Intersection ? this.getAllSourceElements().stream().anyMatch(MemberSourceBase::isConstPredicate) : this.getAllSourceElements().stream().allMatch(MemberSourceBase::isConstPredicate);
        }

        private static boolean isConstPredicate(PsiElement e) {
            return e instanceof JSConstStatusOwner && ((JSConstStatusOwner)e).isConst();
        }

        public boolean isForceReadonly() {
            return this.myMemberSourceKind.isForceReadonly();
        }

        public boolean isForceOptional() {
            return this.myMemberSourceKind.isForceOptional();
        }

        public boolean isOptional() {
            JSRecordType.MemberSourceKind kind = this.myMemberSourceKind;
            if (kind.isForceOptional()) {
                return true;
            }
            if (kind.isForceNonOptional()) {
                return false;
            }
            return this.getAllSourceElements().stream().allMatch(MemberSourceBase::isOptionalPredicate);
        }

        private static boolean isOptionalPredicate(PsiElement e) {
            return e instanceof JSOptionalOwner && ((JSOptionalOwner)e).isOptional();
        }

        public boolean isIdentity() {
            return this.myMemberSourceKind == JSRecordType.MemberSourceKind.Identity;
        }
    }

    public static final class SingleMemberSource
    extends MemberSourceBase {
        @NotNull
        private final PsiElement mySourceElement;
        @NotNull
        private final List<PsiElement> myElementSingletonList;

        public SingleMemberSource(@NotNull PsiElement sourceElement) {
            if (sourceElement == null) {
                SingleMemberSource.$$$reportNull$$$0(0);
            }
            super(JSRecordType.MemberSourceKind.Identity);
            this.mySourceElement = sourceElement;
            this.myElementSingletonList = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
        }

        public SingleMemberSource(@NotNull PsiElement sourceElement, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
            if (sourceElement == null) {
                SingleMemberSource.$$$reportNull$$$0(1);
            }
            if (memberSourceKind == null) {
                SingleMemberSource.$$$reportNull$$$0(2);
            }
            super(memberSourceKind);
            this.mySourceElement = sourceElement;
            this.myElementSingletonList = ContainerUtil.createMaybeSingletonList((Object)sourceElement);
        }

        public boolean hasSingleDocumentation() {
            return this.getSourceKind().hasSingleDocumentation();
        }

        public PsiElement getSingleElement() {
            return this.mySourceElement;
        }

        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List<PsiElement> list2 = this.myElementSingletonList;
            if (list2 == null) {
                SingleMemberSource.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public JSRecordType.MemberSource copyWithKind(JSRecordType.MemberSourceKind kind) {
            return new SingleMemberSource(this.mySourceElement, kind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberSourceKind";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$SingleMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$SingleMemberSource";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class MultipleMemberSource
    extends MemberSourceBase {
        @NotNull
        private final List<PsiElement> mySourceElements;

        public MultipleMemberSource(@NotNull List<PsiElement> sourceElements, @NotNull JSRecordType.MemberSourceKind memberSourceKind) {
            if (sourceElements == null) {
                MultipleMemberSource.$$$reportNull$$$0(0);
            }
            if (memberSourceKind == null) {
                MultipleMemberSource.$$$reportNull$$$0(1);
            }
            super(memberSourceKind);
            this.mySourceElements = sourceElements;
        }

        @Nullable
        public PsiElement getSingleElement() {
            return this.mySourceElements.size() == 0 ? null : this.mySourceElements.get(0);
        }

        @NotNull
        public List<PsiElement> getAllSourceElements() {
            List<PsiElement> list2 = this.mySourceElements;
            if (list2 == null) {
                MultipleMemberSource.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public JSRecordType.MemberSource copyWithKind(JSRecordType.MemberSourceKind kind) {
            return new MultipleMemberSource(this.mySourceElements, kind);
        }

        public boolean hasSingleDocumentation() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberSourceKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MultipleMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordMemberSourceFactory$MultipleMemberSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSourceElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

