/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.util.ReentrantRecursionGuard;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSResolvedTypeIdCache {
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, JSRecordType> myCachedRecordTypes = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final ReentrantRecursionGuard<Object> ourRecordTypesGuard = new ReentrantRecursionGuard("js.record.type.guard");
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, Map<Key<?>, Object>> myCachedValues = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final ReentrantRecursionGuard<Pair<JSResolvedTypeId, Key<?>>> ourValuesGuard = new ReentrantRecursionGuard("js.values.guard");

    @Nullable
    public <T> T getLocalCachedValue(@NotNull JSResolvedTypeId id, @NotNull Key<T> key, @NotNull Supplier<? extends T> supplier) {
        Map oldMap;
        Map map;
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(0);
        }
        if (key == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(1);
        }
        if (supplier == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(2);
        }
        if ((map = (Map)this.myCachedValues.get(id)) == null && (oldMap = this.myCachedValues.putIfAbsent(id, map = ContainerUtil.createConcurrentWeakKeySoftValueMap())) != null) {
            map = oldMap;
        }
        Object el = map.get(key);
        JSType owner = id.getOwnerType();
        if (el != null) {
            return (T)(el == JSTypeBaseImpl.getSelfNoTransformationType() ? owner : el);
        }
        Map finalMap = map;
        Consumer<Object> cacheNewValue = result2 -> {
            if (result2 != null) {
                if (result2 == owner) {
                    result2 = JSTypeBaseImpl.getSelfNoTransformationType();
                }
                finalMap.put(key, result2);
            }
        };
        Object value = ourValuesGuard.computeAndCache(Pair.create((Object)id, key), cacheNewValue, it -> supplier.get());
        return (T)(value == JSTypeBaseImpl.getSelfNoTransformationType() ? owner : value);
    }

    @NotNull
    public JSRecordType buildRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        JSResolvedTypeId id;
        JSRecordType recordType;
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(4);
        }
        if ((recordType = (JSRecordType)this.myCachedRecordTypes.get(id = type.getResolvedTypeId())) != null) {
            JSRecordType jSRecordType = JSResolvedTypeIdCache.copyWithStrict(type, recordType);
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(5);
            }
            return jSRecordType;
        }
        Consumer<JSRecordType> cacheNewValue = it -> {
            if (it != null) {
                this.myCachedRecordTypes.put(id, (JSRecordType)it);
            }
        };
        Object idForPreventingRecursion = JSResolvedTypeIdCache.getIdForPreventingRecursion(type);
        JSRecordType candidate = ourRecordTypesGuard.computeAndCache(idForPreventingRecursion, cacheNewValue, it -> JSResolvedTypeIdCache.buildRecordTypeNoCache(type, sourceElement));
        if (candidate == null) {
            Object object = type.isJavaScript() ? JSTypeCastUtil.NO_RECORD_TYPE : new JSRecordTypeImpl(type.getSource(), ContainerUtil.emptyList());
            if (object == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(6);
            }
            return object;
        }
        JSRecordType jSRecordType = JSResolvedTypeIdCache.copyWithStrict(type, candidate);
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(7);
        }
        return jSRecordType;
    }

    @NotNull
    private static Object getIdForPreventingRecursion(@NotNull JSType type) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(8);
        }
        if (type instanceof JSGenericTypeImpl) {
            Pair pair = Pair.create((Object)((JSGenericTypeImpl)type).getType().getResolvedTypeId(), type.getClass());
            if (pair == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(9);
            }
            return pair;
        }
        JSResolvedTypeId jSResolvedTypeId = type.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(10);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    private static JSRecordType copyWithStrict(@NotNull JSType original, @NotNull JSRecordType recordType) {
        if (original == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(11);
        }
        if (recordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(12);
        }
        if (recordType == JSTypeCastUtil.NO_RECORD_TYPE) {
            JSRecordType jSRecordType = recordType;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(13);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = (JSRecordType)recordType.copyWithStrict(original.isSourceStrict());
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(14);
        }
        return jSRecordType;
    }

    @NotNull
    private static JSRecordType buildRecordTypeNoCache(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(15);
        }
        if (element == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(16);
        }
        JSType substitute = JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)type);
        ProgressManager.checkCanceled();
        if (substitute != type) {
            JSRecordType jSRecordType = substitute.asRecordType();
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(17);
            }
            return jSRecordType;
        }
        Collection<? extends PsiElement> resolvedElements = JSResolvedTypeIdCache.resolveElementsForRecordType(type, element);
        if (type.isJavaScript() && (type instanceof JSObjectType || resolvedElements.isEmpty() || (type instanceof JSTypeImpl || type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSTypeImpl) && resolvedElements.stream().allMatch(el -> el instanceof JSFunction || el instanceof JSVariable || el instanceof JSDefinitionExpression || el instanceof JSImplicitElement))) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(18);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(resolvedElements, type);
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(19);
        }
        return jSRecordType;
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(20);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(21);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(22);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 3: 
            case 8: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForPreventingRecursion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordTypeNoCache";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsForRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedValue";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdForPreventingRecursion";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithStrict";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeNoCache";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

