/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeComparingCache {
    public static final Key<Boolean> SUBTYPING_CONTEXT = Key.create((String)"js.type.subtyping");
    public static final Logger LOG = Logger.getInstance(JSTypeComparingCache.class);
    static final Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, CompositeAssignableResult>>> CONTEXT_MAP_KEY = Key.create((String)"js.context.comparing.map");
    private final boolean myLogTrace;
    private final ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, CompositeAssignableResult>> myDefaultResult = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private final AtomicLong myCacheMissCount = new AtomicLong();
    private final AtomicLong myCacheUseCount = new AtomicLong();
    private final AtomicLong myNoCacheCount = new AtomicLong();
    private static final byte UNSET = 0;
    private static final byte ASSIGNABLE = 1;
    private static final byte NOT_ASSIGNABLE = 2;

    public JSTypeComparingCache() {
        this.myLogTrace = LOG.isTraceEnabled();
    }

    private static boolean areTypesAcceptable(@NotNull JSType lType, @NotNull JSType rType) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(0);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(1);
        }
        return !lType.isEcma() && !rType.isEcma();
    }

    @NotNull
    public JSTypeCastUtil.AssignableResult areAssignableTypes(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(2);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(3);
        }
        if (processingContext == null) {
            JSTypeComparingCache.$$$reportNull$$$0(4);
        }
        if (!JSTypeComparingCache.areTypesAcceptable(lType, rType)) {
            this.logNoCache(lType, rType);
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NO_CACHE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(5);
            }
            return assignableResult;
        }
        JSResolvedTypeId lTypeId = lType.getResolvedTypeId();
        JSResolvedTypeId rTypeId = rType.getResolvedTypeId();
        JSTypeCastUtil.AssignableResult assignableResult = this.areAssignableIds(lTypeId, rTypeId, JSTypeComparingCache.useProcessingContextAsCache(lType, rType), processingContext);
        if (assignableResult == null) {
            JSTypeComparingCache.$$$reportNull$$$0(6);
        }
        return assignableResult;
    }

    public void putAssignableTypes(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(7);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSTypeComparingCache.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(10);
        }
        if (!JSTypeComparingCache.areTypesAcceptable(lType, rType)) {
            return;
        }
        JSResolvedTypeId lTypeId = lType.getResolvedTypeId();
        JSResolvedTypeId rTypeId = rType.getResolvedTypeId();
        this.putAssignableIds(lTypeId, rTypeId, processingContext, JSTypeComparingCache.useProcessingContextAsCache(lType, rType), result2);
    }

    private static boolean useProcessingContextAsCache(@NotNull JSType lType, @NotNull JSType rType) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(11);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(12);
        }
        return !JSTypeComparingCache.isCacheableType(lType, true) || !JSTypeComparingCache.isCacheableType(rType, true);
    }

    @NotNull
    private JSTypeCastUtil.AssignableResult areAssignableIds(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, boolean contextOnly, @NotNull ProcessingContext context) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(13);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(14);
        }
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Map<JSResolvedTypeId, Map<JSResolvedTypeId, CompositeAssignableResult>> map = this.getCachedMap(context, contextOnly);
        Map<JSResolvedTypeId, CompositeAssignableResult> compared = map.get(lType);
        if (compared == null) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(16);
            }
            return assignableResult;
        }
        CompositeAssignableResult cached = compared.get(rType);
        if (cached == null) {
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                JSTypeComparingCache.$$$reportNull$$$0(17);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult result2 = cached.asAssignable(JSGenericParameterImpl.isCallEnvironment(context));
        this.logUsedCache(lType, rType, result2);
        JSTypeCastUtil.AssignableResult assignableResult = result2;
        if (assignableResult == null) {
            JSTypeComparingCache.$$$reportNull$$$0(18);
        }
        return assignableResult;
    }

    @NotNull
    private Map<JSResolvedTypeId, Map<JSResolvedTypeId, CompositeAssignableResult>> getCachedMap(@NotNull ProcessingContext context, boolean contextOnly) {
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(19);
        }
        if (contextOnly) {
            Map map = (Map)context.get(CONTEXT_MAP_KEY);
            if (map == null) {
                map = ContainerUtil.createWeakKeySoftValueMap();
                context.put(CONTEXT_MAP_KEY, (Object)map);
            }
            Map map2 = map;
            if (map2 == null) {
                JSTypeComparingCache.$$$reportNull$$$0(20);
            }
            return map2;
        }
        ConcurrentMap<JSResolvedTypeId, Map<JSResolvedTypeId, CompositeAssignableResult>> concurrentMap = this.myDefaultResult;
        if (concurrentMap == null) {
            JSTypeComparingCache.$$$reportNull$$$0(21);
        }
        return concurrentMap;
    }

    private void putAssignableIds(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull ProcessingContext context, boolean contextOnly, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(22);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(23);
        }
        if (context == null) {
            JSTypeComparingCache.$$$reportNull$$$0(24);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Map<JSResolvedTypeId, Map<JSResolvedTypeId, CompositeAssignableResult>> toUse = this.getCachedMap(context, contextOnly);
        Map map = toUse.computeIfAbsent(lType, el -> ContainerUtil.createConcurrentWeakMap());
        CompositeAssignableResult oldResult = (CompositeAssignableResult)((Object)map.get(rType));
        boolean isCall = JSGenericParameterImpl.isCallEnvironment(context);
        if (oldResult == null) {
            CompositeAssignableResult toCache = CompositeAssignableResult.from(result2, isCall);
            map.putIfAbsent(rType, toCache);
        } else {
            JSTypeCastUtil.AssignableResult currentValue = oldResult.asAssignable(isCall);
            if (currentValue != JSTypeCastUtil.AssignableResult.NOT_SURE) {
                return;
            }
            CompositeAssignableResult toCache = oldResult.copyWith(result2, isCall);
            map.replace(rType, oldResult, toCache);
        }
        this.logWasCached(lType, rType, result2);
    }

    private static boolean isCacheableType(@Nullable JSType type, boolean isTopLevelType) {
        JSType nestedType;
        if (type instanceof JSNamedType || type == null) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            List<JSType> arguments = genericType.getArguments();
            JSType mainType = genericType.getType();
            return arguments.stream().allMatch(el -> JSTypeComparingCache.isCacheableType(el, false)) && JSTypeComparingCache.isCacheableType(mainType, false);
        }
        if (type instanceof JSCompositeTypeBaseImpl) {
            return ((JSCompositeTypeBaseImpl)type).getTypes().stream().allMatch(el -> JSTypeComparingCache.isCacheableType(el, false));
        }
        if (type instanceof JSArrayType && JSTypeComparingCache.isCacheableType(nestedType = ((JSArrayType)type).getType(), false)) {
            return true;
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if ((!isTopLevelType || constraintType != null) && JSTypeComparingCache.isCacheableType(constraintType, false)) {
                return !((JSGenericParameterImpl)type).isApplying();
            }
        }
        return !isTopLevelType && type instanceof JSAnyType;
    }

    private void logWasCached(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(26);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(27);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(28);
        }
        if (this.myLogTrace) {
            LOG.info(String.format("Cached result %d. ltype: %s, rtype: %s, assignable: %s", new Object[]{this.myCacheMissCount.incrementAndGet(), lType, rType, result2}));
        }
    }

    private void logNoCache(@NotNull JSType lType, @NotNull JSType rType) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(29);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(30);
        }
        if (this.myLogTrace) {
            LOG.info(String.format("No caching (%s). ltype: %s, rtype: %s", this.myNoCacheCount.incrementAndGet(), lType, rType));
        }
    }

    private void logUsedCache(@NotNull JSResolvedTypeId lType, @NotNull JSResolvedTypeId rType, @NotNull JSTypeCastUtil.AssignableResult result2) {
        if (lType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(31);
        }
        if (rType == null) {
            JSTypeComparingCache.$$$reportNull$$$0(32);
        }
        if (result2 == null) {
            JSTypeComparingCache.$$$reportNull$$$0(33);
        }
        if (this.myLogTrace && result2.isStrict() && result2 != JSTypeCastUtil.AssignableResult.NOT_SURE) {
            LOG.info(String.format("Used cached value (%s). ltype: %s, rtype: %s, assignable: %s", new Object[]{this.myCacheUseCount.incrementAndGet(), lType, rType, result2}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 12: 
            case 14: 
            case 23: 
            case 27: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache";
                break;
            }
            case 10: 
            case 25: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "areAssignableTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "areAssignableIds";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areTypesAcceptable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableTypes";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putAssignableTypes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "useProcessingContextAsCache";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableIds";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCachedMap";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putAssignableIds";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "logWasCached";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "logNoCache";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "logUsedCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum CompositeAssignableResult {
        ASSIGNABLE_UNSET(1, 0),
        NOT_ASSIGNABLE_UNSET(2, 0),
        UNSET_ASSIGNABLE(0, 1),
        UNSET_NOT_ASSIGNABLE(0, 2),
        ASSIGNABLE_ASSIGNABLE(1, 1),
        ASSIGNABLE_NOT_ASSIGNABLE(1, 2),
        NOT_ASSIGNABLE_NOT_ASSIGNABLE(2, 2),
        NOT_ASSIGNABLE_ASSIGNABLE(2, 1);

        private final byte mySimple;
        private final byte myCall;

        private CompositeAssignableResult(byte simple, byte call) {
            this.mySimple = simple;
            this.myCall = call;
        }

        @NotNull
        private static CompositeAssignableResult from(@NotNull JSTypeCastUtil.AssignableResult result2, boolean isCall) {
            if (result2 == null) {
                CompositeAssignableResult.$$$reportNull$$$0(0);
            }
            boolean assignable = result2.isAssignable();
            if (isCall) {
                CompositeAssignableResult compositeAssignableResult = assignable ? UNSET_ASSIGNABLE : UNSET_NOT_ASSIGNABLE;
                if (compositeAssignableResult == null) {
                    CompositeAssignableResult.$$$reportNull$$$0(1);
                }
                return compositeAssignableResult;
            }
            CompositeAssignableResult compositeAssignableResult = assignable ? ASSIGNABLE_UNSET : NOT_ASSIGNABLE_UNSET;
            if (compositeAssignableResult == null) {
                CompositeAssignableResult.$$$reportNull$$$0(2);
            }
            return compositeAssignableResult;
        }

        @NotNull
        private static JSTypeCastUtil.AssignableResult intToAssignable(byte value) {
            if (value == 1) {
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    CompositeAssignableResult.$$$reportNull$$$0(3);
                }
                return assignableResult;
            }
            if (value == 2) {
                JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
                if (assignableResult == null) {
                    CompositeAssignableResult.$$$reportNull$$$0(4);
                }
                return assignableResult;
            }
            JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                CompositeAssignableResult.$$$reportNull$$$0(5);
            }
            return assignableResult;
        }

        @NotNull
        private JSTypeCastUtil.AssignableResult asAssignable(boolean isCall) {
            JSTypeCastUtil.AssignableResult assignableResult = isCall ? CompositeAssignableResult.intToAssignable(this.myCall) : CompositeAssignableResult.intToAssignable(this.mySimple);
            if (assignableResult == null) {
                CompositeAssignableResult.$$$reportNull$$$0(6);
            }
            return assignableResult;
        }

        private static byte resultToByte(@NotNull JSTypeCastUtil.AssignableResult result2) {
            if (result2 == null) {
                CompositeAssignableResult.$$$reportNull$$$0(7);
            }
            return result2.isAssignable() ? (byte)1 : 2;
        }

        @NotNull
        private CompositeAssignableResult copyWith(@NotNull JSTypeCastUtil.AssignableResult result2, boolean isCall) {
            byte call;
            if (result2 == null) {
                CompositeAssignableResult.$$$reportNull$$$0(8);
            }
            byte resultInt = CompositeAssignableResult.resultToByte(result2);
            byte simple = isCall ? this.mySimple : resultInt;
            byte by = call = isCall ? resultInt : this.myCall;
            if (simple == 1) {
                CompositeAssignableResult compositeAssignableResult = call == 1 ? ASSIGNABLE_ASSIGNABLE : ASSIGNABLE_NOT_ASSIGNABLE;
                if (compositeAssignableResult == null) {
                    CompositeAssignableResult.$$$reportNull$$$0(9);
                }
                return compositeAssignableResult;
            }
            CompositeAssignableResult compositeAssignableResult = call == 1 ? NOT_ASSIGNABLE_ASSIGNABLE : NOT_ASSIGNABLE_NOT_ASSIGNABLE;
            if (compositeAssignableResult == null) {
                CompositeAssignableResult.$$$reportNull$$$0(10);
            }
            return compositeAssignableResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache$CompositeAssignableResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingCache$CompositeAssignableResult";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intToAssignable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asAssignable";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "resultToByte";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "copyWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

