/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntHashSet;
import gnu.trove.decorator.TIntHashSetDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureUtil {
    public static void setParameters(@NotNull JSFunction function, MultiMap<JSParameter, UsageInfo> paramsUsages, JSChangeSignatureProcessor.RequiredImportProcessor importProcessor, JSLanguageDialect lang, JSParameterInfo ... parameters) {
        List<Object> newParameters;
        if (function == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSParameterList oldParamList = function.getParameterList();
        if (oldParamList == null) {
            return;
        }
        for (JSParameterInfo p : parameters) {
            String type;
            if (p.getOldIndex() != -1) {
                JSChangeSignatureProcessor.LOG.assertTrue(oldParamList.getParameters().length > p.getOldIndex());
                JSChangeSignatureUtil.rename(oldParamList.getParameters()[p.getOldIndex()], p.getDeclarationText(), paramsUsages);
            }
            if (!(!StringUtil.isNotEmpty((String)(type = p.getTypeText())) || p.isRest() && DialectDetector.isActionScript((PsiElement)function))) {
                importProcessor.computeImportsForType(type, (PsiElement)function);
            }
            if (!StringUtil.isNotEmpty((String)p.getInitializer())) continue;
            importProcessor.computeImportsForExpression(p.getInitializer(), (PsiElement)function);
        }
        DialectOptionHolder holder = lang != null ? lang.getOptionHolder() : null;
        boolean isArrowFunction = function.isArrowFunction();
        if (parameters.length > 0) {
            StringBuilder b = new StringBuilder("function dummy");
            JSChangeSignatureDialog.buildParameterListText(Arrays.asList(parameters), b, holder);
            b.append(";");
            JSFunction dummy = (JSFunction)JSChangeUtil.createJSTreeFromText(function.getProject(), b.toString(), lang).getPsi();
            newParameters = Arrays.asList(dummy.getParameters());
        } else {
            newParameters = Collections.emptyList();
        }
        for (int i = 0; i < newParameters.size(); ++i) {
            if (i < oldParamList.getParameters().length) {
                oldParamList.getParameters()[i].replace((PsiElement)newParameters.get(i));
                continue;
            }
            if (i > 0) {
                PsiElement prevElement;
                if (isArrowFunction) {
                    oldParamList = JSChangeSignatureUtil.addParenthesesIfNeeded(oldParamList);
                }
                if ((prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)oldParamList.getLastChild())) == null || prevElement.getNode().getElementType() != JSTokenTypes.COMMA) {
                    oldParamList.addBefore(JSChangeUtil.createCommaPsiElement((PsiElement)oldParamList), oldParamList.getLastChild());
                }
            }
            oldParamList.addBefore((PsiElement)newParameters.get(i), oldParamList.getLastChild());
        }
        while (oldParamList.getParameters().length > newParameters.size()) {
            PsiElement prev;
            JSParameterListElement parameter;
            JSParameterListElement removeFrom = parameter = oldParamList.getParameters()[newParameters.size()];
            while (removeFrom.getNode().getElementType() != JSTokenTypes.COMMA && (prev = removeFrom.getPrevSibling()) != null && prev.getNode().getElementType() != JSTokenTypes.LPAR) {
                removeFrom = prev;
            }
            oldParamList.deleteChildRange((PsiElement)removeFrom, (PsiElement)parameter);
        }
        if (isArrowFunction) {
            if (oldParamList.getParameters().length == 1) {
                boolean parensRequired = JSPsiImplUtils.parensAroundArrowFunctionParametersRequired(oldParamList, function);
                oldParamList = !parensRequired ? JSChangeSignatureUtil.removeParentheses(oldParamList) : JSChangeSignatureUtil.addParenthesesIfNeeded(oldParamList);
            } else if (oldParamList.getParameters().length == 0) {
                oldParamList = JSChangeSignatureUtil.addParenthesesIfNeeded(oldParamList);
            }
        }
        for (int i = parameters.length - 1; i >= 0; --i) {
            if (!parameters[i].isOptional() || holder != null && JSChangeSignatureUtil.supportsDefaultParameterInitializer(lang)) continue;
            JSIntroduceParameterHandler.addOptionalParameterInitializer(function, ((JSParameterListElement)newParameters.get(i)).getName(), parameters[i].getDefaultValue(), null);
        }
        PsiElement prev = oldParamList.getPrevSibling();
        int startOffset = prev != null ? prev.getTextRange().getStartOffset() : oldParamList.getTextRange().getStartOffset();
        int endOffset = oldParamList.getTextRange().getEndOffset();
        PsiFile file2 = function.getContainingFile();
        CodeStyleManager.getInstance((Project)function.getProject()).reformatText(file2, startOffset, endOffset);
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)function);
        if (docComment instanceof JSDocComment) {
            JSChangeSignatureUtil.updateJSDocParameters(function, (JSDocComment)docComment);
        }
    }

    private static void updateJSDocParameters(JSFunction newFunction, JSDocComment docComment) {
        int insertionIndex;
        JSDocumentationUtils.JSTagToParameterMap tagToParameterMap = JSDocumentationUtils.getTagToParameterMap(docComment, newFunction, null);
        Map<Integer, JSParameterListElement> map = tagToParameterMap.getMatchedTags();
        ArrayList<Integer> currentTagOrder = new ArrayList<Integer>(map.size());
        ArrayList<Integer> requiredTagOrder = new ArrayList<Integer>(map.size());
        for (Map.Entry<Integer, JSParameterListElement> entry : map.entrySet()) {
            currentTagOrder.add(entry.getKey());
            requiredTagOrder.add(entry.getKey());
        }
        currentTagOrder.addAll(tagToParameterMap.getNonMatchedTags());
        if (tagToParameterMap.getRestDocTagIndex() != -1) {
            currentTagOrder.add(tagToParameterMap.getRestDocTagIndex());
        }
        ContainerUtil.sort(currentTagOrder);
        ContainerUtil.sort(requiredTagOrder, Comparator.comparingInt(o -> ((JSParameterListElement)map.get(o)).getTextOffset()));
        ArrayList<Pair<Integer, String>> tagsToCreate = new ArrayList<Pair<Integer, String>>();
        TIntHashSetDecorator tagsToRemove = new TIntHashSetDecorator(new TIntHashSet());
        int requiredTagOrderIndex = 0;
        JSDocTag[] tags = docComment.getTags();
        for (int currentTagOrderIndex = 0; currentTagOrderIndex < currentTagOrder.size(); ++currentTagOrderIndex) {
            if (requiredTagOrderIndex < requiredTagOrder.size() && ((Integer)currentTagOrder.get(currentTagOrderIndex)).equals(requiredTagOrder.get(requiredTagOrderIndex))) {
                ++requiredTagOrderIndex;
                continue;
            }
            tagsToRemove.add(currentTagOrder.get(currentTagOrderIndex));
            for (int associatedTag = currentTagOrderIndex + 1; !map.containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                tagsToRemove.add(associatedTag);
            }
        }
        int n = insertionIndex = currentTagOrder.isEmpty() ? 0 : (Integer)currentTagOrder.get(currentTagOrder.size() - 1) + 1;
        while (requiredTagOrderIndex < requiredTagOrder.size()) {
            int requiredTagIndex = (Integer)requiredTagOrder.get(requiredTagOrderIndex);
            JSDocTag requiredTag = tags[requiredTagIndex];
            tagsToCreate.add((Pair<Integer, String>)Pair.create((Object)insertionIndex, (Object)JSChangeSignatureUtil.getTagTextWithComment(requiredTag)));
            for (int associatedTag = requiredTagIndex + 1; !map.containsKey(associatedTag) && associatedTag < tags.length && "param".equals(tags[associatedTag].getName()); ++associatedTag) {
                tagsToCreate.add((Pair<Integer, String>)Pair.create((Object)insertionIndex, (Object)JSChangeSignatureUtil.getTagTextWithComment(tags[associatedTag])));
            }
            ++requiredTagOrderIndex;
        }
        if (!tagsToRemove.isEmpty() || !tagsToCreate.isEmpty()) {
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes((PsiElement)docComment, tagsToCreate, null, (Set<Integer>)tagsToRemove);
        }
    }

    private static String getTagTextWithComment(JSDocTag requiredTag) {
        StringBuilder tagText = new StringBuilder(requiredTag.getText().substring(1));
        for (ASTNode node = requiredTag.getNode().getTreeNext(); node != null && (node.getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA || node.getElementType() == JSTokenTypes.WHITE_SPACE && node.getTreeNext() != null && node.getTreeNext().getElementType() == JSDocTokenTypes.DOC_COMMENT_DATA); node = node.getTreeNext()) {
            tagText.append(node.getText());
        }
        return tagText.toString();
    }

    private static void rename(@NotNull JSParameterListElement parameter, @NotNull String newName, @NotNull MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (parameter == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(2);
        }
        if (paramsUsages == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (newName.equals(parameter.getName())) {
            return;
        }
        JSChangeSignatureUtil.updateDeclaration(parameter, newName);
        if (parameter instanceof JSParameter) {
            JSChangeSignatureUtil.rebindParameterUsages((JSParameter)parameter, newName, paramsUsages);
        }
    }

    private static void rebindParameterUsages(@NotNull JSParameter parameter, @NotNull String newName, @NotNull MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (parameter == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(5);
        }
        if (paramsUsages == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(6);
        }
        for (UsageInfo parameterUsage : paramsUsages.get((Object)parameter)) {
            if (parameterUsage.getElement() instanceof JSReferenceExpression) {
                ((JSReferenceExpression)parameterUsage.getElement()).bindToElement((PsiElement)parameter);
                continue;
            }
            if (parameterUsage.getReference() == null) continue;
            parameterUsage.getReference().handleElementRename(newName);
        }
    }

    private static void updateDeclaration(@NotNull JSParameterListElement parameter, @NotNull String newDeclarationText) {
        PsiElement declarationElement;
        if (parameter == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(7);
        }
        if (newDeclarationText == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(8);
        }
        if ((declarationElement = parameter.getDeclarationElement()) == null) {
            return;
        }
        JSFunction function = JSPsiElementFactory.createJSSourceElement("function(" + newDeclarationText + "){}", (PsiElement)parameter, JSFunction.class);
        if (function.getParameters()[0].getDeclarationElement() == null) {
            return;
        }
        parameter.getDeclarationElement().replace(function.getParameters()[0].getDeclarationElement());
    }

    @NotNull
    public static JSParameterList addParenthesesIfNeeded(@NotNull JSParameterList paramList) {
        if (paramList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiElement lastChild = paramList.getLastChild();
        if (lastChild != null && lastChild.getNode().getElementType() == JSTokenTypes.RPAR) {
            JSParameterList jSParameterList = paramList;
            if (jSParameterList == null) {
                JSChangeSignatureUtil.$$$reportNull$$$0(10);
            }
            return jSParameterList;
        }
        String text = "function dummy(" + paramList.getText() + "){}";
        JSFunction root = JSPsiElementFactory.createJSSourceElement(text, (PsiElement)paramList, JSFunction.class);
        JSParameterList jSParameterList = (JSParameterList)paramList.replace((PsiElement)ObjectUtils.assertNotNull((Object)root.getParameterList()));
        if (jSParameterList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(11);
        }
        return jSParameterList;
    }

    @NotNull
    private static JSParameterList removeParentheses(@NotNull JSParameterList paramList) {
        if (paramList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(12);
        }
        String text = paramList.getText();
        text = StringUtil.trimStart((String)text, (String)"(");
        text = StringUtil.trimEnd((String)text, (String)")");
        text = "let dummy = " + text + " => x";
        JSVarStatement root = JSPsiElementFactory.createJSStatement(text, (PsiElement)paramList, JSVarStatement.class);
        JSExpression initializer = root.getVariables()[0].getInitializer();
        JSParameterList jSParameterList = (JSParameterList)paramList.replace((PsiElement)((JSFunction)initializer).getParameterList());
        if (jSParameterList == null) {
            JSChangeSignatureUtil.$$$reportNull$$$0(13);
        }
        return jSParameterList;
    }

    private static boolean supportsDefaultParameterInitializer(@Nullable JSLanguageDialect lang) {
        if (lang == null) {
            return false;
        }
        DialectOptionHolder optionHolder = lang.getOptionHolder();
        return optionHolder.isTypeScript || optionHolder.isECMA6 || optionHolder.isECMA4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsUsages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDeclarationText";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramList";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addParenthesesIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParentheses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rebindParameterUsages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParenthesesIfNeeded";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeParentheses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

