/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseClassBasedIntroduceDialog;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.MethodSignatureComponent;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractFunctionDialog
extends JSBaseClassBasedIntroduceDialog<IntroducedEntityInfoProvider>
implements JSExtractFunctionSettings {
    private JPanel myPanel;
    private NameSuggestionsField myFunctionName;
    private JSVisibilityPanel myVisibilityPanel;
    private EditorComboBox myVarType;
    private MethodSignatureComponent myPreviewText;
    private JTable parametersTable;
    private JPanel myVarTypePanel;
    private JCheckBox myDeclareStaticCheckBox;
    private JCheckBox myDeclareAsFunctionExpression;
    private JLabel myNameLabel;
    private JPanel myToolbarDecoratorPanel;
    private JSExtractFunctionSettings.ParametersInfo parametersInfo;
    private final ExtractedFunctionSignatureGenerator mySignatureGenerator;
    private final JSExtractFunctionHandler.ContextInfo contextInfo;
    private final JSExtractFunctionHandler.IntroductionScope myIntroductionScope;

    public JSExtractFunctionDialog(@NotNull ExtractedFunctionSignatureGenerator signatureGenerator, final @NotNull JSExtractFunctionHandler.ContextInfo ci, @NotNull JSExtractFunctionHandler.IntroductionScope introductionScope) {
        if (signatureGenerator == null) {
            JSExtractFunctionDialog.$$$reportNull$$$0(0);
        }
        if (ci == null) {
            JSExtractFunctionDialog.$$$reportNull$$$0(1);
        }
        if (introductionScope == null) {
            JSExtractFunctionDialog.$$$reportNull$$$0(2);
        }
        super(ci.file.getProject(), new IntroducedEntityInfoProvider(){

            @Override
            public int getOccurrenceCount() {
                return 0;
            }

            @Override
            @Nullable
            public String evaluateType() {
                return null;
            }

            @Override
            public PsiFile getContainingFile() {
                return ci.file;
            }

            @Override
            public String[] suggestCandidateNames() {
                return JSExtractFunctionHandler.suggestNames(ci.myCodeFragment);
            }

            @Override
            public boolean checkConflicts(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public PsiElement findNamedElementInScope(@NotNull String name, PsiElement place) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "name";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionDialog$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkConflicts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findNamedElementInScope";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "javascript.extract.method.title");
        this.contextInfo = ci;
        this.myIntroductionScope = introductionScope;
        this.mySignatureGenerator = signatureGenerator;
        this.$$$setupUI$$$();
        ChangeListener listener2 = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSExtractFunctionDialog.this.initiateValidation();
            }
        };
        this.myVisibilityPanel.addListener(listener2);
        this.myDeclareAsFunctionExpression.addChangeListener(listener2);
        this.myDeclareAsFunctionExpression.setFocusable(true);
        this.myDeclareStaticCheckBox.addChangeListener(listener2);
        this.myDeclareStaticCheckBox.setFocusable(true);
        this.myDeclareAsFunctionExpression.setSelected(JSExtractFunctionHandler.getDeclareAsFunctionExpression());
        boolean isClassContext = this.getIntroductionScope().isClassContext();
        this.myVisibilityPanel.setVisible(isClassContext);
        this.myDeclareAsFunctionExpression.setVisible(!this.contextInfo.ecmaL4);
        this.myDeclareAsFunctionExpression.setEnabled(!this.getIntroductionScope().forceMakeFunExpr);
        this.myVarTypePanel.setVisible(false);
        this.myDeclareStaticCheckBox.setVisible(isClassContext);
        if (isClassContext) {
            this.myDeclareStaticCheckBox.setEnabled(this.contextInfo.getJSContext() == JSContext.UNKNOWN && JSExtractFunctionHandler.possibleToExtractStaticFromInstance(ci, this.myIntroductionScope));
            this.myDeclareStaticCheckBox.setSelected(JSExtractFunctionHandler.getDeclareStatic() || this.contextInfo.getJSContext() == JSContext.STATIC);
            if (!ci.ecmaL4) {
                this.myDeclareAsFunctionExpression.setSelected(true);
                this.myDeclareAsFunctionExpression.setVisible(false);
            }
        }
        this.myVisibilityPanel.configureForClassMember(false, false, ci.holder);
        this.doInit();
    }

    private void swapVars(int selectedRow, int anotherRow) {
        JSNamedElement var = this.parametersInfo.variables.get(selectedRow);
        this.parametersInfo.variables.set(selectedRow, this.parametersInfo.variables.get(anotherRow));
        this.parametersInfo.variables.set(anotherRow, var);
    }

    private void changeRowNumber(int selectedRow, int newValue) {
        JSNamedElement currentVar = this.parametersInfo.variables.get(selectedRow);
        JSExtractFunctionSettings.ParameterInfo currentVarParametersInfo = this.parametersInfo.variableOptions.get(currentVar);
        this.parametersInfo.variableOptions.put(currentVar, new JSExtractFunctionSettings.ParameterInfo(currentVarParametersInfo.name, currentVarParametersInfo.used, currentVarParametersInfo.type, newValue));
    }

    @Override
    protected void checkIsValid() {
        super.checkIsValid();
        this.myPreviewText.setSignature(this.mySignatureGenerator.fun(this, this.contextInfo));
        this.checkUniqueness(this.getIntroductionScope().parent);
        Action action = this.getOKAction();
        boolean nameValidationStatus = true;
        for (JSNamedElement var : this.parametersInfo.variables) {
            JSExtractFunctionSettings.ParameterInfo parameterInfo = this.parametersInfo.variableOptions.get(var);
            if (parameterInfo == null || JSNamesValidation.isIdentifier(parameterInfo.name, this.contextInfo.getContextElement())) continue;
            nameValidationStatus = false;
            break;
        }
        action.setEnabled(action.isEnabled() && nameValidationStatus);
    }

    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Override
    public JComboBox getVarTypeField() {
        return this.myVarType;
    }

    @Override
    public String getMethodName() {
        return this.getVariableName();
    }

    @Override
    @Nullable
    public JSExtractFunctionSettings.ParametersInfo getParametersInfo() {
        return this.parametersInfo;
    }

    private void setParametersInfo(JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        this.parametersInfo = parametersInfo;
        int i = 0;
        for (JSNamedElement var : parametersInfo.variables) {
            if (JSExtractFunctionHandler.isArgumentsReference(var)) continue;
            String string = JSExtractFunctionDialog.getTypeTextForVariable(var);
            parametersInfo.variableOptions.put(var, new JSExtractFunctionSettings.ParameterInfo(var.getName(), true, string, i++));
        }
        ((AbstractTableModel)this.parametersTable.getModel()).fireTableDataChanged();
    }

    private static String getTypeTextForVariable(JSNamedElement var) {
        JSType type = var instanceof JSVariable ? ((JSVariable)var).getJSType() : null;
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
    }

    @Override
    protected NameSuggestionsField getNameField() {
        return this.myFunctionName;
    }

    @Override
    protected JLabel getNameLabel() {
        return this.myNameLabel;
    }

    @Override
    protected JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    protected JCheckBox getReplaceAllCheckBox() {
        return null;
    }

    @Override
    public JSVisibilityPanel getVisibilityPanel() {
        return this.myVisibilityPanel;
    }

    @Override
    public boolean makeStatic() {
        return this.myDeclareStaticCheckBox.isSelected();
    }

    @Override
    public boolean makeFunctionExpression() {
        return this.myDeclareAsFunctionExpression.isVisible() && this.myDeclareAsFunctionExpression.isSelected() || this.getIntroductionScope().forceMakeFunExpr;
    }

    @Override
    public JSExtractFunctionHandler.IntroductionScope getIntroductionScope() {
        return this.myIntroductionScope;
    }

    private void createUIComponents() {
        this.myFunctionName = this.configureNameField();
        this.myVarType = this.configureTypeField();
        this.myPreviewText = new MethodSignatureComponent(this.mySignatureGenerator.fun(new DefaultJSExtractFunctionSettings("extracted", this.myIntroductionScope), this.contextInfo), this.myProject, (FileType)JSChangeSignatureDialog.getFileTypeFromContext(this.contextInfo.getContextElement()));
        this.myPreviewText.setMinimumSize((Dimension)JBUI.size((int)300, (int)40));
        this.parametersTable = new JBTable();
        this.setParametersInfo(JSExtractFunctionHandler.createDefaultParametersInfo(this.getIntroductionScope()));
        this.parametersTable.setAutoCreateColumnsFromModel(false);
        this.parametersTable.setModel(new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.size();
            }

            @Override
            public int getColumnCount() {
                return 2 + (JSExtractFunctionDialog.this.isEcma4Context() || JSExtractFunctionDialog.this.isTypeScriptContext() ? 1 : 0);
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                JSNamedElement var = ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variables.get(rowIndex);
                if (columnIndex == 0) {
                    return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get((Object)var).used;
                }
                if (columnIndex == 1) {
                    return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get((Object)var).name;
                }
                if (columnIndex == 2) {
                    return ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get((Object)var).type;
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                JSNamedElement var = ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variables.get(rowIndex);
                JSExtractFunctionSettings.ParameterInfo parameterInfo = ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.get(var);
                JSExtractFunctionSettings.ParameterInfo newParameterInfo = null;
                if (columnIndex == 0) {
                    newParameterInfo = new JSExtractFunctionSettings.ParameterInfo(parameterInfo.name, (Boolean)aValue, parameterInfo.type, rowIndex);
                } else if (columnIndex == 1) {
                    newParameterInfo = new JSExtractFunctionSettings.ParameterInfo((String)aValue, parameterInfo.used, parameterInfo.type, rowIndex);
                } else if (columnIndex == 2) {
                    newParameterInfo = new JSExtractFunctionSettings.ParameterInfo(parameterInfo.name, parameterInfo.used, (String)aValue, rowIndex);
                }
                if (newParameterInfo != null) {
                    ((JSExtractFunctionDialog)JSExtractFunctionDialog.this).parametersInfo.variableOptions.put(var, newParameterInfo);
                }
                JSExtractFunctionDialog.this.initiateValidation();
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Boolean.class;
                }
                if (columnIndex == 1) {
                    return String.class;
                }
                if (columnIndex == 2) {
                    return String.class;
                }
                return super.getColumnClass(columnIndex);
            }
        });
        DefaultTableColumnModel tableColumnModel = new DefaultTableColumnModel();
        TableColumn checkboxColumn = new TableColumn(0);
        checkboxColumn.setMaxWidth(60);
        tableColumnModel.addColumn(checkboxColumn);
        tableColumnModel.addColumn(new TableColumn(1));
        if (this.isTypeScriptContext() || this.isEcma4Context()) {
            tableColumnModel.addColumn(new TableColumn(2));
        }
        this.parametersTable.setColumnModel(tableColumnModel);
        this.parametersTable.setRowSelectionAllowed(false);
        this.parametersTable.getSelectionModel().setSelectionInterval(0, 0);
        this.myToolbarDecoratorPanel = ToolbarDecorator.createDecorator((JTable)this.parametersTable).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = JSExtractFunctionDialog.this.parametersTable.getSelectedRow();
                if (selectedRow - 1 >= 0) {
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow, selectedRow - 1);
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow - 1, selectedRow);
                    JSExtractFunctionDialog.this.swapVars(selectedRow, selectedRow - 1);
                    ((AbstractTableModel)JSExtractFunctionDialog.this.parametersTable.getModel()).fireTableRowsUpdated(selectedRow - 1, selectedRow);
                    JSExtractFunctionDialog.this.parametersTable.getSelectionModel().setSelectionInterval(selectedRow - 1, selectedRow - 1);
                    JSExtractFunctionDialog.this.initiateValidation();
                }
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = JSExtractFunctionDialog.this.parametersTable.getSelectedRow();
                if (selectedRow + 1 < JSExtractFunctionDialog.this.parametersTable.getRowCount()) {
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow, selectedRow + 1);
                    JSExtractFunctionDialog.this.changeRowNumber(selectedRow + 1, selectedRow);
                    JSExtractFunctionDialog.this.swapVars(selectedRow, selectedRow + 1);
                    ((AbstractTableModel)JSExtractFunctionDialog.this.parametersTable.getModel()).fireTableRowsUpdated(selectedRow, selectedRow + 1);
                    JSExtractFunctionDialog.this.parametersTable.getSelectionModel().setSelectionInterval(selectedRow + 1, selectedRow + 1);
                    JSExtractFunctionDialog.this.initiateValidation();
                }
            }
        }).createPanel();
    }

    public boolean isEcma4Context() {
        return this.contextInfo.ecmaL4;
    }

    public boolean isTypeScriptContext() {
        return this.contextInfo.holder != null && this.contextInfo.holder.isTypeScript;
    }

    protected String getHelpId() {
        if (this.isEcma4Context()) {
            return "refactoring.extractMethod.ActionScript";
        }
        if (this.isTypeScriptContext()) {
            return "typescript_extract_method";
        }
        return "refactoring.extractMethod.JavaScript";
    }

    @Override
    protected void doOKAction() {
        PsiElement conflict = JSExtractFunctionHandler.findConflictingElementInScope(this.getMethodName(), this.myIntroductionScope.parent, this.makeStatic(), null);
        if (conflict != null && !BasicIntroducedEntityInfoProvider.showMemberAlreadyExists(conflict)) {
            return;
        }
        if (this.myDeclareAsFunctionExpression.isEnabled() && this.myDeclareAsFunctionExpression.isVisible()) {
            JSExtractFunctionHandler.saveDeclareAsFunctionExpression(this.myDeclareAsFunctionExpression.isSelected());
        }
        if (this.myDeclareStaticCheckBox.isEnabled() && this.myDeclareStaticCheckBox.isVisible()) {
            JSExtractFunctionHandler.saveDeclareStatic(this.myDeclareStaticCheckBox.isSelected());
        }
        super.doOKAction();
    }

    @Override
    protected boolean isValidName(String name, PsiElement context) {
        if (this.myIntroductionScope.isClassContext()) {
            return JSNamesValidation.isClassMemberName(name, context);
        }
        return super.isValidName(name, context);
    }

    @Override
    protected void saveLastUsedVisibility(@NotNull JSAttributeList.AccessType type) {
        if (type == null) {
            JSExtractFunctionDialog.$$$reportNull$$$0(3);
        }
        JSExtractFunctionHandler.saveClassMemberVisibility(type);
    }

    @Override
    @Nullable
    protected JSAttributeList.AccessType getLastUsedVisibility() {
        return JSExtractFunctionHandler.getClassMemberVisibility();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ci";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "saveLastUsedVisibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JSVisibilityPanel jSVisibilityPanel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Signature preview", (int)0, (int)0, null, null));
        MethodSignatureComponent methodSignatureComponent = this.myPreviewText;
        jPanel3.add((Component)methodSignatureComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Parameters", (int)0, (int)0, null, null));
        JPanel jPanel5 = this.myToolbarDecoratorPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Function", (int)0, (int)0, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myFunctionName;
        jPanel6.add((Component)nameSuggestionsField, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        this.myDeclareStaticCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(false);
        jCheckBox2.setText("Declare static");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myVarTypePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        EditorComboBox editorComboBox = this.myVarType;
        jPanel.add((Component)editorComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Return type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeclareAsFunctionExpression = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(false);
        jCheckBox.setText("Declare functional expression");
        jCheckBox.setMnemonic('F');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel6.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myVisibilityPanel = jSVisibilityPanel = new JSVisibilityPanel();
        JComponent jComponent = jSVisibilityPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel2.setLabelFor((Component)editorComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

