/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.javascript.structureView.JSSuperGroup;
import com.intellij.psi.PsiElement;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class JSSuperGrouper
implements Grouper {
    @NonNls
    private static final String SHOW_CLASSES = "SHOW_CLASSES";

    JSSuperGrouper() {
    }

    @NotNull
    public Collection<Group> group(@NotNull AbstractTreeNode parent, @NotNull Collection<TreeElement> children) {
        if (parent == null) {
            JSSuperGrouper.$$$reportNull$$$0(0);
        }
        if (children == null) {
            JSSuperGrouper.$$$reportNull$$$0(1);
        }
        if (JSSuperGrouper.isParentGrouped(parent)) {
            List<Group> list2 = Collections.emptyList();
            if (list2 == null) {
                JSSuperGrouper.$$$reportNull$$$0(2);
            }
            return list2;
        }
        if (parent.getValue() instanceof CustomRegionTreeElement) {
            List<Group> list3 = Collections.emptyList();
            if (list3 == null) {
                JSSuperGrouper.$$$reportNull$$$0(3);
            }
            return list3;
        }
        THashMap groups = new THashMap();
        for (TreeElement _child : children) {
            JSQualifiedName ns;
            if (!(_child instanceof JSStructureViewElementBase)) continue;
            JSStructureViewElementBase child = (JSStructureViewElementBase)_child;
            PsiElement value = child.getValue();
            if (value instanceof JSVariable) {
                if (!child.isInherited()) continue;
                PsiElement parentElement = value.getParent();
                if (parentElement instanceof JSVarStatement) {
                    parentElement = parentElement.getParent();
                }
                if (parentElement instanceof JSClass) {
                    JSSuperGrouper.addGroup((Map<String, Group>)groups, _child, ((JSClass)parentElement).getQualifiedName());
                    continue;
                }
            }
            if (!(value instanceof JSElementBase) || value instanceof JSFunctionItem && JSSuperGrouper.processFunction((JSStructureViewElementBase)((Object)parent.getValue()), (Map<String, Group>)groups, _child, value) || !child.isInherited() || (ns = ((JSElementBase)value).getNamespace()) == null) continue;
            JSSuperGrouper.addGroup((Map<String, Group>)groups, _child, ns.getQualifiedName());
        }
        Collection<Group> collection = groups.values();
        if (collection == null) {
            JSSuperGrouper.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static boolean processFunction(JSStructureViewElementBase parentElement, Map<String, Group> groups, TreeElement _child, PsiElement value) {
        JSClass declaringClass;
        JSClass parentClass;
        PsiElement element = JSStructureViewElementBase.getPsiElement((StructureViewTreeElement)parentElement);
        if (element instanceof JSClass && (parentClass = (JSClass)element) != (declaringClass = JSInheritanceUtil.findSomeDeclaringClass((JSQualifiedNamedElement)((JSFunction)value))) && declaringClass != null) {
            JSSuperGrouper.addGroup(groups, _child, declaringClass.getQualifiedName());
            return true;
        }
        return false;
    }

    private static void addGroup(Map<String, Group> groups, TreeElement _child, String qName) {
        JSSuperGroup group = (JSSuperGroup)groups.get(qName);
        if (group == null) {
            group = new JSSuperGroup(qName);
            groups.put(qName, group);
        }
        group.addChild(_child);
    }

    @NotNull
    public ActionPresentation getPresentation() {
        ActionPresentationData actionPresentationData = new ActionPresentationData(IdeBundle.message((String)"action.structureview.group.methods.by.defining.type", (Object[])new Object[0]), null, AllIcons.General.ImplementingMethod);
        if (actionPresentationData == null) {
            JSSuperGrouper.$$$reportNull$$$0(5);
        }
        return actionPresentationData;
    }

    @NotNull
    public String getName() {
        if (SHOW_CLASSES == null) {
            JSSuperGrouper.$$$reportNull$$$0(6);
        }
        return SHOW_CLASSES;
    }

    private static boolean isParentGrouped(AbstractTreeNode parent) {
        while (parent != null) {
            if (parent.getValue() instanceof JSSuperGroup) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSSuperGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSSuperGrouper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

