/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSVariableStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSVariableElementType
extends JSStubElementType<JSVariableStub<JSVariable>, JSVariable> {
    public JSVariableElementType() {
        super("VARIABLE");
    }

    public JSVariableElementType(@NonNls String debugName) {
        super(debugName);
    }

    @NotNull
    public JSVariableStub<JSVariable> createStub(@NotNull JSVariable psi, StubElement parentStub) {
        if (psi == null) {
            JSVariableElementType.$$$reportNull$$$0(0);
        }
        JSVariableStubImpl jSVariableStubImpl = new JSVariableStubImpl(psi, parentStub, this);
        if (jSVariableStubImpl == null) {
            JSVariableElementType.$$$reportNull$$$0(1);
        }
        return jSVariableStubImpl;
    }

    public boolean shouldCreateStub(ASTNode node) {
        return JSVariableElementType.shouldCreateStubForVariable(node);
    }

    public PsiElement construct(ASTNode node) {
        return new JSVariableImpl(node);
    }

    @NotNull
    public JSVariableStub<JSVariable> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSVariableElementType.$$$reportNull$$$0(2);
        }
        JSVariableStubImpl jSVariableStubImpl = new JSVariableStubImpl(dataStream, parentStub, (IStubElementType)this);
        if (jSVariableStubImpl == null) {
            JSVariableElementType.$$$reportNull$$$0(3);
        }
        return jSVariableStubImpl;
    }

    public boolean shouldIndexSymbol(@NotNull JSVariable psi) {
        if (psi == null) {
            JSVariableElementType.$$$reportNull$$$0(4);
        }
        return !psi.isLocal();
    }

    public static boolean shouldCreateStubForVariable(@NotNull ASTNode node) {
        ASTNode parent;
        if (node == null) {
            JSVariableElementType.$$$reportNull$$$0(5);
        }
        if ((parent = node.getTreeParent()) == null || parent.getElementType() != JSStubElementTypes.VAR_STATEMENT) {
            return true;
        }
        boolean insideFunction = false;
        while (parent != null) {
            IElementType type = parent.getElementType();
            if (JSElementTypes.FUNCTIONS.contains(type)) {
                ASTNode docComment = node.findChildByType(JSStubElementTypes.DOC_COMMENT);
                if (docComment == null) {
                    docComment = node.getTreeParent().findChildByType(JSStubElementTypes.DOC_COMMENT);
                }
                if (docComment != null && docComment.getFirstChildNode() != null) {
                    return true;
                }
                insideFunction = true;
                break;
            }
            if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type)) {
                return true;
            }
            parent = parent.getTreeParent();
        }
        if (!insideFunction && !JSVariableBaseImpl.hasBlockScope(node)) {
            return true;
        }
        ASTNode initializer = JSTreeUtil.getInitializerNode(node);
        return initializer != null && !JSSymbolUtil.typeMayBeInlined(initializer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/JSVariableElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/JSVariableElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexSymbol";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

