/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.inspections.JSAnnotatorInspection;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemGroup;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnnotatorProblemReporter {
    private final AnnotationHolder myHolder;

    public JSAnnotatorProblemReporter(AnnotationHolder holder) {
        this.myHolder = holder;
    }

    @Nullable
    public Annotation registerGenericError(ASTNode nameIdentifier, String message, IntentionAction ... intentionActions) {
        return this.registerProblem(nameIdentifier.getPsi(), message, ProblemHighlightType.GENERIC_ERROR, intentionActions);
    }

    @Nullable
    public Annotation registerGenericError(PsiElement nameIdentifier, String message, IntentionAction ... intentionActions) {
        return this.registerProblem(nameIdentifier, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, intentionActions);
    }

    public Annotation registerProblem(@Nullable PsiElement nameIdentifier, String message) {
        return this.registerProblem(nameIdentifier, message, null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
    }

    @Nullable
    public Annotation registerProblem(@Nullable PsiElement nameIdentifier, String message, @Nullable ProblemHighlightType type, IntentionAction ... intentionActions) {
        return this.registerProblem(nameIdentifier, message, type, null, LocalQuickFix.EMPTY_ARRAY, intentionActions);
    }

    @Nullable
    public Annotation registerProblem(PsiElement nameIdentifier, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, LocalQuickFix ... fixes) {
        return this.registerProblem(nameIdentifier, message, type, inspectionId, fixes, IntentionAction.EMPTY_ARRAY);
    }

    @Nullable
    protected Annotation registerProblem(@Nullable PsiElement nameIdentifier, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions) {
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(0);
        }
        return this.registerProblem(nameIdentifier, null, message, type, inspectionId, fixes, intentionActions);
    }

    @Nullable
    public Annotation registerProblem(@Nullable PsiElement nameIdentifier, @Nullable TextRange range, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions) {
        FileViewProvider viewProvider;
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(1);
        }
        if (inspectionId != null && !this.shouldReportInspectionProblems()) {
            return null;
        }
        boolean isAnnotatorInspection = inspectionId == null;
        String string = inspectionId = isAnnotatorInspection ? this.getAnnotatorInspectionId() : inspectionId;
        if (range == null && nameIdentifier != null) {
            range = nameIdentifier.getTextRange();
        }
        if (range == null) {
            return null;
        }
        PsiFile file2 = nameIdentifier != null ? nameIdentifier.getContainingFile() : null;
        LocalInspectionToolWrapper localInspectionToolWrapper = null;
        HighlightDisplayKey displayKey = null;
        InspectionProfile inspectionProfile = null;
        Set suppressors = null;
        if (nameIdentifier != null && inspectionId != null) {
            inspectionProfile = JSAnnotatorProblemReporter.getInspectionProfile(nameIdentifier);
            localInspectionToolWrapper = JSAnnotatorProblemReporter.getInspectionToolWrapper(nameIdentifier, inspectionId, inspectionProfile);
            displayKey = HighlightDisplayKey.find((String)inspectionId);
            if (localInspectionToolWrapper == null || !inspectionProfile.isToolEnabled(displayKey, (PsiElement)file2)) {
                return null;
            }
            if (!IntentionAndInspectionFilter.isInspectionSupportedForElement(inspectionId, nameIdentifier)) {
                return null;
            }
            if (nameIdentifier.isValid()) {
                suppressors = InspectionProfileEntry.getSuppressors((PsiElement)nameIdentifier);
                for (InspectionSuppressor suppressor2 : suppressors) {
                    if (!suppressor2.isSuppressedFor(nameIdentifier, inspectionId)) continue;
                    return null;
                }
                LocalInspectionTool tool = (LocalInspectionTool)localInspectionToolWrapper.getTool();
                if (SuppressionUtil.inspectionResultSuppressed((PsiElement)nameIdentifier, (LocalInspectionTool)tool)) {
                    return null;
                }
            }
        }
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        String ref = nameIdentifier != null ? ProblemDescriptorUtil.extractHighlightedText((TextRange)range, (PsiElement)nameIdentifier) : "";
        message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        Annotation annotation = null;
        if ((type == ProblemHighlightType.ERROR || type == ProblemHighlightType.GENERIC_ERROR) && file2 != null && (viewProvider = file2.getViewProvider()).isPhysical() && !ProjectScope.getProjectScope((Project)file2.getProject()).contains(viewProvider.getVirtualFile())) {
            type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        }
        if (type == ProblemHighlightType.ERROR || type == ProblemHighlightType.GENERIC_ERROR) {
            annotation = this.myHolder.createErrorAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (type == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
            annotation = this.myHolder.createWarningAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (type == ProblemHighlightType.WEAK_WARNING) {
            annotation = this.myHolder.createWeakWarningAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (type == ProblemHighlightType.INFORMATION) {
            annotation = this.myHolder.createInfoAnnotation(range, message);
            annotation.setHighlightType(type);
        } else if (localInspectionToolWrapper != null) {
            if (displayKey == null) {
                return null;
            }
            HighlightDisplayLevel defaultLevel = inspectionProfile.getErrorLevel(displayKey, nameIdentifier);
            if (defaultLevel == HighlightDisplayLevel.ERROR) {
                ProblemHighlightType error = type == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR;
                annotation = JSAnnotatorProblemReporter.createErrorAnnotation(range, message, error, this.myHolder);
            } else if (defaultLevel == HighlightDisplayLevel.WARNING) {
                annotation = this.myHolder.createWarningAnnotation(range, message);
            }
            if (annotation == null) {
                annotation = this.myHolder.createWeakWarningAnnotation(range, message);
            }
        } else {
            annotation = this.myHolder.createWeakWarningAnnotation(range, message);
        }
        if (isAnnotatorInspection && suppressors != null) {
            String finalInspectionId = inspectionId;
            SuppressIntentionAction[] actions = (SuppressIntentionAction[])suppressors.stream().flatMap(suppressor -> Arrays.stream(suppressor.getSuppressActions(nameIdentifier, finalInspectionId))).map(fix -> SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)fix)).toArray(SuppressIntentionAction[]::new);
            annotation.setProblemGroup((ProblemGroup)new JSAnnotatorProblemGroup(actions, finalInspectionId));
        }
        if (nameIdentifier != null && file2 != null) {
            JSAnnotatorProblemReporter.registerIntentionAndFixes(nameIdentifier, fixes, intentionActions, annotation, file2, displayKey);
        }
        return annotation;
    }

    private boolean shouldReportInspectionProblems() {
        PsiFile psiFile = this.myHolder.getCurrentAnnotationSession().getFile();
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if (file2 == null || file2 instanceof LightVirtualFile) {
            return true;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)psiFile.getProject());
        return fileIndex.isInContent(file2) && !fileIndex.isInLibrary(file2);
    }

    @NotNull
    private static InspectionProfile getInspectionProfile(@NotNull PsiElement nameIdentifier) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(2);
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)nameIdentifier.getProject()).getCurrentProfile();
        if (inspectionProfileImpl == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(3);
        }
        return inspectionProfileImpl;
    }

    private static LocalInspectionToolWrapper getInspectionToolWrapper(@NotNull PsiElement nameIdentifier, @NotNull String inspectionId, InspectionProfile inspectionProfile) {
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(4);
        }
        if (inspectionId == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(5);
        }
        return (LocalInspectionToolWrapper)inspectionProfile.getInspectionTool(inspectionId, nameIdentifier);
    }

    public static void registerIntentionAndFixes(@NotNull PsiElement nameIdentifier, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions, @NotNull Annotation annotation, @NotNull PsiFile file2, @Nullable HighlightDisplayKey displayKey) {
        String displayName;
        if (nameIdentifier == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(6);
        }
        if (intentionActions == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(7);
        }
        if (annotation == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(9);
        }
        boolean fixRegistered = false;
        if (fixes != null) {
            SmartPsiElementPointer pointer = null;
            LocalQuickFix[] localQuickFixArray = fixes;
            int n = localQuickFixArray.length;
            for (int i = 0; i < n; ++i) {
                LocalQuickFix l = localQuickFixArray[i];
                if (!(l instanceof IntentionAction)) continue;
                annotation.registerFix((IntentionAction)l, null, displayKey);
                fixRegistered = true;
                if (!(l instanceof FixAndIntentionAction)) continue;
                pointer = ((FixAndIntentionAction)l).registerElementRefForFix(nameIdentifier, pointer);
            }
        }
        for (IntentionAction action : intentionActions) {
            fixRegistered = true;
            annotation.registerFix(action, null, displayKey);
        }
        if (!file2.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) && displayKey != null && !fixRegistered && (displayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)displayKey)) != null) {
            annotation.registerFix((IntentionAction)new EmptyIntentionAction(displayName), null, displayKey);
        }
    }

    public static TextRange shortenTextRange(PsiElement place, TextRange range) {
        Document document2 = PsiDocumentManager.getInstance((Project)place.getProject()).getDocument(place.getContainingFile());
        if (document2 != null && document2.getLineNumber(range.getStartOffset()) < document2.getLineNumber(range.getEndOffset())) {
            range = new TextRange(range.getStartOffset(), document2.getLineEndOffset(document2.getLineNumber(range.getStartOffset())));
        }
        return range;
    }

    @Deprecated
    public static Annotation createErrorAnnotation(PsiElement nameIdentifier, String message, ProblemHighlightType type, @NotNull AnnotationHolder holder) {
        if (holder == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(10);
        }
        return JSAnnotatorProblemReporter.createErrorAnnotation(nameIdentifier.getTextRange(), message, type, holder);
    }

    private static Annotation createErrorAnnotation(TextRange range, String message, ProblemHighlightType type, @NotNull AnnotationHolder holder) {
        if (holder == null) {
            JSAnnotatorProblemReporter.$$$reportNull$$$0(11);
        }
        Annotation annotation = holder.createErrorAnnotation(range, message);
        annotation.setHighlightType(type);
        return annotation;
    }

    @Nullable
    protected String getAnnotatorInspectionId() {
        return JSAnnotatorInspection.SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionActions";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSAnnotatorProblemReporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionProfile";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionToolWrapper";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerIntentionAndFixes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

