/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptCompileActionBase
extends AnAction {
    TypeScriptCompileActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager2, @NotNull Collection<? extends JSAnnotationError> infos) {
        if (manager2 == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(1);
        }
        manager2.logProjectErrors((ImmutableList<JSAnnotationError>)ContainerUtil.immutableList(new ArrayList<JSAnnotationError>(infos)), true);
    }

    protected boolean compileFile(@NotNull VirtualFile file2, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService service, @NotNull Collection<JSAnnotationError> infos, @NotNull Collection<String> processedFiles) {
        if (file2 == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(3);
        }
        if (service == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(4);
        }
        if (infos == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(5);
        }
        if (processedFiles == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(6);
        }
        indicator.checkCanceled();
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Action Compile: do compile for " + file2.getName());
        }
        try {
            Future<JSLanguageServiceResultContainer> compile = service.compileFileAndGetErrors(file2);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                this.processCompileFileResult(container, infos, processedFiles);
            }
            return true;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.checkCanceled();
            return false;
        }
    }

    protected void processCompileFileResult(@Nullable JSLanguageServiceResultContainer container, @NotNull Collection<JSAnnotationError> infos, @NotNull Collection<String> processedFiles) {
        if (infos == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(7);
        }
        if (processedFiles == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(8);
        }
        if (container != null) {
            infos.addAll((Collection<JSAnnotationError>)container.getAnnotationResults());
            List<String> compiledFiles = container.getProcessedFiles();
            if (compiledFiles != null) {
                for (String s : compiledFiles) {
                    if (StringUtil.isEmpty((String)s)) continue;
                    processedFiles.add(FileUtil.toSystemIndependentName((String)s));
                }
            }
        }
    }

    protected boolean compileConfig(ProgressIndicator indicator, TypeScriptCompilerService service, VirtualFile config2, Collection<JSAnnotationError> infos) {
        indicator.checkCanceled();
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("Action Compile: do compile for " + config2.getName());
        }
        try {
            indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile.config", (Object[])new Object[]{config2.getPath()}));
            Future<JSLanguageServiceResultContainer> compile = service.compileConfigProjectAndGetErrors(config2);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                this.processCompileConfigResult(container, infos);
            }
            return true;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.cancel();
            return false;
        }
    }

    protected void processCompileConfigResult(@Nullable JSLanguageServiceResultContainer container, @NotNull Collection<JSAnnotationError> infos) {
        if (infos == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(9);
        }
        if (container != null) {
            infos.addAll((Collection<JSAnnotationError>)container.getAnnotationResults());
        }
    }

    protected void logErrors(Project project, Collection<? extends JSAnnotationError> infos) {
        JSLanguageServiceToolWindowManager manager2 = TypeScriptToolWindowProvider.getToolWindow(project);
        if (manager2 != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                manager2.init();
                this.logErrors(manager2, infos);
            }, project.getDisposed());
        }
    }

    public final synchronized void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(10);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DataContext context = e.getDataContext();
        this.runCompile(project, context);
    }

    public final void runCompile(@NotNull Project project, @Nullable DataContext context) {
        if (project == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        Consumer<ProgressIndicator> background = this.getBackgroundProcess(project, context);
        if (background == null) {
            return;
        }
        this.runBackgroundTask(project, background);
    }

    private void runBackgroundTask(@NotNull Project project, final Consumer<? super ProgressIndicator> background) {
        if (project == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(12);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            background.consume(indicator == null ? new EmptyProgressIndicator() : indicator);
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Compiling TypeScript Files", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        indicator.checkCanceled();
                        background.consume((Object)indicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    finally {
                        TypeScriptCompileActionBase.this.release();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase$1", "run"));
                }
            });
        }
    }

    protected void release() {
    }

    @Nullable
    protected abstract Consumer<ProgressIndicator> getBackgroundProcess(@Nullable Project var1, @Nullable DataContext var2);

    protected void updateServerFiles(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService languageCompilerService) {
        if (project == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(14);
        }
        if (languageCompilerService == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(15);
        }
        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> JSHighlightingInfoBuilder.createUpdateContext(project, (Condition<VirtualFile>)languageCompilerService.getAcceptableFilesFilter()));
        indicator.checkCanceled();
        languageCompilerService.update(context);
        indicator.checkCanceled();
    }

    protected void runBeforeStartingCompile(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService languageCompilerService) {
        if (project == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(17);
        }
        if (languageCompilerService == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(18);
        }
        this.updateServerFiles(project, indicator, languageCompilerService);
        languageCompilerService.flushCompileQueue();
    }

    @Nullable
    protected TypeScriptCompilerService getServiceForConfig(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(19);
        }
        if (configFile == null) {
            TypeScriptCompileActionBase.$$$reportNull$$$0(20);
        }
        Ref serviceRef = Ref.create();
        ReadAction.run(() -> {
            TypeScriptCompilerService service = TypeScriptCompilerService.getServiceForFile(project, configFile, false);
            serviceRef.set((Object)service);
        });
        return (TypeScriptCompilerService)serviceRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageCompilerService";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logErrors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "compileFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompileFileResult";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompileConfigResult";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "runCompile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "runBackgroundTask";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "updateServerFiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "runBeforeStartingCompile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getServiceForConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

