/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceFileCommandCache;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceQueueImpl;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerState;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceExtension;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptServiceRelatedAction;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptSuppressByCommentFix;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCache;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.CompletionDetailsRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.GetCodeFixesRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SemanticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SuggestionDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SyntacticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    public static final String PROCESSED_FILES_FIELD = "processedFiles";
    public static final String DIAGNOSTICS_FIELD = "diagnostics";
    @NotNull
    protected final TypeScriptCompilerSettings mySettings;
    private final JSLanguageServiceFileCommandCache myQuickFixCache;
    @NotNull
    private final Condition<VirtualFile> myFileFilter;
    @NotNull
    private final JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> myCompletionDefaultProcessor;

    public TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(1);
        }
        this(project, settings, "Console");
    }

    protected TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull String consoleId) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(3);
        }
        if (consoleId == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(4);
        }
        super(project, consoleId);
        this.myCompletionDefaultProcessor = (serviceObject, answer) -> {
            JsonObject element = answer.getElement();
            try {
                TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)this.getGson().fromJson((JsonElement)element, TypeScriptCompletionResponse.class);
                if (response == null || response.body == null) {
                    return ContainerUtil.emptyList();
                }
                return ContainerUtil.newArrayList((Object[])response.body);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
                return ContainerUtil.emptyList();
            }
        };
        this.mySettings = settings;
        this.myQuickFixCache = new JSLanguageServiceFileCommandCache(this);
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        this.myFileFilter = virtualFile -> {
            if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
                return false;
            }
            if (TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value(virtualFile)) {
                return true;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (DumbService.isDumb((Project)project)) {
                    return false;
                }
                return this.isAcceptableNonTsFile(project, service, (VirtualFile)virtualFile);
            });
        };
    }

    protected boolean isAcceptableNonTsFile(@NotNull Project project, @NotNull TypeScriptConfigService service, @NotNull VirtualFile virtualFile) {
        FileType type;
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(5);
        }
        if (service == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(7);
        }
        if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type = virtualFile.getFileType())) {
            return false;
        }
        Collection<? extends VirtualFile> configs = TypeScriptConfigUtil.getNearestParentConfigFiles(virtualFile, service.getConfigFiles());
        TypeScriptConfig config2 = service.parseConfigFile((VirtualFile)ContainerUtil.getFirstItem(configs));
        return config2 != null && config2.allowJs();
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(8);
        }
        if (!this.isServiceCreated()) {
            return;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process != null) {
            String path = command.getCompilerId();
            if (StringUtil.isEmpty((String)path)) {
                this.sendCommand(new TypeScriptReloadProjectsCommand());
            } else {
                TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
                args.projectFileName = LocalFilePath.create(path);
                this.sendCommand(new TypeScriptReloadProjectsCommand(args));
            }
            process.resetCaches();
        }
    }

    @Override
    protected void processVfsChangesForFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(9);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isReCompileOnChanges()) {
            this.addToCompileQueueWithUpdate(files);
        } else {
            TypeScriptServerState serverState = this.getServerStateIfStarted();
            if (serverState != null) {
                files.forEach(el -> serverState.addFileToVfsQueue((VirtualFile)el));
            }
        }
    }

    private void addToCompileQueueWithUpdate(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(10);
        }
        ReadAction.run(() -> this.addToCompileQueueWithUpdateImpl(files));
    }

    private void addToCompileQueueWithUpdateImpl(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isReCompileOnChanges() || !this.isEnabled()) {
            return;
        }
        List<String> fileNames = this.getFileNames(files);
        if (fileNames.isEmpty()) {
            return;
        }
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.addToCompileQueue(new Update(new TypeScriptCompileUpdater(), 10){

                public void run() {
                    if (TypeScriptServerServiceImpl.this.isServiceCreated()) {
                        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> JSHighlightingInfoBuilder.createUpdateContext(TypeScriptServerServiceImpl.this.myProject, TypeScriptServerServiceImpl.this.getAcceptableFilesFilter()));
                        TypeScriptServerServiceImpl.this.update(context);
                    }
                }
            });
        }
        this.addToCompileQueue(fileNames);
    }

    @Override
    @Nullable
    protected TypeScriptLanguageServiceQueueImpl getProcess() {
        return (TypeScriptLanguageServiceQueueImpl)super.getProcess();
    }

    @NotNull
    private List<String> getFileNames(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(12);
        }
        GlobalSearchScope scope = this.getScope();
        List list2 = ContainerUtil.mapNotNull(files, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && scope.accept(el) && null == el.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        if (list2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public CompletableFuture<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile virtualFile, @NotNull PsiFile file2, @NotNull Document document2, int positionInFileOffset) {
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(15);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return null;
        }
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(file2.getProject(), this.getAcceptableFilesFilter());
        TypeScriptCompletionsRequestArgs args = new TypeScriptCompletionsRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, virtualFile, document2, positionInFileOffset);
        JSLanguageServiceSimpleCommand completionCommand = this.createCompletionCommand(args, virtualFile, file2);
        this.update(context);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        return process.execute(completionCommand, completionProcessor);
    }

    @Nullable
    public CompletableFuture<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getDetailedCompletionItems(@NotNull VirtualFile virtualFile, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> items, @NotNull Document document2, int positionInFileOffset) {
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(17);
        }
        if (items == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(18);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return null;
        }
        List names = ContainerUtil.map(items, el -> el.name);
        CompletionDetailsRequest request = new CompletionDetailsRequest(names);
        TypeScriptLanguageServiceUtil.fillFilePosition((TypeScriptFileLocationRequestArgs)request.arguments, virtualFile, document2, positionInFileOffset);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        return process.execute(request, completionProcessor);
    }

    @Override
    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return null;
    }

    @Override
    public boolean isServiceEnabled(@NotNull VirtualFile context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(20);
        }
        return TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject);
    }

    @NotNull
    protected JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> createCompletionProcessor() {
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> jSLanguageServiceCommandProcessor = this.myCompletionDefaultProcessor;
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(21);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file2) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(22);
        }
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(23);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(24);
        }
        TypeScriptCompletionsCommand typeScriptCompletionsCommand = new TypeScriptCompletionsCommand(args);
        if (typeScriptCompletionsCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(25);
        }
        return typeScriptCompletionsCommand;
    }

    @Nullable
    public CompletableFuture<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(26);
        }
        return this.updateImpl(context);
    }

    @Nullable
    public CompletableFuture<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(27);
        }
        if ((process = this.getProcess()) == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        String path = file2.getPath();
        if (TypeScriptUtil.isDefinitionFile(path) || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file2)) {
            return null;
        }
        TypeScriptServerServiceImpl.setUpdateForVfsChangedFiles(process);
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.file = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2));
        this.setMacroParamsIfNeeded(args, file2);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    private static void setUpdateForVfsChangedFiles(@NotNull TypeScriptLanguageServiceQueueImpl process) {
        TypeScriptServerState state;
        Set<VirtualFile> files;
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(28);
        }
        if ((files = (state = process.getServerState()).getVfsChangedFiles()).isEmpty()) {
            return;
        }
        files.forEach(el -> process.executeNoBlocking(new TypeScriptReloadFileCommand((VirtualFile)el), null));
    }

    @Nullable
    public CompletableFuture<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull VirtualFile config2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (config2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(29);
        }
        if ((process = this.getProcess()) == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        TypeScriptServerServiceImpl.setUpdateForVfsChangedFiles(process);
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.projectFileName = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(config2));
        return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file2) {
        VirtualFile mainFile;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(30);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!this.isServiceCreated() || !this.isServiceEnabled(file2)) {
            return;
        }
        if (this.mySettings.useMainFile() && file2.equals(mainFile = this.getMainFile())) {
            return;
        }
        String normalizeNameAndPath = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2);
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments, file2);
        arguments.file = LocalFilePath.create(normalizeNameAndPath);
        this.sendCommand(command);
    }

    @Override
    @NotNull
    public Collection<? extends IntentionAction> getServiceFixes(@NotNull PsiFile file2, PsiElement element, @NotNull JSAnnotationError result2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(32);
        }
        if (!(result2 instanceof TypeScriptLanguageServiceAnnotationResult)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(33);
            }
            return list2;
        }
        TypeScriptLanguageServiceAnnotationResult typescriptResult = (TypeScriptLanguageServiceAnnotationResult)result2;
        int code = typescriptResult.getErrorCode();
        if (code == -1) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(34);
            }
            return list3;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        Set tsCompilerCodesErrorCodes = process == null ? Collections.emptySet() : process.getServerState().myErrorCodeFixes;
        boolean isSuggestion = result2.getCategory() == "hide";
        boolean isTSCompilerError = TypeScriptServerServiceImpl.isTSCompilerError(typescriptResult);
        if ((tsCompilerCodesErrorCodes.contains(String.valueOf(code)) || !isTSCompilerError) && file2.getVirtualFile() != null) {
            TypeScriptSuppressByCommentFix suppressByCommentFix;
            TypeScriptLanguageServiceFixSet set = this.createFixSet(file2, this.myQuickFixCache, typescriptResult);
            ArrayList<TypeScriptServiceRelatedAction> resultActions = new ArrayList<TypeScriptServiceRelatedAction>();
            resultActions.addAll(set.getFixes());
            if (!isSuggestion && isTSCompilerError && (suppressByCommentFix = this.getSuppressAction(element)) != null) {
                resultActions.add(suppressByCommentFix);
            }
            ArrayList<TypeScriptServiceRelatedAction> arrayList = resultActions;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(35);
            }
            return arrayList;
        }
        List list4 = isSuggestion ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)this.getSuppressAction(element));
        if (list4 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(36);
        }
        return list4;
    }

    @NotNull
    protected TypeScriptLanguageServiceFixSet createFixSet(@NotNull PsiFile file2, @NotNull JSLanguageServiceFileCommandCache cache, @NotNull TypeScriptLanguageServiceAnnotationResult typescriptResult) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(37);
        }
        if (cache == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(38);
        }
        if (typescriptResult == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(39);
        }
        TypeScriptLanguageServiceFixSet typeScriptLanguageServiceFixSet = new TypeScriptLanguageServiceFixSet(file2.getProject(), cache, file2.getVirtualFile(), typescriptResult, null);
        if (typeScriptLanguageServiceFixSet == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(40);
        }
        return typeScriptLanguageServiceFixSet;
    }

    private static boolean isTSCompilerError(@NotNull TypeScriptLanguageServiceAnnotationResult error) {
        if (error == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(41);
        }
        return !StringUtil.equals((CharSequence)error.getSource(), (CharSequence)"tslint");
    }

    @Nullable
    public TypeScriptSuppressByCommentFix getSuppressAction(@Nullable PsiElement element) {
        if (element != null) {
            Class<? extends JSSuppressionHolder> aClass = JSInspectionSuppressor.getHolderClass(element);
            return new TypeScriptSuppressByCommentFix(aClass);
        }
        return null;
    }

    @Override
    public void openEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(42);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!this.isServiceCreated() || !this.isServiceEnabled(file2)) {
            return;
        }
        TypeScriptOpenEditorCommand command = this.createOpenEditorCommand(this.myProject, file2);
        if (command == null) {
            return;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)el -> this.addToCompileQueueWithUpdate(Collections.singletonList(file2))));
    }

    @Override
    public boolean checkCanUseService() {
        return this.getCanStartProcessState() != ThreeState.NO && (this.mySettings.isRecompileOnChanges() || this.myFailCount.get() < (long)this.getAliveCheckCount());
    }

    @Override
    public JSLanguageServiceQueue getLSProcess() {
        return super.getLSProcess();
    }

    @Override
    @Nullable
    public CompletableFuture<List<JSAnnotationError>> highlight(@NotNull PsiFile file2, @NotNull JSFileHighlightingInfo info) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(43);
        }
        if (info == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> configs = TypeScriptServerServiceImpl.getChangedConfigs(file2);
        if (configs != null && !configs.isEmpty()) {
            this.saveChangedConfigsAndRestartHighlighting(file2, configs);
            return null;
        }
        return this.updateFilesAndGetErrors(file2, info);
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file2) {
        DialectOptionHolder holder;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(45);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)file2)) == null || !holder.isTypeScript && !holder.isJavaScript()) {
            return false;
        }
        VirtualFile context = file2.getVirtualFile();
        if (context == null) {
            return false;
        }
        if (!this.isServiceEnabled(context)) {
            return false;
        }
        if (!this.checkAnnotationProvider(file2)) {
            return false;
        }
        if (holder.isTypeScript) {
            return true;
        }
        TypeScriptConfig configForPsiFile = TypeScriptConfigUtil.getConfigForPsiFile(file2);
        return configForPsiFile != null && configForPsiFile.allowJs();
    }

    protected boolean checkAnnotationProvider(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(46);
        }
        TypeScriptAnnotatorCheckerProvider provider2 = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file2);
        return provider2 instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = this.myFileFilter;
        if (condition == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(47);
        }
        return condition;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NodeJsInterpreter interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreter(this.myProject);
        boolean hasInterpreter = interpreter != null;
        ThreeState prevValue = this.getCanStartProcessState();
        this.setCanStartProcessState(ThreeState.fromBoolean((boolean)hasInterpreter));
        if (!hasInterpreter) {
            this.showInterpreterError(prevValue);
            return null;
        }
        Ref serviceRef = Ref.create();
        Condition expiredConditionForReadyConsumer = el -> {
            JSLanguageServiceQueue service = (JSLanguageServiceQueue)serviceRef.get();
            if (service == null) {
                return false;
            }
            return !service.isValid();
        };
        Consumer<JsonObject> readyConsumer = this.createReadyConsumer((Condition<Object>)expiredConditionForReadyConsumer);
        JSLanguageServiceProtocol protocol = this.createProtocol(readyConsumer, this.getServicePath());
        if (protocol == null) {
            return null;
        }
        boolean setActive = this.myFailCount.get() == 0L;
        JSLanguageServiceQueue.ServiceInfoReporter errorReporter = this.myToolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, setActive) : this.myDefaultReporter;
        Consumer<JSLanguageServiceQueue> initializer = this.getInitializedCallback();
        TypeScriptLanguageServiceQueueImpl service = null;
        try {
            String tsServicePath = TypeScriptServiceDirectoryWatcher.getService(this.myProject).calcServiceDirectoryAndRefresh();
            ProgressManager.checkCanceled();
            service = new TypeScriptLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, errorReporter, this.createLSCache(), tsServicePath);
            serviceRef.set((Object)service);
            initializer.consume((Object)service);
            JSLanguageServiceQueue.LOGGER.trace("New service queue was created and initialized: " + service.hashCode());
            return service;
        }
        catch (Error | RuntimeException error) {
            if (service != null) {
                Disposer.dispose(service);
            }
            throw error;
        }
    }

    @NotNull
    protected TypeScriptLanguageServiceCache createLSCache() {
        TypeScriptLanguageServiceCache typeScriptLanguageServiceCache = new TypeScriptLanguageServiceCache(this.myProject);
        if (typeScriptLanguageServiceCache == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(48);
        }
        return typeScriptLanguageServiceCache;
    }

    @NotNull
    private String getServicePath() {
        String string = TypeScriptServiceDirectoryWatcher.getService(this.myProject).calcServiceDirectoryAndRefresh();
        if (string == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    private Consumer<JsonObject> createReadyConsumer(Condition<Object> expiredCondition) {
        Consumer consumer = el -> {
            try {
                JsonObject message = el.getAsJsonObject("message");
                if (message == null) {
                    JSLanguageServiceQueue.LOGGER.error("No ready message");
                    return;
                }
                JsonPrimitive version = message.getAsJsonPrimitive("version");
                String versionAsString = TypeScriptLanguageServiceUtil.getNormalizedVersionString(version.getAsString());
                if (this.myToolWindowManager != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.myToolWindowManager.setName(versionAsString), expiredCondition);
                }
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(50);
        }
        return consumer;
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(@NotNull Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        if (readyConsumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(51);
        }
        if (tsServicePath == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(52);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new TypeScriptServiceStandardOutputProtocol(this.myProject, this.mySettings, readyConsumer, this.createEventConsumer(), "typescript", tsServicePath);
    }

    @NotNull
    protected Consumer<JSLanguageServiceAnswer> createEventConsumer() {
        Consumer consumer = el -> {
            TypeScriptServerState serverState = this.getServerStateIfStarted();
            if (serverState == null) {
                return;
            }
            serverState.processEvent((JSLanguageServiceAnswer)el);
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(53);
        }
        return consumer;
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return TypeScriptToolWindowProvider.getToolWindow(project);
    }

    @Override
    protected boolean needInitToolWindow() {
        return this.isEnabled();
    }

    @NotNull
    protected Consumer<JSLanguageServiceQueue> getInitializedCallback() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> commands = this.getInitialCommands();
        Consumer consumer = service -> ReadAction.run(() -> {
            TypeScriptServerServiceImpl.sendUpdateCodeFixesState(service);
            TypeScriptServerServiceImpl.sendInitialState(service, commands);
        });
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(54);
        }
        return consumer;
    }

    private static void sendUpdateCodeFixesState(@NotNull JSLanguageServiceQueue service) {
        if (service == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(55);
        }
        GetCodeFixesRequest fixes = new GetCodeFixesRequest();
        if (service instanceof TypeScriptLanguageServiceQueueImpl) {
            TypeScriptServerState state = ((TypeScriptLanguageServiceQueueImpl)service).getServerState();
            service.executeNoBlocking(fixes, (Consumer<? super JSLanguageServiceAnswer>)((Consumer)answer -> {
                JsonObject nested = answer.getElement();
                JsonElement body = nested.get(BODY_FIELD);
                if (body == null || !body.isJsonArray()) {
                    return;
                }
                JsonArray array = body.getAsJsonArray();
                Set result2 = StreamEx.of((Iterator)array.iterator()).map(element -> {
                    if (element.isJsonPrimitive()) {
                        return element.getAsString();
                    }
                    return "";
                }).toSet();
                state.setErrorCodes(result2);
            }));
        }
    }

    private static void sendInitialState(@NotNull JSLanguageServiceQueue service, @NotNull Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> initialCommands) {
        if (service == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(56);
        }
        if (initialCommands == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(57);
        }
        JSLanguageServiceQueue.LOGGER.trace("Send initial state for " + service.hashCode());
        initialCommands.forEach((command, consumer) -> service.executeNoBlocking((JSLanguageServiceCommand)command, null, (Consumer<? super JSLanguageServiceObject>)consumer));
    }

    @NotNull
    protected Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> getInitialCommands() {
        VirtualFile mainFile;
        ArrayList<VirtualFile> toProcess = new ArrayList<VirtualFile>();
        VirtualFile virtualFile = mainFile = this.isMainFileContext() ? this.getMainFile() : null;
        if (mainFile != null) {
            toProcess.add(mainFile);
        }
        toProcess.addAll(JSHighlightingInfoBuilder.getFilteredOpenedFiles(this.myProject, this.getAcceptableFilesFilter()).keySet());
        if (toProcess.isEmpty()) {
            Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(58);
            }
            return map;
        }
        HashMap<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> commandsToConsumers = new HashMap<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>>();
        for (VirtualFile vFile : toProcess) {
            TypeScriptOpenEditorCommand command = this.createOpenEditorCommand(this.myProject, vFile);
            if (command == null) continue;
            Consumer consumer = serviceObject -> ReadAction.run(() -> {
                PsiFile file2;
                if (vFile.isValid() && !this.myProject.isDisposed() && (file2 = PsiManager.getInstance((Project)this.myProject).findFile(vFile)) != null) {
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
                }
            });
            commandsToConsumers.put(command, (Consumer<JSLanguageServiceObject>)consumer);
        }
        HashMap<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> hashMap = commandsToConsumers;
        if (hashMap == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(59);
        }
        return hashMap;
    }

    @Nullable
    private static Collection<VirtualFile> getChangedConfigs(@NotNull PsiFile fileToHighlight) {
        if (fileToHighlight == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(60);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager manager2 = FileDocumentManager.getInstance();
        HashSet<VirtualFile> additionalFilesToWatch = null;
        for (TypeScriptServiceExtension extension : TypeScriptServiceExtension.EP_NAME.getExtensionList()) {
            Set<VirtualFile> additionalConfigs = extension.getConfigFilesToWatch(fileToHighlight);
            if (additionalFilesToWatch == null) {
                additionalFilesToWatch = new HashSet<VirtualFile>();
            }
            additionalFilesToWatch.addAll(additionalConfigs);
        }
        List changedConfigs = null;
        for (Document document2 : manager2.getUnsavedDocuments()) {
            VirtualFile docFile = manager2.getFile(document2);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile.getFileType()) && (additionalFilesToWatch == null || !additionalFilesToWatch.contains(docFile))) continue;
            if (changedConfigs == null) {
                changedConfigs = ContainerUtil.newSmartList();
            }
            changedConfigs.add(docFile);
        }
        return changedConfigs;
    }

    private void saveChangedConfigsAndRestartHighlighting(@NotNull PsiFile file2, @NotNull Collection<VirtualFile> configs) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(61);
        }
        if (configs == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(62);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (VirtualFile config2 : configs) {
                Document document2 = FileDocumentManager.getInstance().getDocument(config2);
                if (document2 == null) continue;
                FileDocumentManager.getInstance().saveDocument(document2);
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
        }, this.myProject.getDisposed());
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && this.mySettings.useService();
    }

    @Nullable
    public TypeScriptServerState getServerStateIfStarted() {
        if (this.isServiceCreated()) {
            TypeScriptLanguageServiceQueueImpl process = this.getProcess();
            if (!TypeScriptServerServiceImpl.checkState(process)) {
                return null;
            }
            return process.getServerState();
        }
        return null;
    }

    @Override
    public void flushCompileQueue() {
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.flushCompileQueue();
        }
    }

    private void flushProjectErrorsQueue() {
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.flushProjectErrorsQueue();
        }
    }

    public void flushQueues() {
        this.flushCompileQueue();
        this.flushProjectErrorsQueue();
    }

    @Nullable
    protected TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(63);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(64);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager instance = FileDocumentManager.getInstance();
        Document document2 = instance.getDocument(file2);
        String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(project, file2);
        if (document2 == null) {
            return null;
        }
        return this.createOpenCommand(file2, instance, document2, projectFileName);
    }

    @NotNull
    protected TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file2, @NotNull FileDocumentManager instance, @NotNull Document document2, @Nullable String projectFileName) {
        long contentLength;
        int lastLineStartOffset;
        int lineCount;
        CharSequence contentToSend;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(65);
        }
        if (instance == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(66);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(67);
        }
        if ((contentToSend = this.getPreprocessedDocumentText(file2, instance, document2)) == null) {
            lineCount = document2.getLineCount();
            lastLineStartOffset = lineCount == 0 ? 0 : document2.getLineStartOffset(lineCount - 1);
            contentLength = document2.getTextLength();
        } else {
            lineCount = TypeScriptServerServiceImpl.getLineCountForText(contentToSend);
            lastLineStartOffset = TypeScriptServerServiceImpl.getLastLineStartOffsetFromText(contentToSend, lineCount);
            contentLength = contentToSend.length();
        }
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(file2, -1L, contentLength, lineCount, lastLineStartOffset, contentToSend, projectFileName);
        if (typeScriptOpenEditorCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(68);
        }
        return typeScriptOpenEditorCommand;
    }

    public static int getLastLineStartOffsetFromText(@NotNull CharSequence contentToSent, int lineCount) {
        if (contentToSent == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(69);
        }
        if (lineCount == 0) {
            return 0;
        }
        return StringUtil.endsWithChar((CharSequence)contentToSent, (char)'\n') ? contentToSent.length() : StringUtil.lastIndexOf((CharSequence)contentToSent, (char)'\n', (int)0, (int)contentToSent.length()) + 1;
    }

    public static int getLineCountForText(@NotNull CharSequence contentToSent) {
        if (contentToSent == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(70);
        }
        return StringUtil.countNewLines((CharSequence)contentToSent) + 1;
    }

    @Nullable
    protected final CharSequence getPreprocessedDocumentText(@NotNull VirtualFile file2, @NotNull FileDocumentManager instance, @NotNull Document document2) {
        CharSequence text;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(71);
        }
        if (instance == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(72);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(73);
        }
        if ((text = this.getDocumentText(file2, instance, document2)) == null) {
            return null;
        }
        return JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, text, file2);
    }

    @Nullable
    protected CharSequence getDocumentText(@NotNull VirtualFile file2, @NotNull FileDocumentManager instance, @NotNull Document document2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(74);
        }
        if (instance == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(75);
        }
        if (document2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(76);
        }
        return instance.isDocumentUnsaved(document2) ? document2.getImmutableCharSequence() : null;
    }

    @NotNull
    private JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            List<String> emittedFiles;
            JsonObject element = answer.getElement();
            JsonElement body = element.get(BODY_FIELD);
            if (body == null || !body.isJsonObject()) {
                return null;
            }
            JsonObject bodyObject = body.getAsJsonObject();
            List<String> list2 = emittedFiles = bodyObject.has(GENERATED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(GENERATED_FILES_FIELD)) : ContainerUtil.emptyList();
            if (!emittedFiles.isEmpty()) {
                TypeScriptCompilerConfigUtil.refreshFiles(this.myProject, emittedFiles);
            }
            List<String> processedFiles = bodyObject.has(PROCESSED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(PROCESSED_FILES_FIELD)) : ContainerUtil.emptyList();
            List<JSAnnotationError> results = TypeScriptServerServiceImpl.parseAnnotationResult(this.getGson(), (JsonElement)bodyObject);
            return new JSLanguageServiceResultContainer(results, processedFiles, emittedFiles);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(77);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private CompletableFuture<List<JSAnnotationError>> updateFilesAndGetErrors(@NotNull PsiFile psiFile, @NotNull JSFileHighlightingInfo info) {
        TypeScriptLanguageServiceQueueImpl process;
        if (psiFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(78);
        }
        if (info == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(79);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        this.updateImpl(info.updateContext);
        VirtualFile file2 = psiFile.getVirtualFile();
        final String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2);
        if (path == null) {
            return null;
        }
        String config2 = this.getConfigForFile(file2);
        Collection<JSLanguageServiceCacheableCommand> commands = this.createGetErrCommand(file2, path);
        if (commands.isEmpty()) {
            return null;
        }
        ArrayList<CompletableFuture<List<JSAnnotationError>>> futures = new ArrayList<CompletableFuture<List<JSAnnotationError>>>();
        for (JSLanguageServiceCacheableCommand command : commands) {
            CompletableFuture<List<JSAnnotationError>> result2 = process.executeWithCache(command, new JSLanguageServiceCacheableCommandProcessor<List<JSAnnotationError>>(){

                @Override
                public List<JSAnnotationError> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                    if (command == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (object == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (answer == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return TypeScriptServerServiceImpl.this.parseGetErrorResult(answer, path);
                }

                @Override
                @NotNull
                public List<JSAnnotationError> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSAnnotationError> result2) {
                    if (command == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (result2 == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    List<JSAnnotationError> list2 = result2;
                    if (list2 == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 5: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 5: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "command";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "object";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "answer";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "processFromCache";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "processFromCache";
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 5: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            if (result2 == null) continue;
            futures.add(result2);
        }
        CompletionStage result3 = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(el -> {
            LinkedHashSet<JSAnnotationError> annotations = new LinkedHashSet<JSAnnotationError>(futures.stream().flatMap(future -> future.getNow(ContainerUtil.emptyList()).stream()).collect(Collectors.toList()));
            this.appendGlobalErrors(process, config2, annotations, file2);
            List<JSAnnotationError> list2 = new ArrayList<JSAnnotationError>(annotations);
            list2 = this.postprocessErrors(psiFile, list2);
            if (!this.mySettings.isShowAllProjectErrors() && TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file2, list2);
            }
            return list2;
        });
        if (this.mySettings.isShowAllProjectErrors()) {
            this.queueProjectErrorsTask(process, this.createProjectCommand(file2, path), file2);
        }
        return result3;
    }

    @NotNull
    protected List<JSAnnotationError> postprocessErrors(@NotNull PsiFile file2, @NotNull List<JSAnnotationError> list2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(80);
        }
        if (list2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(81);
        }
        List<JSAnnotationError> list3 = list2;
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(82);
        }
        return list3;
    }

    @NotNull
    protected List<JSAnnotationError> parseGetErrorResult(@NotNull JSLanguageServiceAnswer answer, String path) {
        JsonObject element;
        JsonElement bodyProperty;
        if (answer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(83);
        }
        if ((bodyProperty = (element = answer.getElement()).get(BODY_FIELD)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(84);
            }
            return list2;
        }
        if (bodyProperty.isJsonArray()) {
            List<JSAnnotationError> list3 = TypeScriptServerServiceImpl.parseDiagnosticsForFile(path, (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])this.getGson().fromJson(bodyProperty, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class));
            if (list3 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(85);
            }
            return list3;
        }
        List<JSAnnotationError> list4 = TypeScriptServerServiceImpl.parseAnnotationResult(this.getGson(), bodyProperty);
        if (list4 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(86);
        }
        return list4;
    }

    @NotNull
    private Gson getGson() {
        Gson gson = JSLanguageServiceUtil.getGson(this);
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(87);
        }
        return gson;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file2, @NotNull String path) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(88);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(89);
        }
        TypeScriptGetProjectErrCommand typeScriptGetProjectErrCommand = new TypeScriptGetProjectErrCommand(path);
        if (typeScriptGetProjectErrCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(90);
        }
        return typeScriptGetProjectErrCommand;
    }

    @Nullable
    private CompletableFuture<Boolean> updateImpl(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(91);
        }
        TypeScriptLanguageServiceUpdateCommand command = this.getUpdateFilesCommand(context);
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return null;
        }
        process.executeNoBlocking(command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)serviceObject -> {
            if (!this.isReCompileOnChanges() || !this.isEnabled()) {
                return;
            }
            List<VirtualFile> files = TypeScriptServerServiceImpl.getFilesToCompileFromServiceObject(serviceObject);
            this.addToCompileQueueWithUpdate(files);
        }));
        return null;
    }

    @NotNull
    private static List<VirtualFile> getFilesToCompileFromServiceObject(@NotNull JSLanguageServiceObject object) {
        if (object == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(92);
        }
        if (object instanceof TypeScriptFileObject) {
            LocalFilePath file2 = ((TypeScriptFileObject)object).file;
            List list2 = ContainerUtil.createMaybeSingletonList((Object)LocalFileSystem.getInstance().findFileByPath(file2.getPath()));
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(93);
            }
            return list2;
        }
        if (object instanceof TypeScriptCommandSetRequest) {
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            ((TypeScriptCommandSetRequest)object).nestedRequests.forEach((obj, command) -> result2.addAll(TypeScriptServerServiceImpl.getFilesToCompileFromServiceObject(obj)));
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(94);
            }
            return arrayList;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(95);
        }
        return list3;
    }

    @NotNull
    protected TypeScriptLanguageServiceUpdateCommand getUpdateFilesCommand(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(96);
        }
        HashMap<VirtualFile, Long> timestamps = new HashMap<VirtualFile, Long>();
        context.getTimestamps().forEach((el, value) -> timestamps.put((VirtualFile)el, (Long)value));
        HashMap<VirtualFile, Document> contents = new HashMap<VirtualFile, Document>();
        context.getOpenContents().forEach((el, value) -> contents.put((VirtualFile)el, (Document)value));
        context.getUnsavedContents().forEach((el, value) -> contents.put((VirtualFile)el, (Document)value));
        TypeScriptLanguageServiceUpdateCommand typeScriptLanguageServiceUpdateCommand = new TypeScriptLanguageServiceUpdateCommand(timestamps, contents);
        if (typeScriptLanguageServiceUpdateCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(97);
        }
        return typeScriptLanguageServiceUpdateCommand;
    }

    @NotNull
    private GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)this.myProject, (String)this.mySettings.getScopeName());
        if (globalSearchScope == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(98);
        }
        return globalSearchScope;
    }

    @NotNull
    protected Collection<JSLanguageServiceCacheableCommand> createGetErrCommand(@NotNull VirtualFile file2, @NotNull String path) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(99);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(100);
        }
        String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, file2);
        SyntacticDiagnosticsSyncRequest syntactic = new SyntacticDiagnosticsSyncRequest(path, projectFileName);
        SemanticDiagnosticsSyncRequest semantic = new SemanticDiagnosticsSyncRequest(path, projectFileName);
        SuggestionDiagnosticsSyncRequest suggestion = new SuggestionDiagnosticsSyncRequest(path, projectFileName);
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSLanguageServiceCacheableCommand[]{semantic, syntactic, suggestion});
        if (arrayList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(101);
        }
        return arrayList;
    }

    protected boolean isMainFileContext() {
        return TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings) && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    @NotNull
    private static List<JSAnnotationError> parseAnnotationResult(@NotNull Gson gson, @NotNull JsonElement bodyProperty) {
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(102);
        }
        if (bodyProperty == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(103);
        }
        if (!bodyProperty.isJsonObject()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(104);
            }
            return list2;
        }
        TypeScriptDiagnosticsResponse result2 = (TypeScriptDiagnosticsResponse)gson.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        LinkedHashSet<JSAnnotationError> results = new LinkedHashSet<JSAnnotationError>();
        if (result2 == null || result2.infos == null || result2.infos.length == 0) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(105);
            }
            return list3;
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body : result2.infos) {
            results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(LocalFilePath.getPath(body.file), body.diagnostics));
        }
        ImmutableList immutableList = ContainerUtil.immutableList(new ArrayList(results));
        if (immutableList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(106);
        }
        return immutableList;
    }

    @NotNull
    private static List<JSAnnotationError> parseDiagnosticsForFile(@Nullable String fileName, @Nullable TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diagnostics) {
        if (diagnostics == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(107);
            }
            return list2;
        }
        ArrayList<JSAnnotationError> result2 = new ArrayList<JSAnnotationError>();
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : diagnostics) {
            result2.add(TypeScriptLanguageServiceAnnotationResult.buildAnnotation(fileName, diagnostic));
        }
        ArrayList<JSAnnotationError> arrayList = result2;
        if (arrayList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(108);
        }
        return arrayList;
    }

    private void addToCompileQueue(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(109);
        }
        this.getCompileArguments(fileNames).forEach(this::queueCompileTask);
    }

    @NotNull
    private Collection<TypeScriptCompileFileArgs> getCompileArguments(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(110);
        }
        if (!fileNames.isEmpty()) {
            if (!TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
                Collection collection = fileNames.stream().filter(el -> !TypeScriptUtil.isDefinitionFile(el)).map(el -> {
                    VirtualFile configFile = (VirtualFile)ReadAction.compute(() -> {
                        TypeScriptConfig config2;
                        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(el);
                        if (path != null && (config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, path)) != null) {
                            return config2.getConfigFile();
                        }
                        return null;
                    });
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = LocalFilePath.create(el);
                    if (configFile != null) {
                        args.projectFileName = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(configFile));
                    }
                    return args;
                }).collect(Collectors.toList());
                if (collection == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(111);
                }
                return collection;
            }
            String path = this.mySettings.getMainFilePath();
            if (!StringUtil.isEmpty((String)path)) {
                TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                args.file = LocalFilePath.create(FileUtil.toSystemDependentName((String)path));
                args.force = true;
                List<TypeScriptCompileFileArgs> list2 = Collections.singletonList(args);
                if (list2 == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(112);
                }
                return list2;
            }
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(113);
        }
        return list3;
    }

    private boolean isReCompileOnChanges() {
        return this.mySettings.isRecompileOnChanges();
    }

    private void queueProjectErrorsTask(@NotNull TypeScriptLanguageServiceQueueImpl process, final @NotNull JSLanguageServiceCommand args, final @NotNull VirtualFile file2) {
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(114);
        }
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(115);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(116);
        }
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        serverState.addToProjectErrorsQueue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.updateProjectErrors(args, file2);
            }
        });
    }

    private void queueCompileTask(final @NotNull TypeScriptCompileFileArgs args) {
        VirtualFile path;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(117);
        }
        if (!((path = LocalFileSystem.getInstance().findFileByPath(args.file.getPath())) != null && this.getScope().contains(path) && TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)path) && path.isValid())) {
            return;
        }
        this.setMacroParamsIfNeeded(args, path);
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.addToCompileQueue(new Update(args){

                public void run() {
                    if (!path.isValid()) {
                        return;
                    }
                    TypeScriptServerServiceImpl.this.sendCompileCommand(args);
                }
            });
        }
    }

    private void setMacroParamsIfNeeded(@NotNull TypeScriptCompileFileArgs args, @NotNull VirtualFile path) {
        String outDir;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(118);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(119);
        }
        if (this.mySettings.useDeprecatedSettings() && this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)(outDir = this.mySettings.getOutDirectory())) && outDir.contains("$")) {
            Pair<String, String> info = JSHighlightingInfoBuilder.getModuleInfo(this.myProject, path);
            args.contentRootForMacro = LocalFilePath.create((String)info.first);
            args.sourceRootForMacro = LocalFilePath.create((String)info.second);
        }
    }

    private void updateProjectErrors(@NotNull JSLanguageServiceCommand command, @NotNull VirtualFile file2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(120);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(121);
        }
        if (!TypeScriptServerServiceImpl.checkState(process = this.getProcess())) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        ConcurrentList answers = ContainerUtil.createConcurrentList();
        Consumer tracker = el -> answers.add(el);
        serverState.registerEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
        serverState.registerEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
        LinkedHashSet results = new LinkedHashSet();
        String config2 = this.getConfigForFile(file2);
        Consumer processor = answer -> {
            boolean isRemoved = serverState.removeEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)tracker) & serverState.removeEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
            if (!isRemoved) {
                return;
            }
            this.appendGlobalErrors(process, config2, results, file2);
            results.addAll(TypeScriptServerServiceImpl.convertEventsToAnnotations((List<JSLanguageServiceAnswer>)answers, JSLanguageServiceUtil.getGson(this)));
            if (TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file2, new ArrayList<JSAnnotationError>(results));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            process.execute(command, (obj, answer) -> {
                processor.consume((Object)answer);
                return null;
            });
        } else {
            process.executeNoBlocking(command, (Consumer<? super JSLanguageServiceAnswer>)processor);
        }
    }

    @Nullable
    protected String getConfigForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(122);
        }
        return (String)ReadAction.compute(() -> TypeScriptCompilerConfigUtil.getConfigIdForFile(this.myProject, file2));
    }

    private void appendGlobalErrors(@NotNull TypeScriptLanguageServiceQueueImpl process, @Nullable String config2, @NotNull Collection<JSAnnotationError> results, @NotNull VirtualFile file2) {
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(123);
        }
        if (results == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(124);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(125);
        }
        if (this.isMainFileContext()) {
            VirtualFile mainFile = this.getMainFile();
            if (mainFile != null) {
                ReadAction.run(() -> {
                    if (DumbService.isDumb((Project)this.myProject)) {
                        return;
                    }
                    TypeScriptImportGraph graph = new TypeScriptImportGraph(new TypeScriptFileImportsImpl(this.myProject, mainFile));
                    if (!graph.containsFile(file2)) {
                        results.add(new TypeScriptLanguageServiceAnnotationResult("File was not processed because there is no a reference from main file", TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2)));
                    }
                });
            }
            return;
        }
        if (config2 == null && !this.skipConfigNotFoundError(file2)) {
            results.add(new TypeScriptLanguageServiceAnnotationResult("Cannot find parent 'tsconfig.json'", TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2)));
        }
        if (config2 == null) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        JSLanguageServiceAnswer configErrors = serverState.getConfigDiagnostics(config2);
        if (configErrors == null) {
            return;
        }
        JsonObject body = configErrors.getElement().get(BODY_FIELD).getAsJsonObject();
        JsonElement diags = body.get(DIAGNOSTICS_FIELD);
        if (diags == null) {
            return;
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diagnostics = (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])this.getGson().fromJson(diags, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class);
        results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(config2, diagnostics));
    }

    @Nullable
    private VirtualFile getMainFile() {
        String mainPath = this.mySettings.getMainFilePath();
        return StringUtil.isEmpty((String)mainPath) ? null : LocalFileSystem.getInstance().findFileByPath(mainPath);
    }

    protected boolean skipConfigNotFoundError(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(126);
        }
        return !StringUtil.isEmpty((String)this.mySettings.getDefaultServiceOptions()) || this.mySettings.useDeprecatedSettings() || this.mySettings.useMainFile() || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file2);
    }

    private static List<JSAnnotationError> convertEventsToAnnotations(@NotNull List<JSLanguageServiceAnswer> answers, @NotNull Gson gson) {
        if (answers == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(127);
        }
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(128);
        }
        ArrayList<JSAnnotationError> result2 = new ArrayList<JSAnnotationError>();
        for (JSLanguageServiceAnswer answer : answers) {
            JsonObject element = answer.getElement();
            JsonElement body = element.get(BODY_FIELD);
            if (body == null) continue;
            TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo responseInfo = (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo)gson.fromJson(body, TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo.class);
            result2.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(LocalFilePath.getPath(responseInfo.file), responseInfo.diagnostics));
        }
        return ContainerUtil.immutableList((List)ContainerUtil.sorted(result2, Comparator.comparing(el -> el.getAbsoluteFilePath())));
    }

    private void updateErrorsForCurrentSelectedEditor(@NotNull VirtualFile file2, @NotNull List<JSAnnotationError> results) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(129);
        }
        if (results == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(130);
        }
        this.getDefaultReporter().logCurrentErrors(file2, results);
    }

    protected static boolean checkState(@Nullable JSLanguageServiceQueue process) {
        if (process == null) {
            return false;
        }
        return process.isValid();
    }

    private void showInterpreterError(@NotNull ThreeState prevValue) {
        if (prevValue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(131);
        }
        if (prevValue != this.getCanStartProcessState()) {
            Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myToolWindowManager != null) {
                    this.myToolWindowManager.logCurrentErrors((List<JSAnnotationError>)JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.service.node.error", (Object[])new Object[0])), this.mySettings.isRecompileOnChanges() || this.mySettings.useServiceForProjectsWithoutConfig());
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
            if (this.myProject.isOpen()) {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
            }
        }
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("TypeScript" == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(132);
        }
        return "TypeScript";
    }

    private void sendCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        TypeScriptLanguageServiceQueueImpl process;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(133);
        }
        if (!TypeScriptServerServiceImpl.checkState(process = this.getProcess())) {
            return;
        }
        this.sendCompile(args, process);
    }

    @Override
    protected boolean checkServiceQueueAliveUnderLock(@NotNull JSLanguageServiceExecutor serviceQueue) {
        if (serviceQueue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(134);
        }
        if (!super.checkServiceQueueAliveUnderLock(serviceQueue)) {
            return false;
        }
        TypeScriptServerState serverState = ((TypeScriptLanguageServiceQueueImpl)serviceQueue).getServerState();
        return serverState.isServiceValid();
    }

    private void sendCompile(@NotNull TypeScriptCompileFileArgs args, @NotNull JSLanguageServiceQueue process) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(135);
        }
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(136);
        }
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        Consumer consumer = answer -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get(BODY_FIELD);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return;
            }
            TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(this.myProject, jsonElement.getAsJsonObject(), GENERATED_FILES_FIELD);
        };
        process.executeNoBlocking(command, (Consumer<? super JSLanguageServiceAnswer>)consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 21: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 113: 
            case 132: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 21: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 113: 
            case 132: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 6: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 13: 
            case 21: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 113: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 15: 
            case 24: 
            case 27: 
            case 30: 
            case 31: 
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 61: 
            case 64: 
            case 65: 
            case 71: 
            case 74: 
            case 80: 
            case 88: 
            case 99: 
            case 116: 
            case 121: 
            case 122: 
            case 125: 
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 19: 
            case 67: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 20: 
            case 26: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 115: 
            case 117: 
            case 118: 
            case 133: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 28: 
            case 114: 
            case 123: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typescriptResult";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 44: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsServicePath";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialCommands";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToHighlight";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 66: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentToSent";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 89: 
            case 100: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 102: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyProperty";
                break;
            }
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 124: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answers";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevValue";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionProcessor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionCommand";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceFixes";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixSet";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createLSCache";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicePath";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadyConsumer";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventConsumer";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedCallback";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommands";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenCommand";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompileResultProcessor";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "postprocessErrors";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGetErrorResult";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getGson";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCommand";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToCompileFromServiceObject";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateFilesCommand";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetErrCommand";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotationResult";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDiagnosticsForFile";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileArguments";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableNonTsFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sendCleanCommandToCompiler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processVfsChangesForFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueueWithUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueueWithUpdateImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 13: 
            case 21: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 113: 
            case 132: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateAndGetCompletionItems";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedCompletionItems";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isServiceEnabled";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionCommand";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "compileFileAndGetErrors";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateForVfsChangedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "compileConfigProjectAndGetErrors";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "closeLastEditor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getServiceFixes";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createFixSet";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isTSCompilerError";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationProvider";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createProtocol";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sendUpdateCodeFixesState";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sendInitialState";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getChangedConfigs";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "saveChangedConfigsAndRestartHighlighting";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createOpenEditorCommand";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createOpenCommand";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLastLineStartOffsetFromText";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getLineCountForText";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessedDocumentText";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentText";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "updateFilesAndGetErrors";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "postprocessErrors";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "parseGetErrorResult";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCommand";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToCompileFromServiceObject";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesCommand";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createGetErrCommand";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotationResult";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueue";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getCompileArguments";
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "queueProjectErrorsTask";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "queueCompileTask";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "setMacroParamsIfNeeded";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectErrors";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 123: 
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "appendGlobalErrors";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "skipConfigNotFoundError";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "convertEventsToAnnotations";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorsForCurrentSelectedEditor";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "showInterpreterError";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sendCompileCommand";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceQueueAliveUnderLock";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "sendCompile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 21: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 58: 
            case 59: 
            case 68: 
            case 77: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 101: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 113: 
            case 132: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeScriptCompileUpdater {
        private TypeScriptCompileUpdater() {
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

