/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FallThroughInSwitchStatementJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("fall.through.in.switch.statement.display.name", new Object[0]);
        if (string == null) {
            FallThroughInSwitchStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            FallThroughInSwitchStatementJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("fall.through.in.switch.statement.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/FallThroughInSwitchStatementJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*-?thro?u");

        private Visitor() {
        }

        public void visitJSSwitchStatement(JSSwitchStatement jsSwitchStatement) {
            JSCaseClause[] caseClauses = jsSwitchStatement.getCaseClauses();
            for (int i = 1; i < caseClauses.length; ++i) {
                JSSourceElement lastStatementOfClause;
                JSCaseClause previousClause;
                Object[] statements;
                JSCaseClause clause = caseClauses[i];
                if (Visitor.isCommented(clause) || (statements = (previousClause = caseClauses[i - 1]).getStatementListItems()).length == 0 || (lastStatementOfClause = (JSSourceElement)ArrayUtil.getLastElement((Object[])statements)) instanceof JSStatement && (JSInheritedLanguagesHelper.isCaseStatementInterrupted((JSStatement)lastStatementOfClause) || !ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastStatementOfClause))) continue;
                this.registerError(clause.getFirstChild());
            }
        }

        private static boolean isCommented(JSCaseClause caseClause) {
            PsiElement element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)caseClause);
            if (!(element instanceof PsiComment)) {
                return false;
            }
            String commentText = element.getText();
            return commentPattern.matcher(commentText).find();
        }
    }
}

