/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class FunctionWithMultipleReturnPointsJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.with.multiple.return.points.display.name", new Object[0]);
        if (string == null) {
            FunctionWithMultipleReturnPointsJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.FUNCTIONMETRICS_GROUP_NAME;
        if (string == null) {
            FunctionWithMultipleReturnPointsJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        int returnPointCount = FunctionWithMultipleReturnPointsJSInspection.countReturnPoints(function);
        if (FunctionWithMultipleReturnPointsJSInspection.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.contains.multiple.return.points.error.string", returnPointCount);
        }
        return InspectionJSBundle.message("anonymous.function.contains.multiple.return.points.error.string", returnPointCount);
    }

    private static int countReturnPoints(JSFunction function) {
        PsiElement lastChild = function.getLastChild();
        if (!(lastChild instanceof JSBlockStatement)) {
            return 0;
        }
        boolean hasFallthroughReturn = false;
        if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            hasFallthroughReturn = true;
        }
        ReturnCountVisitor visitor = new ReturnCountVisitor();
        lastChild.accept((PsiElementVisitor)visitor);
        int returnCount = visitor.getReturnCount();
        if (hasFallthroughReturn) {
            return returnCount + 1;
        }
        return returnCount;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReturnCountVisitor
    extends JSRecursiveElementVisitor {
        private int returnCount = 0;

        private ReturnCountVisitor() {
        }

        public void visitJSElement(JSElement jsElement) {
            int oldCount = 0;
            if (jsElement instanceof JSFunction) {
                oldCount = this.returnCount;
            }
            super.visitJSElement(jsElement);
            if (jsElement instanceof JSFunction) {
                this.returnCount = oldCount;
            }
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            ++this.returnCount;
        }

        public int getReturnCount() {
            return this.returnCount;
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            int returnPointCount;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((returnPointCount = FunctionWithMultipleReturnPointsJSInspection.countReturnPoints(function)) <= 1) {
                return;
            }
            this.registerFunctionError(function);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/functionmetrics/FunctionWithMultipleReturnPointsJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

