/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.console.WebConsoleHistoryView;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/console/ResourcesStaticServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "intellij.javascript.debugger"})
public final class ResourcesStaticServer
extends HttpRequestHandler {
    private static final String PREFIX = "/a03365f2-eea1-451a-ad19-6dae9187a990/";
    private static final String ROOT = "frontend/";
    private static final String MAIN = "frontend/console.html";
    private static final String iconsFolder = "icons/";
    private static final Logger LOG;
    private static long lastModified;
    private static final Map<String, WebConsoleHistoryView> iconIdCache;
    private static final Map<WebConsoleHistoryView, Integer> consoleId;
    private static int consoleIdCounter;
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.uri()");
        if (!StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String path;
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = path = urlDecoder.path();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        if (!StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null)) {
            throw (Throwable)new IllegalStateException("prefix should have been checked by #isSupported");
        }
        String string2 = path;
        int n = PREFIX.length();
        boolean bl = false;
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String payLoad = string3;
        Class<WebConsoleHistoryView> clazz = WebConsoleHistoryView.class;
        HttpRequest httpRequest = (HttpRequest)request;
        Channel channel = context.channel();
        Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"context.channel()");
        ResourcesStaticServer.Companion.sendResource(httpRequest, channel, clazz, payLoad);
        return true;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ResourcesStaticServer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Resou\u2026StaticServer::class.java)");
        LOG = logger;
        iconIdCache = new HashMap();
        consoleId = new HashMap();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0006\u0010\"\u001a\u00020\u0006J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0002J,\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010'\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/javascript/debugger/console/ResourcesStaticServer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAIN", "", "PREFIX", "ROOT", "consoleId", "", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "", "consoleIdCounter", "iconIdCache", "iconsFolder", "instance", "Lcom/intellij/javascript/debugger/console/ResourcesStaticServer;", "getInstance", "()Lcom/intellij/javascript/debugger/console/ResourcesStaticServer;", "lastModified", "", "cacheIconId", "console", "id", "cacheIconId$intellij_javascript_debugger", "clearConsoleCaches", "", "clearConsoleCaches$intellij_javascript_debugger", "getIcon", "Ljavax/swing/Icon;", "fileName", "getIconStream", "Ljava/io/InputStream;", "getMainUrl", "getStaticUrl", "staticPath", "isIcon", "", "resourceName", "sendResource", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "clazz", "Ljava/lang/Class;", "intellij.javascript.debugger"})
    public static final class Companion {
        @NotNull
        public final ResourcesStaticServer getInstance() {
            Object object = HttpRequestHandler.Companion.getEP_NAME().findExtension(ResourcesStaticServer.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (ResourcesStaticServer)((Object)object);
        }

        @NotNull
        public final String cacheIconId$intellij_javascript_debugger(@NotNull WebConsoleHistoryView console, @NotNull String id) {
            Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            if (!consoleId.containsKey(console)) {
                Map map = consoleId;
                int n = consoleIdCounter;
                consoleIdCounter = n + 1;
                map.put(console, n);
            }
            String compoundId = String.valueOf(consoleId.get(console)) + "_" + id;
            iconIdCache.put(compoundId, console);
            return ResourcesStaticServer.iconsFolder + compoundId;
        }

        public final void clearConsoleCaches$intellij_javascript_debugger(@NotNull WebConsoleHistoryView console) {
            Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
            iconIdCache.entrySet().removeIf((Predicate)new Predicate<Map.Entry<String, WebConsoleHistoryView>>(console){
                final /* synthetic */ WebConsoleHistoryView $console;

                public final boolean test(@NotNull Map.Entry<String, WebConsoleHistoryView> e) {
                    Intrinsics.checkParameterIsNotNull(e, (String)"e");
                    return Intrinsics.areEqual((Object)e.getValue(), (Object)this.$console);
                }
                {
                    this.$console = webConsoleHistoryView;
                }
            });
            consoleId.remove(console);
        }

        private final Icon getIcon(String fileName) {
            WebConsoleHistoryView webConsoleHistoryView = (WebConsoleHistoryView)iconIdCache.get(fileName);
            return webConsoleHistoryView != null ? webConsoleHistoryView.getCachedIcon$intellij_javascript_debugger(StringsKt.substringAfter$default((String)fileName, (String)"_", null, (int)2, null)) : null;
        }

        private final String getStaticUrl(String staticPath) {
            return "http://localhost:" + BuiltInServerManager.Companion.getInstance().getPort() + ResourcesStaticServer.PREFIX + staticPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendResource(HttpRequest request, Channel channel, Class<?> clazz, String resourceName) {
            String string = resourceName;
            int n = StringsKt.lastIndexOf$default((CharSequence)resourceName, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String fileName = string3;
            HttpResponse httpResponse = FileResponses.INSTANCE.prepareSend(request, channel, lastModified, fileName, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            if (httpResponse == null) {
                return;
            }
            HttpResponse response = httpResponse;
            Responses.addKeepAliveIfNeeded((HttpResponse)response, (HttpRequest)request);
            try {
                InputStream inputStream;
                if (this.isIcon(resourceName)) {
                    inputStream = this.getIconStream(fileName);
                } else {
                    String string4 = PathUtil.getJarPathForClass(clazz);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"PathUtil.getJarPathForClass(clazz)");
                    String jarPath = string4;
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isInternal() && !StringsKt.endsWith$default((String)jarPath, (String)".jar", (boolean)false, (int)2, null)) {
                        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache, must-revalidate");
                        long l = lastModified;
                        lastModified = l + 1L;
                        jarPath = StringsKt.replace$default((String)jarPath, (String)"/out/classes/production/intellij.javascript.debugger", (String)"/plugins/JavaScriptDebugger/source/console/", (boolean)false, (int)4, null);
                        inputStream = Files.newInputStream(Paths.get(jarPath + resourceName, new String[0]), new OpenOption[0]);
                    } else {
                        inputStream = clazz.getResourceAsStream(resourceName);
                    }
                }
                InputStream resourceAsStream = inputStream;
                Closeable closeable = resourceAsStream;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    InputStream resource = (InputStream)closeable;
                    boolean bl3 = false;
                    if (resource == null) {
                        if (Companion.isIcon(resourceName)) {
                            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)request, null, null, (int)12, null);
                        }
                        LOG.error("file " + resourceName + " not found, jarPath: " + PathUtil.getJarPathForClass(clazz));
                        return;
                    }
                    channel.write((Object)response);
                    if (request.method() != HttpMethod.HEAD) {
                        channel.writeAndFlush((Object)new ChunkedStream(resource));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException resourceAsStream) {
                // empty catch block
            }
            ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }

        private final boolean isIcon(String resourceName) {
            return StringsKt.startsWith$default((String)resourceName, (String)"frontend/icons/", (boolean)false, (int)2, null);
        }

        /*
         * Unable to fully structure code
         */
        private final InputStream getIconStream(String fileName) {
            block15: {
                block12: {
                    block13: {
                        block11: {
                            block14: {
                                block10: {
                                    var3_2 = fileName;
                                    switch (var3_2.hashCode()) {
                                        case 1020747143: {
                                            if (!var3_2.equals("node-collapsed.png")) ** break;
                                            break;
                                        }
                                        case 328411459: {
                                            if (!var3_2.equals("error.png")) ** break;
                                            break block10;
                                        }
                                        case 176814313: {
                                            if (!var3_2.equals("info.png")) ** break;
                                            break block11;
                                        }
                                        case -1487661772: {
                                            if (!var3_2.equals("evaluationResult.png")) ** break;
                                            break block12;
                                        }
                                        case 1021092511: {
                                            if (!var3_2.equals("prompt.png")) ** break;
                                            break block13;
                                        }
                                        case -482140969: {
                                            if (!var3_2.equals("warning.png")) ** break;
                                            break block14;
                                        }
                                        case 2071334239: {
                                            if (!var3_2.equals("node-expanded.png")) ** break;
                                            v0 = UIUtil.getTreeNodeIcon((boolean)true, (boolean)false, (boolean)false);
                                            break block15;
                                        }
                                    }
                                    v0 = UIUtil.getTreeNodeIcon((boolean)false, (boolean)false, (boolean)false);
                                    break block15;
                                }
                                v0 = UIUtil.getBalloonErrorIcon();
                                break block15;
                            }
                            v0 = UIUtil.getBalloonWarningIcon();
                            break block15;
                        }
                        v0 = UIUtil.getBalloonInformationIcon();
                        break block15;
                    }
                    v0 = AllIcons.Debugger.PromptInputHistory;
                    break block15;
                }
                v0 = AllIcons.Debugger.EvaluationResult;
                break block15;
                if ((v0 = this.getIcon(fileName)) == null) {
                    return null;
                }
            }
            icon = v0;
            output = new ByteArrayOutputStream();
            v1 = EditorColorsManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"EditorColorsManager.getInstance()");
            v2 = v1.getGlobalScheme();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"EditorColorsManager.getInstance().globalScheme");
            v3 = IconUtil.scaleByFont((Icon)icon, null, (float)v2.getConsoleFontSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"IconUtil.scaleByFont(ico\u2026onsoleFontSize.toFloat())");
            scaledIcon = v3;
            v4 = UIUtil.createImage((ScaleContext)ScaleContext.create(), (double)scaledIcon.getIconWidth(), (double)scaledIcon.getIconHeight(), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR);
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"UIUtil.createImage(Scale\u2026tUtil.RoundingMode.FLOOR)");
            image = v4;
            scaledIcon.paintIcon(null, image.getGraphics(), 0, 0);
            ImageIO.write((RenderedImage)ImageUtil.toBufferedImage((Image)image), StringsKt.substringAfterLast$default((String)fileName, (String)".", null, (int)2, null), output);
            data = output.toByteArray();
            return new ByteArrayInputStream(data);
        }

        @NotNull
        public final String getMainUrl() {
            StringBuilder stringBuilder = new StringBuilder().append("frontend/console.html?internal=");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            return this.getStaticUrl(stringBuilder.append(application.isInternal()).toString());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

