/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;

final class SourceMapVisualizer {
    private static final TextAttributes UNMAPPED_MARKER = SourceMapVisualizer.createTextAttributes((Color)JBColor.LIGHT_GRAY);
    public static final TextAttributes SELECTED_MARKER = new TextAttributes((Color)JBColor.WHITE, (Color)JBColor.BLACK, (Color)JBColor.BLACK, EffectType.ROUNDED_BOX, 0);
    private static final TextAttributes[] MAPPED_MARKERS = new TextAttributes[]{SourceMapVisualizer.createTextAttributes(new Color(16770648)), SourceMapVisualizer.createTextAttributes(new Color(0xFFCC66)), SourceMapVisualizer.createTextAttributes(new Color(0xFFBBBB)), SourceMapVisualizer.createTextAttributes(new Color(0xAAFFFF)), SourceMapVisualizer.createTextAttributes(new Color(0xFFAAFF))};

    SourceMapVisualizer() {
    }

    private static TextAttributes createTextAttributes(Color color) {
        return new TextAttributes(null, color, (Color)JBColor.WHITE, EffectType.BOXED, 0);
    }

    private static TextAttributes getTextAttributes(int line) {
        if (line == -1) {
            return UNMAPPED_MARKER;
        }
        return MAPPED_MARKERS[line % MAPPED_MARKERS.length];
    }

    public static void addMarkersToGeneratedFile(@NotNull SourceMap map, @NotNull MarkupModel markupModel) {
        if (map == null) {
            SourceMapVisualizer.$$$reportNull$$$0(0);
        }
        if (markupModel == null) {
            SourceMapVisualizer.$$$reportNull$$$0(1);
        }
        SourceMapVisualizer.addHighlighters((MappingList)map.getGeneratedMappings(), markupModel);
    }

    public static void addMarkersToSourceFile(SourceMap map, MarkupModel markupModel, Url sourceUrl) {
        MappingList mappings = (MappingList)map.findSourceMappings(sourceUrl, null, null, false);
        assert (mappings != null);
        SourceMapVisualizer.addHighlighters(mappings, markupModel);
    }

    public static void addHighlighters(@NotNull MappingList mappings, @NotNull MarkupModel markupModel) {
        if (mappings == null) {
            SourceMapVisualizer.$$$reportNull$$$0(2);
        }
        if (markupModel == null) {
            SourceMapVisualizer.$$$reportNull$$$0(3);
        }
        Document document = markupModel.getDocument();
        int lineCount = document.getLineCount();
        int currentLine = -1;
        int currentColumn = 0;
        for (int i = 0; i < mappings.getSize(); ++i) {
            int endOffset;
            MappingEntry mapping = mappings.getByIndex(i);
            if (mappings.getLine(mapping) - currentLine > 1 && mappings.getLine(mapping) - 1 < lineCount) {
                markupModel.addRangeHighlighter(document.getLineStartOffset(currentLine + 1), document.getLineEndOffset(mappings.getLine(mapping) - 1), 6000, UNMAPPED_MARKER, HighlighterTargetArea.EXACT_RANGE);
            }
            currentLine = mappings.getLine(mapping);
            assert (currentLine > -1);
            if (currentLine >= lineCount) continue;
            int lineStartOffset = document.getLineStartOffset(currentLine);
            int startOffset = lineStartOffset + currentColumn;
            MappingEntry nextMapping = mappings.getNextOnTheSameLine(i, true);
            if (nextMapping == null) {
                endOffset = document.getLineEndOffset(currentLine);
                currentColumn = 0;
            } else {
                currentColumn = mappings.getColumn(nextMapping);
                endOffset = lineStartOffset + currentColumn;
            }
            if (startOffset >= endOffset) continue;
            markupModel.addRangeHighlighter(startOffset, endOffset, 6000, SourceMapVisualizer.getTextAttributes(mapping.getSourceLine()), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markupModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/sourcemap/visualizer/SourceMapVisualizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addMarkersToGeneratedFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlighters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

