/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.RemoteHostTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileAction;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteDeploymentFileSystem;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditRemoteFileTask
extends RemoteHostTask {
    private static final Logger LOG = Logger.getInstance(EditRemoteFileTask.class);
    private static final String MESSAGE_DIALOG_TITLE = WDBundle.message("remote.edit.message.title", new Object[0]);
    private final boolean myRequestFocus;
    private RemoteConnection myConnection;
    private FileObject myRemoteFile;
    private final WebServerConfig.RemotePath myRemotePath;
    private String myPresentablePath;
    @Nullable
    private final String myPresentableServerName;

    EditRemoteFileTask(boolean requestFocus, @NotNull Project project, @NotNull Deployable server, @Nullable FileObject file, @Nullable WebServerConfig.RemotePath remotePath, @Nullable RemoteConnection openConnection, @Nullable String presentableServerName) {
        if (project == null) {
            EditRemoteFileTask.$$$reportNull$$$0(0);
        }
        if (server == null) {
            EditRemoteFileTask.$$$reportNull$$$0(1);
        }
        super(project, ConnectionOwnerFactory.createConnectionOwner(project), server, PublishConfig.getInstance(project), WDBundle.message("remote.edit.downloading.content", new Object[0]), true, DeploymentRevisionTracker.DEAF, DeploymentMode.CUSTOM);
        this.myRequestFocus = requestFocus;
        this.myConnection = openConnection;
        this.myPresentableServerName = presentableServerName;
        LOG.assertTrue(file != null || remotePath != null);
        this.myRemoteFile = file;
        this.myRemotePath = remotePath;
    }

    private void initFromFile(FileObject object, @NotNull Deployable server) {
        if (server == null) {
            EditRemoteFileTask.$$$reportNull$$$0(2);
        }
        this.myRemoteFile = object;
        WebServerConfig.RemotePath path = server.getRemotePath(this.myRemoteFile);
        this.setTitle(StringUtil.toTitleCase((String)WDBundle.message("loading.content.of", path)));
        this.myPresentablePath = path.path;
    }

    @Override
    protected boolean executeOperations(ExecutionContextBase context, RemoteConnection connection) {
        byte[] remoteBytes;
        this.myConnection = connection;
        try {
            context.getProgressIndicator().checkCanceled();
            if (this.myRemoteFile == null) {
                this.myRemoteFile = context.findRemoteFile(this.myRemotePath, true);
                if (this.myRemoteFile == null || !this.myRemoteFile.exists()) {
                    this.showBalloon(MessageType.WARNING, WDBundle.message("remote.file.does.not.exist", this.myPresentablePath), false);
                    return false;
                }
            }
            context.getProgressIndicator().checkCanceled();
            boolean symbolicLink = this.myRemoteFile.isSymbolicLink();
            if (!symbolicLink) {
                Ref isKnownFileType = Ref.create((Object)false);
                ApplicationManager.getApplication().invokeAndWait(() -> isKnownFileType.set((Object)EditRemoteFileAction.ensureFileTypeKnown(this.myProject, this.myRemoteFile.getName().getBaseName())));
                if (!((Boolean)isKnownFileType.get()).booleanValue()) {
                    return false;
                }
            }
            context.getProgressIndicator().checkCanceled();
            this.initFromFile(this.myRemoteFile, context.getServer());
            context.getProgressIndicator().checkCanceled();
            String url = RemoteDeploymentFileSystem.constructURL(this.myRemoteFile, context.getServer());
            Ref isOpened = Ref.create((Object)false);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                RemoteVirtualFile createdFile = RemoteDeploymentFileSystem.getInstance().checkAndGetFileIfOpened(url);
                if (createdFile != null) {
                    EditRemoteFileTask.openFile(createdFile, true, this.getProject());
                }
                isOpened.set((Object)(createdFile != null ? 1 : 0));
            });
            if (((Boolean)isOpened.get()).booleanValue()) {
                return true;
            }
            if (!this.myRemoteFile.exists()) {
                this.showBalloon(MessageType.WARNING, WDBundle.message("remote.file.does.not.exist", this.myPresentablePath), false);
                return false;
            }
            Boolean x = this.tryHandlingAsSymbolicLink(context);
            if (x != null) {
                return x;
            }
            context.getProgressIndicator().setText(WDBundle.message("remote.edit.getting.content.of.0", this.myPresentablePath));
            remoteBytes = FileTransferUtil.getContent(this.myRemoteFile, null);
            context.getProgressIndicator().checkCanceled();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.showBalloon(MessageType.ERROR, WDBundle.message("could.not.load.remote.file.content", this.myPresentablePath, PublishUtils.getMessage(e, false)), false);
            return false;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            RemoteVirtualFile file = RemoteDeploymentFileSystem.getInstance().constructFileByNodeServerAndContent(this.myRemoteFile, context.getServer(), remoteBytes, this.getExistingConnection(), this.myPresentableServerName);
            EditRemoteFileTask.openFile(file, this.myRequestFocus, this.getProject());
        }, this.getProject().getDisposed());
        return true;
    }

    @Nullable
    private Boolean tryHandlingAsSymbolicLink(ExecutionContextBase context) throws FileSystemException {
        if (!this.myRemoteFile.isSymbolicLink()) {
            return null;
        }
        FileObject destination = null;
        try {
            while (destination == null || destination.isSymbolicLink()) {
                if ((destination = destination == null ? this.myRemoteFile.getLinkDestination() : destination.getLinkDestination()) != null) continue;
                return null;
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((Project)this.myProject, (String)WDBundle.message("remote.edit.remote.file.0.is.a.symlink.and.the.destination.failed.to.be.found.1", this.myPresentablePath, PublishUtils.getMessage(e, false)), (String)MESSAGE_DIALOG_TITLE));
            return false;
        }
        String destinationPresentablePath = context.getServer().getPresentablePath(destination);
        Ref openLinkedFileRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> openLinkedFileRef.set((Object)Messages.showYesNoDialog((Project)this.myProject, (String)WDBundle.message("remote.edit.remote.file.0.is.a.symlink.ndo.you.want.to.edit.destination.1", this.myPresentablePath, destinationPresentablePath), (String)MESSAGE_DIALOG_TITLE, (Icon)Messages.getQuestionIcon())), context.getProgressIndicator().getModalityState());
        int openLinkedFile = (Integer)openLinkedFileRef.get();
        if (openLinkedFile == 1) {
            return false;
        }
        this.initFromFile(destination, context.getServer());
        return this.executeOperations(context, this.getExistingConnection());
    }

    private static void openFile(RemoteVirtualFile createdFile, boolean focus, @NotNull Project project) {
        boolean opened;
        if (project == null) {
            EditRemoteFileTask.$$$reportNull$$$0(3);
        }
        if (!(opened = new OpenFileDescriptor(project, (VirtualFile)createdFile).navigateInEditor(project, focus))) {
            Messages.showInfoMessage((Project)project, (String)WDBundle.message("remote.edit.can.not.open.remote.file.0.in.editor.file.type.1.is.not.supported", createdFile.getName(), createdFile.getFileType().getName()), (String)MESSAGE_DIALOG_TITLE);
            return;
        }
        EditRemoteFileTask.pinEditor(createdFile, project);
    }

    private static void pinEditor(@NotNull RemoteVirtualFile file, @NotNull Project project) {
        FileEditor editor;
        if (file == null) {
            EditRemoteFileTask.$$$reportNull$$$0(4);
        }
        if (project == null) {
            EditRemoteFileTask.$$$reportNull$$$0(5);
        }
        if ((editor = FileEditorManager.getInstance((Project)project).getSelectedEditor((VirtualFile)file)) == null) {
            return;
        }
        JComponent component = editor.getComponent();
        EditorWindowHolder holder = (EditorWindowHolder)ComponentUtil.getParentOfType(EditorWindowHolder.class, (Component)component);
        if (holder == null) {
            return;
        }
        EditorWindow editorWindow = holder.getEditorWindow();
        if (!editorWindow.isFileOpen((VirtualFile)file)) {
            return;
        }
        editorWindow.setFilePinned((VirtualFile)file, true);
    }

    @Override
    @Nullable
    protected RemoteConnection getExistingConnection() {
        return this.myConnection;
    }

    @Override
    protected DeploymentNotifier.ToolWindowIdProvider getBalloonAnchor() {
        return WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW_ID_PROVIDER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/remoteEdit/EditRemoteFileTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initFromFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "openFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "pinEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

